/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.cluster.datastore;

import akka.util.Timeout;
import com.google.common.util.concurrent.Uninterruptibles;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;
import org.mockito.verification.VerificationMode;
import org.opendaylight.controller.cluster.access.concepts.ClientIdentifier;
import org.opendaylight.controller.cluster.access.concepts.FrontendIdentifier;
import org.opendaylight.controller.cluster.access.concepts.FrontendType;
import org.opendaylight.controller.cluster.access.concepts.MemberName;
import org.opendaylight.controller.cluster.datastore.AbstractActorTest;
import org.opendaylight.controller.cluster.datastore.DatastoreContext;
import org.opendaylight.controller.cluster.datastore.DistributedDataStore;
import org.opendaylight.controller.cluster.datastore.utils.ActorUtils;
import org.opendaylight.controller.md.cluster.datastore.model.TestModel;
import org.opendaylight.yangtools.yang.model.api.SchemaContext;
import scala.concurrent.duration.FiniteDuration;

public class DistributedDataStoreTest
extends AbstractActorTest {
    private static final ClientIdentifier UNKNOWN_ID = ClientIdentifier.create((FrontendIdentifier)FrontendIdentifier.create((MemberName)MemberName.forName((String)"local"), (FrontendType)FrontendType.forName((String)"unknown")), (long)0L);
    private static SchemaContext SCHEMA_CONTEXT;
    @Mock
    private ActorUtils actorUtils;
    @Mock
    private DatastoreContext datastoreContext;
    @Mock
    private Timeout shardElectionTimeout;

    @BeforeClass
    public static void beforeClass() {
        SCHEMA_CONTEXT = TestModel.createTestContext();
    }

    @AfterClass
    public static void afterClass() {
        SCHEMA_CONTEXT = null;
    }

    @Before
    public void setUp() {
        MockitoAnnotations.initMocks((Object)this);
        ((ActorUtils)Mockito.doReturn((Object)SCHEMA_CONTEXT).when((Object)this.actorUtils)).getSchemaContext();
        ((ActorUtils)Mockito.doReturn((Object)DatastoreContext.newBuilder().build()).when((Object)this.actorUtils)).getDatastoreContext();
    }

    @Test
    public void testRateLimitingUsedInReadWriteTxCreation() {
        try (DistributedDataStore distributedDataStore = new DistributedDataStore(this.actorUtils, UNKNOWN_ID);){
            distributedDataStore.newReadWriteTransaction();
            ((ActorUtils)Mockito.verify((Object)this.actorUtils, (VerificationMode)Mockito.times((int)1))).acquireTxCreationPermit();
        }
    }

    @Test
    public void testRateLimitingUsedInWriteOnlyTxCreation() {
        try (DistributedDataStore distributedDataStore = new DistributedDataStore(this.actorUtils, UNKNOWN_ID);){
            distributedDataStore.newWriteOnlyTransaction();
            ((ActorUtils)Mockito.verify((Object)this.actorUtils, (VerificationMode)Mockito.times((int)1))).acquireTxCreationPermit();
        }
    }

    @Test
    public void testRateLimitingNotUsedInReadOnlyTxCreation() {
        try (DistributedDataStore distributedDataStore = new DistributedDataStore(this.actorUtils, UNKNOWN_ID);){
            distributedDataStore.newReadOnlyTransaction();
            distributedDataStore.newReadOnlyTransaction();
            distributedDataStore.newReadOnlyTransaction();
            ((ActorUtils)Mockito.verify((Object)this.actorUtils, (VerificationMode)Mockito.times((int)0))).acquireTxCreationPermit();
        }
    }

    @Test
    public void testWaitTillReadyBlocking() {
        ((ActorUtils)Mockito.doReturn((Object)this.datastoreContext).when((Object)this.actorUtils)).getDatastoreContext();
        ((DatastoreContext)Mockito.doReturn((Object)this.shardElectionTimeout).when((Object)this.datastoreContext)).getShardLeaderElectionTimeout();
        ((DatastoreContext)Mockito.doReturn((Object)1).when((Object)this.datastoreContext)).getInitialSettleTimeoutMultiplier();
        ((Timeout)Mockito.doReturn((Object)FiniteDuration.apply((long)50L, (TimeUnit)TimeUnit.MILLISECONDS)).when((Object)this.shardElectionTimeout)).duration();
        try (DistributedDataStore distributedDataStore = new DistributedDataStore(this.actorUtils, UNKNOWN_ID);){
            long start = System.currentTimeMillis();
            distributedDataStore.waitTillReady();
            long end = System.currentTimeMillis();
            Assert.assertTrue((String)"Expected to be blocked for 50 millis", (end - start >= 50L ? 1 : 0) != 0);
        }
    }

    @Test
    public void testWaitTillReadyCountDown() {
        try (DistributedDataStore distributedDataStore = new DistributedDataStore(this.actorUtils, UNKNOWN_ID);){
            ((ActorUtils)Mockito.doReturn((Object)this.datastoreContext).when((Object)this.actorUtils)).getDatastoreContext();
            ((DatastoreContext)Mockito.doReturn((Object)this.shardElectionTimeout).when((Object)this.datastoreContext)).getShardLeaderElectionTimeout();
            ((Timeout)Mockito.doReturn((Object)FiniteDuration.apply((long)5000L, (TimeUnit)TimeUnit.MILLISECONDS)).when((Object)this.shardElectionTimeout)).duration();
            Executors.newSingleThreadExecutor().submit(() -> {
                Uninterruptibles.sleepUninterruptibly((long)500L, (TimeUnit)TimeUnit.MILLISECONDS);
                distributedDataStore.readinessFuture().set(null);
            });
            long start = System.currentTimeMillis();
            distributedDataStore.waitTillReady();
            long end = System.currentTimeMillis();
            Assert.assertTrue((String)"Expected to be released in 500 millis", (end - start < 5000L ? 1 : 0) != 0);
        }
    }
}

