/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.cluster.datastore;

import akka.actor.ActorSystem;
import akka.actor.Address;
import akka.actor.AddressFromURIString;
import akka.cluster.Cluster;
import akka.testkit.javadsl.TestKit;
import com.google.common.base.Stopwatch;
import com.google.common.util.concurrent.Uninterruptibles;
import com.typesafe.config.Config;
import com.typesafe.config.ConfigFactory;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.io.FileUtils;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.opendaylight.controller.cluster.databroker.TestClientBackedDataStore;
import org.opendaylight.controller.cluster.datastore.AbstractDataStore;
import org.opendaylight.controller.cluster.datastore.AbstractDistributedDataStoreIntegrationTest;
import org.opendaylight.controller.cluster.datastore.IntegrationTestKit;
import org.opendaylight.controller.cluster.datastore.MemberNode;
import org.opendaylight.controller.cluster.datastore.TestDistributedDataStore;
import org.opendaylight.controller.cluster.raft.utils.InMemorySnapshotStore;
import org.opendaylight.controller.md.cluster.datastore.model.CarsModel;
import org.opendaylight.mdsal.dom.spi.store.DOMStoreReadWriteTransaction;
import org.opendaylight.mdsal.dom.spi.store.DOMStoreTransactionChain;
import org.opendaylight.mdsal.dom.spi.store.DOMStoreWriteTransaction;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.common.Uint64;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;
import org.opendaylight.yangtools.yang.data.api.schema.MapEntryNode;
import org.opendaylight.yangtools.yang.data.api.schema.MapNode;
import org.opendaylight.yangtools.yang.data.api.schema.NormalizedNode;
import org.opendaylight.yangtools.yang.data.impl.schema.ImmutableNodes;
import org.opendaylight.yangtools.yang.data.impl.schema.builder.api.CollectionNodeBuilder;

@RunWith(value=Parameterized.class)
public class DistributedDataStoreWithSegmentedJournalIntegrationTest
extends AbstractDistributedDataStoreIntegrationTest {
    @Parameterized.Parameters(name="{0}")
    public static Collection<Object[]> data() {
        return Arrays.asList({TestDistributedDataStore.class}, {TestClientBackedDataStore.class});
    }

    @Before
    public void setUp() {
        InMemorySnapshotStore.clear();
        this.system = ActorSystem.create((String)"cluster-test", (Config)ConfigFactory.load((String)"segmented.conf").getConfig("Member1"));
        DistributedDataStoreWithSegmentedJournalIntegrationTest.cleanSnapshotDir(this.system);
        Address member1Address = AddressFromURIString.parse((String)"akka://cluster-test@127.0.0.1:2558");
        Cluster.get((ActorSystem)this.system).join(member1Address);
    }

    @After
    public void tearDown() {
        TestKit.shutdownActorSystem((ActorSystem)this.system, (boolean)true);
        this.system = null;
    }

    private static void cleanSnapshotDir(ActorSystem system) {
        File journalDir = new File(system.settings().config().getString("akka.persistence.journal.segmented-file.root-directory"));
        if (!journalDir.exists()) {
            return;
        }
        try {
            FileUtils.cleanDirectory((File)journalDir);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Test
    public void testManyWritesDeletes() throws Exception {
        DOMStoreTransactionChain txChain;
        IntegrationTestKit testKit = new IntegrationTestKit(this.getSystem(), this.datastoreContextBuilder);
        CollectionNodeBuilder carMapBuilder = ImmutableNodes.mapNodeBuilder((QName)CarsModel.CAR_QNAME);
        try (AbstractDataStore dataStore = testKit.setupAbstractDataStore((Class<? extends AbstractDataStore>)this.testParameter, "testManyWritesDeletes", "module-shards-cars-member-1.conf", true, "cars");){
            txChain = dataStore.createTransactionChain();
            DOMStoreWriteTransaction writeTx = txChain.newWriteOnlyTransaction();
            writeTx.write(CarsModel.BASE_PATH, CarsModel.emptyContainer());
            writeTx.write(CarsModel.CAR_LIST_PATH, CarsModel.newCarMapNode());
            testKit.doCommit(writeTx.ready());
            int numCars = 20;
            for (int i = 0; i < numCars; ++i) {
                DOMStoreReadWriteTransaction rwTx = txChain.newReadWriteTransaction();
                YangInstanceIdentifier path = CarsModel.newCarPath("car" + i);
                MapEntryNode data = CarsModel.newCarEntry("car" + i, Uint64.valueOf((int)20000));
                rwTx.merge(path, (NormalizedNode)data);
                carMapBuilder.withChild((NormalizedNode)data);
                testKit.doCommit(rwTx.ready());
                if (i % 5 != 0) continue;
                rwTx = txChain.newReadWriteTransaction();
                rwTx.delete(path);
                carMapBuilder.withoutChild(path.getLastPathArgument());
                testKit.doCommit(rwTx.ready());
            }
            Optional optional = (Optional)txChain.newReadOnlyTransaction().read(CarsModel.CAR_LIST_PATH).get(5L, TimeUnit.SECONDS);
            Assert.assertTrue((String)"isPresent", (boolean)optional.isPresent());
            MapNode cars = (MapNode)carMapBuilder.build();
            Assert.assertEquals((String)"cars not matching result", (Object)cars, optional.get());
            txChain.close();
            Stopwatch sw = Stopwatch.createStarted();
            AtomicBoolean done = new AtomicBoolean(false);
            while (!done.get()) {
                MemberNode.verifyRaftState(dataStore, "cars", raftState -> {
                    if (raftState.getLastApplied() == raftState.getLastLogIndex()) {
                        done.set(true);
                    }
                });
                Assert.assertTrue((String)"Shard did not persist all journal entries in time.", (sw.elapsed(TimeUnit.SECONDS) <= 5L ? 1 : 0) != 0);
                Uninterruptibles.sleepUninterruptibly((long)50L, (TimeUnit)TimeUnit.MILLISECONDS);
            }
        }
        dataStore = testKit.setupAbstractDataStore((Class<? extends AbstractDataStore>)this.testParameter, "testManyWritesDeletes", "module-shards-cars-member-1.conf", true, "cars");
        try {
            txChain = dataStore.createTransactionChain();
            MapNode cars = (MapNode)carMapBuilder.build();
            Optional optional = (Optional)txChain.newReadOnlyTransaction().read(CarsModel.CAR_LIST_PATH).get(5L, TimeUnit.SECONDS);
            Assert.assertTrue((String)"isPresent", (boolean)optional.isPresent());
            Assert.assertEquals((String)"restored cars do not match snapshot", (Object)cars, optional.get());
            txChain.close();
        }
        finally {
            if (dataStore != null) {
                dataStore.close();
            }
        }
    }
}

