/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.cluster.datastore;

import akka.actor.ActorRef;
import java.util.Arrays;
import java.util.List;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;
import org.opendaylight.controller.cluster.datastore.AbstractActorTest;
import org.opendaylight.controller.cluster.datastore.ForwardingDataTreeChangeListener;
import org.opendaylight.controller.cluster.datastore.messages.DataTreeChanged;
import org.opendaylight.controller.cluster.raft.utils.MessageCollectorActor;
import org.opendaylight.yangtools.yang.data.api.schema.tree.DataTreeCandidate;

public class ForwardingDataTreeChangeListenerTest
extends AbstractActorTest {
    @Test
    public void testOnDataChanged() {
        ActorRef actorRef = ForwardingDataTreeChangeListenerTest.getSystem().actorOf(MessageCollectorActor.props());
        ForwardingDataTreeChangeListener forwardingListener = new ForwardingDataTreeChangeListener(ForwardingDataTreeChangeListenerTest.getSystem().actorSelection(actorRef.path()), ActorRef.noSender());
        List<DataTreeCandidate> expected = Arrays.asList((DataTreeCandidate)Mockito.mock(DataTreeCandidate.class));
        forwardingListener.onDataTreeChanged(expected);
        DataTreeChanged actual = (DataTreeChanged)MessageCollectorActor.expectFirstMatching((ActorRef)actorRef, DataTreeChanged.class, (long)5000L);
        Assert.assertSame(expected, (Object)actual.getChanges());
    }
}

