/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.cluster.datastore;

import akka.actor.ActorRef;
import akka.testkit.javadsl.TestKit;
import com.google.common.collect.ImmutableList;
import java.time.Duration;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.opendaylight.controller.cluster.datastore.AbstractActorTest;
import org.opendaylight.controller.cluster.datastore.ClusterWrapper;
import org.opendaylight.controller.cluster.datastore.RootDataTreeChangeListenerProxy;
import org.opendaylight.controller.cluster.datastore.config.Configuration;
import org.opendaylight.controller.cluster.datastore.exceptions.NotInitializedException;
import org.opendaylight.controller.cluster.datastore.messages.DataTreeChanged;
import org.opendaylight.controller.cluster.datastore.messages.EnableNotification;
import org.opendaylight.controller.cluster.datastore.messages.FindLocalShard;
import org.opendaylight.controller.cluster.datastore.messages.LocalShardFound;
import org.opendaylight.controller.cluster.datastore.messages.RegisterDataTreeChangeListener;
import org.opendaylight.controller.cluster.datastore.messages.RegisterDataTreeNotificationListenerReply;
import org.opendaylight.controller.cluster.datastore.utils.ActorUtils;
import org.opendaylight.controller.md.cluster.datastore.model.PeopleModel;
import org.opendaylight.mdsal.dom.api.ClusteredDOMDataTreeChangeListener;
import org.opendaylight.mdsal.dom.api.DOMDataTreeChangeListener;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;
import org.opendaylight.yangtools.yang.data.api.schema.tree.DataTreeCandidate;
import org.opendaylight.yangtools.yang.data.api.schema.tree.DataTreeCandidates;

public class RootDataTreeChangeListenerProxyTest
extends AbstractActorTest {
    @Test(timeout=10000L)
    public void testSuccessfulRegistrationOnTwoShards() {
        TestKit kit = new TestKit(RootDataTreeChangeListenerProxyTest.getSystem());
        ActorUtils actorUtils = new ActorUtils(RootDataTreeChangeListenerProxyTest.getSystem(), kit.getRef(), (ClusterWrapper)Mockito.mock(ClusterWrapper.class), (Configuration)Mockito.mock(Configuration.class));
        ClusteredDOMDataTreeChangeListener mockClusteredListener = (ClusteredDOMDataTreeChangeListener)Mockito.mock(ClusteredDOMDataTreeChangeListener.class);
        YangInstanceIdentifier path = YangInstanceIdentifier.empty();
        RootDataTreeChangeListenerProxy rootListenerProxy = new RootDataTreeChangeListenerProxy(actorUtils, (DOMDataTreeChangeListener)mockClusteredListener, Set.of("shard-1", "shard-2"));
        Duration timeout = Duration.ofSeconds(5L);
        FindLocalShard findLocalShard1 = (FindLocalShard)kit.expectMsgClass(FindLocalShard.class);
        kit.reply((Object)new LocalShardFound(kit.getRef()));
        FindLocalShard findLocalShard2 = (FindLocalShard)kit.expectMsgClass(FindLocalShard.class);
        kit.reply((Object)new LocalShardFound(kit.getRef()));
        Assert.assertTrue((boolean)List.of(findLocalShard1.getShardName(), findLocalShard2.getShardName()).containsAll(List.of("shard-2", "shard-1")));
        RegisterDataTreeChangeListener registerForShard1 = (RegisterDataTreeChangeListener)kit.expectMsgClass(timeout, RegisterDataTreeChangeListener.class);
        Assert.assertEquals((String)"getPath", (Object)path, (Object)registerForShard1.getPath());
        Assert.assertTrue((String)"isRegisterOnAllInstances", (boolean)registerForShard1.isRegisterOnAllInstances());
        kit.reply((Object)new RegisterDataTreeNotificationListenerReply(kit.getRef()));
        RegisterDataTreeChangeListener registerForShard2 = (RegisterDataTreeChangeListener)kit.expectMsgClass(timeout, RegisterDataTreeChangeListener.class);
        Assert.assertEquals((String)"getPath", (Object)path, (Object)registerForShard2.getPath());
        Assert.assertTrue((String)"isRegisterOnAllInstances", (boolean)registerForShard2.isRegisterOnAllInstances());
        kit.reply((Object)new RegisterDataTreeNotificationListenerReply(kit.getRef()));
        Assert.assertEquals((Object)registerForShard1.getListenerActorPath(), (Object)registerForShard2.getListenerActorPath());
        TestKit kit2 = new TestKit(RootDataTreeChangeListenerProxyTest.getSystem());
        ActorRef rootListenerActor = RootDataTreeChangeListenerProxyTest.getSystem().actorFor(registerForShard1.getListenerActorPath());
        rootListenerActor.tell((Object)new EnableNotification(true, "test"), kit.getRef());
        DataTreeCandidate peopleCandidate = DataTreeCandidates.fromNormalizedNode((YangInstanceIdentifier)YangInstanceIdentifier.empty(), PeopleModel.create());
        rootListenerActor.tell((Object)new DataTreeChanged((Collection)ImmutableList.of((Object)peopleCandidate)), kit.getRef());
        rootListenerActor.tell((Object)new DataTreeChanged((Collection)ImmutableList.of((Object)peopleCandidate)), kit2.getRef());
        ((ClusteredDOMDataTreeChangeListener)Mockito.verify((Object)mockClusteredListener, (VerificationMode)Mockito.timeout((long)100L).times(1))).onDataTreeChanged((Collection)ArgumentMatchers.any());
        rootListenerProxy.close();
    }

    @Test(timeout=10000L, expected=AssertionError.class)
    public void testNotAllShardsFound() {
        TestKit kit = new TestKit(RootDataTreeChangeListenerProxyTest.getSystem());
        ActorUtils actorUtils = new ActorUtils(RootDataTreeChangeListenerProxyTest.getSystem(), kit.getRef(), (ClusterWrapper)Mockito.mock(ClusterWrapper.class), (Configuration)Mockito.mock(Configuration.class));
        ClusteredDOMDataTreeChangeListener mockClusteredListener = (ClusteredDOMDataTreeChangeListener)Mockito.mock(ClusteredDOMDataTreeChangeListener.class);
        RootDataTreeChangeListenerProxy rootListenerProxy = new RootDataTreeChangeListenerProxy(actorUtils, (DOMDataTreeChangeListener)mockClusteredListener, Set.of("shard-1", "shard-2"));
        Duration timeout = Duration.ofSeconds(5L);
        kit.expectMsgClass(FindLocalShard.class);
        kit.reply((Object)new LocalShardFound(kit.getRef()));
        kit.expectMsgClass(FindLocalShard.class);
        kit.expectMsgClass(timeout, RegisterDataTreeChangeListener.class);
        rootListenerProxy.close();
    }

    @Test(timeout=10000L, expected=AssertionError.class)
    public void testLocalShardNotInitialized() {
        TestKit kit = new TestKit(RootDataTreeChangeListenerProxyTest.getSystem());
        ActorUtils actorUtils = new ActorUtils(RootDataTreeChangeListenerProxyTest.getSystem(), kit.getRef(), (ClusterWrapper)Mockito.mock(ClusterWrapper.class), (Configuration)Mockito.mock(Configuration.class));
        ClusteredDOMDataTreeChangeListener mockClusteredListener = (ClusteredDOMDataTreeChangeListener)Mockito.mock(ClusteredDOMDataTreeChangeListener.class);
        RootDataTreeChangeListenerProxy rootListenerProxy = new RootDataTreeChangeListenerProxy(actorUtils, (DOMDataTreeChangeListener)mockClusteredListener, Set.of("shard-1"));
        Duration timeout = Duration.ofSeconds(5L);
        kit.expectMsgClass(FindLocalShard.class);
        kit.reply((Object)new NotInitializedException("not initialized"));
        kit.expectMsgClass(timeout, RegisterDataTreeChangeListener.class);
        rootListenerProxy.close();
    }
}

