/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.cluster.datastore;

import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;
import org.opendaylight.controller.cluster.datastore.DatastoreContext;
import org.opendaylight.controller.cluster.datastore.MockIdentifiers;
import org.opendaylight.controller.cluster.datastore.TransactionContext;
import org.opendaylight.controller.cluster.datastore.TransactionContextWrapper;
import org.opendaylight.controller.cluster.datastore.TransactionOperation;
import org.opendaylight.controller.cluster.datastore.utils.ActorUtils;

public class TransactionContextWrapperTest {
    @Mock
    private ActorUtils actorUtils;
    @Mock
    private TransactionContext transactionContext;
    private TransactionContextWrapper transactionContextWrapper;

    @Before
    public void setUp() {
        MockitoAnnotations.initMocks((Object)this);
        ((ActorUtils)Mockito.doReturn((Object)DatastoreContext.newBuilder().build()).when((Object)this.actorUtils)).getDatastoreContext();
        this.transactionContextWrapper = new TransactionContextWrapper(MockIdentifiers.transactionIdentifier(TransactionContextWrapperTest.class, "mock"), this.actorUtils, "mock");
    }

    @Test
    public void testExecutePriorTransactionOperations() {
        for (int i = 0; i < 100; ++i) {
            this.transactionContextWrapper.maybeExecuteTransactionOperation((TransactionOperation)Mockito.mock(TransactionOperation.class));
        }
        Assert.assertEquals((long)901L, (long)this.transactionContextWrapper.getLimiter().availablePermits());
        this.transactionContextWrapper.executePriorTransactionOperations(this.transactionContext);
        Assert.assertEquals((long)1001L, (long)this.transactionContextWrapper.getLimiter().availablePermits());
    }
}

