/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.cluster.datastore.actors;

import akka.actor.ActorRef;
import akka.testkit.javadsl.TestKit;
import java.time.Duration;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;
import org.mockito.verification.VerificationMode;
import org.opendaylight.controller.cluster.datastore.AbstractActorTest;
import org.opendaylight.controller.cluster.datastore.actors.DataTreeNotificationListenerRegistrationActor;
import org.opendaylight.controller.cluster.datastore.messages.CloseDataTreeNotificationListenerRegistration;
import org.opendaylight.controller.cluster.datastore.messages.CloseDataTreeNotificationListenerRegistrationReply;
import org.opendaylight.yangtools.concepts.ListenerRegistration;

public class DataTreeNotificationListenerRegistrationActorTest
extends AbstractActorTest {
    @Mock
    private ListenerRegistration<?> mockListenerReg;
    @Mock
    private Runnable mockOnClose;
    private TestKit kit;

    @Before
    public void setup() {
        MockitoAnnotations.initMocks((Object)this);
        DataTreeNotificationListenerRegistrationActor.killDelay = 100L;
        this.kit = new TestKit(DataTreeNotificationListenerRegistrationActorTest.getSystem());
    }

    @Test
    public void testOnReceiveCloseListenerRegistrationAfterSetRegistration() {
        ActorRef subject = DataTreeNotificationListenerRegistrationActorTest.getSystem().actorOf(DataTreeNotificationListenerRegistrationActor.props(), "testOnReceiveCloseListenerRegistrationAfterSetRegistration");
        this.kit.watch(subject);
        subject.tell((Object)new DataTreeNotificationListenerRegistrationActor.SetRegistration(this.mockListenerReg, this.mockOnClose), ActorRef.noSender());
        subject.tell((Object)CloseDataTreeNotificationListenerRegistration.getInstance(), this.kit.getRef());
        this.kit.expectMsgClass(Duration.ofSeconds(5L), CloseDataTreeNotificationListenerRegistrationReply.class);
        ((ListenerRegistration)Mockito.verify(this.mockListenerReg, (VerificationMode)Mockito.timeout((long)5000L))).close();
        ((Runnable)Mockito.verify((Object)this.mockOnClose, (VerificationMode)Mockito.timeout((long)5000L))).run();
        this.kit.expectTerminated(Duration.ofSeconds(5L), subject);
    }

    @Test
    public void testOnReceiveCloseListenerRegistrationBeforeSetRegistration() {
        ActorRef subject = DataTreeNotificationListenerRegistrationActorTest.getSystem().actorOf(DataTreeNotificationListenerRegistrationActor.props(), "testOnReceiveSetRegistrationAfterPriorClose");
        this.kit.watch(subject);
        subject.tell((Object)CloseDataTreeNotificationListenerRegistration.getInstance(), this.kit.getRef());
        this.kit.expectMsgClass(Duration.ofSeconds(5L), CloseDataTreeNotificationListenerRegistrationReply.class);
        subject.tell((Object)new DataTreeNotificationListenerRegistrationActor.SetRegistration(this.mockListenerReg, this.mockOnClose), ActorRef.noSender());
        ((ListenerRegistration)Mockito.verify(this.mockListenerReg, (VerificationMode)Mockito.timeout((long)5000L))).close();
        ((Runnable)Mockito.verify((Object)this.mockOnClose, (VerificationMode)Mockito.timeout((long)5000L))).run();
        this.kit.expectTerminated(Duration.ofSeconds(5L), subject);
    }

    @Test
    public void testOnReceiveSetRegistrationAfterPriorClose() {
        DataTreeNotificationListenerRegistrationActor.killDelay = 1000L;
        ListenerRegistration mockListenerReg2 = (ListenerRegistration)Mockito.mock(ListenerRegistration.class);
        Runnable mockOnClose2 = (Runnable)Mockito.mock(Runnable.class);
        ActorRef subject = DataTreeNotificationListenerRegistrationActorTest.getSystem().actorOf(DataTreeNotificationListenerRegistrationActor.props(), "testOnReceiveSetRegistrationAfterPriorClose");
        this.kit.watch(subject);
        subject.tell((Object)new DataTreeNotificationListenerRegistrationActor.SetRegistration(this.mockListenerReg, this.mockOnClose), ActorRef.noSender());
        subject.tell((Object)CloseDataTreeNotificationListenerRegistration.getInstance(), ActorRef.noSender());
        subject.tell((Object)new DataTreeNotificationListenerRegistrationActor.SetRegistration(mockListenerReg2, mockOnClose2), ActorRef.noSender());
        ((ListenerRegistration)Mockito.verify(this.mockListenerReg, (VerificationMode)Mockito.timeout((long)5000L))).close();
        ((Runnable)Mockito.verify((Object)this.mockOnClose, (VerificationMode)Mockito.timeout((long)5000L))).run();
        ((ListenerRegistration)Mockito.verify((Object)mockListenerReg2, (VerificationMode)Mockito.timeout((long)5000L))).close();
        ((Runnable)Mockito.verify((Object)mockOnClose2, (VerificationMode)Mockito.timeout((long)5000L))).run();
        this.kit.expectTerminated(Duration.ofSeconds(5L), subject);
    }
}

