/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.cluster.datastore.config;

import com.google.common.collect.ImmutableSortedSet;
import com.google.common.collect.Sets;
import java.net.URI;
import java.util.Collection;
import java.util.Set;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.opendaylight.controller.cluster.access.concepts.MemberName;
import org.opendaylight.controller.cluster.datastore.config.ConfigurationImpl;
import org.opendaylight.controller.cluster.datastore.config.ModuleShardConfiguration;
import org.opendaylight.controller.cluster.datastore.shardstrategy.ModuleShardStrategy;
import org.opendaylight.controller.cluster.datastore.shardstrategy.ShardStrategy;

public abstract class ConfigurationImplBaseTest {
    private static final MemberName MEMBER_1 = MemberName.forName((String)"member-1");
    private static final MemberName MEMBER_2 = MemberName.forName((String)"member-2");
    private static final MemberName MEMBER_3 = MemberName.forName((String)"member-3");
    private static final MemberName MEMBER_4 = MemberName.forName((String)"member-4");
    private static final MemberName MEMBER_5 = MemberName.forName((String)"member-5");
    private static final MemberName MEMBER_100 = MemberName.forName((String)"member-100");
    private ConfigurationImpl configuration;

    @Before
    public void setup() {
        this.configuration = this.createConfiguration();
    }

    public abstract ConfigurationImpl createConfiguration();

    @Test
    public void testConstructor() {
        Assert.assertNotNull((Object)this.configuration);
    }

    @Test
    public void testGetMemberShardNames() {
        Collection memberShardNames = this.configuration.getMemberShardNames(MEMBER_1);
        Assert.assertEquals((String)"getMemberShardNames", (Object)ImmutableSortedSet.of((Comparable)((Object)"people-1"), (Comparable)((Object)"cars-1"), (Comparable)((Object)"test-1"), (Comparable)((Object)"default")), (Object)ImmutableSortedSet.copyOf((Collection)memberShardNames));
        memberShardNames = this.configuration.getMemberShardNames(MEMBER_2);
        Assert.assertEquals((String)"getMemberShardNames", (Object)ImmutableSortedSet.of((Comparable)((Object)"default")), (Object)ImmutableSortedSet.copyOf((Collection)memberShardNames));
        memberShardNames = this.configuration.getMemberShardNames(MEMBER_100);
        Assert.assertEquals((String)"getMemberShardNames size", (long)0L, (long)memberShardNames.size());
    }

    @Test
    public void testGetMembersFromShardName() {
        Collection members = this.configuration.getMembersFromShardName("default");
        Assert.assertEquals((String)"getMembersFromShardName", (Object)ImmutableSortedSet.of((Comparable)MEMBER_1, (Comparable)MEMBER_2, (Comparable)MEMBER_3), (Object)ImmutableSortedSet.copyOf((Collection)members));
        members = this.configuration.getMembersFromShardName("cars-1");
        Assert.assertEquals((String)"getMembersFromShardName", (Object)ImmutableSortedSet.of((Comparable)MEMBER_1), (Object)ImmutableSortedSet.copyOf((Collection)members));
        members = this.configuration.getMembersFromShardName("foobar");
        Assert.assertEquals((String)"getMembersFromShardName size", (long)0L, (long)members.size());
    }

    @Test
    public void testGetAllShardNames() {
        Set allShardNames = this.configuration.getAllShardNames();
        Assert.assertEquals((String)"getAllShardNames", (Object)ImmutableSortedSet.of((Comparable)((Object)"people-1"), (Comparable)((Object)"cars-1"), (Comparable)((Object)"test-1"), (Comparable)((Object)"default")), (Object)ImmutableSortedSet.copyOf((Collection)allShardNames));
    }

    @Test
    public void testGetModuleNameFromNameSpace() {
        String moduleName = this.configuration.getModuleNameFromNameSpace("urn:opendaylight:params:xml:ns:yang:controller:md:sal:dom:store:test:cars");
        Assert.assertEquals((String)"getModuleNameFromNameSpace", (Object)"cars", (Object)moduleName);
        moduleName = this.configuration.getModuleNameFromNameSpace("urn:opendaylight:params:xml:ns:yang:controller:md:sal:dom:store:test");
        Assert.assertEquals((String)"getModuleNameFromNameSpace", (Object)"test", (Object)moduleName);
        moduleName = this.configuration.getModuleNameFromNameSpace("non-existent");
        Assert.assertNull((String)"getModuleNameFromNameSpace - expected null", (Object)moduleName);
    }

    @Test
    public void testGetStrategyForModule() {
        ShardStrategy strategy = this.configuration.getStrategyForModule("cars");
        Assert.assertNotNull((String)"getStrategyForModule null", (Object)strategy);
        Assert.assertEquals((String)"getStrategyForModule type", ModuleShardStrategy.class, strategy.getClass());
        strategy = this.configuration.getStrategyForModule("people");
        Assert.assertNotNull((String)"getStrategyForModule null", (Object)strategy);
        Assert.assertEquals((String)"getStrategyForModule type", ModuleShardStrategy.class, strategy.getClass());
        strategy = this.configuration.getStrategyForModule("default");
        Assert.assertNull((String)"getStrategyForModule - expected null", (Object)strategy);
        strategy = this.configuration.getStrategyForModule("non-existent");
        Assert.assertNull((String)"getStrategyForModule - expected null", (Object)strategy);
    }

    @Test
    public void testGetShardNameForModule() {
        String shardName = this.configuration.getShardNameForModule("cars");
        Assert.assertEquals((String)"getShardNameForModule", (Object)"cars-1", (Object)shardName);
        shardName = this.configuration.getShardNameForModule("people");
        Assert.assertEquals((String)"getShardNameForModule", (Object)"people-1", (Object)shardName);
        shardName = this.configuration.getShardNameForModule("non-existent");
        Assert.assertNull((String)"getShardNameForModule - expected null", (Object)shardName);
    }

    @Test
    public void testAddModuleShardConfiguration() throws Exception {
        URI namespace = new URI("urn:opendaylight:test:oven");
        String moduleName = "oven";
        String shardName = "oven-shard";
        String shardStrategyName = "module";
        ImmutableSortedSet shardMemberNames = ImmutableSortedSet.of((Comparable)MEMBER_1, (Comparable)MEMBER_4, (Comparable)MEMBER_5);
        this.configuration.addModuleShardConfiguration(new ModuleShardConfiguration(namespace, moduleName, shardName, shardStrategyName, (Collection)shardMemberNames));
        Assert.assertEquals((String)"getMemberShardNames", (Object)ImmutableSortedSet.of((Comparable)((Object)"people-1"), (Comparable)((Object)"cars-1"), (Comparable)((Object)"test-1"), (Comparable)((Object)"default"), (Comparable)((Object)shardName)), (Object)ImmutableSortedSet.copyOf((Collection)this.configuration.getMemberShardNames(MEMBER_1)));
        Assert.assertEquals((String)"getMemberShardNames", (Object)ImmutableSortedSet.of((Comparable)((Object)shardName)), (Object)ImmutableSortedSet.copyOf((Collection)this.configuration.getMemberShardNames(MEMBER_4)));
        Assert.assertEquals((String)"getMemberShardNames", (Object)ImmutableSortedSet.of((Comparable)((Object)shardName)), (Object)ImmutableSortedSet.copyOf((Collection)this.configuration.getMemberShardNames(MEMBER_5)));
        Assert.assertEquals((String)"getMembersFromShardName", (Object)shardMemberNames, (Object)ImmutableSortedSet.copyOf((Collection)this.configuration.getMembersFromShardName(shardName)));
        Assert.assertEquals((String)"getShardNameForModule", (Object)shardName, (Object)this.configuration.getShardNameForModule(moduleName));
        Assert.assertEquals((String)"getModuleNameFromNameSpace", (Object)moduleName, (Object)this.configuration.getModuleNameFromNameSpace(namespace.toASCIIString()));
        Assert.assertEquals((String)"getAllShardNames", (Object)ImmutableSortedSet.of((Comparable)((Object)"people-1"), (Comparable)((Object)"cars-1"), (Comparable)((Object)"test-1"), (Comparable)((Object)"default"), (Comparable)((Object)shardName)), (Object)ImmutableSortedSet.copyOf((Collection)this.configuration.getAllShardNames()));
        ShardStrategy strategy = this.configuration.getStrategyForModule("cars");
        Assert.assertNotNull((String)"getStrategyForModule null", (Object)strategy);
        Assert.assertEquals((String)"getStrategyForModule type", ModuleShardStrategy.class, strategy.getClass());
    }

    @Test
    public void testGetUniqueMemberNamesForAllShards() {
        Assert.assertEquals((String)"getUniqueMemberNamesForAllShards", (Object)Sets.newHashSet((Object[])new MemberName[]{MEMBER_1, MEMBER_2, MEMBER_3}), (Object)this.configuration.getUniqueMemberNamesForAllShards());
    }

    @Test
    public void testAddMemberReplicaForShard() {
        this.configuration.addMemberReplicaForShard("people-1", MEMBER_2);
        String shardName = this.configuration.getShardNameForModule("people");
        Assert.assertEquals((String)"ModuleShardName", (Object)"people-1", (Object)shardName);
        ShardStrategy shardStrategy = this.configuration.getStrategyForModule("people");
        Assert.assertEquals((String)"ModuleStrategy", ModuleShardStrategy.class, shardStrategy.getClass());
        Collection members = this.configuration.getMembersFromShardName("people-1");
        Assert.assertEquals((String)"Members", (Object)ImmutableSortedSet.of((Comparable)MEMBER_1, (Comparable)MEMBER_2), (Object)ImmutableSortedSet.copyOf((Collection)members));
        this.configuration.addMemberReplicaForShard("non-existent", MEMBER_2);
        Set shardNames = this.configuration.getAllShardNames();
        Assert.assertEquals((String)"ShardNames", (Object)ImmutableSortedSet.of((Comparable)((Object)"people-1"), (Comparable)((Object)"cars-1"), (Comparable)((Object)"test-1"), (Comparable)((Object)"default")), (Object)ImmutableSortedSet.copyOf((Collection)shardNames));
    }

    @Test
    public void testRemoveMemberReplicaForShard() {
        this.configuration.removeMemberReplicaForShard("default", MEMBER_2);
        String shardName = this.configuration.getShardNameForModule("default");
        Assert.assertEquals((String)"ModuleShardName", (Object)"default", (Object)shardName);
        ShardStrategy shardStrategy = this.configuration.getStrategyForModule("default");
        Assert.assertNull((String)"ModuleStrategy", (Object)shardStrategy);
        Collection members = this.configuration.getMembersFromShardName("default");
        Assert.assertEquals((String)"Members", (Object)ImmutableSortedSet.of((Comparable)MEMBER_1, (Comparable)MEMBER_3), (Object)ImmutableSortedSet.copyOf((Collection)members));
        this.configuration.removeMemberReplicaForShard("non-existent", MEMBER_2);
        Set shardNames = this.configuration.getAllShardNames();
        Assert.assertEquals((String)"ShardNames", (Object)ImmutableSortedSet.of((Comparable)((Object)"people-1"), (Comparable)((Object)"cars-1"), (Comparable)((Object)"test-1"), (Comparable)((Object)"default")), (Object)ImmutableSortedSet.copyOf((Collection)shardNames));
    }
}

