/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.cluster.datastore.messages;

import com.google.common.collect.ImmutableSortedSet;
import java.io.Serializable;
import java.util.Optional;
import org.apache.commons.lang.SerializationUtils;
import org.junit.Assert;
import org.junit.Test;
import org.opendaylight.controller.cluster.access.concepts.TransactionIdentifier;
import org.opendaylight.controller.cluster.datastore.AbstractTest;
import org.opendaylight.controller.cluster.datastore.messages.BatchedModifications;
import org.opendaylight.controller.cluster.datastore.messages.BatchedModificationsReply;
import org.opendaylight.controller.cluster.datastore.modification.DeleteModification;
import org.opendaylight.controller.cluster.datastore.modification.MergeModification;
import org.opendaylight.controller.cluster.datastore.modification.Modification;
import org.opendaylight.controller.cluster.datastore.modification.WriteModification;
import org.opendaylight.controller.md.cluster.datastore.model.TestModel;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;
import org.opendaylight.yangtools.yang.data.api.schema.DataContainerChild;
import org.opendaylight.yangtools.yang.data.api.schema.NormalizedNode;
import org.opendaylight.yangtools.yang.data.impl.schema.ImmutableNodes;
import org.opendaylight.yangtools.yang.data.impl.schema.builder.impl.ImmutableContainerNodeBuilder;

public class BatchedModificationsTest
extends AbstractTest {
    @Test
    public void testSerialization() {
        YangInstanceIdentifier writePath = TestModel.TEST_PATH;
        NormalizedNode writeData = ImmutableContainerNodeBuilder.create().withNodeIdentifier((YangInstanceIdentifier.PathArgument)new YangInstanceIdentifier.NodeIdentifier(TestModel.TEST_QNAME)).withChild((DataContainerChild)ImmutableNodes.leafNode((QName)TestModel.DESC_QNAME, (Object)"foo")).build();
        YangInstanceIdentifier mergePath = TestModel.OUTER_LIST_PATH;
        NormalizedNode mergeData = ImmutableContainerNodeBuilder.create().withNodeIdentifier((YangInstanceIdentifier.PathArgument)new YangInstanceIdentifier.NodeIdentifier(TestModel.OUTER_LIST_QNAME)).build();
        YangInstanceIdentifier deletePath = TestModel.TEST_PATH;
        TransactionIdentifier tx1 = BatchedModificationsTest.nextTransactionId();
        BatchedModifications batched = new BatchedModifications(tx1, 11);
        batched.addModification((Modification)new WriteModification(writePath, writeData));
        batched.addModification((Modification)new MergeModification(mergePath, mergeData));
        batched.addModification((Modification)new DeleteModification(deletePath));
        Assert.assertFalse((String)"isReady", (boolean)batched.isReady());
        batched.setReady();
        Assert.assertTrue((String)"isReady", (boolean)batched.isReady());
        batched.setTotalMessagesSent(5);
        BatchedModifications clone = (BatchedModifications)SerializationUtils.clone((Serializable)((Serializable)batched.toSerializable()));
        Assert.assertEquals((String)"getVersion", (long)11L, (long)clone.getVersion());
        Assert.assertEquals((String)"getTransactionID", (Object)tx1, (Object)clone.getTransactionId());
        Assert.assertTrue((String)"isReady", (boolean)clone.isReady());
        Assert.assertFalse((String)"isDoCommitOnReady", (boolean)clone.isDoCommitOnReady());
        Assert.assertFalse((String)"participatingShardNames present", (boolean)clone.getParticipatingShardNames().isPresent());
        Assert.assertEquals((String)"getTotalMessagesSent", (long)5L, (long)clone.getTotalMessagesSent());
        Assert.assertEquals((String)"getModifications size", (long)3L, (long)clone.getModifications().size());
        WriteModification write = (WriteModification)clone.getModifications().get(0);
        Assert.assertEquals((String)"getVersion", (long)11L, (long)write.getVersion());
        Assert.assertEquals((String)"getPath", (Object)writePath, (Object)write.getPath());
        Assert.assertEquals((String)"getData", (Object)writeData, (Object)write.getData());
        MergeModification merge = (MergeModification)clone.getModifications().get(1);
        Assert.assertEquals((String)"getVersion", (long)11L, (long)merge.getVersion());
        Assert.assertEquals((String)"getPath", (Object)mergePath, (Object)merge.getPath());
        Assert.assertEquals((String)"getData", (Object)mergeData, (Object)merge.getData());
        DeleteModification delete = (DeleteModification)clone.getModifications().get(2);
        Assert.assertEquals((String)"getVersion", (long)11L, (long)delete.getVersion());
        Assert.assertEquals((String)"getPath", (Object)deletePath, (Object)delete.getPath());
        TransactionIdentifier tx2 = BatchedModificationsTest.nextTransactionId();
        batched = new BatchedModifications(tx2, 10000);
        ImmutableSortedSet shardNames = ImmutableSortedSet.of((Comparable)((Object)"one"), (Comparable)((Object)"two"));
        batched.setReady(Optional.of(shardNames));
        batched.setDoCommitOnReady(true);
        Assert.assertTrue((String)"isReady", (boolean)batched.isReady());
        clone = (BatchedModifications)SerializationUtils.clone((Serializable)((Serializable)batched.toSerializable()));
        Assert.assertEquals((String)"getVersion", (long)11L, (long)clone.getVersion());
        Assert.assertEquals((String)"getTransactionID", (Object)tx2, (Object)clone.getTransactionId());
        Assert.assertTrue((String)"isReady", (boolean)clone.isReady());
        Assert.assertTrue((String)"isDoCommitOnReady", (boolean)clone.isDoCommitOnReady());
        Assert.assertTrue((String)"participatingShardNames present", (boolean)clone.getParticipatingShardNames().isPresent());
        Assert.assertEquals((String)"participatingShardNames", (Object)shardNames, clone.getParticipatingShardNames().get());
        Assert.assertEquals((String)"getModifications size", (long)0L, (long)clone.getModifications().size());
        batched = new BatchedModifications(tx2, 11);
        clone = (BatchedModifications)SerializationUtils.clone((Serializable)((Serializable)batched.toSerializable()));
        Assert.assertEquals((String)"getVersion", (long)11L, (long)clone.getVersion());
        Assert.assertEquals((String)"getTransactionID", (Object)tx2, (Object)clone.getTransactionId());
        Assert.assertFalse((String)"isReady", (boolean)clone.isReady());
        Assert.assertEquals((String)"getModifications size", (long)0L, (long)clone.getModifications().size());
        batched = new BatchedModifications(tx2, 5);
        batched.addModification((Modification)new WriteModification(writePath, writeData));
        batched.setReady(Optional.of(ImmutableSortedSet.of((Comparable)((Object)"one"), (Comparable)((Object)"two"))));
        clone = (BatchedModifications)SerializationUtils.clone((Serializable)((Serializable)batched.toSerializable()));
        Assert.assertEquals((String)"getVersion", (long)5L, (long)clone.getVersion());
        Assert.assertEquals((String)"getTransactionID", (Object)tx2, (Object)clone.getTransactionId());
        Assert.assertTrue((String)"isReady", (boolean)clone.isReady());
        Assert.assertFalse((String)"participatingShardNames present", (boolean)clone.getParticipatingShardNames().isPresent());
        Assert.assertEquals((String)"getModifications size", (long)1L, (long)clone.getModifications().size());
    }

    @Test
    public void testBatchedModificationsReplySerialization() {
        BatchedModificationsReply clone = (BatchedModificationsReply)SerializationUtils.clone((Serializable)((Serializable)new BatchedModificationsReply(100).toSerializable()));
        Assert.assertEquals((String)"getNumBatched", (long)100L, (long)clone.getNumBatched());
    }
}

