/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.cluster.datastore.modification;

import com.google.common.util.concurrent.FluentFuture;
import com.google.common.util.concurrent.MoreExecutors;
import java.util.Optional;
import java.util.concurrent.ExecutorService;
import org.junit.AfterClass;
import org.junit.Before;
import org.junit.BeforeClass;
import org.opendaylight.controller.md.cluster.datastore.model.TestModel;
import org.opendaylight.mdsal.dom.spi.store.DOMStoreReadTransaction;
import org.opendaylight.mdsal.dom.spi.store.DOMStoreThreePhaseCommitCohort;
import org.opendaylight.mdsal.dom.spi.store.DOMStoreWriteTransaction;
import org.opendaylight.mdsal.dom.store.inmemory.InMemoryDOMDataStore;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;
import org.opendaylight.yangtools.yang.data.api.schema.NormalizedNode;
import org.opendaylight.yangtools.yang.model.api.EffectiveModelContext;

public abstract class AbstractModificationTest {
    private static EffectiveModelContext TEST_SCHEMA_CONTEXT;
    protected InMemoryDOMDataStore store;

    @BeforeClass
    public static void beforeClass() {
        TEST_SCHEMA_CONTEXT = TestModel.createTestContext();
    }

    @AfterClass
    public static void afterClass() {
        TEST_SCHEMA_CONTEXT = null;
    }

    @Before
    public void setUp() {
        this.store = new InMemoryDOMDataStore("test", (ExecutorService)MoreExecutors.newDirectExecutorService());
        this.store.onModelContextUpdated(TEST_SCHEMA_CONTEXT);
    }

    protected void commitTransaction(DOMStoreWriteTransaction transaction) {
        DOMStoreThreePhaseCommitCohort cohort = transaction.ready();
        cohort.preCommit();
        cohort.commit();
    }

    protected Optional<NormalizedNode<?, ?>> readData(YangInstanceIdentifier path) throws Exception {
        DOMStoreReadTransaction transaction = this.store.newReadOnlyTransaction();
        FluentFuture future = transaction.read(path);
        return (Optional)future.get();
    }
}

