/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.cluster.datastore.modification;

import java.io.Serializable;
import java.util.Optional;
import org.apache.commons.lang.SerializationUtils;
import org.junit.Assert;
import org.junit.Test;
import org.opendaylight.controller.cluster.datastore.modification.AbstractModificationTest;
import org.opendaylight.controller.cluster.datastore.modification.WriteModification;
import org.opendaylight.controller.md.cluster.datastore.model.TestModel;
import org.opendaylight.mdsal.dom.spi.store.DOMStoreReadWriteTransaction;
import org.opendaylight.mdsal.dom.spi.store.DOMStoreWriteTransaction;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;
import org.opendaylight.yangtools.yang.data.api.schema.DataContainerChild;
import org.opendaylight.yangtools.yang.data.api.schema.NormalizedNode;
import org.opendaylight.yangtools.yang.data.impl.schema.ImmutableNodes;
import org.opendaylight.yangtools.yang.data.impl.schema.builder.impl.ImmutableContainerNodeBuilder;

public class WriteModificationTest
extends AbstractModificationTest {
    @Test
    public void testApply() throws Exception {
        DOMStoreReadWriteTransaction writeTransaction = this.store.newReadWriteTransaction();
        WriteModification writeModification = new WriteModification(TestModel.TEST_PATH, (NormalizedNode)ImmutableNodes.containerNode((QName)TestModel.TEST_QNAME));
        writeModification.apply((DOMStoreWriteTransaction)writeTransaction);
        this.commitTransaction((DOMStoreWriteTransaction)writeTransaction);
        Optional<NormalizedNode<?, ?>> data = this.readData(TestModel.TEST_PATH);
        Assert.assertTrue((boolean)data.isPresent());
    }

    @Test
    public void testSerialization() {
        YangInstanceIdentifier path = TestModel.TEST_PATH;
        NormalizedNode data = ImmutableContainerNodeBuilder.create().withNodeIdentifier((YangInstanceIdentifier.PathArgument)new YangInstanceIdentifier.NodeIdentifier(TestModel.TEST_QNAME)).withChild((DataContainerChild)ImmutableNodes.leafNode((QName)TestModel.DESC_QNAME, (Object)"foo")).build();
        WriteModification expected = new WriteModification(path, data);
        WriteModification clone = (WriteModification)SerializationUtils.clone((Serializable)expected);
        Assert.assertEquals((String)"getPath", (Object)expected.getPath(), (Object)clone.getPath());
        Assert.assertEquals((String)"getData", (Object)expected.getData(), (Object)clone.getData());
    }
}

