/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.cluster.datastore.persisted;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Range;
import com.google.common.collect.RangeSet;
import com.google.common.collect.TreeRangeSet;
import com.google.common.primitives.UnsignedLong;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.junit.Assert;
import org.junit.Test;
import org.opendaylight.controller.cluster.access.concepts.ClientIdentifier;
import org.opendaylight.controller.cluster.access.concepts.FrontendIdentifier;
import org.opendaylight.controller.cluster.access.concepts.FrontendType;
import org.opendaylight.controller.cluster.access.concepts.MemberName;
import org.opendaylight.controller.cluster.datastore.persisted.FrontendClientMetadata;
import org.opendaylight.controller.cluster.datastore.persisted.FrontendHistoryMetadata;
import org.opendaylight.controller.cluster.datastore.persisted.FrontendShardDataTreeSnapshotMetadata;

public class FrontendShardDataTreeSnapshotMetadataTest {
    @Test(expected=NullPointerException.class)
    public final void testCreateMetadataSnapshotNullInput() {
        new FrontendShardDataTreeSnapshotMetadata(null);
    }

    @Test
    public final void testCreateMetadataSnapshotEmptyInput() throws Exception {
        FrontendShardDataTreeSnapshotMetadata emptyOrigSnapshot = FrontendShardDataTreeSnapshotMetadataTest.createEmptyMetadataSnapshot();
        FrontendShardDataTreeSnapshotMetadata emptyCopySnapshot = FrontendShardDataTreeSnapshotMetadataTest.copy(emptyOrigSnapshot, 127);
        FrontendShardDataTreeSnapshotMetadataTest.testMetadataSnapshotEqual(emptyOrigSnapshot, emptyCopySnapshot);
    }

    @Test
    public final void testSerializeMetadataSnapshotWithOneClient() throws Exception {
        FrontendShardDataTreeSnapshotMetadata origSnapshot = FrontendShardDataTreeSnapshotMetadataTest.createMetadataSnapshot(1);
        FrontendShardDataTreeSnapshotMetadata copySnapshot = FrontendShardDataTreeSnapshotMetadataTest.copy(origSnapshot, 162);
        FrontendShardDataTreeSnapshotMetadataTest.testMetadataSnapshotEqual(origSnapshot, copySnapshot);
    }

    @Test
    public final void testSerializeMetadataSnapshotWithMoreClients() throws Exception {
        FrontendShardDataTreeSnapshotMetadata origSnapshot = FrontendShardDataTreeSnapshotMetadataTest.createMetadataSnapshot(5);
        FrontendShardDataTreeSnapshotMetadata copySnapshot = FrontendShardDataTreeSnapshotMetadataTest.copy(origSnapshot, 314);
        FrontendShardDataTreeSnapshotMetadataTest.testMetadataSnapshotEqual(origSnapshot, copySnapshot);
    }

    private static void testMetadataSnapshotEqual(FrontendShardDataTreeSnapshotMetadata origSnapshot, FrontendShardDataTreeSnapshotMetadata copySnapshot) {
        List origClientList = origSnapshot.getClients();
        List copyClientList = copySnapshot.getClients();
        Assert.assertTrue((origClientList.size() == copyClientList.size() ? 1 : 0) != 0);
        HashMap origIdent = new HashMap();
        HashMap copyIdent = new HashMap();
        origClientList.forEach(client -> origIdent.put(client.getIdentifier(), client));
        origClientList.forEach(client -> copyIdent.put(client.getIdentifier(), client));
        Assert.assertTrue((boolean)origIdent.keySet().containsAll(copyIdent.keySet()));
        Assert.assertTrue((boolean)copyIdent.keySet().containsAll(origIdent.keySet()));
        origIdent.values().forEach(client -> {
            FrontendClientMetadata copyClient = (FrontendClientMetadata)copyIdent.get(client.getIdentifier());
            FrontendShardDataTreeSnapshotMetadataTest.testObject(client.getIdentifier(), copyClient.getIdentifier());
            Assert.assertTrue((boolean)client.getPurgedHistories().equals((Object)copyClient.getPurgedHistories()));
            Assert.assertTrue((boolean)client.getCurrentHistories().equals(copyClient.getCurrentHistories()));
        });
    }

    private static FrontendShardDataTreeSnapshotMetadata createEmptyMetadataSnapshot() {
        return new FrontendShardDataTreeSnapshotMetadata(Collections.emptyList());
    }

    private static FrontendShardDataTreeSnapshotMetadata createMetadataSnapshot(int size) {
        ArrayList<FrontendClientMetadata> clients = new ArrayList<FrontendClientMetadata>(size);
        for (long i = 0L; i < (long)size; ++i) {
            clients.add(FrontendShardDataTreeSnapshotMetadataTest.createFrontedClientMetadata(i));
        }
        return new FrontendShardDataTreeSnapshotMetadata(clients);
    }

    private static FrontendClientMetadata createFrontedClientMetadata(long num) {
        String index = String.valueOf(num);
        String indexName = "test_" + index;
        FrontendIdentifier frontendIdentifier = FrontendIdentifier.create((MemberName)MemberName.forName((String)indexName), (FrontendType)FrontendType.forName((String)index));
        ClientIdentifier clientIdentifier = ClientIdentifier.create((FrontendIdentifier)frontendIdentifier, (long)num);
        TreeRangeSet purgedHistories = TreeRangeSet.create();
        purgedHistories.add(Range.closed((Comparable)UnsignedLong.ZERO, (Comparable)UnsignedLong.ONE));
        Set<FrontendHistoryMetadata> currentHistories = Collections.singleton(new FrontendHistoryMetadata(num, num, true, (Map)ImmutableMap.of((Object)UnsignedLong.ZERO, (Object)Boolean.TRUE), (RangeSet)purgedHistories));
        return new FrontendClientMetadata(clientIdentifier, (RangeSet)purgedHistories, currentHistories);
    }

    private static <T> void testObject(T object, T equalObject) {
        Assert.assertEquals((long)object.hashCode(), (long)equalObject.hashCode());
        Assert.assertTrue((boolean)object.equals(object));
        Assert.assertTrue((boolean)object.equals(equalObject));
        Assert.assertFalse((boolean)object.equals(null));
        Assert.assertFalse((boolean)object.equals("dummy"));
    }

    private static <T> T copy(T obj, int expectedSize) throws IOException, ClassNotFoundException {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        try (ObjectOutputStream oos = new ObjectOutputStream(bos);){
            oos.writeObject(obj);
        }
        byte[] bytes = bos.toByteArray();
        Assert.assertEquals((long)expectedSize, (long)bytes.length);
        try (ObjectInputStream ois = new ObjectInputStream(new ByteArrayInputStream(bytes));){
            Object object = ois.readObject();
            return (T)object;
        }
    }
}

