/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.cluster.datastore.shardmanager;

import akka.actor.ActorRef;
import akka.actor.ActorSystem;
import akka.actor.AddressFromURIString;
import akka.actor.Props;
import akka.actor.Status;
import akka.cluster.Cluster;
import akka.cluster.ClusterEvent;
import akka.cluster.Member;
import akka.dispatch.Dispatchers;
import akka.dispatch.OnComplete;
import akka.japi.Creator;
import akka.pattern.Patterns;
import akka.persistence.RecoveryCompleted;
import akka.serialization.Serialization;
import akka.testkit.TestActorRef;
import akka.testkit.javadsl.TestKit;
import akka.util.Timeout;
import com.google.common.base.Stopwatch;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.google.common.util.concurrent.Uninterruptibles;
import java.net.URI;
import java.util.AbstractMap;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.opendaylight.controller.cluster.access.concepts.MemberName;
import org.opendaylight.controller.cluster.datastore.AbstractDataStore;
import org.opendaylight.controller.cluster.datastore.AbstractShardManagerTest;
import org.opendaylight.controller.cluster.datastore.ClusterWrapper;
import org.opendaylight.controller.cluster.datastore.ClusterWrapperImpl;
import org.opendaylight.controller.cluster.datastore.DatastoreContext;
import org.opendaylight.controller.cluster.datastore.DatastoreContextFactory;
import org.opendaylight.controller.cluster.datastore.DistributedDataStore;
import org.opendaylight.controller.cluster.datastore.Shard;
import org.opendaylight.controller.cluster.datastore.config.Configuration;
import org.opendaylight.controller.cluster.datastore.config.ConfigurationImpl;
import org.opendaylight.controller.cluster.datastore.config.EmptyModuleShardConfigProvider;
import org.opendaylight.controller.cluster.datastore.config.ModuleShardConfigProvider;
import org.opendaylight.controller.cluster.datastore.config.ModuleShardConfiguration;
import org.opendaylight.controller.cluster.datastore.exceptions.AlreadyExistsException;
import org.opendaylight.controller.cluster.datastore.exceptions.NoShardLeaderException;
import org.opendaylight.controller.cluster.datastore.exceptions.NotInitializedException;
import org.opendaylight.controller.cluster.datastore.exceptions.PrimaryNotFoundException;
import org.opendaylight.controller.cluster.datastore.identifiers.ShardIdentifier;
import org.opendaylight.controller.cluster.datastore.identifiers.ShardManagerIdentifier;
import org.opendaylight.controller.cluster.datastore.messages.ActorInitialized;
import org.opendaylight.controller.cluster.datastore.messages.AddShardReplica;
import org.opendaylight.controller.cluster.datastore.messages.ChangeShardMembersVotingStatus;
import org.opendaylight.controller.cluster.datastore.messages.CreateShard;
import org.opendaylight.controller.cluster.datastore.messages.FindLocalShard;
import org.opendaylight.controller.cluster.datastore.messages.FindPrimary;
import org.opendaylight.controller.cluster.datastore.messages.LocalPrimaryShardFound;
import org.opendaylight.controller.cluster.datastore.messages.LocalShardFound;
import org.opendaylight.controller.cluster.datastore.messages.LocalShardNotFound;
import org.opendaylight.controller.cluster.datastore.messages.PeerDown;
import org.opendaylight.controller.cluster.datastore.messages.PeerUp;
import org.opendaylight.controller.cluster.datastore.messages.PrimaryShardInfo;
import org.opendaylight.controller.cluster.datastore.messages.RemotePrimaryShardFound;
import org.opendaylight.controller.cluster.datastore.messages.RemoveShardReplica;
import org.opendaylight.controller.cluster.datastore.messages.ShardLeaderStateChanged;
import org.opendaylight.controller.cluster.datastore.messages.UpdateSchemaContext;
import org.opendaylight.controller.cluster.datastore.persisted.DatastoreSnapshot;
import org.opendaylight.controller.cluster.datastore.persisted.ShardManagerSnapshot;
import org.opendaylight.controller.cluster.datastore.shardmanager.AbstractShardManagerCreator;
import org.opendaylight.controller.cluster.datastore.shardmanager.RegisterForShardAvailabilityChanges;
import org.opendaylight.controller.cluster.datastore.shardmanager.ShardInformation;
import org.opendaylight.controller.cluster.datastore.shardmanager.ShardManager;
import org.opendaylight.controller.cluster.datastore.shardmanager.ShardPeerAddressResolver;
import org.opendaylight.controller.cluster.datastore.shardmanager.SwitchShardBehavior;
import org.opendaylight.controller.cluster.datastore.utils.ForwardingActor;
import org.opendaylight.controller.cluster.datastore.utils.MockClusterWrapper;
import org.opendaylight.controller.cluster.datastore.utils.MockConfiguration;
import org.opendaylight.controller.cluster.datastore.utils.PrimaryShardInfoFutureCache;
import org.opendaylight.controller.cluster.notifications.LeaderStateChanged;
import org.opendaylight.controller.cluster.notifications.RegisterRoleChangeListener;
import org.opendaylight.controller.cluster.notifications.RoleChangeNotification;
import org.opendaylight.controller.cluster.raft.RaftState;
import org.opendaylight.controller.cluster.raft.base.messages.FollowerInitialSyncUpStatus;
import org.opendaylight.controller.cluster.raft.base.messages.SwitchBehavior;
import org.opendaylight.controller.cluster.raft.client.messages.GetSnapshot;
import org.opendaylight.controller.cluster.raft.client.messages.Shutdown;
import org.opendaylight.controller.cluster.raft.messages.AddServer;
import org.opendaylight.controller.cluster.raft.messages.AddServerReply;
import org.opendaylight.controller.cluster.raft.messages.ChangeServersVotingStatus;
import org.opendaylight.controller.cluster.raft.messages.RemoveServer;
import org.opendaylight.controller.cluster.raft.messages.RemoveServerReply;
import org.opendaylight.controller.cluster.raft.messages.ServerChangeReply;
import org.opendaylight.controller.cluster.raft.messages.ServerChangeStatus;
import org.opendaylight.controller.cluster.raft.messages.ServerRemoved;
import org.opendaylight.controller.cluster.raft.policy.DisableElectionsRaftPolicy;
import org.opendaylight.controller.cluster.raft.utils.InMemorySnapshotStore;
import org.opendaylight.controller.cluster.raft.utils.MessageCollectorActor;
import org.opendaylight.controller.md.cluster.datastore.model.TestModel;
import org.opendaylight.yangtools.concepts.Registration;
import org.opendaylight.yangtools.yang.data.api.schema.tree.DataTree;
import org.opendaylight.yangtools.yang.data.api.schema.tree.ReadOnlyDataTree;
import org.opendaylight.yangtools.yang.model.api.EffectiveModelContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Function1;
import scala.concurrent.Await;
import scala.concurrent.Awaitable;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.FiniteDuration;

public class ShardManagerTest
extends AbstractShardManagerTest {
    private static final Logger LOG = LoggerFactory.getLogger(ShardManagerTest.class);
    private static final MemberName MEMBER_2 = MemberName.forName((String)"member-2");
    private static final MemberName MEMBER_3 = MemberName.forName((String)"member-3");
    private static EffectiveModelContext TEST_SCHEMA_CONTEXT;
    private final String shardMgrID;

    public ShardManagerTest() {
        this.shardMgrID = ShardManagerIdentifier.builder().type(this.shardMrgIDSuffix).build().toString();
    }

    @BeforeClass
    public static void beforeClass() {
        TEST_SCHEMA_CONTEXT = TestModel.createTestContext();
    }

    @AfterClass
    public static void afterClass() {
        TEST_SCHEMA_CONTEXT = null;
    }

    private ActorSystem newActorSystem(String config) {
        return this.newActorSystem("cluster-test", config);
    }

    private ActorRef newMockShardActor(ActorSystem system, String shardName, String memberName) {
        String name = ShardIdentifier.create((String)shardName, (MemberName)MemberName.forName((String)memberName), (String)"config").toString();
        if (system == ShardManagerTest.getSystem()) {
            return this.actorFactory.createActor(MessageCollectorActor.props(), name);
        }
        return system.actorOf(MessageCollectorActor.props(), name);
    }

    private Props newShardMgrProps() {
        return this.newShardMgrProps((Configuration)new MockConfiguration());
    }

    private static DatastoreContextFactory newDatastoreContextFactory(DatastoreContext datastoreContext) {
        DatastoreContextFactory mockFactory = (DatastoreContextFactory)Mockito.mock(DatastoreContextFactory.class);
        ((DatastoreContextFactory)Mockito.doReturn((Object)datastoreContext).when((Object)mockFactory)).getBaseDatastoreContext();
        ((DatastoreContextFactory)Mockito.doReturn((Object)datastoreContext).when((Object)mockFactory)).getShardDatastoreContext(ArgumentMatchers.anyString());
        return mockFactory;
    }

    private TestShardManager.Builder newTestShardMgrBuilderWithMockShardActor() {
        return this.newTestShardMgrBuilderWithMockShardActor(mockShardActor);
    }

    private TestShardManager.Builder newTestShardMgrBuilderWithMockShardActor(ActorRef shardActor) {
        return (TestShardManager.Builder)TestShardManager.builder(this.datastoreContextBuilder).shardActor(shardActor).distributedDataStore((AbstractDataStore)Mockito.mock(DistributedDataStore.class));
    }

    private Props newPropsShardMgrWithMockShardActor() {
        return this.newTestShardMgrBuilderWithMockShardActor().props().withDispatcher(Dispatchers.DefaultDispatcherId());
    }

    private Props newPropsShardMgrWithMockShardActor(ActorRef shardActor) {
        return this.newTestShardMgrBuilderWithMockShardActor(shardActor).props().withDispatcher(Dispatchers.DefaultDispatcherId());
    }

    private TestShardManager newTestShardManager() {
        return this.newTestShardManager(this.newShardMgrProps());
    }

    private TestShardManager newTestShardManager(Props props) {
        TestActorRef shardManagerActor = this.actorFactory.createTestActor(props);
        TestShardManager shardManager = (TestShardManager)shardManagerActor.underlyingActor();
        shardManager.waitForRecoveryComplete();
        return shardManager;
    }

    private static void waitForShardInitialized(ActorRef shardManager, String shardName, TestKit kit) {
        AssertionError last = null;
        Stopwatch sw = Stopwatch.createStarted();
        while (sw.elapsed(TimeUnit.SECONDS) <= 5L) {
            try {
                shardManager.tell((Object)new FindLocalShard(shardName, true), kit.getRef());
                kit.expectMsgClass(LocalShardFound.class);
                return;
            }
            catch (AssertionError e) {
                last = e;
                Uninterruptibles.sleepUninterruptibly((long)50L, (TimeUnit)TimeUnit.MILLISECONDS);
            }
        }
        throw last;
    }

    private static <T> T expectMsgClassOrFailure(Class<T> msgClass, TestKit kit, String msg) {
        Object reply = kit.expectMsgAnyClassOf(kit.duration("5 sec"), new Class[]{msgClass, Status.Failure.class});
        if (reply instanceof Status.Failure) {
            throw new AssertionError(msg + " failed", ((Status.Failure)reply).cause());
        }
        return (T)reply;
    }

    @Test
    public void testPerShardDatastoreContext() throws Exception {
        LOG.info("testPerShardDatastoreContext starting");
        final DatastoreContextFactory mockFactory = ShardManagerTest.newDatastoreContextFactory(this.datastoreContextBuilder.shardElectionTimeoutFactor(5L).build());
        ((DatastoreContextFactory)Mockito.doReturn((Object)DatastoreContext.newBuilderFrom((DatastoreContext)this.datastoreContextBuilder.build()).shardElectionTimeoutFactor(6L).build()).when((Object)mockFactory)).getShardDatastoreContext("default");
        ((DatastoreContextFactory)Mockito.doReturn((Object)DatastoreContext.newBuilderFrom((DatastoreContext)this.datastoreContextBuilder.build()).shardElectionTimeoutFactor(7L).build()).when((Object)mockFactory)).getShardDatastoreContext("topology");
        final MockConfiguration mockConfig = new MockConfiguration(){

            public Collection<String> getMemberShardNames(MemberName memberName) {
                return Arrays.asList("default", "topology");
            }

            public Collection<MemberName> getMembersFromShardName(String shardName) {
                return ShardManagerTest.members("member-1");
            }
        };
        ActorRef defaultShardActor = this.actorFactory.createActor(MessageCollectorActor.props(), this.actorFactory.generateActorId("default"));
        ActorRef topologyShardActor = this.actorFactory.createActor(MessageCollectorActor.props(), this.actorFactory.generateActorId("topology"));
        final Map<String, AbstractMap.SimpleEntry<ActorRef, Object>> shardInfoMap = Collections.synchronizedMap(new HashMap());
        shardInfoMap.put("default", new AbstractMap.SimpleEntry<ActorRef, Object>(defaultShardActor, null));
        shardInfoMap.put("topology", new AbstractMap.SimpleEntry<ActorRef, Object>(topologyShardActor, null));
        final PrimaryShardInfoFutureCache primaryShardInfoCache = new PrimaryShardInfoFutureCache();
        final CountDownLatch newShardActorLatch = new CountDownLatch(2);
        Creator<ShardManager> creator = new Creator<ShardManager>(){
            private static final long serialVersionUID = 1L;

            public ShardManager create() {
                class LocalShardManager
                extends ShardManager {
                    final /* synthetic */ Map val$shardInfoMap;
                    final /* synthetic */ CountDownLatch val$newShardActorLatch;
                    final /* synthetic */ ShardManagerTest this$0;

                    LocalShardManager(AbstractShardManagerCreator<?> creator) {
                        this.this$0 = this$0;
                        this.val$shardInfoMap = var3_3;
                        this.val$newShardActorLatch = var4_4;
                        super(creator);
                    }

                    protected ActorRef newShardActor(ShardInformation info) {
                        Map.Entry entry = (Map.Entry)this.val$shardInfoMap.get(info.getShardName());
                        ActorRef ref = null;
                        if (entry != null) {
                            ref = (ActorRef)entry.getKey();
                            entry.setValue(info.getDatastoreContext());
                        }
                        this.val$newShardActorLatch.countDown();
                        return ref;
                    }
                }
                return new LocalShardManager(ShardManagerTest.this, ((GenericCreator)((GenericCreator)new GenericCreator<LocalShardManager>(LocalShardManager.class).datastoreContextFactory(mockFactory)).primaryShardInfoCache(primaryShardInfoCache)).configuration((Configuration)mockConfig), shardInfoMap, newShardActorLatch);
            }
        };
        TestKit kit = new TestKit(ShardManagerTest.getSystem());
        ActorRef shardManager = this.actorFactory.createActor(Props.create(ShardManager.class, (Creator)new DelegatingShardManagerCreator(creator)).withDispatcher(Dispatchers.DefaultDispatcherId()));
        shardManager.tell((Object)new UpdateSchemaContext(TEST_SCHEMA_CONTEXT), kit.getRef());
        Assert.assertTrue((String)"Shard actors created", (boolean)newShardActorLatch.await(5L, TimeUnit.SECONDS));
        Assert.assertEquals((String)"getShardElectionTimeoutFactor", (long)6L, (long)((DatastoreContext)((Map.Entry)shardInfoMap.get("default")).getValue()).getShardElectionTimeoutFactor());
        Assert.assertEquals((String)"getShardElectionTimeoutFactor", (long)7L, (long)((DatastoreContext)((Map.Entry)shardInfoMap.get("topology")).getValue()).getShardElectionTimeoutFactor());
        DatastoreContextFactory newMockFactory = ShardManagerTest.newDatastoreContextFactory(this.datastoreContextBuilder.shardElectionTimeoutFactor(5L).build());
        ((DatastoreContextFactory)Mockito.doReturn((Object)DatastoreContext.newBuilderFrom((DatastoreContext)this.datastoreContextBuilder.build()).shardElectionTimeoutFactor(66L).build()).when((Object)newMockFactory)).getShardDatastoreContext("default");
        ((DatastoreContextFactory)Mockito.doReturn((Object)DatastoreContext.newBuilderFrom((DatastoreContext)this.datastoreContextBuilder.build()).shardElectionTimeoutFactor(77L).build()).when((Object)newMockFactory)).getShardDatastoreContext("topology");
        shardManager.tell((Object)newMockFactory, kit.getRef());
        DatastoreContext newContext = (DatastoreContext)MessageCollectorActor.expectFirstMatching((ActorRef)defaultShardActor, DatastoreContext.class);
        Assert.assertEquals((String)"getShardElectionTimeoutFactor", (long)66L, (long)newContext.getShardElectionTimeoutFactor());
        newContext = (DatastoreContext)MessageCollectorActor.expectFirstMatching((ActorRef)topologyShardActor, DatastoreContext.class);
        Assert.assertEquals((String)"getShardElectionTimeoutFactor", (long)77L, (long)newContext.getShardElectionTimeoutFactor());
        LOG.info("testPerShardDatastoreContext ending");
    }

    @Test
    public void testOnReceiveFindPrimaryForNonExistentShard() {
        TestKit kit = new TestKit(ShardManagerTest.getSystem());
        ActorRef shardManager = this.actorFactory.createActor(this.newPropsShardMgrWithMockShardActor());
        shardManager.tell((Object)new UpdateSchemaContext(TEST_SCHEMA_CONTEXT), kit.getRef());
        shardManager.tell((Object)new FindPrimary("non-existent", false), kit.getRef());
        kit.expectMsgClass(java.time.Duration.ofSeconds(5L), PrimaryNotFoundException.class);
    }

    @Test
    public void testOnReceiveFindPrimaryForLocalLeaderShard() {
        LOG.info("testOnReceiveFindPrimaryForLocalLeaderShard starting");
        TestKit kit = new TestKit(ShardManagerTest.getSystem());
        String memberId = "member-1-shard-default-" + this.shardMrgIDSuffix;
        ActorRef shardManager = this.actorFactory.createActor(this.newPropsShardMgrWithMockShardActor());
        shardManager.tell((Object)new UpdateSchemaContext(TEST_SCHEMA_CONTEXT), kit.getRef());
        shardManager.tell((Object)new ActorInitialized(), mockShardActor);
        DataTree mockDataTree = (DataTree)Mockito.mock(DataTree.class);
        shardManager.tell((Object)new ShardLeaderStateChanged(memberId, memberId, (ReadOnlyDataTree)mockDataTree, 11), kit.getRef());
        MessageCollectorActor.expectFirstMatching((ActorRef)mockShardActor, RegisterRoleChangeListener.class);
        shardManager.tell((Object)new RoleChangeNotification(memberId, RaftState.Candidate.name(), RaftState.Leader.name()), mockShardActor);
        shardManager.tell((Object)new FindPrimary("default", false), kit.getRef());
        LocalPrimaryShardFound primaryFound = (LocalPrimaryShardFound)kit.expectMsgClass(java.time.Duration.ofSeconds(5L), LocalPrimaryShardFound.class);
        Assert.assertTrue((String)("Unexpected primary path " + primaryFound.getPrimaryPath()), (boolean)primaryFound.getPrimaryPath().contains("member-1-shard-default"));
        Assert.assertSame((String)"getLocalShardDataTree", (Object)mockDataTree, (Object)primaryFound.getLocalShardDataTree());
        LOG.info("testOnReceiveFindPrimaryForLocalLeaderShard ending");
    }

    @Test
    public void testOnReceiveFindPrimaryForNonLocalLeaderShardBeforeMemberUp() {
        LOG.info("testOnReceiveFindPrimaryForNonLocalLeaderShardBeforeMemberUp starting");
        TestKit kit = new TestKit(ShardManagerTest.getSystem());
        ActorRef shardManager = this.actorFactory.createActor(this.newPropsShardMgrWithMockShardActor());
        shardManager.tell((Object)new UpdateSchemaContext(TEST_SCHEMA_CONTEXT), kit.getRef());
        shardManager.tell((Object)new ActorInitialized(), mockShardActor);
        String memberId2 = "member-2-shard-default-" + this.shardMrgIDSuffix;
        String memberId1 = "member-1-shard-default-" + this.shardMrgIDSuffix;
        shardManager.tell((Object)new RoleChangeNotification(memberId1, RaftState.Candidate.name(), RaftState.Follower.name()), mockShardActor);
        shardManager.tell((Object)new LeaderStateChanged(memberId1, memberId2, 11), mockShardActor);
        shardManager.tell((Object)new FindPrimary("default", false), kit.getRef());
        kit.expectMsgClass(java.time.Duration.ofSeconds(5L), NoShardLeaderException.class);
        LOG.info("testOnReceiveFindPrimaryForNonLocalLeaderShardBeforeMemberUp ending");
    }

    @Test
    public void testOnReceiveFindPrimaryForNonLocalLeaderShard() {
        LOG.info("testOnReceiveFindPrimaryForNonLocalLeaderShard starting");
        TestKit kit = new TestKit(ShardManagerTest.getSystem());
        ActorRef shardManager = this.actorFactory.createActor(this.newPropsShardMgrWithMockShardActor());
        shardManager.tell((Object)new UpdateSchemaContext(TEST_SCHEMA_CONTEXT), kit.getRef());
        shardManager.tell((Object)new ActorInitialized(), mockShardActor);
        String memberId2 = "member-2-shard-default-" + this.shardMrgIDSuffix;
        MockClusterWrapper.sendMemberUp(shardManager, "member-2", kit.getRef().path().toString());
        String memberId1 = "member-1-shard-default-" + this.shardMrgIDSuffix;
        shardManager.tell((Object)new RoleChangeNotification(memberId1, RaftState.Candidate.name(), RaftState.Follower.name()), mockShardActor);
        short leaderVersion = 10;
        shardManager.tell((Object)new ShardLeaderStateChanged(memberId1, memberId2, leaderVersion), mockShardActor);
        shardManager.tell((Object)new FindPrimary("default", false), kit.getRef());
        RemotePrimaryShardFound primaryFound = (RemotePrimaryShardFound)kit.expectMsgClass(java.time.Duration.ofSeconds(5L), RemotePrimaryShardFound.class);
        Assert.assertTrue((String)("Unexpected primary path " + primaryFound.getPrimaryPath()), (boolean)primaryFound.getPrimaryPath().contains("member-2-shard-default"));
        Assert.assertEquals((String)"getPrimaryVersion", (long)leaderVersion, (long)primaryFound.getPrimaryVersion());
        LOG.info("testOnReceiveFindPrimaryForNonLocalLeaderShard ending");
    }

    @Test
    public void testOnReceiveFindPrimaryForUninitializedShard() {
        TestKit kit = new TestKit(ShardManagerTest.getSystem());
        ActorRef shardManager = this.actorFactory.createActor(this.newPropsShardMgrWithMockShardActor());
        shardManager.tell((Object)new FindPrimary("default", false), kit.getRef());
        kit.expectMsgClass(java.time.Duration.ofSeconds(5L), NotInitializedException.class);
    }

    @Test
    public void testOnReceiveFindPrimaryForInitializedShardWithNoRole() {
        TestKit kit = new TestKit(ShardManagerTest.getSystem());
        ActorRef shardManager = this.actorFactory.createActor(this.newPropsShardMgrWithMockShardActor());
        shardManager.tell((Object)new UpdateSchemaContext(TEST_SCHEMA_CONTEXT), kit.getRef());
        shardManager.tell((Object)new ActorInitialized(), mockShardActor);
        shardManager.tell((Object)new FindPrimary("default", false), kit.getRef());
        kit.expectMsgClass(java.time.Duration.ofSeconds(5L), NoShardLeaderException.class);
    }

    @Test
    public void testOnReceiveFindPrimaryForFollowerShardWithNoInitialLeaderId() {
        LOG.info("testOnReceiveFindPrimaryForFollowerShardWithNoInitialLeaderId starting");
        TestKit kit = new TestKit(ShardManagerTest.getSystem());
        ActorRef shardManager = this.actorFactory.createActor(this.newPropsShardMgrWithMockShardActor());
        shardManager.tell((Object)new UpdateSchemaContext(TEST_SCHEMA_CONTEXT), kit.getRef());
        shardManager.tell((Object)new ActorInitialized(), mockShardActor);
        String memberId = "member-1-shard-default-" + this.shardMrgIDSuffix;
        shardManager.tell((Object)new RoleChangeNotification(memberId, RaftState.Candidate.name(), RaftState.Follower.name()), mockShardActor);
        shardManager.tell((Object)new FindPrimary("default", false), kit.getRef());
        kit.expectMsgClass(java.time.Duration.ofSeconds(5L), NoShardLeaderException.class);
        DataTree mockDataTree = (DataTree)Mockito.mock(DataTree.class);
        shardManager.tell((Object)new ShardLeaderStateChanged(memberId, memberId, (ReadOnlyDataTree)mockDataTree, 11), mockShardActor);
        shardManager.tell((Object)new FindPrimary("default", false), kit.getRef());
        LocalPrimaryShardFound primaryFound = (LocalPrimaryShardFound)kit.expectMsgClass(java.time.Duration.ofSeconds(5L), LocalPrimaryShardFound.class);
        Assert.assertTrue((String)("Unexpected primary path " + primaryFound.getPrimaryPath()), (boolean)primaryFound.getPrimaryPath().contains("member-1-shard-default"));
        Assert.assertSame((String)"getLocalShardDataTree", (Object)mockDataTree, (Object)primaryFound.getLocalShardDataTree());
        LOG.info("testOnReceiveFindPrimaryForFollowerShardWithNoInitialLeaderId starting");
    }

    @Test
    public void testOnReceiveFindPrimaryWaitForShardLeader() {
        LOG.info("testOnReceiveFindPrimaryWaitForShardLeader starting");
        this.datastoreContextBuilder.shardInitializationTimeout(10L, TimeUnit.SECONDS);
        TestKit kit = new TestKit(ShardManagerTest.getSystem());
        ActorRef shardManager = this.actorFactory.createActor(this.newPropsShardMgrWithMockShardActor());
        shardManager.tell((Object)new UpdateSchemaContext(TEST_SCHEMA_CONTEXT), kit.getRef());
        shardManager.tell((Object)new FindPrimary("default", true), kit.getRef());
        kit.expectNoMessage(java.time.Duration.ofMillis(150L));
        shardManager.tell((Object)new ActorInitialized(), mockShardActor);
        kit.expectNoMessage(java.time.Duration.ofMillis(150L));
        String memberId = "member-1-shard-default-" + this.shardMrgIDSuffix;
        shardManager.tell((Object)new RoleChangeNotification(memberId, RaftState.Candidate.name(), RaftState.Leader.name()), mockShardActor);
        kit.expectNoMessage(java.time.Duration.ofMillis(150L));
        DataTree mockDataTree = (DataTree)Mockito.mock(DataTree.class);
        shardManager.tell((Object)new ShardLeaderStateChanged(memberId, memberId, (ReadOnlyDataTree)mockDataTree, 11), mockShardActor);
        LocalPrimaryShardFound primaryFound = (LocalPrimaryShardFound)kit.expectMsgClass(java.time.Duration.ofSeconds(5L), LocalPrimaryShardFound.class);
        Assert.assertTrue((String)("Unexpected primary path " + primaryFound.getPrimaryPath()), (boolean)primaryFound.getPrimaryPath().contains("member-1-shard-default"));
        Assert.assertSame((String)"getLocalShardDataTree", (Object)mockDataTree, (Object)primaryFound.getLocalShardDataTree());
        kit.expectNoMessage(java.time.Duration.ofMillis(200L));
        LOG.info("testOnReceiveFindPrimaryWaitForShardLeader ending");
    }

    @Test
    public void testOnReceiveFindPrimaryWaitForReadyWithUninitializedShard() {
        LOG.info("testOnReceiveFindPrimaryWaitForReadyWithUninitializedShard starting");
        TestKit kit = new TestKit(ShardManagerTest.getSystem());
        ActorRef shardManager = this.actorFactory.createActor(this.newPropsShardMgrWithMockShardActor());
        shardManager.tell((Object)new UpdateSchemaContext(TEST_SCHEMA_CONTEXT), kit.getRef());
        shardManager.tell((Object)new FindPrimary("default", true), kit.getRef());
        kit.expectMsgClass(java.time.Duration.ofSeconds(2L), NotInitializedException.class);
        shardManager.tell((Object)new ActorInitialized(), mockShardActor);
        kit.expectNoMessage(java.time.Duration.ofMillis(200L));
        LOG.info("testOnReceiveFindPrimaryWaitForReadyWithUninitializedShard ending");
    }

    @Test
    public void testOnReceiveFindPrimaryWaitForReadyWithCandidateShard() {
        LOG.info("testOnReceiveFindPrimaryWaitForReadyWithCandidateShard starting");
        TestKit kit = new TestKit(ShardManagerTest.getSystem());
        ActorRef shardManager = this.actorFactory.createActor(this.newPropsShardMgrWithMockShardActor());
        shardManager.tell((Object)new UpdateSchemaContext(TEST_SCHEMA_CONTEXT), kit.getRef());
        shardManager.tell((Object)new ActorInitialized(), mockShardActor);
        shardManager.tell((Object)new RoleChangeNotification("member-1-shard-default-" + this.shardMrgIDSuffix, null, RaftState.Candidate.name()), mockShardActor);
        shardManager.tell((Object)new FindPrimary("default", true), kit.getRef());
        kit.expectMsgClass(java.time.Duration.ofSeconds(2L), NoShardLeaderException.class);
        LOG.info("testOnReceiveFindPrimaryWaitForReadyWithCandidateShard ending");
    }

    @Test
    public void testOnReceiveFindPrimaryWaitForReadyWithIsolatedLeaderShard() {
        LOG.info("testOnReceiveFindPrimaryWaitForReadyWithIsolatedLeaderShard starting");
        TestKit kit = new TestKit(ShardManagerTest.getSystem());
        ActorRef shardManager = this.actorFactory.createActor(this.newPropsShardMgrWithMockShardActor());
        shardManager.tell((Object)new UpdateSchemaContext(TEST_SCHEMA_CONTEXT), kit.getRef());
        shardManager.tell((Object)new ActorInitialized(), mockShardActor);
        shardManager.tell((Object)new RoleChangeNotification("member-1-shard-default-" + this.shardMrgIDSuffix, null, RaftState.IsolatedLeader.name()), mockShardActor);
        shardManager.tell((Object)new FindPrimary("default", true), kit.getRef());
        kit.expectMsgClass(java.time.Duration.ofSeconds(2L), NoShardLeaderException.class);
        LOG.info("testOnReceiveFindPrimaryWaitForReadyWithIsolatedLeaderShard ending");
    }

    @Test
    public void testOnReceiveFindPrimaryWaitForReadyWithNoRoleShard() {
        LOG.info("testOnReceiveFindPrimaryWaitForReadyWithNoRoleShard starting");
        TestKit kit = new TestKit(ShardManagerTest.getSystem());
        ActorRef shardManager = this.actorFactory.createActor(this.newPropsShardMgrWithMockShardActor());
        shardManager.tell((Object)new UpdateSchemaContext(TEST_SCHEMA_CONTEXT), kit.getRef());
        shardManager.tell((Object)new ActorInitialized(), mockShardActor);
        shardManager.tell((Object)new FindPrimary("default", true), kit.getRef());
        kit.expectMsgClass(java.time.Duration.ofSeconds(2L), NoShardLeaderException.class);
        LOG.info("testOnReceiveFindPrimaryWaitForReadyWithNoRoleShard ending");
    }

    @Test
    public void testOnReceiveFindPrimaryForRemoteShard() {
        LOG.info("testOnReceiveFindPrimaryForRemoteShard starting");
        String shardManagerID = ShardManagerIdentifier.builder().type(this.shardMrgIDSuffix).build().toString();
        ActorSystem system1 = this.newActorSystem("Member1");
        Cluster.get((ActorSystem)system1).join(AddressFromURIString.parse((String)"akka://cluster-test@127.0.0.1:2558"));
        TestActorRef shardManager1 = TestActorRef.create((ActorSystem)system1, (Props)((TestShardManager.Builder)this.newTestShardMgrBuilderWithMockShardActor().cluster((ClusterWrapper)new ClusterWrapperImpl(system1))).props().withDispatcher(Dispatchers.DefaultDispatcherId()), (String)shardManagerID);
        ActorSystem system2 = this.newActorSystem("Member2");
        Cluster.get((ActorSystem)system2).join(AddressFromURIString.parse((String)"akka://cluster-test@127.0.0.1:2558"));
        ActorRef mockShardActor2 = this.newMockShardActor(system2, "astronauts", "member-2");
        MockConfiguration mockConfig2 = new MockConfiguration((Map<String, List<String>>)ImmutableMap.builder().put((Object)"default", Arrays.asList("member-1", "member-2")).put((Object)"astronauts", Arrays.asList("member-2")).build());
        TestActorRef shardManager2 = TestActorRef.create((ActorSystem)system2, (Props)((TestShardManager.Builder)this.newTestShardMgrBuilder((Configuration)mockConfig2).shardActor(mockShardActor2).cluster((ClusterWrapper)new ClusterWrapperImpl(system2))).props().withDispatcher(Dispatchers.DefaultDispatcherId()), (String)shardManagerID);
        TestKit kit = new TestKit(system1);
        shardManager1.tell((Object)new UpdateSchemaContext(TEST_SCHEMA_CONTEXT), kit.getRef());
        shardManager2.tell((Object)new UpdateSchemaContext(TEST_SCHEMA_CONTEXT), kit.getRef());
        shardManager2.tell((Object)new ActorInitialized(), mockShardActor2);
        String memberId2 = "member-2-shard-astronauts-" + this.shardMrgIDSuffix;
        short leaderVersion = 10;
        shardManager2.tell((Object)new ShardLeaderStateChanged(memberId2, memberId2, (ReadOnlyDataTree)Mockito.mock(DataTree.class), leaderVersion), mockShardActor2);
        shardManager2.tell((Object)new RoleChangeNotification(memberId2, RaftState.Candidate.name(), RaftState.Leader.name()), mockShardActor2);
        ((TestShardManager)shardManager1.underlyingActor()).waitForMemberUp();
        shardManager1.tell((Object)new FindPrimary("astronauts", false), kit.getRef());
        RemotePrimaryShardFound found = (RemotePrimaryShardFound)kit.expectMsgClass(java.time.Duration.ofSeconds(5L), RemotePrimaryShardFound.class);
        String path = found.getPrimaryPath();
        Assert.assertTrue((String)("Unexpected primary path " + path), (boolean)path.contains("member-2-shard-astronauts-config"));
        Assert.assertEquals((String)"getPrimaryVersion", (long)leaderVersion, (long)found.getPrimaryVersion());
        ((TestShardManager)shardManager2.underlyingActor()).verifyFindPrimary();
        LOG.info("testOnReceiveFindPrimaryForRemoteShard ending");
    }

    @Test
    public void testShardAvailabilityOnChangeOfMemberReachability() {
        LOG.info("testShardAvailabilityOnChangeOfMemberReachability starting");
        String shardManagerID = ShardManagerIdentifier.builder().type(this.shardMrgIDSuffix).build().toString();
        ActorSystem system1 = this.newActorSystem("Member1");
        Cluster.get((ActorSystem)system1).join(AddressFromURIString.parse((String)"akka://cluster-test@127.0.0.1:2558"));
        ActorRef mockShardActor1 = this.newMockShardActor(system1, "default", "member-1");
        TestActorRef shardManager1 = TestActorRef.create((ActorSystem)system1, (Props)((TestShardManager.Builder)this.newTestShardMgrBuilder().shardActor(mockShardActor1).cluster((ClusterWrapper)new ClusterWrapperImpl(system1))).props().withDispatcher(Dispatchers.DefaultDispatcherId()), (String)shardManagerID);
        ActorSystem system2 = this.newActorSystem("Member2");
        Cluster.get((ActorSystem)system2).join(AddressFromURIString.parse((String)"akka://cluster-test@127.0.0.1:2558"));
        ActorRef mockShardActor2 = this.newMockShardActor(system2, "default", "member-2");
        MockConfiguration mockConfig2 = new MockConfiguration((Map<String, List<String>>)ImmutableMap.builder().put((Object)"default", Arrays.asList("member-1", "member-2")).build());
        TestActorRef shardManager2 = TestActorRef.create((ActorSystem)system2, (Props)((TestShardManager.Builder)this.newTestShardMgrBuilder((Configuration)mockConfig2).shardActor(mockShardActor2).cluster((ClusterWrapper)new ClusterWrapperImpl(system2))).props().withDispatcher(Dispatchers.DefaultDispatcherId()), (String)shardManagerID);
        TestKit kit = new TestKit(system1);
        shardManager1.tell((Object)new UpdateSchemaContext(TEST_SCHEMA_CONTEXT), kit.getRef());
        shardManager2.tell((Object)new UpdateSchemaContext(TEST_SCHEMA_CONTEXT), kit.getRef());
        shardManager1.tell((Object)new ActorInitialized(), mockShardActor1);
        shardManager2.tell((Object)new ActorInitialized(), mockShardActor2);
        String memberId2 = "member-2-shard-default-" + this.shardMrgIDSuffix;
        String memberId1 = "member-1-shard-default-" + this.shardMrgIDSuffix;
        shardManager1.tell((Object)new ShardLeaderStateChanged(memberId1, memberId2, (ReadOnlyDataTree)Mockito.mock(DataTree.class), 11), mockShardActor1);
        shardManager1.tell((Object)new RoleChangeNotification(memberId1, RaftState.Candidate.name(), RaftState.Follower.name()), mockShardActor1);
        shardManager2.tell((Object)new ShardLeaderStateChanged(memberId2, memberId2, (ReadOnlyDataTree)Mockito.mock(DataTree.class), 11), mockShardActor2);
        shardManager2.tell((Object)new RoleChangeNotification(memberId2, RaftState.Candidate.name(), RaftState.Leader.name()), mockShardActor2);
        ((TestShardManager)shardManager1.underlyingActor()).waitForMemberUp();
        shardManager1.tell((Object)new FindPrimary("default", true), kit.getRef());
        RemotePrimaryShardFound found = (RemotePrimaryShardFound)kit.expectMsgClass(java.time.Duration.ofSeconds(5L), RemotePrimaryShardFound.class);
        String path = found.getPrimaryPath();
        Assert.assertTrue((String)("Unexpected primary path " + path), (boolean)path.contains("member-2-shard-default-config"));
        shardManager1.tell((Object)MockClusterWrapper.createUnreachableMember("member-2", "akka://cluster-test@127.0.0.1:2558"), kit.getRef());
        ((TestShardManager)shardManager1.underlyingActor()).waitForUnreachableMember();
        PeerDown peerDown = (PeerDown)MessageCollectorActor.expectFirstMatching((ActorRef)mockShardActor1, PeerDown.class);
        Assert.assertEquals((String)"getMemberName", (Object)MEMBER_2, (Object)peerDown.getMemberName());
        MessageCollectorActor.clearMessages((ActorRef)mockShardActor1);
        shardManager1.tell((Object)MockClusterWrapper.createMemberRemoved("member-2", "akka://cluster-test@127.0.0.1:2558"), kit.getRef());
        MessageCollectorActor.expectFirstMatching((ActorRef)mockShardActor1, PeerDown.class);
        shardManager1.tell((Object)new FindPrimary("default", true), kit.getRef());
        kit.expectMsgClass(java.time.Duration.ofSeconds(5L), NoShardLeaderException.class);
        shardManager1.tell((Object)MockClusterWrapper.createReachableMember("member-2", "akka://cluster-test@127.0.0.1:2558"), kit.getRef());
        ((TestShardManager)shardManager1.underlyingActor()).waitForReachableMember();
        PeerUp peerUp = (PeerUp)MessageCollectorActor.expectFirstMatching((ActorRef)mockShardActor1, PeerUp.class);
        Assert.assertEquals((String)"getMemberName", (Object)MEMBER_2, (Object)peerUp.getMemberName());
        MessageCollectorActor.clearMessages((ActorRef)mockShardActor1);
        shardManager1.tell((Object)new FindPrimary("default", true), kit.getRef());
        RemotePrimaryShardFound found1 = (RemotePrimaryShardFound)kit.expectMsgClass(java.time.Duration.ofSeconds(5L), RemotePrimaryShardFound.class);
        String path1 = found1.getPrimaryPath();
        Assert.assertTrue((String)("Unexpected primary path " + path1), (boolean)path1.contains("member-2-shard-default-config"));
        shardManager1.tell((Object)MockClusterWrapper.createMemberUp("member-2", "akka://cluster-test@127.0.0.1:2558"), kit.getRef());
        MessageCollectorActor.expectFirstMatching((ActorRef)mockShardActor1, PeerUp.class);
        shardManager1.tell((Object)MockClusterWrapper.createUnreachableMember("member-2", "akka://cluster-test@127.0.0.1:2558"), kit.getRef());
        ((TestShardManager)shardManager1.underlyingActor()).waitForUnreachableMember();
        shardManager1.tell((Object)new FindPrimary("default", true), kit.getRef());
        shardManager1.tell((Object)MockClusterWrapper.createReachableMember("member-2", "akka://cluster-test@127.0.0.1:2558"), kit.getRef());
        RemotePrimaryShardFound found2 = (RemotePrimaryShardFound)kit.expectMsgClass(java.time.Duration.ofSeconds(5L), RemotePrimaryShardFound.class);
        String path2 = found2.getPrimaryPath();
        Assert.assertTrue((String)("Unexpected primary path " + path2), (boolean)path2.contains("member-2-shard-default-config"));
        LOG.info("testShardAvailabilityOnChangeOfMemberReachability ending");
    }

    @Test
    public void testShardAvailabilityChangeOnMemberUnreachableAndLeadershipChange() {
        LOG.info("testShardAvailabilityChangeOnMemberUnreachableAndLeadershipChange starting");
        String shardManagerID = ShardManagerIdentifier.builder().type(this.shardMrgIDSuffix).build().toString();
        ActorSystem system1 = this.newActorSystem("Member1");
        Cluster.get((ActorSystem)system1).join(AddressFromURIString.parse((String)"akka://cluster-test@127.0.0.1:2558"));
        ActorRef mockShardActor1 = this.newMockShardActor(system1, "default", "member-1");
        PrimaryShardInfoFutureCache primaryShardInfoCache = new PrimaryShardInfoFutureCache();
        TestActorRef shardManager1 = TestActorRef.create((ActorSystem)system1, (Props)((TestShardManager.Builder)((TestShardManager.Builder)this.newTestShardMgrBuilder().shardActor(mockShardActor1).cluster((ClusterWrapper)new ClusterWrapperImpl(system1))).primaryShardInfoCache(primaryShardInfoCache)).props().withDispatcher(Dispatchers.DefaultDispatcherId()), (String)shardManagerID);
        ActorSystem system2 = this.newActorSystem("Member2");
        Cluster.get((ActorSystem)system2).join(AddressFromURIString.parse((String)"akka://cluster-test@127.0.0.1:2558"));
        ActorRef mockShardActor2 = this.newMockShardActor(system2, "default", "member-2");
        MockConfiguration mockConfig2 = new MockConfiguration((Map<String, List<String>>)ImmutableMap.builder().put((Object)"default", Arrays.asList("member-1", "member-2")).build());
        TestActorRef shardManager2 = TestActorRef.create((ActorSystem)system2, (Props)((TestShardManager.Builder)this.newTestShardMgrBuilder((Configuration)mockConfig2).shardActor(mockShardActor2).cluster((ClusterWrapper)new ClusterWrapperImpl(system2))).props().withDispatcher(Dispatchers.DefaultDispatcherId()), (String)shardManagerID);
        TestKit kit = new TestKit(system1);
        shardManager1.tell((Object)new UpdateSchemaContext(TEST_SCHEMA_CONTEXT), kit.getRef());
        shardManager2.tell((Object)new UpdateSchemaContext(TEST_SCHEMA_CONTEXT), kit.getRef());
        shardManager1.tell((Object)new ActorInitialized(), mockShardActor1);
        shardManager2.tell((Object)new ActorInitialized(), mockShardActor2);
        String memberId2 = "member-2-shard-default-" + this.shardMrgIDSuffix;
        String memberId1 = "member-1-shard-default-" + this.shardMrgIDSuffix;
        shardManager1.tell((Object)new ShardLeaderStateChanged(memberId1, memberId2, (ReadOnlyDataTree)Mockito.mock(DataTree.class), 11), mockShardActor1);
        shardManager1.tell((Object)new RoleChangeNotification(memberId1, RaftState.Candidate.name(), RaftState.Follower.name()), mockShardActor1);
        shardManager2.tell((Object)new ShardLeaderStateChanged(memberId2, memberId2, (ReadOnlyDataTree)Mockito.mock(DataTree.class), 11), mockShardActor2);
        shardManager2.tell((Object)new RoleChangeNotification(memberId2, RaftState.Candidate.name(), RaftState.Leader.name()), mockShardActor2);
        ((TestShardManager)shardManager1.underlyingActor()).waitForMemberUp();
        shardManager1.tell((Object)new FindPrimary("default", true), kit.getRef());
        RemotePrimaryShardFound found = (RemotePrimaryShardFound)kit.expectMsgClass(java.time.Duration.ofSeconds(5L), RemotePrimaryShardFound.class);
        String path = found.getPrimaryPath();
        Assert.assertTrue((String)("Unexpected primary path " + path), (boolean)path.contains("member-2-shard-default-config"));
        primaryShardInfoCache.putSuccessful("default", new PrimaryShardInfo(system1.actorSelection(mockShardActor1.path()), 11));
        shardManager1.tell((Object)MockClusterWrapper.createUnreachableMember("member-2", "akka://cluster-test@127.0.0.1:2558"), kit.getRef());
        ((TestShardManager)shardManager1.underlyingActor()).waitForUnreachableMember();
        shardManager1.tell((Object)new FindPrimary("default", true), kit.getRef());
        kit.expectMsgClass(java.time.Duration.ofSeconds(5L), NoShardLeaderException.class);
        Assert.assertNull((String)"Expected primaryShardInfoCache entry removed", (Object)primaryShardInfoCache.getIfPresent("default"));
        shardManager1.tell((Object)new ShardLeaderStateChanged(memberId1, memberId1, (ReadOnlyDataTree)Mockito.mock(DataTree.class), 11), mockShardActor1);
        shardManager1.tell((Object)new RoleChangeNotification(memberId1, RaftState.Follower.name(), RaftState.Leader.name()), mockShardActor1);
        shardManager1.tell((Object)new FindPrimary("default", true), kit.getRef());
        LocalPrimaryShardFound found1 = (LocalPrimaryShardFound)kit.expectMsgClass(java.time.Duration.ofSeconds(5L), LocalPrimaryShardFound.class);
        String path1 = found1.getPrimaryPath();
        Assert.assertTrue((String)("Unexpected primary path " + path1), (boolean)path1.contains("member-1-shard-default-config"));
        LOG.info("testShardAvailabilityChangeOnMemberUnreachableAndLeadershipChange ending");
    }

    @Test
    public void testShardAvailabilityChangeOnMemberWithNameContainedInLeaderIdUnreachable() {
        LOG.info("testShardAvailabilityChangeOnMemberWithNameContainedInLeaderIdUnreachable starting");
        String shardManagerID = ShardManagerIdentifier.builder().type(this.shardMrgIDSuffix).build().toString();
        MockConfiguration mockConfig = new MockConfiguration((Map<String, List<String>>)ImmutableMap.builder().put((Object)"default", Arrays.asList("member-256", "member-2")).build());
        ActorSystem system256 = this.newActorSystem("Member256");
        Cluster.get((ActorSystem)system256).join(AddressFromURIString.parse((String)"akka://cluster-test@127.0.0.1:2562"));
        ActorRef mockShardActor256 = this.newMockShardActor(system256, "default", "member-256");
        PrimaryShardInfoFutureCache primaryShardInfoCache = new PrimaryShardInfoFutureCache();
        TestActorRef shardManager256 = TestActorRef.create((ActorSystem)system256, (Props)((TestShardManager.Builder)((TestShardManager.Builder)this.newTestShardMgrBuilder((Configuration)mockConfig).shardActor(mockShardActor256).cluster((ClusterWrapper)new ClusterWrapperImpl(system256))).primaryShardInfoCache(primaryShardInfoCache)).props().withDispatcher(Dispatchers.DefaultDispatcherId()), (String)shardManagerID);
        ActorSystem system2 = this.newActorSystem("Member2");
        Cluster.get((ActorSystem)system2).join(AddressFromURIString.parse((String)"akka://cluster-test@127.0.0.1:2562"));
        ActorRef mockShardActor2 = this.newMockShardActor(system2, "default", "member-2");
        TestActorRef shardManager2 = TestActorRef.create((ActorSystem)system2, (Props)((TestShardManager.Builder)this.newTestShardMgrBuilder((Configuration)mockConfig).shardActor(mockShardActor2).cluster((ClusterWrapper)new ClusterWrapperImpl(system2))).props().withDispatcher(Dispatchers.DefaultDispatcherId()), (String)shardManagerID);
        TestKit kit256 = new TestKit(system256);
        shardManager256.tell((Object)new UpdateSchemaContext(TEST_SCHEMA_CONTEXT), kit256.getRef());
        shardManager2.tell((Object)new UpdateSchemaContext(TEST_SCHEMA_CONTEXT), kit256.getRef());
        shardManager256.tell((Object)new ActorInitialized(), mockShardActor256);
        shardManager2.tell((Object)new ActorInitialized(), mockShardActor2);
        String memberId256 = "member-256-shard-default-" + this.shardMrgIDSuffix;
        String memberId2 = "member-2-shard-default-" + this.shardMrgIDSuffix;
        shardManager256.tell((Object)new ShardLeaderStateChanged(memberId256, memberId256, (ReadOnlyDataTree)Mockito.mock(DataTree.class), 11), mockShardActor256);
        shardManager256.tell((Object)new RoleChangeNotification(memberId256, RaftState.Candidate.name(), RaftState.Leader.name()), mockShardActor256);
        shardManager2.tell((Object)new ShardLeaderStateChanged(memberId2, memberId256, (ReadOnlyDataTree)Mockito.mock(DataTree.class), 11), mockShardActor2);
        shardManager2.tell((Object)new RoleChangeNotification(memberId2, RaftState.Candidate.name(), RaftState.Follower.name()), mockShardActor2);
        ((TestShardManager)shardManager256.underlyingActor()).waitForMemberUp();
        shardManager256.tell((Object)new FindPrimary("default", true), kit256.getRef());
        LocalPrimaryShardFound found = (LocalPrimaryShardFound)kit256.expectMsgClass(java.time.Duration.ofSeconds(5L), LocalPrimaryShardFound.class);
        String path = found.getPrimaryPath();
        Assert.assertTrue((String)("Unexpected primary path " + path + " which must on member-256"), (boolean)path.contains("member-256-shard-default-config"));
        final PrimaryShardInfo primaryShardInfo = new PrimaryShardInfo(system256.actorSelection(mockShardActor256.path()), 11);
        primaryShardInfoCache.putSuccessful("default", primaryShardInfo);
        shardManager256.tell((Object)MockClusterWrapper.createUnreachableMember("member-2", "akka://cluster-test@127.0.0.1:2558"), kit256.getRef());
        ((TestShardManager)shardManager256.underlyingActor()).waitForUnreachableMember();
        shardManager256.tell((Object)new FindPrimary("default", true), kit256.getRef());
        found = (LocalPrimaryShardFound)kit256.expectMsgClass(java.time.Duration.ofSeconds(5L), LocalPrimaryShardFound.class);
        path = found.getPrimaryPath();
        Assert.assertTrue((String)("Unexpected primary path " + path + " which must still not on member-256"), (boolean)path.contains("member-256-shard-default-config"));
        Future futurePrimaryShard = primaryShardInfoCache.getIfPresent("default");
        futurePrimaryShard.onComplete((Function1)new OnComplete<PrimaryShardInfo>(){

            public void onComplete(Throwable failure, PrimaryShardInfo futurePrimaryShardInfo) {
                if (failure != null) {
                    Assert.assertTrue((String)"Primary shard info is unexpectedly removed from primaryShardInfoCache", (boolean)false);
                } else {
                    Assert.assertEquals((String)"Expected primaryShardInfoCache entry", (Object)primaryShardInfo, (Object)futurePrimaryShardInfo);
                }
            }
        }, (ExecutionContext)system256.dispatchers().defaultGlobalDispatcher());
        LOG.info("testShardAvailabilityChangeOnMemberWithNameContainedInLeaderIdUnreachable ending");
    }

    @Test
    public void testOnReceiveFindLocalShardForNonExistentShard() {
        TestKit kit = new TestKit(ShardManagerTest.getSystem());
        ActorRef shardManager = this.actorFactory.createActor(this.newPropsShardMgrWithMockShardActor());
        shardManager.tell((Object)new UpdateSchemaContext(TEST_SCHEMA_CONTEXT), kit.getRef());
        shardManager.tell((Object)new FindLocalShard("non-existent", false), kit.getRef());
        LocalShardNotFound notFound = (LocalShardNotFound)kit.expectMsgClass(java.time.Duration.ofSeconds(5L), LocalShardNotFound.class);
        Assert.assertEquals((String)"getShardName", (Object)"non-existent", (Object)notFound.getShardName());
    }

    @Test
    public void testOnReceiveFindLocalShardForExistentShard() {
        TestKit kit = new TestKit(ShardManagerTest.getSystem());
        ActorRef shardManager = this.actorFactory.createActor(this.newPropsShardMgrWithMockShardActor());
        shardManager.tell((Object)new UpdateSchemaContext(TEST_SCHEMA_CONTEXT), kit.getRef());
        shardManager.tell((Object)new ActorInitialized(), mockShardActor);
        shardManager.tell((Object)new FindLocalShard("default", false), kit.getRef());
        LocalShardFound found = (LocalShardFound)kit.expectMsgClass(java.time.Duration.ofSeconds(5L), LocalShardFound.class);
        Assert.assertTrue((String)("Found path contains " + found.getPath().path().toString()), (boolean)found.getPath().path().toString().contains("member-1-shard-default-config"));
    }

    @Test
    public void testOnReceiveFindLocalShardForNotInitializedShard() {
        TestKit kit = new TestKit(ShardManagerTest.getSystem());
        ActorRef shardManager = this.actorFactory.createActor(this.newPropsShardMgrWithMockShardActor());
        shardManager.tell((Object)new FindLocalShard("default", false), kit.getRef());
        kit.expectMsgClass(java.time.Duration.ofSeconds(5L), NotInitializedException.class);
    }

    @Test
    public void testOnReceiveFindLocalShardWaitForShardInitialized() throws Exception {
        LOG.info("testOnReceiveFindLocalShardWaitForShardInitialized starting");
        TestKit kit = new TestKit(ShardManagerTest.getSystem());
        ActorRef shardManager = this.actorFactory.createActor(this.newPropsShardMgrWithMockShardActor());
        shardManager.tell((Object)new UpdateSchemaContext(TEST_SCHEMA_CONTEXT), kit.getRef());
        Future future = Patterns.ask((ActorRef)shardManager, (Object)new FindLocalShard("default", true), (Timeout)new Timeout(5L, TimeUnit.SECONDS));
        shardManager.tell((Object)new ActorInitialized(), mockShardActor);
        Object resp = Await.result((Awaitable)future, (Duration)kit.duration("5 seconds"));
        Assert.assertTrue((String)("Expected: LocalShardFound, Actual: " + resp), (boolean)(resp instanceof LocalShardFound));
        LOG.info("testOnReceiveFindLocalShardWaitForShardInitialized starting");
    }

    @Test
    public void testRoleChangeNotificationAndShardLeaderStateChangedReleaseReady() throws Exception {
        TestShardManager shardManager = this.newTestShardManager();
        String memberId = "member-1-shard-default-" + this.shardMrgIDSuffix;
        shardManager.handleCommand(new RoleChangeNotification(memberId, RaftState.Candidate.name(), RaftState.Leader.name()));
        Assert.assertFalse((boolean)ready.isDone());
        shardManager.handleCommand(new ShardLeaderStateChanged(memberId, memberId, (ReadOnlyDataTree)Mockito.mock(DataTree.class), 11));
        Assert.assertTrue((boolean)ready.isDone());
    }

    @Test
    public void testRoleChangeNotificationToFollowerWithShardLeaderStateChangedReleaseReady() throws Exception {
        TestKit kit = new TestKit(ShardManagerTest.getSystem());
        TestShardManager shardManager = this.newTestShardManager();
        String memberId = "member-1-shard-default-" + this.shardMrgIDSuffix;
        shardManager.handleCommand(new RoleChangeNotification(memberId, null, RaftState.Follower.name()));
        Assert.assertFalse((boolean)ready.isDone());
        shardManager.handleCommand(MockClusterWrapper.createMemberUp("member-2", kit.getRef().path().toString()));
        shardManager.handleCommand(new ShardLeaderStateChanged(memberId, "member-2-shard-default-" + this.shardMrgIDSuffix, (ReadOnlyDataTree)Mockito.mock(DataTree.class), 11));
        Assert.assertTrue((boolean)ready.isDone());
    }

    @Test
    public void testReadyCountDownForMemberUpAfterLeaderStateChanged() throws Exception {
        TestKit kit = new TestKit(ShardManagerTest.getSystem());
        TestShardManager shardManager = this.newTestShardManager();
        String memberId = "member-1-shard-default-" + this.shardMrgIDSuffix;
        shardManager.handleCommand(new RoleChangeNotification(memberId, null, RaftState.Follower.name()));
        Assert.assertFalse((boolean)ready.isDone());
        shardManager.handleCommand(new ShardLeaderStateChanged(memberId, "member-2-shard-default-" + this.shardMrgIDSuffix, (ReadOnlyDataTree)Mockito.mock(DataTree.class), 11));
        shardManager.handleCommand(MockClusterWrapper.createMemberUp("member-2", kit.getRef().path().toString()));
        Assert.assertTrue((boolean)ready.isDone());
    }

    @Test
    public void testRoleChangeNotificationDoNothingForUnknownShard() throws Exception {
        TestShardManager shardManager = this.newTestShardManager();
        shardManager.handleCommand(new RoleChangeNotification("unknown", RaftState.Candidate.name(), RaftState.Leader.name()));
        Assert.assertFalse((boolean)ready.isDone());
    }

    @Test
    public void testByDefaultSyncStatusIsFalse() {
        TestShardManager shardManager = this.newTestShardManager();
        Assert.assertFalse((boolean)shardManager.getMBean().getSyncStatus());
    }

    @Test
    public void testWhenShardIsLeaderSyncStatusIsTrue() throws Exception {
        TestShardManager shardManager = this.newTestShardManager();
        shardManager.handleCommand(new RoleChangeNotification("member-1-shard-default-" + this.shardMrgIDSuffix, RaftState.Follower.name(), RaftState.Leader.name()));
        Assert.assertTrue((boolean)shardManager.getMBean().getSyncStatus());
    }

    @Test
    public void testWhenShardIsCandidateSyncStatusIsFalse() throws Exception {
        TestShardManager shardManager = this.newTestShardManager();
        String shardId = "member-1-shard-default-" + this.shardMrgIDSuffix;
        shardManager.handleCommand(new RoleChangeNotification(shardId, RaftState.Follower.name(), RaftState.Candidate.name()));
        Assert.assertFalse((boolean)shardManager.getMBean().getSyncStatus());
        shardManager.handleCommand(new FollowerInitialSyncUpStatus(true, shardId));
        Assert.assertFalse((boolean)shardManager.getMBean().getSyncStatus());
    }

    @Test
    public void testWhenShardIsFollowerSyncStatusDependsOnFollowerInitialSyncStatus() throws Exception {
        TestShardManager shardManager = this.newTestShardManager();
        String shardId = "member-1-shard-default-" + this.shardMrgIDSuffix;
        shardManager.handleCommand(new RoleChangeNotification(shardId, RaftState.Candidate.name(), RaftState.Follower.name()));
        Assert.assertFalse((boolean)shardManager.getMBean().getSyncStatus());
        shardManager.handleCommand(new FollowerInitialSyncUpStatus(true, shardId));
        Assert.assertTrue((boolean)shardManager.getMBean().getSyncStatus());
        shardManager.handleCommand(new FollowerInitialSyncUpStatus(false, shardId));
        Assert.assertFalse((boolean)shardManager.getMBean().getSyncStatus());
    }

    @Test
    public void testWhenMultipleShardsPresentSyncStatusMustBeTrueForAllShards() throws Exception {
        LOG.info("testWhenMultipleShardsPresentSyncStatusMustBeTrueForAllShards starting");
        TestShardManager shardManager = this.newTestShardManager(this.newShardMgrProps((Configuration)new MockConfiguration(){

            public List<String> getMemberShardNames(MemberName memberName) {
                return Arrays.asList("default", "astronauts");
            }
        }));
        Assert.assertFalse((boolean)shardManager.getMBean().getSyncStatus());
        String defaultShardId = "member-1-shard-default-" + this.shardMrgIDSuffix;
        shardManager.handleCommand(new RoleChangeNotification(defaultShardId, RaftState.Follower.name(), RaftState.Leader.name()));
        Assert.assertFalse((boolean)shardManager.getMBean().getSyncStatus());
        String astronautsShardId = "member-1-shard-astronauts-" + this.shardMrgIDSuffix;
        shardManager.handleCommand(new RoleChangeNotification(astronautsShardId, RaftState.Follower.name(), RaftState.Leader.name()));
        Assert.assertTrue((boolean)shardManager.getMBean().getSyncStatus());
        shardManager.handleCommand(new RoleChangeNotification(astronautsShardId, RaftState.Leader.name(), RaftState.Follower.name()));
        Assert.assertFalse((boolean)shardManager.getMBean().getSyncStatus());
        shardManager.handleCommand(new FollowerInitialSyncUpStatus(true, astronautsShardId));
        Assert.assertTrue((boolean)shardManager.getMBean().getSyncStatus());
        LOG.info("testWhenMultipleShardsPresentSyncStatusMustBeTrueForAllShards ending");
    }

    @Test
    public void testOnReceiveSwitchShardBehavior() {
        TestKit kit = new TestKit(ShardManagerTest.getSystem());
        ActorRef shardManager = this.actorFactory.createActor(this.newPropsShardMgrWithMockShardActor());
        shardManager.tell((Object)new UpdateSchemaContext(TEST_SCHEMA_CONTEXT), kit.getRef());
        shardManager.tell((Object)new ActorInitialized(), mockShardActor);
        shardManager.tell((Object)new SwitchShardBehavior(mockShardName, RaftState.Leader, 1000L), kit.getRef());
        SwitchBehavior switchBehavior = (SwitchBehavior)MessageCollectorActor.expectFirstMatching((ActorRef)mockShardActor, SwitchBehavior.class);
        Assert.assertEquals((Object)RaftState.Leader, (Object)switchBehavior.getNewState());
        Assert.assertEquals((long)1000L, (long)switchBehavior.getNewTerm());
    }

    private static List<MemberName> members(String ... names) {
        return Arrays.asList(names).stream().map(MemberName::forName).collect(Collectors.toList());
    }

    @Test
    public void testOnCreateShard() {
        LOG.info("testOnCreateShard starting");
        TestKit kit = new TestKit(ShardManagerTest.getSystem());
        this.datastoreContextBuilder.shardInitializationTimeout(1L, TimeUnit.MINUTES).persistent(true);
        ActorRef shardManager = this.actorFactory.createActor(this.newShardMgrProps((Configuration)new ConfigurationImpl((ModuleShardConfigProvider)new EmptyModuleShardConfigProvider())).withDispatcher(Dispatchers.DefaultDispatcherId()));
        EffectiveModelContext schemaContext = TEST_SCHEMA_CONTEXT;
        shardManager.tell((Object)new UpdateSchemaContext(schemaContext), ActorRef.noSender());
        DatastoreContext datastoreContext = DatastoreContext.newBuilder().shardElectionTimeoutFactor(100L).persistent(false).build();
        Shard.Builder shardBuilder = Shard.builder();
        ModuleShardConfiguration config = new ModuleShardConfiguration(URI.create("foo-ns"), "foo-module", "foo", null, ShardManagerTest.members("member-1", "member-5", "member-6"));
        shardManager.tell((Object)new CreateShard(config, (Shard.AbstractBuilder)shardBuilder, datastoreContext), kit.getRef());
        kit.expectMsgClass(java.time.Duration.ofSeconds(5L), Status.Success.class);
        shardManager.tell((Object)new FindLocalShard("foo", true), kit.getRef());
        kit.expectMsgClass(java.time.Duration.ofSeconds(5L), LocalShardFound.class);
        Assert.assertFalse((String)"isRecoveryApplicable", (boolean)shardBuilder.getDatastoreContext().isPersistent());
        Assert.assertTrue((String)"Epxected ShardPeerAddressResolver", (boolean)(shardBuilder.getDatastoreContext().getShardRaftConfig().getPeerAddressResolver() instanceof ShardPeerAddressResolver));
        Assert.assertEquals((String)"peerMembers", (Object)Sets.newHashSet((Object[])new String[]{ShardIdentifier.create((String)"foo", (MemberName)MemberName.forName((String)"member-5"), (String)this.shardMrgIDSuffix).toString(), ShardIdentifier.create((String)"foo", (MemberName)MemberName.forName((String)"member-6"), (String)this.shardMrgIDSuffix).toString()}), shardBuilder.getPeerAddresses().keySet());
        Assert.assertEquals((String)"ShardIdentifier", (Object)ShardIdentifier.create((String)"foo", (MemberName)MEMBER_1, (String)this.shardMrgIDSuffix), (Object)shardBuilder.getId());
        Assert.assertSame((String)"schemaContext", (Object)schemaContext, (Object)shardBuilder.getSchemaContext());
        shardManager.tell((Object)new CreateShard(config, (Shard.AbstractBuilder)shardBuilder, null), kit.getRef());
        Status.Success success = (Status.Success)kit.expectMsgClass(java.time.Duration.ofSeconds(5L), Status.Success.class);
        Assert.assertNotNull((String)"Success status is null", (Object)success.status());
        LOG.info("testOnCreateShard ending");
    }

    @Test
    public void testOnCreateShardWithLocalMemberNotInShardConfig() {
        LOG.info("testOnCreateShardWithLocalMemberNotInShardConfig starting");
        TestKit kit = new TestKit(ShardManagerTest.getSystem());
        this.datastoreContextBuilder.shardInitializationTimeout(1L, TimeUnit.MINUTES).persistent(true);
        ActorRef shardManager = this.actorFactory.createActor(this.newShardMgrProps((Configuration)new ConfigurationImpl((ModuleShardConfigProvider)new EmptyModuleShardConfigProvider())).withDispatcher(Dispatchers.DefaultDispatcherId()));
        shardManager.tell((Object)new UpdateSchemaContext(TEST_SCHEMA_CONTEXT), ActorRef.noSender());
        Shard.Builder shardBuilder = Shard.builder();
        ModuleShardConfiguration config = new ModuleShardConfiguration(URI.create("foo-ns"), "foo-module", "foo", null, ShardManagerTest.members("member-5", "member-6"));
        shardManager.tell((Object)new CreateShard(config, (Shard.AbstractBuilder)shardBuilder, null), kit.getRef());
        kit.expectMsgClass(java.time.Duration.ofSeconds(5L), Status.Success.class);
        shardManager.tell((Object)new FindLocalShard("foo", true), kit.getRef());
        kit.expectMsgClass(java.time.Duration.ofSeconds(5L), LocalShardFound.class);
        Assert.assertEquals((String)"peerMembers size", (long)0L, (long)shardBuilder.getPeerAddresses().size());
        Assert.assertEquals((String)"schemaContext", (Object)DisableElectionsRaftPolicy.class.getName(), (Object)shardBuilder.getDatastoreContext().getShardRaftConfig().getCustomRaftPolicyImplementationClass());
        LOG.info("testOnCreateShardWithLocalMemberNotInShardConfig ending");
    }

    @Test
    public void testOnCreateShardWithNoInitialSchemaContext() {
        LOG.info("testOnCreateShardWithNoInitialSchemaContext starting");
        TestKit kit = new TestKit(ShardManagerTest.getSystem());
        ActorRef shardManager = this.actorFactory.createActor(this.newShardMgrProps((Configuration)new ConfigurationImpl((ModuleShardConfigProvider)new EmptyModuleShardConfigProvider())).withDispatcher(Dispatchers.DefaultDispatcherId()));
        Shard.Builder shardBuilder = Shard.builder();
        ModuleShardConfiguration config = new ModuleShardConfiguration(URI.create("foo-ns"), "foo-module", "foo", null, ShardManagerTest.members("member-1"));
        shardManager.tell((Object)new CreateShard(config, (Shard.AbstractBuilder)shardBuilder, null), kit.getRef());
        kit.expectMsgClass(java.time.Duration.ofSeconds(5L), Status.Success.class);
        EffectiveModelContext schemaContext = TEST_SCHEMA_CONTEXT;
        shardManager.tell((Object)new UpdateSchemaContext(schemaContext), ActorRef.noSender());
        shardManager.tell((Object)new FindLocalShard("foo", true), kit.getRef());
        kit.expectMsgClass(java.time.Duration.ofSeconds(5L), LocalShardFound.class);
        Assert.assertSame((String)"schemaContext", (Object)schemaContext, (Object)shardBuilder.getSchemaContext());
        Assert.assertNotNull((String)"schemaContext is null", (Object)shardBuilder.getDatastoreContext());
        LOG.info("testOnCreateShardWithNoInitialSchemaContext ending");
    }

    @Test
    public void testGetSnapshot() {
        LOG.info("testGetSnapshot starting");
        TestKit kit = new TestKit(ShardManagerTest.getSystem());
        MockConfiguration mockConfig = new MockConfiguration((Map<String, List<String>>)ImmutableMap.builder().put((Object)"shard1", Arrays.asList("member-1")).put((Object)"shard2", Arrays.asList("member-1")).put((Object)"astronauts", Collections.emptyList()).build());
        TestActorRef shardManager = this.actorFactory.createTestActor(this.newShardMgrProps((Configuration)mockConfig).withDispatcher(Dispatchers.DefaultDispatcherId()));
        shardManager.tell((Object)GetSnapshot.INSTANCE, kit.getRef());
        Status.Failure failure = (Status.Failure)kit.expectMsgClass(Status.Failure.class);
        Assert.assertEquals((String)"Failure cause type", IllegalStateException.class, failure.cause().getClass());
        shardManager.tell((Object)new UpdateSchemaContext(TEST_SCHEMA_CONTEXT), ActorRef.noSender());
        ShardManagerTest.waitForShardInitialized((ActorRef)shardManager, "shard1", kit);
        ShardManagerTest.waitForShardInitialized((ActorRef)shardManager, "shard2", kit);
        shardManager.tell((Object)GetSnapshot.INSTANCE, kit.getRef());
        DatastoreSnapshot datastoreSnapshot = ShardManagerTest.expectMsgClassOrFailure(DatastoreSnapshot.class, kit, "GetSnapshot");
        Assert.assertEquals((String)"getType", (Object)this.shardMrgIDSuffix, (Object)datastoreSnapshot.getType());
        Assert.assertNull((String)"Expected null ShardManagerSnapshot", (Object)datastoreSnapshot.getShardManagerSnapshot());
        Assert.assertEquals((String)"Shard names", (Object)Sets.newHashSet((Object[])new String[]{"shard1", "shard2"}), (Object)Sets.newHashSet((Iterable)datastoreSnapshot.getShardSnapshots().stream().map(DatastoreSnapshot.ShardSnapshot::getName).collect(Collectors.toSet())));
        TestKit mockShardLeaderKit = new TestKit(ShardManagerTest.getSystem());
        TestShardManager shardManagerInstance = (TestShardManager)shardManager.underlyingActor();
        shardManagerInstance.setMessageInterceptor(ShardManagerTest.newFindPrimaryInterceptor(mockShardLeaderKit.getRef()));
        shardManager.tell((Object)new AddShardReplica("astronauts"), kit.getRef());
        mockShardLeaderKit.expectMsgClass(AddServer.class);
        mockShardLeaderKit.reply((Object)new AddServerReply(ServerChangeStatus.OK, ""));
        kit.expectMsgClass(Status.Success.class);
        ShardManagerTest.waitForShardInitialized((ActorRef)shardManager, "astronauts", kit);
        shardManager.tell((Object)GetSnapshot.INSTANCE, kit.getRef());
        datastoreSnapshot = ShardManagerTest.expectMsgClassOrFailure(DatastoreSnapshot.class, kit, "GetSnapshot");
        Assert.assertEquals((String)"Shard names", (Object)Sets.newHashSet((Object[])new String[]{"shard1", "shard2", "astronauts"}), (Object)Sets.newHashSet((Iterable)Lists.transform((List)datastoreSnapshot.getShardSnapshots(), DatastoreSnapshot.ShardSnapshot::getName)));
        ShardManagerSnapshot snapshot = datastoreSnapshot.getShardManagerSnapshot();
        Assert.assertNotNull((String)"Expected ShardManagerSnapshot", (Object)snapshot);
        Assert.assertEquals((String)"Shard names", (Object)Sets.newHashSet((Object[])new String[]{"shard1", "shard2", "astronauts"}), (Object)Sets.newHashSet((Iterable)snapshot.getShardList()));
        LOG.info("testGetSnapshot ending");
    }

    @Test
    public void testRestoreFromSnapshot() {
        LOG.info("testRestoreFromSnapshot starting");
        this.datastoreContextBuilder.shardInitializationTimeout(3L, TimeUnit.SECONDS);
        TestKit kit = new TestKit(ShardManagerTest.getSystem());
        MockConfiguration mockConfig = new MockConfiguration((Map<String, List<String>>)ImmutableMap.builder().put((Object)"shard1", Collections.emptyList()).put((Object)"shard2", Collections.emptyList()).put((Object)"astronauts", Collections.emptyList()).build());
        ShardManagerSnapshot snapshot = new ShardManagerSnapshot(Arrays.asList("shard1", "shard2", "astronauts"), Collections.emptyMap());
        DatastoreSnapshot restoreFromSnapshot = new DatastoreSnapshot(this.shardMrgIDSuffix, snapshot, Collections.emptyList());
        TestActorRef shardManager = this.actorFactory.createTestActor(((TestShardManager.Builder)this.newTestShardMgrBuilder((Configuration)mockConfig).restoreFromSnapshot(restoreFromSnapshot)).props().withDispatcher(Dispatchers.DefaultDispatcherId()));
        ((TestShardManager)shardManager.underlyingActor()).waitForRecoveryComplete();
        shardManager.tell((Object)new UpdateSchemaContext(TEST_SCHEMA_CONTEXT), ActorRef.noSender());
        ShardManagerTest.waitForShardInitialized((ActorRef)shardManager, "shard1", kit);
        ShardManagerTest.waitForShardInitialized((ActorRef)shardManager, "shard2", kit);
        ShardManagerTest.waitForShardInitialized((ActorRef)shardManager, "astronauts", kit);
        shardManager.tell((Object)GetSnapshot.INSTANCE, kit.getRef());
        DatastoreSnapshot datastoreSnapshot = ShardManagerTest.expectMsgClassOrFailure(DatastoreSnapshot.class, kit, "GetSnapshot");
        Assert.assertEquals((String)"getType", (Object)this.shardMrgIDSuffix, (Object)datastoreSnapshot.getType());
        Assert.assertNotNull((String)"Expected ShardManagerSnapshot", (Object)datastoreSnapshot.getShardManagerSnapshot());
        Assert.assertEquals((String)"Shard names", (Object)Sets.newHashSet((Object[])new String[]{"shard1", "shard2", "astronauts"}), (Object)Sets.newHashSet((Iterable)datastoreSnapshot.getShardManagerSnapshot().getShardList()));
        LOG.info("testRestoreFromSnapshot ending");
    }

    @Test
    public void testAddShardReplicaForNonExistentShardConfig() {
        TestKit kit = new TestKit(ShardManagerTest.getSystem());
        ActorRef shardManager = this.actorFactory.createActor(this.newShardMgrProps((Configuration)new ConfigurationImpl((ModuleShardConfigProvider)new EmptyModuleShardConfigProvider())).withDispatcher(Dispatchers.DefaultDispatcherId()));
        shardManager.tell((Object)new AddShardReplica("model-inventory"), kit.getRef());
        Status.Failure resp = (Status.Failure)kit.expectMsgClass(java.time.Duration.ofSeconds(2L), Status.Failure.class);
        Assert.assertTrue((String)"Failure obtained", (boolean)(resp.cause() instanceof IllegalArgumentException));
    }

    @Test
    public void testAddShardReplica() {
        LOG.info("testAddShardReplica starting");
        MockConfiguration mockConfig = new MockConfiguration((Map<String, List<String>>)ImmutableMap.builder().put((Object)"default", Arrays.asList("member-1", "member-2")).put((Object)"astronauts", Arrays.asList("member-2")).build());
        String shardManagerID = ShardManagerIdentifier.builder().type(this.shardMrgIDSuffix).build().toString();
        this.datastoreContextBuilder.shardManagerPersistenceId(shardManagerID);
        ActorSystem system1 = this.newActorSystem("Member1");
        Cluster.get((ActorSystem)system1).join(AddressFromURIString.parse((String)"akka://cluster-test@127.0.0.1:2558"));
        ActorRef mockDefaultShardActor = this.newMockShardActor(system1, "default", "member-1");
        TestActorRef newReplicaShardManager = TestActorRef.create((ActorSystem)system1, (Props)((TestShardManager.Builder)this.newTestShardMgrBuilder((Configuration)mockConfig).shardActor(mockDefaultShardActor).cluster((ClusterWrapper)new ClusterWrapperImpl(system1))).props().withDispatcher(Dispatchers.DefaultDispatcherId()), (String)shardManagerID);
        ActorSystem system2 = this.newActorSystem("Member2");
        Cluster.get((ActorSystem)system2).join(AddressFromURIString.parse((String)"akka://cluster-test@127.0.0.1:2558"));
        String memberId2 = "member-2-shard-astronauts-" + this.shardMrgIDSuffix;
        String name = ShardIdentifier.create((String)"astronauts", (MemberName)MEMBER_2, (String)"config").toString();
        TestActorRef mockShardLeaderActor = TestActorRef.create((ActorSystem)system2, (Props)Props.create(MockRespondActor.class, (Object[])new Object[]{AddServer.class, new AddServerReply(ServerChangeStatus.OK, memberId2)}).withDispatcher(Dispatchers.DefaultDispatcherId()), (String)name);
        TestActorRef leaderShardManager = TestActorRef.create((ActorSystem)system2, (Props)((TestShardManager.Builder)this.newTestShardMgrBuilder((Configuration)mockConfig).shardActor((ActorRef)mockShardLeaderActor).cluster((ClusterWrapper)new ClusterWrapperImpl(system2))).props().withDispatcher(Dispatchers.DefaultDispatcherId()), (String)shardManagerID);
        TestKit kit = new TestKit(ShardManagerTest.getSystem());
        newReplicaShardManager.tell((Object)new UpdateSchemaContext(TEST_SCHEMA_CONTEXT), kit.getRef());
        leaderShardManager.tell((Object)new UpdateSchemaContext(TEST_SCHEMA_CONTEXT), kit.getRef());
        leaderShardManager.tell((Object)new ActorInitialized(), (ActorRef)mockShardLeaderActor);
        short leaderVersion = 10;
        leaderShardManager.tell((Object)new ShardLeaderStateChanged(memberId2, memberId2, (ReadOnlyDataTree)Mockito.mock(DataTree.class), leaderVersion), (ActorRef)mockShardLeaderActor);
        leaderShardManager.tell((Object)new RoleChangeNotification(memberId2, RaftState.Candidate.name(), RaftState.Leader.name()), (ActorRef)mockShardLeaderActor);
        ((TestShardManager)newReplicaShardManager.underlyingActor()).waitForMemberUp();
        ((TestShardManager)leaderShardManager.underlyingActor()).waitForMemberUp();
        String[] restoredShards = new String[]{"default", "people"};
        ShardManagerSnapshot snapshot = new ShardManagerSnapshot(Arrays.asList(restoredShards), Collections.emptyMap());
        InMemorySnapshotStore.addSnapshot((String)shardManagerID, (Object)snapshot);
        Uninterruptibles.sleepUninterruptibly((long)2L, (TimeUnit)TimeUnit.MILLISECONDS);
        InMemorySnapshotStore.addSnapshotSavedLatch((String)shardManagerID);
        InMemorySnapshotStore.addSnapshotDeletedLatch((String)shardManagerID);
        newReplicaShardManager.tell((Object)new AddShardReplica("astronauts"), kit.getRef());
        AddServer addServerMsg = (AddServer)MessageCollectorActor.expectFirstMatching((ActorRef)mockShardLeaderActor, AddServer.class);
        String addServerId = "member-1-shard-astronauts-" + this.shardMrgIDSuffix;
        Assert.assertEquals((String)"AddServer serverId", (Object)addServerId, (Object)addServerMsg.getNewServerId());
        kit.expectMsgClass(java.time.Duration.ofSeconds(5L), Status.Success.class);
        InMemorySnapshotStore.waitForSavedSnapshot((String)shardManagerID, ShardManagerSnapshot.class);
        InMemorySnapshotStore.waitForDeletedSnapshot((String)shardManagerID);
        List persistedSnapshots = InMemorySnapshotStore.getSnapshots((String)shardManagerID, ShardManagerSnapshot.class);
        Assert.assertEquals((String)"Number of snapshots persisted", (long)1L, (long)persistedSnapshots.size());
        ShardManagerSnapshot shardManagerSnapshot = (ShardManagerSnapshot)persistedSnapshots.get(0);
        Assert.assertEquals((String)"Persisted local shards", (Object)Sets.newHashSet((Object[])new String[]{"default", "astronauts"}), (Object)Sets.newHashSet((Iterable)shardManagerSnapshot.getShardList()));
        LOG.info("testAddShardReplica ending");
    }

    @Test
    public void testAddShardReplicaWithPreExistingReplicaInRemoteShardLeader() {
        LOG.info("testAddShardReplicaWithPreExistingReplicaInRemoteShardLeader starting");
        TestKit kit = new TestKit(ShardManagerTest.getSystem());
        TestActorRef shardManager = this.actorFactory.createTestActor(this.newPropsShardMgrWithMockShardActor(), this.shardMgrID);
        shardManager.tell((Object)new UpdateSchemaContext(TEST_SCHEMA_CONTEXT), kit.getRef());
        shardManager.tell((Object)new ActorInitialized(), mockShardActor);
        String leaderId = "leader-member-shard-default-" + this.shardMrgIDSuffix;
        AddServerReply addServerReply = new AddServerReply(ServerChangeStatus.ALREADY_EXISTS, null);
        ActorRef leaderShardActor = ((TestShardManager)shardManager.underlyingActor()).getContext().actorOf(Props.create(MockRespondActor.class, (Object[])new Object[]{AddServer.class, addServerReply}), leaderId);
        MockClusterWrapper.sendMemberUp((ActorRef)shardManager, "leader-member", leaderShardActor.path().toString());
        String newReplicaId = "member-1-shard-default-" + this.shardMrgIDSuffix;
        shardManager.tell((Object)new RoleChangeNotification(newReplicaId, RaftState.Candidate.name(), RaftState.Follower.name()), mockShardActor);
        shardManager.tell((Object)new ShardLeaderStateChanged(newReplicaId, leaderId, 11), mockShardActor);
        shardManager.tell((Object)new AddShardReplica("default"), kit.getRef());
        MessageCollectorActor.expectFirstMatching((ActorRef)leaderShardActor, AddServer.class);
        Status.Failure resp = (Status.Failure)kit.expectMsgClass(java.time.Duration.ofSeconds(5L), Status.Failure.class);
        Assert.assertEquals((String)"Failure cause", AlreadyExistsException.class, resp.cause().getClass());
        shardManager.tell((Object)new FindLocalShard("default", false), kit.getRef());
        kit.expectMsgClass(java.time.Duration.ofSeconds(5L), LocalShardFound.class);
        shardManager.tell((Object)new AddShardReplica("default"), kit.getRef());
        resp = (Status.Failure)kit.expectMsgClass(java.time.Duration.ofSeconds(5L), Status.Failure.class);
        Assert.assertEquals((String)"Failure cause", AlreadyExistsException.class, resp.cause().getClass());
        shardManager.tell((Object)ShardManagerTest.newDatastoreContextFactory(this.datastoreContextBuilder.shardLeaderElectionTimeout(100L, TimeUnit.MILLISECONDS).build()), kit.getRef());
        leaderShardActor.tell((Object)"clear-response", ActorRef.noSender());
        shardManager.tell((Object)new AddShardReplica("default"), kit.getRef());
        kit.expectMsgClass(java.time.Duration.ofSeconds(5L), Status.Failure.class);
        shardManager.tell((Object)new FindLocalShard("default", false), kit.getRef());
        kit.expectMsgClass(java.time.Duration.ofSeconds(5L), LocalShardFound.class);
        LOG.info("testAddShardReplicaWithPreExistingReplicaInRemoteShardLeader ending");
    }

    @Test
    public void testAddShardReplicaWithPreExistingLocalReplicaLeader() {
        LOG.info("testAddShardReplicaWithPreExistingLocalReplicaLeader starting");
        TestKit kit = new TestKit(ShardManagerTest.getSystem());
        String memberId = "member-1-shard-default-" + this.shardMrgIDSuffix;
        ActorRef shardManager = this.actorFactory.createActor(this.newPropsShardMgrWithMockShardActor());
        shardManager.tell((Object)new UpdateSchemaContext(TEST_SCHEMA_CONTEXT), kit.getRef());
        shardManager.tell((Object)new ActorInitialized(), mockShardActor);
        shardManager.tell((Object)new ShardLeaderStateChanged(memberId, memberId, (ReadOnlyDataTree)Mockito.mock(DataTree.class), 11), kit.getRef());
        shardManager.tell((Object)new RoleChangeNotification(memberId, RaftState.Candidate.name(), RaftState.Leader.name()), mockShardActor);
        shardManager.tell((Object)new AddShardReplica("default"), kit.getRef());
        Status.Failure resp = (Status.Failure)kit.expectMsgClass(java.time.Duration.ofSeconds(5L), Status.Failure.class);
        Assert.assertEquals((String)"Failure cause", AlreadyExistsException.class, resp.cause().getClass());
        shardManager.tell((Object)new FindLocalShard("default", false), kit.getRef());
        kit.expectMsgClass(java.time.Duration.ofSeconds(5L), LocalShardFound.class);
        LOG.info("testAddShardReplicaWithPreExistingLocalReplicaLeader ending");
    }

    @Test
    public void testAddShardReplicaWithAddServerReplyFailure() {
        LOG.info("testAddShardReplicaWithAddServerReplyFailure starting");
        TestKit kit = new TestKit(ShardManagerTest.getSystem());
        TestKit mockShardLeaderKit = new TestKit(ShardManagerTest.getSystem());
        MockConfiguration mockConfig = new MockConfiguration((Map<String, List<String>>)ImmutableMap.of((Object)"astronauts", Arrays.asList("member-2")));
        ActorRef mockNewReplicaShardActor = this.newMockShardActor(ShardManagerTest.getSystem(), "astronauts", "member-1");
        TestActorRef shardManager = this.actorFactory.createTestActor(this.newTestShardMgrBuilder((Configuration)mockConfig).shardActor(mockNewReplicaShardActor).props().withDispatcher(Dispatchers.DefaultDispatcherId()), this.shardMgrID);
        ((TestShardManager)shardManager.underlyingActor()).setMessageInterceptor(ShardManagerTest.newFindPrimaryInterceptor(mockShardLeaderKit.getRef()));
        shardManager.tell((Object)new UpdateSchemaContext(TEST_SCHEMA_CONTEXT), kit.getRef());
        TestKit terminateWatcher = new TestKit(ShardManagerTest.getSystem());
        terminateWatcher.watch(mockNewReplicaShardActor);
        shardManager.tell((Object)new AddShardReplica("astronauts"), kit.getRef());
        AddServer addServerMsg = (AddServer)mockShardLeaderKit.expectMsgClass(AddServer.class);
        Assert.assertEquals((String)"AddServer serverId", (Object)("member-1-shard-astronauts-" + this.shardMrgIDSuffix), (Object)addServerMsg.getNewServerId());
        mockShardLeaderKit.reply((Object)new AddServerReply(ServerChangeStatus.TIMEOUT, null));
        Status.Failure failure = (Status.Failure)kit.expectMsgClass(java.time.Duration.ofSeconds(5L), Status.Failure.class);
        Assert.assertEquals((String)"Failure cause", TimeoutException.class, failure.cause().getClass());
        shardManager.tell((Object)new FindLocalShard("astronauts", false), kit.getRef());
        kit.expectMsgClass(java.time.Duration.ofSeconds(5L), LocalShardNotFound.class);
        terminateWatcher.expectTerminated(mockNewReplicaShardActor);
        shardManager.tell((Object)new AddShardReplica("astronauts"), kit.getRef());
        mockShardLeaderKit.expectMsgClass(AddServer.class);
        mockShardLeaderKit.reply((Object)new AddServerReply(ServerChangeStatus.NO_LEADER, null));
        failure = (Status.Failure)kit.expectMsgClass(java.time.Duration.ofSeconds(5L), Status.Failure.class);
        Assert.assertEquals((String)"Failure cause", NoShardLeaderException.class, failure.cause().getClass());
        LOG.info("testAddShardReplicaWithAddServerReplyFailure ending");
    }

    @Test
    public void testAddShardReplicaWithAlreadyInProgress() {
        this.testServerChangeWhenAlreadyInProgress("astronauts", new AddShardReplica("astronauts"), AddServer.class, new AddShardReplica("astronauts"));
    }

    @Test
    public void testAddShardReplicaWithFindPrimaryTimeout() {
        LOG.info("testAddShardReplicaWithFindPrimaryTimeout starting");
        this.datastoreContextBuilder.shardInitializationTimeout(100L, TimeUnit.MILLISECONDS);
        TestKit kit = new TestKit(ShardManagerTest.getSystem());
        MockConfiguration mockConfig = new MockConfiguration((Map<String, List<String>>)ImmutableMap.of((Object)"astronauts", Arrays.asList("member-2")));
        ActorRef newReplicaShardManager = this.actorFactory.createActor(this.newTestShardMgrBuilder((Configuration)mockConfig).shardActor(mockShardActor).props().withDispatcher(Dispatchers.DefaultDispatcherId()), this.shardMgrID);
        newReplicaShardManager.tell((Object)new UpdateSchemaContext(TEST_SCHEMA_CONTEXT), kit.getRef());
        MockClusterWrapper.sendMemberUp(newReplicaShardManager, "member-2", AddressFromURIString.parse((String)"akka://non-existent@127.0.0.1:5").toString());
        newReplicaShardManager.tell((Object)new AddShardReplica("astronauts"), kit.getRef());
        Status.Failure resp = (Status.Failure)kit.expectMsgClass(java.time.Duration.ofSeconds(5L), Status.Failure.class);
        Assert.assertTrue((String)"Failure obtained", (boolean)(resp.cause() instanceof RuntimeException));
        LOG.info("testAddShardReplicaWithFindPrimaryTimeout ending");
    }

    @Test
    public void testRemoveShardReplicaForNonExistentShard() {
        TestKit kit = new TestKit(ShardManagerTest.getSystem());
        ActorRef shardManager = this.actorFactory.createActor(this.newShardMgrProps((Configuration)new ConfigurationImpl((ModuleShardConfigProvider)new EmptyModuleShardConfigProvider())).withDispatcher(Dispatchers.DefaultDispatcherId()));
        shardManager.tell((Object)new RemoveShardReplica("model-inventory", MEMBER_1), kit.getRef());
        Status.Failure resp = (Status.Failure)kit.expectMsgClass(java.time.Duration.ofSeconds(10L), Status.Failure.class);
        Assert.assertTrue((String)"Failure obtained", (boolean)(resp.cause() instanceof PrimaryNotFoundException));
    }

    @Test
    public void testRemoveShardReplicaLocal() {
        TestKit kit = new TestKit(ShardManagerTest.getSystem());
        String memberId = "member-1-shard-default-" + this.shardMrgIDSuffix;
        ActorRef respondActor = this.actorFactory.createActor(Props.create(MockRespondActor.class, (Object[])new Object[]{RemoveServer.class, new RemoveServerReply(ServerChangeStatus.OK, null)}), memberId);
        ActorRef shardManager = ShardManagerTest.getSystem().actorOf(this.newPropsShardMgrWithMockShardActor(respondActor));
        shardManager.tell((Object)new UpdateSchemaContext(TEST_SCHEMA_CONTEXT), kit.getRef());
        shardManager.tell((Object)new ActorInitialized(), respondActor);
        shardManager.tell((Object)new ShardLeaderStateChanged(memberId, memberId, (ReadOnlyDataTree)Mockito.mock(DataTree.class), 11), kit.getRef());
        shardManager.tell((Object)new RoleChangeNotification(memberId, RaftState.Candidate.name(), RaftState.Leader.name()), respondActor);
        shardManager.tell((Object)new RemoveShardReplica("default", MEMBER_1), kit.getRef());
        RemoveServer removeServer = (RemoveServer)MessageCollectorActor.expectFirstMatching((ActorRef)respondActor, RemoveServer.class);
        Assert.assertEquals((Object)ShardIdentifier.create((String)"default", (MemberName)MEMBER_1, (String)this.shardMrgIDSuffix).toString(), (Object)removeServer.getServerId());
        kit.expectMsgClass(java.time.Duration.ofSeconds(5L), Status.Success.class);
    }

    @Test
    public void testRemoveShardReplicaRemote() {
        MockConfiguration mockConfig = new MockConfiguration((Map<String, List<String>>)ImmutableMap.builder().put((Object)"default", Arrays.asList("member-1", "member-2")).put((Object)"astronauts", Arrays.asList("member-1")).build());
        String shardManagerID = ShardManagerIdentifier.builder().type(this.shardMrgIDSuffix).build().toString();
        ActorSystem system1 = this.newActorSystem("Member1");
        Cluster.get((ActorSystem)system1).join(AddressFromURIString.parse((String)"akka://cluster-test@127.0.0.1:2558"));
        ActorRef mockDefaultShardActor = this.newMockShardActor(system1, "default", "member-1");
        TestActorRef newReplicaShardManager = TestActorRef.create((ActorSystem)system1, (Props)((TestShardManager.Builder)((TestShardManager.Builder)this.newTestShardMgrBuilder().configuration((Configuration)mockConfig)).shardActor(mockDefaultShardActor).cluster((ClusterWrapper)new ClusterWrapperImpl(system1))).props().withDispatcher(Dispatchers.DefaultDispatcherId()), (String)shardManagerID);
        ActorSystem system2 = this.newActorSystem("Member2");
        Cluster.get((ActorSystem)system2).join(AddressFromURIString.parse((String)"akka://cluster-test@127.0.0.1:2558"));
        String name = ShardIdentifier.create((String)"default", (MemberName)MEMBER_2, (String)this.shardMrgIDSuffix).toString();
        String memberId2 = "member-2-shard-default-" + this.shardMrgIDSuffix;
        TestActorRef mockShardLeaderActor = TestActorRef.create((ActorSystem)system2, (Props)Props.create(MockRespondActor.class, (Object[])new Object[]{RemoveServer.class, new RemoveServerReply(ServerChangeStatus.OK, memberId2)}), (String)name);
        LOG.error("Mock Shard Leader Actor : {}", (Object)mockShardLeaderActor);
        TestActorRef leaderShardManager = TestActorRef.create((ActorSystem)system2, (Props)((TestShardManager.Builder)((TestShardManager.Builder)this.newTestShardMgrBuilder().configuration((Configuration)mockConfig)).shardActor((ActorRef)mockShardLeaderActor).cluster((ClusterWrapper)new ClusterWrapperImpl(system2))).props().withDispatcher(Dispatchers.DefaultDispatcherId()), (String)shardManagerID);
        ActorRef actorRef = ((TestShardManager)leaderShardManager.underlyingActor()).context().actorOf(Props.create(ForwardingActor.class, (Object[])new Object[]{mockShardLeaderActor}), "member-2-shard-default-" + this.shardMrgIDSuffix);
        LOG.error("Forwarding actor : {}", (Object)actorRef);
        TestKit kit = new TestKit(ShardManagerTest.getSystem());
        newReplicaShardManager.tell((Object)new UpdateSchemaContext(TEST_SCHEMA_CONTEXT), kit.getRef());
        leaderShardManager.tell((Object)new UpdateSchemaContext(TEST_SCHEMA_CONTEXT), kit.getRef());
        leaderShardManager.tell((Object)new ActorInitialized(), (ActorRef)mockShardLeaderActor);
        newReplicaShardManager.tell((Object)new ActorInitialized(), (ActorRef)mockShardLeaderActor);
        short leaderVersion = 10;
        leaderShardManager.tell((Object)new ShardLeaderStateChanged(memberId2, memberId2, (ReadOnlyDataTree)Mockito.mock(DataTree.class), leaderVersion), (ActorRef)mockShardLeaderActor);
        leaderShardManager.tell((Object)new RoleChangeNotification(memberId2, RaftState.Candidate.name(), RaftState.Leader.name()), (ActorRef)mockShardLeaderActor);
        String memberId1 = "member-1-shard-default-" + this.shardMrgIDSuffix;
        newReplicaShardManager.tell((Object)new ShardLeaderStateChanged(memberId1, memberId2, (ReadOnlyDataTree)Mockito.mock(DataTree.class), leaderVersion), mockShardActor);
        newReplicaShardManager.tell((Object)new RoleChangeNotification(memberId1, RaftState.Candidate.name(), RaftState.Follower.name()), mockShardActor);
        ((TestShardManager)newReplicaShardManager.underlyingActor()).waitForMemberUp();
        ((TestShardManager)leaderShardManager.underlyingActor()).waitForMemberUp();
        newReplicaShardManager.tell((Object)new RemoveShardReplica("default", MEMBER_1), kit.getRef());
        RemoveServer removeServer = (RemoveServer)MessageCollectorActor.expectFirstMatching((ActorRef)mockShardLeaderActor, RemoveServer.class);
        String removeServerId = ShardIdentifier.create((String)"default", (MemberName)MEMBER_1, (String)this.shardMrgIDSuffix).toString();
        Assert.assertEquals((String)"RemoveServer serverId", (Object)removeServerId, (Object)removeServer.getServerId());
        kit.expectMsgClass(java.time.Duration.ofSeconds(5L), Status.Success.class);
    }

    @Test
    public void testRemoveShardReplicaWhenAnotherRemoveShardReplicaAlreadyInProgress() {
        this.testServerChangeWhenAlreadyInProgress("astronauts", new RemoveShardReplica("astronauts", MEMBER_2), RemoveServer.class, new RemoveShardReplica("astronauts", MEMBER_3));
    }

    @Test
    public void testRemoveShardReplicaWhenAddShardReplicaAlreadyInProgress() {
        this.testServerChangeWhenAlreadyInProgress("astronauts", new AddShardReplica("astronauts"), AddServer.class, new RemoveShardReplica("astronauts", MEMBER_2));
    }

    public void testServerChangeWhenAlreadyInProgress(String shardName, Object firstServerChange, Class<?> firstForwardedServerChangeClass, Object secondServerChange) {
        TestKit kit = new TestKit(ShardManagerTest.getSystem());
        TestKit mockShardLeaderKit = new TestKit(ShardManagerTest.getSystem());
        TestKit secondRequestKit = new TestKit(ShardManagerTest.getSystem());
        MockConfiguration mockConfig = new MockConfiguration((Map<String, List<String>>)ImmutableMap.builder().put((Object)shardName, Arrays.asList("member-2")).build());
        TestActorRef shardManager = TestActorRef.create((ActorSystem)ShardManagerTest.getSystem(), (Props)((TestShardManager.Builder)((TestShardManager.Builder)this.newTestShardMgrBuilder().configuration((Configuration)mockConfig)).shardActor(mockShardActor).cluster(new MockClusterWrapper())).props().withDispatcher(Dispatchers.DefaultDispatcherId()), (String)this.shardMgrID);
        ((TestShardManager)shardManager.underlyingActor()).setMessageInterceptor(ShardManagerTest.newFindPrimaryInterceptor(mockShardLeaderKit.getRef()));
        shardManager.tell((Object)new UpdateSchemaContext(TEST_SCHEMA_CONTEXT), kit.getRef());
        shardManager.tell(firstServerChange, kit.getRef());
        mockShardLeaderKit.expectMsgClass(firstForwardedServerChangeClass);
        shardManager.tell(secondServerChange, secondRequestKit.getRef());
        secondRequestKit.expectMsgClass(java.time.Duration.ofSeconds(5L), Status.Failure.class);
    }

    @Test
    public void testServerRemovedShardActorNotRunning() {
        LOG.info("testServerRemovedShardActorNotRunning starting");
        TestKit kit = new TestKit(ShardManagerTest.getSystem());
        MockConfiguration mockConfig = new MockConfiguration((Map<String, List<String>>)ImmutableMap.builder().put((Object)"default", Arrays.asList("member-1", "member-2")).put((Object)"astronauts", Arrays.asList("member-2")).put((Object)"people", Arrays.asList("member-1", "member-2")).build());
        TestActorRef shardManager = this.actorFactory.createTestActor(this.newShardMgrProps((Configuration)mockConfig).withDispatcher(Dispatchers.DefaultDispatcherId()));
        ((TestShardManager)shardManager.underlyingActor()).waitForRecoveryComplete();
        shardManager.tell((Object)new FindLocalShard("people", false), kit.getRef());
        kit.expectMsgClass(java.time.Duration.ofSeconds(5L), NotInitializedException.class);
        shardManager.tell((Object)new FindLocalShard("default", false), kit.getRef());
        kit.expectMsgClass(java.time.Duration.ofSeconds(5L), NotInitializedException.class);
        ShardIdentifier.Builder builder = new ShardIdentifier.Builder();
        ShardIdentifier shardId = builder.shardName("default").memberName(MEMBER_1).type(this.shardMrgIDSuffix).build();
        shardManager.tell((Object)new ServerRemoved(shardId.toString()), kit.getRef());
        ((TestShardManager)shardManager.underlyingActor()).verifySnapshotPersisted(Sets.newHashSet((Object[])new String[]{"people"}));
        LOG.info("testServerRemovedShardActorNotRunning ending");
    }

    @Test
    public void testServerRemovedShardActorRunning() {
        LOG.info("testServerRemovedShardActorRunning starting");
        TestKit kit = new TestKit(ShardManagerTest.getSystem());
        MockConfiguration mockConfig = new MockConfiguration((Map<String, List<String>>)ImmutableMap.builder().put((Object)"default", Arrays.asList("member-1", "member-2")).put((Object)"astronauts", Arrays.asList("member-2")).put((Object)"people", Arrays.asList("member-1", "member-2")).build());
        String shardId = ShardIdentifier.create((String)"default", (MemberName)MEMBER_1, (String)this.shardMrgIDSuffix).toString();
        ActorRef shard = this.actorFactory.createActor(MessageCollectorActor.props(), shardId);
        TestActorRef shardManager = this.actorFactory.createTestActor(this.newTestShardMgrBuilder((Configuration)mockConfig).addShardActor("default", shard).props().withDispatcher(Dispatchers.DefaultDispatcherId()));
        ((TestShardManager)shardManager.underlyingActor()).waitForRecoveryComplete();
        shardManager.tell((Object)new UpdateSchemaContext(TEST_SCHEMA_CONTEXT), kit.getRef());
        shardManager.tell((Object)new ActorInitialized(), shard);
        ShardManagerTest.waitForShardInitialized((ActorRef)shardManager, "people", kit);
        ShardManagerTest.waitForShardInitialized((ActorRef)shardManager, "default", kit);
        shardManager.tell((Object)new ServerRemoved(shardId), kit.getRef());
        ((TestShardManager)shardManager.underlyingActor()).verifySnapshotPersisted(Sets.newHashSet((Object[])new String[]{"people"}));
        MessageCollectorActor.expectFirstMatching((ActorRef)shard, Shutdown.class);
        LOG.info("testServerRemovedShardActorRunning ending");
    }

    @Test
    public void testShardPersistenceWithRestoredData() {
        LOG.info("testShardPersistenceWithRestoredData starting");
        TestKit kit = new TestKit(ShardManagerTest.getSystem());
        MockConfiguration mockConfig = new MockConfiguration((Map<String, List<String>>)ImmutableMap.builder().put((Object)"default", Arrays.asList("member-1", "member-2")).put((Object)"astronauts", Arrays.asList("member-2")).put((Object)"people", Arrays.asList("member-1", "member-2")).build());
        String[] restoredShards = new String[]{"default", "astronauts"};
        ShardManagerSnapshot snapshot = new ShardManagerSnapshot(Arrays.asList(restoredShards), Collections.emptyMap());
        InMemorySnapshotStore.addSnapshot((String)("shard-manager-" + this.shardMrgIDSuffix), (Object)snapshot);
        TestActorRef newRestoredShardManager = this.actorFactory.createTestActor(this.newShardMgrProps((Configuration)mockConfig).withDispatcher(Dispatchers.DefaultDispatcherId()));
        ((TestShardManager)newRestoredShardManager.underlyingActor()).waitForRecoveryComplete();
        newRestoredShardManager.tell((Object)new FindLocalShard("people", false), kit.getRef());
        LocalShardNotFound notFound = (LocalShardNotFound)kit.expectMsgClass(java.time.Duration.ofSeconds(5L), LocalShardNotFound.class);
        Assert.assertEquals((String)"for uninitialized shard", (Object)"people", (Object)notFound.getShardName());
        newRestoredShardManager.tell((Object)new FindLocalShard("default", false), kit.getRef());
        kit.expectMsgClass(java.time.Duration.ofSeconds(5L), NotInitializedException.class);
        newRestoredShardManager.tell((Object)new FindLocalShard("astronauts", false), kit.getRef());
        kit.expectMsgClass(java.time.Duration.ofSeconds(5L), NotInitializedException.class);
        LOG.info("testShardPersistenceWithRestoredData ending");
    }

    @Test
    public void testShutDown() throws Exception {
        LOG.info("testShutDown starting");
        TestKit kit = new TestKit(ShardManagerTest.getSystem());
        MockConfiguration mockConfig = new MockConfiguration((Map<String, List<String>>)ImmutableMap.builder().put((Object)"shard1", Arrays.asList("member-1")).put((Object)"shard2", Arrays.asList("member-1")).build());
        String shardId1 = ShardIdentifier.create((String)"shard1", (MemberName)MEMBER_1, (String)this.shardMrgIDSuffix).toString();
        ActorRef shard1 = this.actorFactory.createActor(MessageCollectorActor.props(), shardId1);
        String shardId2 = ShardIdentifier.create((String)"shard2", (MemberName)MEMBER_1, (String)this.shardMrgIDSuffix).toString();
        ActorRef shard2 = this.actorFactory.createActor(MessageCollectorActor.props(), shardId2);
        ActorRef shardManager = this.actorFactory.createActor(this.newTestShardMgrBuilder((Configuration)mockConfig).addShardActor("shard1", shard1).addShardActor("shard2", shard2).props());
        shardManager.tell((Object)new UpdateSchemaContext(TEST_SCHEMA_CONTEXT), kit.getRef());
        shardManager.tell((Object)new ActorInitialized(), shard1);
        shardManager.tell((Object)new ActorInitialized(), shard2);
        FiniteDuration duration = FiniteDuration.create((long)5L, (TimeUnit)TimeUnit.SECONDS);
        Future stopFuture = Patterns.gracefulStop((ActorRef)shardManager, (FiniteDuration)duration, (Object)Shutdown.INSTANCE);
        MessageCollectorActor.expectFirstMatching((ActorRef)shard1, Shutdown.class);
        MessageCollectorActor.expectFirstMatching((ActorRef)shard2, Shutdown.class);
        try {
            Await.ready((Awaitable)stopFuture, (Duration)FiniteDuration.create((long)500L, (TimeUnit)TimeUnit.MILLISECONDS));
            Assert.fail((String)"ShardManager actor stopped without waiting for the Shards to be stopped");
        }
        catch (TimeoutException timeoutException) {
            // empty catch block
        }
        this.actorFactory.killActor(shard1, kit);
        this.actorFactory.killActor(shard2, kit);
        Boolean stopped = (Boolean)Await.result((Awaitable)stopFuture, (Duration)duration);
        Assert.assertEquals((String)"Stopped", (Object)Boolean.TRUE, (Object)stopped);
        LOG.info("testShutDown ending");
    }

    @Test
    public void testChangeServersVotingStatus() {
        TestKit kit = new TestKit(ShardManagerTest.getSystem());
        String memberId = "member-1-shard-default-" + this.shardMrgIDSuffix;
        ActorRef respondActor = this.actorFactory.createActor(Props.create(MockRespondActor.class, (Object[])new Object[]{ChangeServersVotingStatus.class, new ServerChangeReply(ServerChangeStatus.OK, null)}), memberId);
        ActorRef shardManager = ShardManagerTest.getSystem().actorOf(this.newPropsShardMgrWithMockShardActor(respondActor));
        shardManager.tell((Object)new UpdateSchemaContext(TEST_SCHEMA_CONTEXT), kit.getRef());
        shardManager.tell((Object)new ActorInitialized(), respondActor);
        shardManager.tell((Object)new ShardLeaderStateChanged(memberId, memberId, (ReadOnlyDataTree)Mockito.mock(DataTree.class), 11), kit.getRef());
        shardManager.tell((Object)new RoleChangeNotification(memberId, RaftState.Candidate.name(), RaftState.Leader.name()), respondActor);
        shardManager.tell((Object)new ChangeShardMembersVotingStatus("default", (Map)ImmutableMap.of((Object)"member-2", (Object)Boolean.TRUE)), kit.getRef());
        ChangeServersVotingStatus actualChangeStatusMsg = (ChangeServersVotingStatus)MessageCollectorActor.expectFirstMatching((ActorRef)respondActor, ChangeServersVotingStatus.class);
        Assert.assertEquals((String)"ChangeServersVotingStatus map", (Object)actualChangeStatusMsg.getServerVotingStatusMap(), (Object)ImmutableMap.of((Object)ShardIdentifier.create((String)"default", (MemberName)MemberName.forName((String)"member-2"), (String)this.shardMrgIDSuffix).toString(), (Object)Boolean.TRUE));
        kit.expectMsgClass(java.time.Duration.ofSeconds(5L), Status.Success.class);
    }

    @Test
    public void testChangeServersVotingStatusWithNoLeader() {
        TestKit kit = new TestKit(ShardManagerTest.getSystem());
        String memberId = "member-1-shard-default-" + this.shardMrgIDSuffix;
        ActorRef respondActor = this.actorFactory.createActor(Props.create(MockRespondActor.class, (Object[])new Object[]{ChangeServersVotingStatus.class, new ServerChangeReply(ServerChangeStatus.NO_LEADER, null)}), memberId);
        ActorRef shardManager = ShardManagerTest.getSystem().actorOf(this.newPropsShardMgrWithMockShardActor(respondActor));
        shardManager.tell((Object)new UpdateSchemaContext(TEST_SCHEMA_CONTEXT), kit.getRef());
        shardManager.tell((Object)new ActorInitialized(), respondActor);
        shardManager.tell((Object)new RoleChangeNotification(memberId, null, RaftState.Follower.name()), respondActor);
        shardManager.tell((Object)new ChangeShardMembersVotingStatus("default", (Map)ImmutableMap.of((Object)"member-2", (Object)Boolean.TRUE)), kit.getRef());
        MessageCollectorActor.expectFirstMatching((ActorRef)respondActor, ChangeServersVotingStatus.class);
        Status.Failure resp = (Status.Failure)kit.expectMsgClass(java.time.Duration.ofSeconds(5L), Status.Failure.class);
        Assert.assertTrue((String)"Failure resposnse", (boolean)(resp.cause() instanceof NoShardLeaderException));
    }

    @Test
    public void testRegisterForShardLeaderChanges() {
        LOG.info("testRegisterForShardLeaderChanges starting");
        String memberId1 = "member-1-shard-default-" + this.shardMrgIDSuffix;
        String memberId2 = "member-2-shard-default-" + this.shardMrgIDSuffix;
        TestKit kit = new TestKit(ShardManagerTest.getSystem());
        ActorRef shardManager = this.actorFactory.createActor(this.newPropsShardMgrWithMockShardActor());
        shardManager.tell((Object)new UpdateSchemaContext(TEST_SCHEMA_CONTEXT), kit.getRef());
        shardManager.tell((Object)new ActorInitialized(), mockShardActor);
        Consumer mockCallback = (Consumer)Mockito.mock(Consumer.class);
        shardManager.tell((Object)new RegisterForShardAvailabilityChanges(mockCallback), kit.getRef());
        Status.Success reply = (Status.Success)kit.expectMsgClass(java.time.Duration.ofSeconds(5L), Status.Success.class);
        Registration reg = (Registration)reply.status();
        DataTree mockDataTree = (DataTree)Mockito.mock(DataTree.class);
        shardManager.tell((Object)new ShardLeaderStateChanged(memberId1, memberId1, (ReadOnlyDataTree)mockDataTree, 11), mockShardActor);
        ((Consumer)Mockito.verify((Object)mockCallback, (VerificationMode)Mockito.timeout((long)5000L))).accept("default");
        Mockito.reset((Object[])new Consumer[]{mockCallback});
        shardManager.tell((Object)new ShardLeaderStateChanged(memberId1, memberId1, (ReadOnlyDataTree)mockDataTree, 11), mockShardActor);
        Uninterruptibles.sleepUninterruptibly((long)500L, (TimeUnit)TimeUnit.MILLISECONDS);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{mockCallback});
        shardManager.tell((Object)new ShardLeaderStateChanged(memberId1, null, (ReadOnlyDataTree)mockDataTree, 11), mockShardActor);
        ((Consumer)Mockito.verify((Object)mockCallback, (VerificationMode)Mockito.timeout((long)5000L))).accept("default");
        Mockito.reset((Object[])new Consumer[]{mockCallback});
        shardManager.tell((Object)new ShardLeaderStateChanged(memberId1, memberId2, (ReadOnlyDataTree)mockDataTree, 11), mockShardActor);
        ((Consumer)Mockito.verify((Object)mockCallback, (VerificationMode)Mockito.timeout((long)5000L))).accept("default");
        Mockito.reset((Object[])new Consumer[]{mockCallback});
        reg.close();
        shardManager.tell((Object)new ShardLeaderStateChanged(memberId1, memberId1, (ReadOnlyDataTree)mockDataTree, 11), mockShardActor);
        Uninterruptibles.sleepUninterruptibly((long)500L, (TimeUnit)TimeUnit.MILLISECONDS);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{mockCallback});
        LOG.info("testRegisterForShardLeaderChanges ending");
    }

    private static MessageInterceptor newFindPrimaryInterceptor(final ActorRef primaryActor) {
        return new MessageInterceptor(){

            @Override
            public Object apply(Object message) {
                return new RemotePrimaryShardFound(Serialization.serializedActorPath((ActorRef)primaryActor), 1);
            }

            @Override
            public boolean canIntercept(Object message) {
                return message instanceof FindPrimary;
            }
        };
    }

    private static class MockRespondActor
    extends MessageCollectorActor {
        static final String CLEAR_RESPONSE = "clear-response";
        private Object responseMsg;
        private final Class<?> requestClass;

        MockRespondActor(Class<?> requestClass, Object responseMsg) {
            this.requestClass = requestClass;
            this.responseMsg = responseMsg;
        }

        public void onReceive(Object message) throws Exception {
            if (message.equals(CLEAR_RESPONSE)) {
                this.responseMsg = null;
            } else {
                super.onReceive(message);
                if (message.getClass().equals(this.requestClass) && this.responseMsg != null) {
                    this.getSender().tell(this.responseMsg, this.getSelf());
                }
            }
        }
    }

    static interface MessageInterceptor
    extends Function<Object, Object> {
        public boolean canIntercept(Object var1);
    }

    private static class DelegatingShardManagerCreator
    implements Creator<ShardManager> {
        private static final long serialVersionUID = 1L;
        private final Creator<ShardManager> delegate;

        DelegatingShardManagerCreator(Creator<ShardManager> delegate) {
            this.delegate = delegate;
        }

        public ShardManager create() throws Exception {
            return (ShardManager)this.delegate.create();
        }
    }

    private static class GenericCreator<C extends ShardManager>
    extends AbstractGenericCreator<GenericCreator<C>, C> {
        GenericCreator(Class<C> shardManagerClass) {
            super(shardManagerClass);
        }
    }

    private static abstract class AbstractGenericCreator<T extends AbstractGenericCreator<T, ?>, C extends ShardManager>
    extends AbstractShardManagerCreator<T> {
        private final Class<C> shardManagerClass;

        AbstractGenericCreator(Class<C> shardManagerClass) {
            this.shardManagerClass = shardManagerClass;
            ((AbstractGenericCreator)((AbstractGenericCreator)((AbstractGenericCreator)this.cluster(new MockClusterWrapper())).configuration((Configuration)new MockConfiguration())).readinessFuture(ready)).primaryShardInfoCache(new PrimaryShardInfoFutureCache());
        }

        public Props props() {
            this.verify();
            return Props.create(this.shardManagerClass, (Object[])new Object[]{this});
        }
    }

    public static class TestShardManager
    extends ShardManager {
        private final CountDownLatch recoveryComplete = new CountDownLatch(1);
        private final CountDownLatch snapshotPersist = new CountDownLatch(1);
        private ShardManagerSnapshot snapshot;
        private final Map<String, ActorRef> shardActors;
        private final ActorRef shardActor;
        private CountDownLatch findPrimaryMessageReceived = new CountDownLatch(1);
        private CountDownLatch memberUpReceived = new CountDownLatch(1);
        private CountDownLatch memberRemovedReceived = new CountDownLatch(1);
        private CountDownLatch memberUnreachableReceived = new CountDownLatch(1);
        private CountDownLatch memberReachableReceived = new CountDownLatch(1);
        private volatile MessageInterceptor messageInterceptor;

        TestShardManager(Builder builder) {
            super((AbstractShardManagerCreator)builder);
            this.shardActor = builder.shardActor;
            this.shardActors = builder.shardActors;
        }

        protected void handleRecover(Object message) throws Exception {
            try {
                super.handleRecover(message);
            }
            finally {
                if (message instanceof RecoveryCompleted) {
                    this.recoveryComplete.countDown();
                }
            }
        }

        private void countDownIfOther(Member member, CountDownLatch latch) {
            if (!this.getCluster().getCurrentMemberName().equals((Object)TestShardManager.memberToName((Member)member))) {
                latch.countDown();
            }
        }

        public void handleCommand(Object message) throws Exception {
            try {
                if (this.messageInterceptor != null && this.messageInterceptor.canIntercept(message)) {
                    this.getSender().tell(this.messageInterceptor.apply(message), this.getSelf());
                } else {
                    super.handleCommand(message);
                }
            }
            finally {
                if (message instanceof FindPrimary) {
                    this.findPrimaryMessageReceived.countDown();
                } else if (message instanceof ClusterEvent.MemberUp) {
                    this.countDownIfOther(((ClusterEvent.MemberUp)message).member(), this.memberUpReceived);
                } else if (message instanceof ClusterEvent.MemberRemoved) {
                    this.countDownIfOther(((ClusterEvent.MemberRemoved)message).member(), this.memberRemovedReceived);
                } else if (message instanceof ClusterEvent.UnreachableMember) {
                    this.countDownIfOther(((ClusterEvent.UnreachableMember)message).member(), this.memberUnreachableReceived);
                } else if (message instanceof ClusterEvent.ReachableMember) {
                    this.countDownIfOther(((ClusterEvent.ReachableMember)message).member(), this.memberReachableReceived);
                }
            }
        }

        void setMessageInterceptor(MessageInterceptor messageInterceptor) {
            this.messageInterceptor = messageInterceptor;
        }

        void waitForRecoveryComplete() {
            Assert.assertTrue((String)"Recovery complete", (boolean)Uninterruptibles.awaitUninterruptibly((CountDownLatch)this.recoveryComplete, (long)5L, (TimeUnit)TimeUnit.SECONDS));
        }

        public void waitForMemberUp() {
            Assert.assertTrue((String)"MemberUp received", (boolean)Uninterruptibles.awaitUninterruptibly((CountDownLatch)this.memberUpReceived, (long)5L, (TimeUnit)TimeUnit.SECONDS));
            this.memberUpReceived = new CountDownLatch(1);
        }

        void waitForMemberRemoved() {
            Assert.assertTrue((String)"MemberRemoved received", (boolean)Uninterruptibles.awaitUninterruptibly((CountDownLatch)this.memberRemovedReceived, (long)5L, (TimeUnit)TimeUnit.SECONDS));
            this.memberRemovedReceived = new CountDownLatch(1);
        }

        void waitForUnreachableMember() {
            Assert.assertTrue((String)"UnreachableMember received", (boolean)Uninterruptibles.awaitUninterruptibly((CountDownLatch)this.memberUnreachableReceived, (long)5L, (TimeUnit)TimeUnit.SECONDS));
            this.memberUnreachableReceived = new CountDownLatch(1);
        }

        void waitForReachableMember() {
            Assert.assertTrue((String)"ReachableMember received", (boolean)Uninterruptibles.awaitUninterruptibly((CountDownLatch)this.memberReachableReceived, (long)5L, (TimeUnit)TimeUnit.SECONDS));
            this.memberReachableReceived = new CountDownLatch(1);
        }

        void verifyFindPrimary() {
            Assert.assertTrue((String)"FindPrimary received", (boolean)Uninterruptibles.awaitUninterruptibly((CountDownLatch)this.findPrimaryMessageReceived, (long)5L, (TimeUnit)TimeUnit.SECONDS));
            this.findPrimaryMessageReceived = new CountDownLatch(1);
        }

        public static Builder builder(DatastoreContext.Builder datastoreContextBuilder) {
            return new Builder(datastoreContextBuilder);
        }

        public void saveSnapshot(Object obj) {
            this.snapshot = (ShardManagerSnapshot)obj;
            this.snapshotPersist.countDown();
            super.saveSnapshot(obj);
        }

        void verifySnapshotPersisted(Set<String> shardList) {
            Assert.assertTrue((String)"saveSnapshot invoked", (boolean)Uninterruptibles.awaitUninterruptibly((CountDownLatch)this.snapshotPersist, (long)5L, (TimeUnit)TimeUnit.SECONDS));
            Assert.assertEquals((String)"Shard Persisted", shardList, (Object)Sets.newHashSet((Iterable)this.snapshot.getShardList()));
        }

        protected ActorRef newShardActor(ShardInformation info) {
            if (this.shardActors.get(info.getShardName()) != null) {
                return this.shardActors.get(info.getShardName());
            }
            if (this.shardActor != null) {
                return this.shardActor;
            }
            return super.newShardActor(info);
        }

        public static class Builder
        extends AbstractGenericCreator<Builder, TestShardManager> {
            private ActorRef shardActor;
            private final Map<String, ActorRef> shardActors = new HashMap<String, ActorRef>();

            Builder(DatastoreContext.Builder datastoreContextBuilder) {
                super(TestShardManager.class);
                this.datastoreContextFactory(ShardManagerTest.newDatastoreContextFactory(datastoreContextBuilder.build()));
            }

            Builder shardActor(ActorRef newShardActor) {
                this.shardActor = newShardActor;
                return this;
            }

            Builder addShardActor(String shardName, ActorRef actorRef) {
                this.shardActors.put(shardName, actorRef);
                return this;
            }
        }
    }
}

