/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.cluster.datastore.shardmanager;

import akka.actor.Address;
import com.google.common.collect.Sets;
import java.util.Collection;
import org.junit.Assert;
import org.junit.Test;
import org.opendaylight.controller.cluster.access.concepts.MemberName;
import org.opendaylight.controller.cluster.datastore.identifiers.ShardIdentifier;
import org.opendaylight.controller.cluster.datastore.shardmanager.ShardPeerAddressResolver;

public class ShardPeerAddressResolverTest {
    private static final MemberName MEMBER_1 = MemberName.forName((String)"member-1");
    private static final MemberName MEMBER_2 = MemberName.forName((String)"member-2");
    private static final MemberName MEMBER_3 = MemberName.forName((String)"member-3");

    @Test
    public void testGetShardActorAddress() {
        ShardPeerAddressResolver resolver = new ShardPeerAddressResolver("config", MEMBER_1);
        Assert.assertEquals((String)"getShardActorAddress", null, (Object)resolver.getShardActorAddress("default", MEMBER_2));
        Address address2 = new Address("tcp", "system2");
        resolver.addPeerAddress(MEMBER_2, address2);
        Assert.assertEquals((String)"getPeerAddress", (Object)address2, (Object)resolver.getPeerAddress(MEMBER_2));
        Address address3 = new Address("tcp", "system3");
        resolver.addPeerAddress(MEMBER_3, address3);
        Assert.assertEquals((String)"getPeerAddress", (Object)address3, (Object)resolver.getPeerAddress(MEMBER_3));
        Assert.assertEquals((String)"getShardActorAddress", (Object)(address2.toString() + "/user/shardmanager-config/member-2-shard-default-config"), (Object)resolver.getShardActorAddress("default", MEMBER_2));
        Assert.assertEquals((String)"getShardActorAddress", (Object)(address3.toString() + "/user/shardmanager-config/member-3-shard-default-config"), (Object)resolver.getShardActorAddress("default", MEMBER_3));
        Assert.assertEquals((String)"getShardActorAddress", (Object)(address2.toString() + "/user/shardmanager-config/member-2-shard-topology-config"), (Object)resolver.getShardActorAddress("topology", MEMBER_2));
        resolver.removePeerAddress(MEMBER_2);
        Assert.assertEquals((String)"getShardActorAddress", null, (Object)resolver.getShardActorAddress("default", MEMBER_2));
        Assert.assertEquals((String)"getShardActorAddress", null, (Object)resolver.getShardActorAddress("topology", MEMBER_2));
        Assert.assertEquals((String)"getShardActorAddress", (Object)(address3.toString() + "/user/shardmanager-config/member-3-shard-default-config"), (Object)resolver.getShardActorAddress("default", MEMBER_3));
    }

    @Test
    public void testResolve() {
        String type = "config";
        ShardPeerAddressResolver resolver = new ShardPeerAddressResolver(type, MEMBER_1);
        MemberName memberName = MEMBER_2;
        String peerId = ShardIdentifier.create((String)"default", (MemberName)memberName, (String)type).toString();
        Assert.assertEquals((String)"resolve", null, (Object)resolver.resolve(peerId));
        Address address = new Address("tcp", "system");
        resolver.addPeerAddress(memberName, address);
        String shardAddress = resolver.getShardActorAddress("default", memberName);
        Assert.assertEquals((String)"getShardActorAddress", (Object)(address.toString() + "/user/shardmanager-" + type + "/" + memberName.getName() + "-shard-default-" + type), (Object)shardAddress);
        Assert.assertEquals((String)"resolve", (Object)shardAddress, (Object)resolver.resolve(peerId));
    }

    @Test
    public void testSetResolved() {
        String type = "config";
        ShardPeerAddressResolver resolver = new ShardPeerAddressResolver(type, MEMBER_1);
        String peerId = ShardIdentifier.create((String)"default", (MemberName)MEMBER_2, (String)type).toString();
        String address = "akka.tcp://opendaylight-cluster-data@127.0.0.1:2550/user/shardmanager-" + type + "/" + MEMBER_2.getName() + "-shard-default-" + type;
        resolver.setResolved(peerId, address);
        Assert.assertEquals((String)"resolve", (Object)address, (Object)resolver.resolve(peerId));
    }

    @Test
    public void testGetShardManagerPeerActorAddresses() {
        ShardPeerAddressResolver resolver = new ShardPeerAddressResolver("config", MEMBER_1);
        resolver.addPeerAddress(MEMBER_1, new Address("tcp", "system1"));
        Address address2 = new Address("tcp", "system2");
        resolver.addPeerAddress(MEMBER_2, address2);
        Address address3 = new Address("tcp", "system3");
        resolver.addPeerAddress(MEMBER_3, address3);
        Collection peerAddresses = resolver.getShardManagerPeerActorAddresses();
        Assert.assertEquals((String)"getShardManagerPeerActorAddresses", (Object)Sets.newHashSet((Object[])new String[]{address2.toString() + "/user/shardmanager-config", address3.toString() + "/user/shardmanager-config"}), (Object)Sets.newHashSet((Iterable)peerAddresses));
    }
}

