/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.cluster.datastore.utils;

import akka.actor.ActorRef;
import akka.actor.Address;
import akka.actor.AddressFromURIString;
import akka.cluster.ClusterEvent;
import akka.cluster.Member;
import akka.cluster.MemberStatus;
import akka.cluster.UniqueAddress;
import org.opendaylight.controller.cluster.access.concepts.MemberName;
import org.opendaylight.controller.cluster.datastore.ClusterWrapper;
import scala.collection.immutable.Set;

public class MockClusterWrapper
implements ClusterWrapper {
    private Address selfAddress = new Address("akka", "test", "127.0.0.1", 2550);
    private final MemberName currentMemberName;

    public MockClusterWrapper() {
        this("member-1");
    }

    public MockClusterWrapper(String currentMemberName) {
        this.currentMemberName = MemberName.forName((String)currentMemberName);
    }

    public void subscribeToMemberEvents(ActorRef actorRef) {
    }

    public MemberName getCurrentMemberName() {
        return this.currentMemberName;
    }

    public Address getSelfAddress() {
        return this.selfAddress;
    }

    public void setSelfAddress(Address selfAddress) {
        this.selfAddress = selfAddress;
    }

    public static void sendMemberUp(ActorRef to, String memberName, String address) {
        to.tell((Object)MockClusterWrapper.createMemberUp(memberName, address), null);
    }

    public static void sendMemberRemoved(ActorRef to, String memberName, String address) {
        to.tell((Object)MockClusterWrapper.createMemberRemoved(memberName, address), null);
    }

    public static ClusterEvent.MemberRemoved createMemberRemoved(String memberName, String address) {
        UniqueAddress uniqueAddress = new UniqueAddress(AddressFromURIString.parse((String)address), 55L);
        Member member = new Member(uniqueAddress, 1, MemberStatus.removed(), (Set)new Set.Set1((Object)memberName));
        return new ClusterEvent.MemberRemoved(member, MemberStatus.up());
    }

    public static ClusterEvent.MemberUp createMemberUp(String memberName, String address) {
        UniqueAddress uniqueAddress = new UniqueAddress(AddressFromURIString.parse((String)address), 55L);
        Member member = new Member(uniqueAddress, 1, MemberStatus.up(), (Set)new Set.Set1((Object)memberName));
        return new ClusterEvent.MemberUp(member);
    }

    public static ClusterEvent.UnreachableMember createUnreachableMember(String memberName, String address) {
        UniqueAddress uniqueAddress = new UniqueAddress(AddressFromURIString.parse((String)address), 55L);
        Member member = new Member(uniqueAddress, 1, MemberStatus.up(), (Set)new Set.Set1((Object)memberName));
        return new ClusterEvent.UnreachableMember(member);
    }

    public static ClusterEvent.ReachableMember createReachableMember(String memberName, String address) {
        UniqueAddress uniqueAddress = new UniqueAddress(AddressFromURIString.parse((String)address), 55L);
        Member member = new Member(uniqueAddress, 1, MemberStatus.up(), (Set)new Set.Set1((Object)memberName));
        return new ClusterEvent.ReachableMember(member);
    }
}

