/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.cluster.datastore.utils;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.opendaylight.controller.cluster.access.concepts.MemberName;
import org.opendaylight.controller.cluster.datastore.config.ConfigurationImpl;
import org.opendaylight.controller.cluster.datastore.config.ModuleConfig;
import org.opendaylight.controller.cluster.datastore.shardstrategy.ShardStrategy;
import org.opendaylight.mdsal.dom.api.DOMDataTreeIdentifier;

public class MockConfiguration
extends ConfigurationImpl {
    public MockConfiguration() {
        this(Collections.singletonMap("default", Arrays.asList("member-1", "member-2")));
    }

    public MockConfiguration(Map<String, List<String>> shardMembers) {
        super(configuration -> {
            HashMap<String, ModuleConfig.Builder> retMap = new HashMap<String, ModuleConfig.Builder>();
            for (Map.Entry e : shardMembers.entrySet()) {
                String shardName = (String)e.getKey();
                retMap.put(shardName, ModuleConfig.builder((String)shardName).shardConfig(shardName, (Collection)((List)e.getValue()).stream().map(MemberName::forName).collect(Collectors.toList())));
            }
            return retMap;
        });
    }

    public ShardStrategy getStrategyForPrefix(DOMDataTreeIdentifier prefix) {
        return null;
    }
}

