/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.cluster.datastore.utils;

import com.codahale.metrics.Snapshot;
import com.codahale.metrics.Timer;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.time.StopWatch;
import org.hamcrest.BaseMatcher;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;
import org.mockito.verification.VerificationMode;
import org.opendaylight.controller.cluster.datastore.DatastoreContext;
import org.opendaylight.controller.cluster.datastore.utils.ActorUtils;
import org.opendaylight.controller.cluster.datastore.utils.TransactionRateLimiter;

public class TransactionRateLimiterTest {
    @Mock
    public ActorUtils actorUtils;
    @Mock
    public DatastoreContext datastoreContext;
    @Mock
    public Timer commitTimer;
    @Mock
    private Timer.Context commitTimerContext;
    @Mock
    private Snapshot commitSnapshot;

    @Before
    public void setUp() {
        MockitoAnnotations.initMocks((Object)this);
        ((ActorUtils)Mockito.doReturn((Object)this.datastoreContext).when((Object)this.actorUtils)).getDatastoreContext();
        ((DatastoreContext)Mockito.doReturn((Object)30).when((Object)this.datastoreContext)).getShardTransactionCommitTimeoutInSeconds();
        ((DatastoreContext)Mockito.doReturn((Object)100L).when((Object)this.datastoreContext)).getTransactionCreationInitialRateLimit();
        ((ActorUtils)Mockito.doReturn((Object)this.commitTimer).when((Object)this.actorUtils)).getOperationTimer("commit");
        ((Timer)Mockito.doReturn((Object)this.commitTimerContext).when((Object)this.commitTimer)).time();
        ((Timer)Mockito.doReturn((Object)this.commitSnapshot).when((Object)this.commitTimer)).getSnapshot();
    }

    @Test
    public void testAcquireRateLimitChanged() {
        for (int i = 1; i < 11; ++i) {
            ((Snapshot)Mockito.doReturn((Object)((double)TimeUnit.MILLISECONDS.toNanos(i) * 1.0)).when((Object)this.commitSnapshot)).getValue((double)i * 0.1);
        }
        TransactionRateLimiter rateLimiter = new TransactionRateLimiter(this.actorUtils);
        rateLimiter.acquire();
        MatcherAssert.assertThat((Object)rateLimiter.getTxCreationLimit(), this.approximately(292.0));
        Assert.assertEquals((long)147L, (long)rateLimiter.getPollOnCount());
    }

    @Test
    public void testAcquirePercentileValueZero() {
        for (int i = 1; i < 11; ++i) {
            ((Snapshot)Mockito.doReturn((Object)((double)TimeUnit.MILLISECONDS.toNanos(i) * 1.0)).when((Object)this.commitSnapshot)).getValue((double)i * 0.1);
        }
        ((Snapshot)Mockito.doReturn((Object)((double)TimeUnit.MILLISECONDS.toNanos(0L) * 1.0)).when((Object)this.commitSnapshot)).getValue(0.1);
        TransactionRateLimiter rateLimiter = new TransactionRateLimiter(this.actorUtils);
        rateLimiter.acquire();
        MatcherAssert.assertThat((Object)rateLimiter.getTxCreationLimit(), this.approximately(192.0));
        Assert.assertEquals((long)97L, (long)rateLimiter.getPollOnCount());
    }

    @Test
    public void testAcquireOnePercentileValueVeryHigh() {
        for (int i = 1; i < 11; ++i) {
            ((Snapshot)Mockito.doReturn((Object)((double)TimeUnit.MILLISECONDS.toNanos(i) * 1.0)).when((Object)this.commitSnapshot)).getValue((double)i * 0.1);
        }
        ((Snapshot)Mockito.doReturn((Object)((double)TimeUnit.MILLISECONDS.toNanos(10000L) * 1.0)).when((Object)this.commitSnapshot)).getValue(1.0);
        TransactionRateLimiter rateLimiter = new TransactionRateLimiter(this.actorUtils);
        rateLimiter.acquire();
        MatcherAssert.assertThat((Object)rateLimiter.getTxCreationLimit(), this.approximately(282.0));
        Assert.assertEquals((long)142L, (long)rateLimiter.getPollOnCount());
    }

    @Test
    public void testAcquireWithAllPercentileValueVeryHigh() {
        for (int i = 1; i < 11; ++i) {
            ((Snapshot)Mockito.doReturn((Object)((double)TimeUnit.MILLISECONDS.toNanos(10000L) * 1.0)).when((Object)this.commitSnapshot)).getValue((double)i * 0.1);
        }
        TransactionRateLimiter rateLimiter = new TransactionRateLimiter(this.actorUtils);
        rateLimiter.acquire();
        MatcherAssert.assertThat((Object)rateLimiter.getTxCreationLimit(), this.approximately(100.0));
        Assert.assertEquals((long)1L, (long)rateLimiter.getPollOnCount());
    }

    @Test
    public void testAcquireWithRealPercentileValues() {
        for (int i = 1; i < 11; ++i) {
            ((Snapshot)Mockito.doReturn((Object)((double)TimeUnit.MILLISECONDS.toNanos(8L) * 1.0)).when((Object)this.commitSnapshot)).getValue((double)i * 0.1);
        }
        ((Snapshot)Mockito.doReturn((Object)((double)TimeUnit.MILLISECONDS.toNanos(20L) * 1.0)).when((Object)this.commitSnapshot)).getValue(0.7);
        ((Snapshot)Mockito.doReturn((Object)((double)TimeUnit.MILLISECONDS.toNanos(100L) * 1.0)).when((Object)this.commitSnapshot)).getValue(0.9);
        ((Snapshot)Mockito.doReturn((Object)((double)TimeUnit.MILLISECONDS.toNanos(200L) * 1.0)).when((Object)this.commitSnapshot)).getValue(1.0);
        TransactionRateLimiter rateLimiter = new TransactionRateLimiter(this.actorUtils);
        rateLimiter.acquire();
        MatcherAssert.assertThat((Object)rateLimiter.getTxCreationLimit(), this.approximately(101.0));
        Assert.assertEquals((long)51L, (long)rateLimiter.getPollOnCount());
    }

    @Test
    public void testAcquireGetRateLimitFromOtherDataStores() {
        for (int i = 1; i < 11; ++i) {
            ((Snapshot)Mockito.doReturn((Object)0.0).when((Object)this.commitSnapshot)).getValue((double)i * 0.1);
        }
        Timer operationalCommitTimer = (Timer)Mockito.mock(Timer.class);
        Timer.Context operationalCommitTimerContext = (Timer.Context)Mockito.mock(Timer.Context.class);
        Snapshot operationalCommitSnapshot = (Snapshot)Mockito.mock(Snapshot.class);
        ((ActorUtils)Mockito.doReturn((Object)operationalCommitTimer).when((Object)this.actorUtils)).getOperationTimer("operational", "commit");
        ((Timer)Mockito.doReturn((Object)operationalCommitTimerContext).when((Object)operationalCommitTimer)).time();
        ((Timer)Mockito.doReturn((Object)operationalCommitSnapshot).when((Object)operationalCommitTimer)).getSnapshot();
        for (int i = 1; i < 11; ++i) {
            ((Snapshot)Mockito.doReturn((Object)((double)TimeUnit.MILLISECONDS.toNanos(i) * 1.0)).when((Object)operationalCommitSnapshot)).getValue((double)i * 0.1);
        }
        DatastoreContext.getGlobalDatastoreNames().add("config");
        DatastoreContext.getGlobalDatastoreNames().add("operational");
        TransactionRateLimiter rateLimiter = new TransactionRateLimiter(this.actorUtils);
        rateLimiter.acquire();
        MatcherAssert.assertThat((Object)rateLimiter.getTxCreationLimit(), this.approximately(292.0));
        Assert.assertEquals((long)147L, (long)rateLimiter.getPollOnCount());
    }

    @Test
    public void testRateLimiting() {
        for (int i = 1; i < 11; ++i) {
            ((Snapshot)Mockito.doReturn((Object)((double)TimeUnit.SECONDS.toNanos(1L) * 1.0)).when((Object)this.commitSnapshot)).getValue((double)i * 0.1);
        }
        TransactionRateLimiter rateLimiter = new TransactionRateLimiter(this.actorUtils);
        StopWatch watch = new StopWatch();
        watch.start();
        rateLimiter.acquire();
        rateLimiter.acquire();
        rateLimiter.acquire();
        watch.stop();
        Assert.assertTrue((String)("did not take as much time as expected rate limit : " + rateLimiter.getTxCreationLimit()), (watch.getTime() > 1000L ? 1 : 0) != 0);
    }

    @Test
    public void testRateLimitNotCalculatedUntilPollCountReached() {
        for (int i = 1; i < 11; ++i) {
            ((Snapshot)Mockito.doReturn((Object)((double)TimeUnit.MILLISECONDS.toNanos(8L) * 1.0)).when((Object)this.commitSnapshot)).getValue((double)i * 0.1);
        }
        ((Snapshot)Mockito.doReturn((Object)((double)TimeUnit.MILLISECONDS.toNanos(20L) * 1.0)).when((Object)this.commitSnapshot)).getValue(0.7);
        ((Snapshot)Mockito.doReturn((Object)((double)TimeUnit.MILLISECONDS.toNanos(100L) * 1.0)).when((Object)this.commitSnapshot)).getValue(0.9);
        ((Snapshot)Mockito.doReturn((Object)((double)TimeUnit.MILLISECONDS.toNanos(200L) * 1.0)).when((Object)this.commitSnapshot)).getValue(1.0);
        TransactionRateLimiter rateLimiter = new TransactionRateLimiter(this.actorUtils);
        rateLimiter.acquire();
        MatcherAssert.assertThat((Object)rateLimiter.getTxCreationLimit(), this.approximately(101.0));
        Assert.assertEquals((long)51L, (long)rateLimiter.getPollOnCount());
        for (int i = 0; i < 49; ++i) {
            rateLimiter.acquire();
        }
        ((Timer)Mockito.verify((Object)this.commitTimer, (VerificationMode)Mockito.times((int)1))).getSnapshot();
        rateLimiter.acquire();
        ((Timer)Mockito.verify((Object)this.commitTimer, (VerificationMode)Mockito.times((int)2))).getSnapshot();
    }

    @Test
    public void testAcquireNegativeAcquireAndPollOnCount() {
        for (int i = 1; i < 11; ++i) {
            ((Snapshot)Mockito.doReturn((Object)((double)TimeUnit.MILLISECONDS.toNanos(8L) * 1.0)).when((Object)this.commitSnapshot)).getValue((double)i * 0.1);
        }
        ((Snapshot)Mockito.doReturn((Object)((double)TimeUnit.MILLISECONDS.toNanos(20L) * 1.0)).when((Object)this.commitSnapshot)).getValue(0.7);
        ((Snapshot)Mockito.doReturn((Object)((double)TimeUnit.MILLISECONDS.toNanos(100L) * 1.0)).when((Object)this.commitSnapshot)).getValue(0.9);
        ((Snapshot)Mockito.doReturn((Object)((double)TimeUnit.MILLISECONDS.toNanos(200L) * 1.0)).when((Object)this.commitSnapshot)).getValue(1.0);
        TransactionRateLimiter rateLimiter = new TransactionRateLimiter(this.actorUtils);
        rateLimiter.setAcquireCount(0x7FFFFFFFFFFFFFFEL);
        rateLimiter.setPollOnCount(Long.MAX_VALUE);
        rateLimiter.acquire();
        MatcherAssert.assertThat((Object)rateLimiter.getTxCreationLimit(), this.approximately(101.0));
        Assert.assertEquals((long)-9223372036854775759L, (long)rateLimiter.getPollOnCount());
        for (int i = 0; i < 50; ++i) {
            rateLimiter.acquire();
        }
        ((Timer)Mockito.verify((Object)this.commitTimer, (VerificationMode)Mockito.times((int)2))).getSnapshot();
    }

    public Matcher<Double> approximately(final double val) {
        return new BaseMatcher<Double>(){

            public boolean matches(Object obj) {
                Double value = (Double)obj;
                return value >= val && value <= val + 1.0;
            }

            public void describeTo(Description description) {
                description.appendText("> " + val + " < " + (val + 1.0));
            }
        };
    }
}

