/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.cluster.sharding;

import akka.actor.ActorRef;
import akka.dispatch.Futures;
import akka.util.Timeout;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.opendaylight.controller.cluster.datastore.AbstractActorTest;
import org.opendaylight.controller.cluster.datastore.DatastoreContext;
import org.opendaylight.controller.cluster.datastore.exceptions.LocalShardNotFoundException;
import org.opendaylight.controller.cluster.datastore.utils.ActorUtils;
import org.opendaylight.controller.cluster.dom.api.LeaderLocation;
import org.opendaylight.controller.cluster.dom.api.LeaderLocationListener;
import org.opendaylight.controller.cluster.dom.api.LeaderLocationListenerRegistration;
import org.opendaylight.controller.cluster.raft.LeadershipTransferFailedException;
import org.opendaylight.controller.cluster.sharding.CDSShardAccessImpl;
import org.opendaylight.controller.md.cluster.datastore.model.TestModel;
import org.opendaylight.mdsal.common.api.LogicalDatastoreType;
import org.opendaylight.mdsal.dom.api.DOMDataTreeIdentifier;
import scala.concurrent.Future;
import scala.concurrent.duration.FiniteDuration;

public class CDSShardAccessImplTest
extends AbstractActorTest {
    private static final DOMDataTreeIdentifier TEST_ID = new DOMDataTreeIdentifier(LogicalDatastoreType.CONFIGURATION, TestModel.TEST_PATH);
    private CDSShardAccessImpl shardAccess;
    private ActorUtils context;

    @Before
    public void setUp() {
        this.context = (ActorUtils)Mockito.mock(ActorUtils.class);
        DatastoreContext datastoreContext = DatastoreContext.newBuilder().build();
        ((ActorUtils)Mockito.doReturn(Optional.of(CDSShardAccessImplTest.getSystem().deadLetters())).when((Object)this.context)).findLocalShard((String)ArgumentMatchers.any());
        ((ActorUtils)Mockito.doReturn((Object)datastoreContext).when((Object)this.context)).getDatastoreContext();
        ((ActorUtils)Mockito.doReturn((Object)CDSShardAccessImplTest.getSystem()).when((Object)this.context)).getActorSystem();
        this.shardAccess = new CDSShardAccessImpl(TEST_ID, this.context);
    }

    @Test
    public void testRegisterLeaderLocationListener() {
        LeaderLocationListener listener1 = (LeaderLocationListener)Mockito.mock(LeaderLocationListener.class);
        this.shardAccess.registerLeaderLocationListener(listener1);
        try {
            this.shardAccess.registerLeaderLocationListener(listener1);
            Assert.fail((String)"Should throw exception");
        }
        catch (Exception e) {
            Assert.assertTrue((boolean)(e instanceof IllegalArgumentException));
        }
        try {
            this.shardAccess.registerLeaderLocationListener(null);
            Assert.fail((String)"Should throw exception");
        }
        catch (Exception e) {
            Assert.assertTrue((boolean)(e instanceof NullPointerException));
        }
        LeaderLocationListener listener2 = (LeaderLocationListener)Mockito.mock(LeaderLocationListener.class);
        this.shardAccess.close();
        try {
            this.shardAccess.registerLeaderLocationListener(listener2);
            Assert.fail((String)"Should throw exception");
        }
        catch (Exception ex) {
            Assert.assertTrue((boolean)(ex instanceof IllegalStateException));
        }
    }

    @Test
    public void testOnLeaderLocationChanged() {
        LeaderLocationListener listener1 = (LeaderLocationListener)Mockito.mock(LeaderLocationListener.class);
        ((LeaderLocationListener)Mockito.doThrow((Throwable[])new Throwable[]{new RuntimeException("Failed")}).when((Object)listener1)).onLeaderLocationChanged((LeaderLocation)ArgumentMatchers.any());
        LeaderLocationListener listener2 = (LeaderLocationListener)Mockito.mock(LeaderLocationListener.class);
        ((LeaderLocationListener)Mockito.doNothing().when((Object)listener2)).onLeaderLocationChanged((LeaderLocation)ArgumentMatchers.any());
        LeaderLocationListener listener3 = (LeaderLocationListener)Mockito.mock(LeaderLocationListener.class);
        ((LeaderLocationListener)Mockito.doNothing().when((Object)listener3)).onLeaderLocationChanged((LeaderLocation)ArgumentMatchers.any());
        LeaderLocationListenerRegistration reg1 = this.shardAccess.registerLeaderLocationListener(listener1);
        LeaderLocationListenerRegistration reg2 = this.shardAccess.registerLeaderLocationListener(listener2);
        LeaderLocationListenerRegistration reg3 = this.shardAccess.registerLeaderLocationListener(listener3);
        this.shardAccess.onLeaderLocationChanged(LeaderLocation.LOCAL);
        ((LeaderLocationListener)Mockito.verify((Object)listener1)).onLeaderLocationChanged((LeaderLocation)ArgumentMatchers.eq((Object)LeaderLocation.LOCAL));
        ((LeaderLocationListener)Mockito.verify((Object)listener2)).onLeaderLocationChanged((LeaderLocation)ArgumentMatchers.eq((Object)LeaderLocation.LOCAL));
        ((LeaderLocationListener)Mockito.verify((Object)listener3)).onLeaderLocationChanged((LeaderLocation)ArgumentMatchers.eq((Object)LeaderLocation.LOCAL));
        reg1.close();
        reg2.close();
        this.shardAccess.onLeaderLocationChanged(LeaderLocation.REMOTE);
        ((LeaderLocationListener)Mockito.verify((Object)listener3)).onLeaderLocationChanged((LeaderLocation)ArgumentMatchers.eq((Object)LeaderLocation.REMOTE));
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{listener1});
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{listener2});
        this.shardAccess.close();
        this.shardAccess.onLeaderLocationChanged(LeaderLocation.UNKNOWN);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{listener1});
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{listener2});
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{listener3});
        reg3.close();
    }

    @Test
    public void testGetShardIdentifier() {
        Assert.assertEquals((Object)this.shardAccess.getShardIdentifier(), (Object)TEST_ID);
        this.shardAccess.close();
        try {
            this.shardAccess.getShardIdentifier();
            Assert.fail((String)"Exception expected");
        }
        catch (Exception e) {
            Assert.assertTrue((boolean)(e instanceof IllegalStateException));
        }
    }

    @Test
    public void testGetLeaderLocation() {
        Assert.assertEquals((Object)this.shardAccess.getLeaderLocation(), (Object)LeaderLocation.UNKNOWN);
        this.shardAccess.onLeaderLocationChanged(LeaderLocation.LOCAL);
        Assert.assertEquals((Object)this.shardAccess.getLeaderLocation(), (Object)LeaderLocation.LOCAL);
        this.shardAccess.onLeaderLocationChanged(LeaderLocation.REMOTE);
        this.shardAccess.onLeaderLocationChanged(LeaderLocation.UNKNOWN);
        Assert.assertEquals((Object)this.shardAccess.getLeaderLocation(), (Object)LeaderLocation.UNKNOWN);
        this.shardAccess.close();
        try {
            this.shardAccess.getLeaderLocation();
            Assert.fail((String)"Should have failed with IllegalStateEx");
        }
        catch (Exception e) {
            Assert.assertTrue((boolean)(e instanceof IllegalStateException));
        }
    }

    @Test
    public void testMakeLeaderLocal() throws Exception {
        FiniteDuration timeout = new FiniteDuration(5L, TimeUnit.SECONDS);
        ActorRef localShardRef = (ActorRef)Mockito.mock(ActorRef.class);
        Future localShardRefFuture = Futures.successful((Object)localShardRef);
        ((ActorUtils)Mockito.doReturn((Object)localShardRefFuture).when((Object)this.context)).findLocalShardAsync((String)ArgumentMatchers.any());
        ((ActorUtils)Mockito.doReturn((Object)Futures.successful(null)).when((Object)this.context)).executeOperationAsync((ActorRef)ArgumentMatchers.any(), ArgumentMatchers.any(), (Timeout)ArgumentMatchers.any());
        ((ActorUtils)Mockito.doReturn((Object)CDSShardAccessImplTest.getSystem().dispatcher()).when((Object)this.context)).getClientDispatcher();
        Assert.assertEquals(CDSShardAccessImplTest.waitOnAsyncTask(this.shardAccess.makeLeaderLocal(), timeout), null);
        ((ActorUtils)Mockito.doReturn((Object)Futures.failed((Throwable)new LeadershipTransferFailedException("Failure"))).when((Object)this.context)).executeOperationAsync((ActorRef)ArgumentMatchers.any(), ArgumentMatchers.any(), (Timeout)ArgumentMatchers.any());
        try {
            CDSShardAccessImplTest.waitOnAsyncTask(this.shardAccess.makeLeaderLocal(), timeout);
            Assert.fail((String)"makeLeaderLocal operation should not be successful");
        }
        catch (Exception e) {
            Assert.assertTrue((boolean)(e instanceof LeadershipTransferFailedException));
        }
        ((ActorUtils)Mockito.doReturn((Object)Futures.failed((Throwable)new LocalShardNotFoundException("Local shard not found"))).when((Object)this.context)).findLocalShardAsync((String)ArgumentMatchers.any());
        try {
            CDSShardAccessImplTest.waitOnAsyncTask(this.shardAccess.makeLeaderLocal(), timeout);
            Assert.fail((String)"makeLeaderLocal operation should not be successful");
        }
        catch (Exception e) {
            Assert.assertTrue((boolean)(e instanceof LeadershipTransferFailedException));
            Assert.assertTrue((boolean)(e.getCause() instanceof LocalShardNotFoundException));
        }
        this.shardAccess.close();
        try {
            this.shardAccess.makeLeaderLocal();
            Assert.fail((String)"Should have thrown IllegalStateEx. ShardAccess is closed");
        }
        catch (Exception e) {
            Assert.assertTrue((boolean)(e instanceof IllegalStateException));
        }
    }
}

