/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.cluster.sharding;

import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import java.util.Collections;
import java.util.List;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.ArgumentCaptor;
import org.mockito.ArgumentMatchers;
import org.mockito.Captor;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;
import org.mockito.verification.VerificationMode;
import org.opendaylight.controller.cluster.databroker.actors.dds.ClientLocalHistory;
import org.opendaylight.controller.cluster.databroker.actors.dds.ClientTransaction;
import org.opendaylight.controller.cluster.databroker.actors.dds.DataStoreClient;
import org.opendaylight.controller.cluster.datastore.DistributedDataStore;
import org.opendaylight.controller.cluster.datastore.DistributedDataStoreInterface;
import org.opendaylight.controller.cluster.datastore.utils.ActorUtils;
import org.opendaylight.controller.cluster.sharding.DistributedShardFrontend;
import org.opendaylight.controller.md.cluster.datastore.model.SchemaContextHelper;
import org.opendaylight.controller.md.cluster.datastore.model.TestModel;
import org.opendaylight.mdsal.common.api.LogicalDatastoreType;
import org.opendaylight.mdsal.dom.api.DOMDataTreeCursorAwareTransaction;
import org.opendaylight.mdsal.dom.api.DOMDataTreeIdentifier;
import org.opendaylight.mdsal.dom.api.DOMDataTreeProducer;
import org.opendaylight.mdsal.dom.api.DOMDataTreeShard;
import org.opendaylight.mdsal.dom.api.DOMDataTreeWriteCursor;
import org.opendaylight.mdsal.dom.broker.ShardedDOMDataTree;
import org.opendaylight.mdsal.dom.spi.store.DOMStoreThreePhaseCommitCohort;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;
import org.opendaylight.yangtools.yang.data.api.schema.ContainerNode;
import org.opendaylight.yangtools.yang.data.api.schema.DataContainerChild;
import org.opendaylight.yangtools.yang.data.api.schema.MapEntryNode;
import org.opendaylight.yangtools.yang.data.api.schema.MapNode;
import org.opendaylight.yangtools.yang.data.api.schema.NormalizedNode;
import org.opendaylight.yangtools.yang.data.impl.schema.ImmutableNodes;
import org.opendaylight.yangtools.yang.data.impl.schema.builder.impl.ImmutableContainerNodeBuilder;

public class DistributedShardFrontendTest {
    private static final DOMDataTreeIdentifier ROOT = new DOMDataTreeIdentifier(LogicalDatastoreType.CONFIGURATION, YangInstanceIdentifier.empty());
    private static final ListenableFuture<Object> SUCCESS_FUTURE = Futures.immediateFuture(null);
    private ShardedDOMDataTree shardedDOMDataTree;
    private DataStoreClient client;
    private ClientLocalHistory clientHistory;
    private ClientTransaction clientTransaction;
    private DOMDataTreeWriteCursor cursor;
    private static final YangInstanceIdentifier OUTER_LIST_YID = TestModel.OUTER_LIST_PATH.node((YangInstanceIdentifier.PathArgument)YangInstanceIdentifier.NodeIdentifierWithPredicates.of((QName)TestModel.OUTER_LIST_QNAME, (QName)TestModel.ID_QNAME, (Object)1));
    private static final DOMDataTreeIdentifier OUTER_LIST_ID = new DOMDataTreeIdentifier(LogicalDatastoreType.CONFIGURATION, OUTER_LIST_YID);
    @Captor
    private ArgumentCaptor<YangInstanceIdentifier.PathArgument> pathArgumentCaptor;
    @Captor
    private ArgumentCaptor<NormalizedNode<?, ?>> nodeCaptor;
    private DOMStoreThreePhaseCommitCohort commitCohort;

    @Before
    public void setUp() {
        MockitoAnnotations.initMocks((Object)this);
        this.shardedDOMDataTree = new ShardedDOMDataTree();
        this.client = (DataStoreClient)Mockito.mock(DataStoreClient.class);
        this.cursor = (DOMDataTreeWriteCursor)Mockito.mock(DOMDataTreeWriteCursor.class);
        this.clientTransaction = (ClientTransaction)Mockito.mock(ClientTransaction.class);
        this.clientHistory = (ClientLocalHistory)Mockito.mock(ClientLocalHistory.class);
        this.commitCohort = (DOMStoreThreePhaseCommitCohort)Mockito.mock(DOMStoreThreePhaseCommitCohort.class);
        ((DOMStoreThreePhaseCommitCohort)Mockito.doReturn(SUCCESS_FUTURE).when((Object)this.commitCohort)).canCommit();
        ((DOMStoreThreePhaseCommitCohort)Mockito.doReturn(SUCCESS_FUTURE).when((Object)this.commitCohort)).preCommit();
        ((DOMStoreThreePhaseCommitCohort)Mockito.doReturn(SUCCESS_FUTURE).when((Object)this.commitCohort)).commit();
        ((DOMStoreThreePhaseCommitCohort)Mockito.doReturn(SUCCESS_FUTURE).when((Object)this.commitCohort)).abort();
        ((DataStoreClient)Mockito.doReturn((Object)this.clientTransaction).when((Object)this.client)).createTransaction();
        ((ClientLocalHistory)Mockito.doReturn((Object)this.clientTransaction).when((Object)this.clientHistory)).createTransaction();
        ((ClientLocalHistory)Mockito.doNothing().when((Object)this.clientHistory)).close();
        ((DataStoreClient)Mockito.doNothing().when((Object)this.client)).close();
        ((DataStoreClient)Mockito.doReturn((Object)this.clientHistory).when((Object)this.client)).createLocalHistory();
        ((ClientTransaction)Mockito.doReturn((Object)this.cursor).when((Object)this.clientTransaction)).openCursor();
        ((DOMDataTreeWriteCursor)Mockito.doNothing().when((Object)this.cursor)).close();
        ((DOMDataTreeWriteCursor)Mockito.doNothing().when((Object)this.cursor)).write((YangInstanceIdentifier.PathArgument)ArgumentMatchers.any(), (NormalizedNode)ArgumentMatchers.any());
        ((DOMDataTreeWriteCursor)Mockito.doNothing().when((Object)this.cursor)).merge((YangInstanceIdentifier.PathArgument)ArgumentMatchers.any(), (NormalizedNode)ArgumentMatchers.any());
        ((DOMDataTreeWriteCursor)Mockito.doNothing().when((Object)this.cursor)).delete((YangInstanceIdentifier.PathArgument)ArgumentMatchers.any());
        ((ClientTransaction)Mockito.doReturn((Object)this.commitCohort).when((Object)this.clientTransaction)).ready();
    }

    @Test
    public void testClientTransaction() throws Exception {
        DistributedDataStore distributedDataStore = (DistributedDataStore)Mockito.mock(DistributedDataStore.class);
        ActorUtils context = (ActorUtils)Mockito.mock(ActorUtils.class);
        ((DistributedDataStore)Mockito.doReturn((Object)context).when((Object)distributedDataStore)).getActorUtils();
        ((ActorUtils)Mockito.doReturn((Object)SchemaContextHelper.full()).when((Object)context)).getSchemaContext();
        DistributedShardFrontend rootShard = new DistributedShardFrontend((DistributedDataStoreInterface)distributedDataStore, this.client, ROOT);
        try (DOMDataTreeProducer producer = this.shardedDOMDataTree.createProducer(Collections.singletonList(ROOT));){
            this.shardedDOMDataTree.registerDataTreeShard(ROOT, (DOMDataTreeShard)rootShard, producer);
        }
        DataStoreClient outerListClient = (DataStoreClient)Mockito.mock(DataStoreClient.class);
        ClientTransaction outerListClientTransaction = (ClientTransaction)Mockito.mock(ClientTransaction.class);
        ClientLocalHistory outerListClientHistory = (ClientLocalHistory)Mockito.mock(ClientLocalHistory.class);
        DOMDataTreeWriteCursor outerListCursor = (DOMDataTreeWriteCursor)Mockito.mock(DOMDataTreeWriteCursor.class);
        ((DOMDataTreeWriteCursor)Mockito.doNothing().when((Object)outerListCursor)).close();
        ((DOMDataTreeWriteCursor)Mockito.doNothing().when((Object)outerListCursor)).write((YangInstanceIdentifier.PathArgument)ArgumentMatchers.any(), (NormalizedNode)ArgumentMatchers.any());
        ((DOMDataTreeWriteCursor)Mockito.doNothing().when((Object)outerListCursor)).merge((YangInstanceIdentifier.PathArgument)ArgumentMatchers.any(), (NormalizedNode)ArgumentMatchers.any());
        ((DOMDataTreeWriteCursor)Mockito.doNothing().when((Object)outerListCursor)).delete((YangInstanceIdentifier.PathArgument)ArgumentMatchers.any());
        ((ClientTransaction)Mockito.doReturn((Object)outerListCursor).when((Object)outerListClientTransaction)).openCursor();
        ((DataStoreClient)Mockito.doReturn((Object)outerListClientTransaction).when((Object)outerListClient)).createTransaction();
        ((DataStoreClient)Mockito.doReturn((Object)outerListClientHistory).when((Object)outerListClient)).createLocalHistory();
        ((ClientLocalHistory)Mockito.doReturn((Object)outerListClientTransaction).when((Object)outerListClientHistory)).createTransaction();
        ((ClientTransaction)Mockito.doReturn((Object)this.commitCohort).when((Object)outerListClientTransaction)).ready();
        ((ClientLocalHistory)Mockito.doNothing().when((Object)outerListClientHistory)).close();
        ((DataStoreClient)Mockito.doNothing().when((Object)outerListClient)).close();
        DistributedShardFrontend outerListShard = new DistributedShardFrontend((DistributedDataStoreInterface)distributedDataStore, outerListClient, OUTER_LIST_ID);
        try (DOMDataTreeProducer producer = this.shardedDOMDataTree.createProducer(Collections.singletonList(OUTER_LIST_ID));){
            this.shardedDOMDataTree.registerDataTreeShard(OUTER_LIST_ID, (DOMDataTreeShard)outerListShard, producer);
        }
        producer = this.shardedDOMDataTree.createProducer(Collections.singletonList(ROOT));
        DOMDataTreeCursorAwareTransaction tx = producer.createTransaction(false);
        DOMDataTreeWriteCursor txCursor = tx.createCursor(ROOT);
        Assert.assertNotNull((Object)txCursor);
        txCursor.write(TestModel.TEST_PATH.getLastPathArgument(), (NormalizedNode)DistributedShardFrontendTest.createCrossShardContainer());
        ((DOMDataTreeWriteCursor)Mockito.verify((Object)outerListCursor, (VerificationMode)Mockito.times((int)2))).write((YangInstanceIdentifier.PathArgument)this.pathArgumentCaptor.capture(), (NormalizedNode)this.nodeCaptor.capture());
        List capturedArgs = this.pathArgumentCaptor.getAllValues();
        Assert.assertEquals((long)2L, (long)capturedArgs.size());
        MatcherAssert.assertThat((Object)capturedArgs, (Matcher)CoreMatchers.hasItems((Object[])new YangInstanceIdentifier.PathArgument[]{new YangInstanceIdentifier.NodeIdentifier(TestModel.ID_QNAME), new YangInstanceIdentifier.NodeIdentifier(TestModel.INNER_LIST_QNAME)}));
        List capturedValues = this.nodeCaptor.getAllValues();
        Assert.assertEquals((long)2L, (long)capturedValues.size());
        MatcherAssert.assertThat((Object)capturedValues, (Matcher)CoreMatchers.hasItems((Object[])new NormalizedNode[]{ImmutableNodes.leafNode((QName)TestModel.ID_QNAME, (Object)1), DistributedShardFrontendTest.createInnerMapNode(1)}));
        txCursor.close();
        tx.commit().get();
        ((DOMStoreThreePhaseCommitCohort)Mockito.verify((Object)this.commitCohort, (VerificationMode)Mockito.times((int)2))).canCommit();
        ((DOMStoreThreePhaseCommitCohort)Mockito.verify((Object)this.commitCohort, (VerificationMode)Mockito.times((int)2))).preCommit();
        ((DOMStoreThreePhaseCommitCohort)Mockito.verify((Object)this.commitCohort, (VerificationMode)Mockito.times((int)2))).commit();
    }

    private static MapNode createInnerMapNode(int id) {
        MapEntryNode listEntry = (MapEntryNode)ImmutableNodes.mapEntryBuilder((QName)TestModel.INNER_LIST_QNAME, (QName)TestModel.NAME_QNAME, (Object)("name-" + id)).withChild((DataContainerChild)ImmutableNodes.leafNode((QName)TestModel.NAME_QNAME, (Object)("name-" + id))).withChild((DataContainerChild)ImmutableNodes.leafNode((QName)TestModel.VALUE_QNAME, (Object)("value-" + id))).build();
        return (MapNode)ImmutableNodes.mapNodeBuilder((QName)TestModel.INNER_LIST_QNAME).withChild((NormalizedNode)listEntry).build();
    }

    private static ContainerNode createCrossShardContainer() {
        MapEntryNode outerListEntry1 = (MapEntryNode)ImmutableNodes.mapEntryBuilder((QName)TestModel.OUTER_LIST_QNAME, (QName)TestModel.ID_QNAME, (Object)1).withChild((DataContainerChild)DistributedShardFrontendTest.createInnerMapNode(1)).build();
        MapEntryNode outerListEntry2 = (MapEntryNode)ImmutableNodes.mapEntryBuilder((QName)TestModel.OUTER_LIST_QNAME, (QName)TestModel.ID_QNAME, (Object)2).withChild((DataContainerChild)DistributedShardFrontendTest.createInnerMapNode(2)).build();
        MapNode outerList = (MapNode)ImmutableNodes.mapNodeBuilder((QName)TestModel.OUTER_LIST_QNAME).withChild((NormalizedNode)outerListEntry1).withChild((NormalizedNode)outerListEntry2).build();
        ContainerNode testContainer = (ContainerNode)ImmutableContainerNodeBuilder.create().withNodeIdentifier((YangInstanceIdentifier.PathArgument)new YangInstanceIdentifier.NodeIdentifier(TestModel.TEST_QNAME)).withChild((DataContainerChild)outerList).build();
        return testContainer;
    }
}

