/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.cluster.sharding;

import akka.actor.ActorRef;
import akka.actor.ActorSystem;
import akka.actor.Address;
import akka.actor.AddressFromURIString;
import akka.cluster.Cluster;
import akka.testkit.javadsl.TestKit;
import com.google.common.collect.Lists;
import com.typesafe.config.Config;
import com.typesafe.config.ConfigFactory;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import org.opendaylight.controller.cluster.ActorSystemProvider;
import org.opendaylight.controller.cluster.access.concepts.MemberName;
import org.opendaylight.controller.cluster.datastore.AbstractDataStore;
import org.opendaylight.controller.cluster.datastore.AbstractTest;
import org.opendaylight.controller.cluster.datastore.DatastoreContext;
import org.opendaylight.controller.cluster.datastore.DistributedDataStore;
import org.opendaylight.controller.cluster.datastore.DistributedDataStoreInterface;
import org.opendaylight.controller.cluster.datastore.IntegrationTestKit;
import org.opendaylight.controller.cluster.datastore.utils.ClusterUtils;
import org.opendaylight.controller.cluster.raft.utils.InMemoryJournal;
import org.opendaylight.controller.cluster.raft.utils.InMemorySnapshotStore;
import org.opendaylight.controller.cluster.sharding.DistributedShardRegistration;
import org.opendaylight.controller.cluster.sharding.DistributedShardedDOMDataTree;
import org.opendaylight.controller.md.cluster.datastore.model.SchemaContextHelper;
import org.opendaylight.controller.md.cluster.datastore.model.TestModel;
import org.opendaylight.mdsal.common.api.LogicalDatastoreType;
import org.opendaylight.mdsal.dom.api.DOMDataTreeCursorAwareTransaction;
import org.opendaylight.mdsal.dom.api.DOMDataTreeIdentifier;
import org.opendaylight.mdsal.dom.api.DOMDataTreeProducer;
import org.opendaylight.mdsal.dom.api.DOMDataTreeShardingConflictException;
import org.opendaylight.mdsal.dom.api.DOMDataTreeWriteCursor;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;
import org.opendaylight.yangtools.yang.data.impl.schema.builder.impl.ImmutableLeafNodeBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DistributedShardedDOMDataTreeRemotingTest
extends AbstractTest {
    private static final Logger LOG = LoggerFactory.getLogger(DistributedShardedDOMDataTreeRemotingTest.class);
    private static final Address MEMBER_1_ADDRESS = AddressFromURIString.parse((String)"akka://cluster-test@127.0.0.1:2558");
    private static final DOMDataTreeIdentifier TEST_ID = new DOMDataTreeIdentifier(LogicalDatastoreType.CONFIGURATION, TestModel.TEST_PATH);
    private static final String MODULE_SHARDS_CONFIG = "module-shards-default.conf";
    private ActorSystem leaderSystem;
    private ActorSystem followerSystem;
    private final DatastoreContext.Builder leaderDatastoreContextBuilder = DatastoreContext.newBuilder().shardHeartbeatIntervalInMillis(100).shardElectionTimeoutFactor(5L);
    private final DatastoreContext.Builder followerDatastoreContextBuilder = DatastoreContext.newBuilder().shardHeartbeatIntervalInMillis(100).shardElectionTimeoutFactor(5L);
    private DistributedDataStore leaderConfigDatastore;
    private DistributedDataStore leaderOperDatastore;
    private DistributedDataStore followerConfigDatastore;
    private DistributedDataStore followerOperDatastore;
    private IntegrationTestKit followerTestKit;
    private IntegrationTestKit leaderTestKit;
    private DistributedShardedDOMDataTree leaderShardFactory;
    private DistributedShardedDOMDataTree followerShardFactory;
    private ActorSystemProvider leaderSystemProvider;
    private ActorSystemProvider followerSystemProvider;

    @Before
    public void setUp() {
        InMemoryJournal.clear();
        InMemorySnapshotStore.clear();
        this.leaderSystem = ActorSystem.create((String)"cluster-test", (Config)ConfigFactory.load().getConfig("Member1"));
        Cluster.get((ActorSystem)this.leaderSystem).join(MEMBER_1_ADDRESS);
        this.followerSystem = ActorSystem.create((String)"cluster-test", (Config)ConfigFactory.load().getConfig("Member2"));
        Cluster.get((ActorSystem)this.followerSystem).join(MEMBER_1_ADDRESS);
        this.leaderSystemProvider = (ActorSystemProvider)Mockito.mock(ActorSystemProvider.class);
        ((ActorSystemProvider)Mockito.doReturn((Object)this.leaderSystem).when((Object)this.leaderSystemProvider)).getActorSystem();
        this.followerSystemProvider = (ActorSystemProvider)Mockito.mock(ActorSystemProvider.class);
        ((ActorSystemProvider)Mockito.doReturn((Object)this.followerSystem).when((Object)this.followerSystemProvider)).getActorSystem();
    }

    @After
    public void tearDown() {
        if (this.leaderConfigDatastore != null) {
            this.leaderConfigDatastore.close();
        }
        if (this.leaderOperDatastore != null) {
            this.leaderOperDatastore.close();
        }
        if (this.followerConfigDatastore != null) {
            this.followerConfigDatastore.close();
        }
        if (this.followerOperDatastore != null) {
            this.followerOperDatastore.close();
        }
        TestKit.shutdownActorSystem((ActorSystem)this.leaderSystem, (boolean)true);
        TestKit.shutdownActorSystem((ActorSystem)this.followerSystem, (boolean)true);
        InMemoryJournal.clear();
        InMemorySnapshotStore.clear();
    }

    private void initEmptyDatastores() throws Exception {
        this.initEmptyDatastores(MODULE_SHARDS_CONFIG);
    }

    private void initEmptyDatastores(String moduleShardsConfig) throws Exception {
        this.leaderTestKit = new IntegrationTestKit(this.leaderSystem, this.leaderDatastoreContextBuilder);
        this.leaderConfigDatastore = this.leaderTestKit.setupDistributedDataStore("config", moduleShardsConfig, true, SchemaContextHelper.distributedShardedDOMDataTreeSchemaContext());
        this.leaderOperDatastore = this.leaderTestKit.setupDistributedDataStore("operational", moduleShardsConfig, true, SchemaContextHelper.distributedShardedDOMDataTreeSchemaContext());
        this.leaderShardFactory = new DistributedShardedDOMDataTree(this.leaderSystemProvider, (DistributedDataStoreInterface)this.leaderOperDatastore, (DistributedDataStoreInterface)this.leaderConfigDatastore);
        this.followerTestKit = new IntegrationTestKit(this.followerSystem, this.followerDatastoreContextBuilder);
        this.followerConfigDatastore = this.followerTestKit.setupDistributedDataStore("config", moduleShardsConfig, true, SchemaContextHelper.distributedShardedDOMDataTreeSchemaContext());
        this.followerOperDatastore = this.followerTestKit.setupDistributedDataStore("operational", moduleShardsConfig, true, SchemaContextHelper.distributedShardedDOMDataTreeSchemaContext());
        this.followerShardFactory = new DistributedShardedDOMDataTree(this.followerSystemProvider, (DistributedDataStoreInterface)this.followerOperDatastore, (DistributedDataStoreInterface)this.followerConfigDatastore);
        this.followerTestKit.waitForMembersUp("member-1");
        LOG.info("Initializing leader DistributedShardedDOMDataTree");
        this.leaderShardFactory.init();
        this.leaderTestKit.waitUntilLeader(this.leaderConfigDatastore.getActorUtils(), ClusterUtils.getCleanShardName((YangInstanceIdentifier)YangInstanceIdentifier.empty()));
        this.leaderTestKit.waitUntilLeader(this.leaderOperDatastore.getActorUtils(), ClusterUtils.getCleanShardName((YangInstanceIdentifier)YangInstanceIdentifier.empty()));
        LOG.info("Initializing follower DistributedShardedDOMDataTree");
        this.followerShardFactory.init();
    }

    @Test
    public void testProducerRegistrations() throws Exception {
        LOG.info("testProducerRegistrations starting");
        this.initEmptyDatastores();
        this.leaderTestKit.waitForMembersUp("member-2");
        DistributedShardRegistration shardRegistration = (DistributedShardRegistration)DistributedShardedDOMDataTreeRemotingTest.waitOnAsyncTask(this.leaderShardFactory.createDistributedShard(TEST_ID, (Collection)Lists.newArrayList((Object[])new MemberName[]{AbstractTest.MEMBER_NAME, AbstractTest.MEMBER_2_NAME})), DistributedShardedDOMDataTree.SHARD_FUTURE_TIMEOUT_DURATION);
        this.leaderTestKit.waitUntilLeader(this.leaderConfigDatastore.getActorUtils(), ClusterUtils.getCleanShardName((YangInstanceIdentifier)TEST_ID.getRootIdentifier()));
        ActorRef leaderShardManager = this.leaderConfigDatastore.getActorUtils().getShardManager();
        Assert.assertNotNull((Object)IntegrationTestKit.findLocalShard(this.leaderConfigDatastore.getActorUtils(), ClusterUtils.getCleanShardName((YangInstanceIdentifier)TEST_ID.getRootIdentifier())));
        Assert.assertNotNull((Object)IntegrationTestKit.findLocalShard(this.followerConfigDatastore.getActorUtils(), ClusterUtils.getCleanShardName((YangInstanceIdentifier)TEST_ID.getRootIdentifier())));
        HashSet peers = new HashSet();
        IntegrationTestKit.verifyShardState((AbstractDataStore)this.leaderConfigDatastore, ClusterUtils.getCleanShardName((YangInstanceIdentifier)TEST_ID.getRootIdentifier()), onDemandShardState -> peers.addAll(onDemandShardState.getPeerAddresses().values()));
        Assert.assertEquals((long)peers.size(), (long)1L);
        DOMDataTreeProducer producer = this.leaderShardFactory.createProducer(Collections.singleton(TEST_ID));
        try {
            this.followerShardFactory.createProducer(Collections.singleton(TEST_ID));
            Assert.fail((String)"Producer should be already registered on the other node");
        }
        catch (IllegalArgumentException e) {
            Assert.assertTrue((boolean)e.getMessage().contains("is attached to producer"));
        }
        producer.close();
        DOMDataTreeProducer followerProducer = this.followerShardFactory.createProducer(Collections.singleton(TEST_ID));
        try {
            this.leaderShardFactory.createProducer(Collections.singleton(TEST_ID));
            Assert.fail((String)"Producer should be already registered on the other node");
        }
        catch (IllegalArgumentException e) {
            Assert.assertTrue((boolean)e.getMessage().contains("is attached to producer"));
        }
        followerProducer.close();
        try {
            DistributedShardedDOMDataTreeRemotingTest.waitOnAsyncTask(this.followerShardFactory.createDistributedShard(TEST_ID, (Collection)Lists.newArrayList((Object[])new MemberName[]{AbstractTest.MEMBER_NAME, AbstractTest.MEMBER_2_NAME})), DistributedShardedDOMDataTree.SHARD_FUTURE_TIMEOUT_DURATION);
            Assert.fail((String)"This prefix already should have a shard registration that was forwarded from the other node");
        }
        catch (DOMDataTreeShardingConflictException e) {
            Assert.assertTrue((boolean)e.getMessage().contains("is already occupied by another shard"));
        }
        shardRegistration.close().toCompletableFuture().get();
        LOG.info("testProducerRegistrations ending");
    }

    @Test
    public void testWriteIntoMultipleShards() throws Exception {
        LOG.info("testWriteIntoMultipleShards starting");
        this.initEmptyDatastores();
        this.leaderTestKit.waitForMembersUp("member-2");
        LOG.debug("registering first shard");
        DistributedShardRegistration shardRegistration = (DistributedShardRegistration)DistributedShardedDOMDataTreeRemotingTest.waitOnAsyncTask(this.leaderShardFactory.createDistributedShard(TEST_ID, (Collection)Lists.newArrayList((Object[])new MemberName[]{AbstractTest.MEMBER_NAME, AbstractTest.MEMBER_2_NAME})), DistributedShardedDOMDataTree.SHARD_FUTURE_TIMEOUT_DURATION);
        this.leaderTestKit.waitUntilLeader(this.leaderConfigDatastore.getActorUtils(), ClusterUtils.getCleanShardName((YangInstanceIdentifier)TEST_ID.getRootIdentifier()));
        IntegrationTestKit.findLocalShard(this.followerConfigDatastore.getActorUtils(), ClusterUtils.getCleanShardName((YangInstanceIdentifier)TEST_ID.getRootIdentifier()));
        HashSet peers = new HashSet();
        IntegrationTestKit.verifyShardState((AbstractDataStore)this.leaderConfigDatastore, ClusterUtils.getCleanShardName((YangInstanceIdentifier)TEST_ID.getRootIdentifier()), onDemandShardState -> peers.addAll(onDemandShardState.getPeerAddresses().values()));
        Assert.assertEquals((long)peers.size(), (long)1L);
        LOG.debug("Got after waiting for nonleader");
        DOMDataTreeProducer producer = this.leaderShardFactory.createProducer(Collections.singleton(TEST_ID));
        DOMDataTreeCursorAwareTransaction tx = producer.createTransaction(true);
        DOMDataTreeWriteCursor cursor = tx.createCursor(TEST_ID);
        Assert.assertNotNull((Object)cursor);
        YangInstanceIdentifier nameId = YangInstanceIdentifier.builder((YangInstanceIdentifier)TestModel.TEST_PATH).node(TestModel.NAME_QNAME).build();
        cursor.write(nameId.getLastPathArgument(), ImmutableLeafNodeBuilder.create().withNodeIdentifier((YangInstanceIdentifier.PathArgument)new YangInstanceIdentifier.NodeIdentifier(TestModel.NAME_QNAME)).withValue((Object)"Test Value").build());
        cursor.close();
        LOG.warn("Got to pre submit");
        tx.commit().get();
        shardRegistration.close().toCompletableFuture().get();
        LOG.info("testWriteIntoMultipleShards ending");
    }

    @Test
    public void testMultipleShardRegistrations() throws Exception {
        LOG.info("testMultipleShardRegistrations starting");
        this.initEmptyDatastores();
        DistributedShardRegistration reg1 = (DistributedShardRegistration)DistributedShardedDOMDataTreeRemotingTest.waitOnAsyncTask(this.leaderShardFactory.createDistributedShard(TEST_ID, (Collection)Lists.newArrayList((Object[])new MemberName[]{AbstractTest.MEMBER_NAME, AbstractTest.MEMBER_2_NAME})), DistributedShardedDOMDataTree.SHARD_FUTURE_TIMEOUT_DURATION);
        DistributedShardRegistration reg2 = (DistributedShardRegistration)DistributedShardedDOMDataTreeRemotingTest.waitOnAsyncTask(this.leaderShardFactory.createDistributedShard(new DOMDataTreeIdentifier(LogicalDatastoreType.CONFIGURATION, TestModel.OUTER_CONTAINER_PATH), (Collection)Lists.newArrayList((Object[])new MemberName[]{AbstractTest.MEMBER_NAME, AbstractTest.MEMBER_2_NAME})), DistributedShardedDOMDataTree.SHARD_FUTURE_TIMEOUT_DURATION);
        DistributedShardRegistration reg3 = (DistributedShardRegistration)DistributedShardedDOMDataTreeRemotingTest.waitOnAsyncTask(this.leaderShardFactory.createDistributedShard(new DOMDataTreeIdentifier(LogicalDatastoreType.CONFIGURATION, TestModel.INNER_LIST_PATH), (Collection)Lists.newArrayList((Object[])new MemberName[]{AbstractTest.MEMBER_NAME, AbstractTest.MEMBER_2_NAME})), DistributedShardedDOMDataTree.SHARD_FUTURE_TIMEOUT_DURATION);
        DistributedShardRegistration reg4 = (DistributedShardRegistration)DistributedShardedDOMDataTreeRemotingTest.waitOnAsyncTask(this.leaderShardFactory.createDistributedShard(new DOMDataTreeIdentifier(LogicalDatastoreType.CONFIGURATION, TestModel.JUNK_PATH), (Collection)Lists.newArrayList((Object[])new MemberName[]{AbstractTest.MEMBER_NAME, AbstractTest.MEMBER_2_NAME})), DistributedShardedDOMDataTree.SHARD_FUTURE_TIMEOUT_DURATION);
        this.leaderTestKit.waitUntilLeader(this.leaderConfigDatastore.getActorUtils(), ClusterUtils.getCleanShardName((YangInstanceIdentifier)TestModel.TEST_PATH));
        this.leaderTestKit.waitUntilLeader(this.leaderConfigDatastore.getActorUtils(), ClusterUtils.getCleanShardName((YangInstanceIdentifier)TestModel.OUTER_CONTAINER_PATH));
        this.leaderTestKit.waitUntilLeader(this.leaderConfigDatastore.getActorUtils(), ClusterUtils.getCleanShardName((YangInstanceIdentifier)TestModel.INNER_LIST_PATH));
        this.leaderTestKit.waitUntilLeader(this.leaderConfigDatastore.getActorUtils(), ClusterUtils.getCleanShardName((YangInstanceIdentifier)TestModel.JUNK_PATH));
        Assert.assertNotNull((Object)IntegrationTestKit.findLocalShard(this.leaderConfigDatastore.getActorUtils(), ClusterUtils.getCleanShardName((YangInstanceIdentifier)TestModel.TEST_PATH)));
        Assert.assertNotNull((Object)IntegrationTestKit.findLocalShard(this.leaderConfigDatastore.getActorUtils(), ClusterUtils.getCleanShardName((YangInstanceIdentifier)TestModel.OUTER_CONTAINER_PATH)));
        Assert.assertNotNull((Object)IntegrationTestKit.findLocalShard(this.leaderConfigDatastore.getActorUtils(), ClusterUtils.getCleanShardName((YangInstanceIdentifier)TestModel.INNER_LIST_PATH)));
        Assert.assertNotNull((Object)IntegrationTestKit.findLocalShard(this.leaderConfigDatastore.getActorUtils(), ClusterUtils.getCleanShardName((YangInstanceIdentifier)TestModel.JUNK_PATH)));
        Assert.assertNotNull((Object)IntegrationTestKit.findLocalShard(this.followerConfigDatastore.getActorUtils(), ClusterUtils.getCleanShardName((YangInstanceIdentifier)TestModel.TEST_PATH)));
        Assert.assertNotNull((Object)IntegrationTestKit.findLocalShard(this.followerConfigDatastore.getActorUtils(), ClusterUtils.getCleanShardName((YangInstanceIdentifier)TestModel.OUTER_CONTAINER_PATH)));
        Assert.assertNotNull((Object)IntegrationTestKit.findLocalShard(this.followerConfigDatastore.getActorUtils(), ClusterUtils.getCleanShardName((YangInstanceIdentifier)TestModel.INNER_LIST_PATH)));
        Assert.assertNotNull((Object)IntegrationTestKit.findLocalShard(this.followerConfigDatastore.getActorUtils(), ClusterUtils.getCleanShardName((YangInstanceIdentifier)TestModel.JUNK_PATH)));
        LOG.debug("Closing registrations");
        reg1.close().toCompletableFuture().get();
        reg2.close().toCompletableFuture().get();
        reg3.close().toCompletableFuture().get();
        reg4.close().toCompletableFuture().get();
        IntegrationTestKit.waitUntilShardIsDown(this.leaderConfigDatastore.getActorUtils(), ClusterUtils.getCleanShardName((YangInstanceIdentifier)TestModel.TEST_PATH));
        IntegrationTestKit.waitUntilShardIsDown(this.leaderConfigDatastore.getActorUtils(), ClusterUtils.getCleanShardName((YangInstanceIdentifier)TestModel.OUTER_CONTAINER_PATH));
        IntegrationTestKit.waitUntilShardIsDown(this.leaderConfigDatastore.getActorUtils(), ClusterUtils.getCleanShardName((YangInstanceIdentifier)TestModel.INNER_LIST_PATH));
        IntegrationTestKit.waitUntilShardIsDown(this.leaderConfigDatastore.getActorUtils(), ClusterUtils.getCleanShardName((YangInstanceIdentifier)TestModel.JUNK_PATH));
        LOG.debug("All leader shards gone");
        IntegrationTestKit.waitUntilShardIsDown(this.followerConfigDatastore.getActorUtils(), ClusterUtils.getCleanShardName((YangInstanceIdentifier)TestModel.TEST_PATH));
        IntegrationTestKit.waitUntilShardIsDown(this.followerConfigDatastore.getActorUtils(), ClusterUtils.getCleanShardName((YangInstanceIdentifier)TestModel.OUTER_CONTAINER_PATH));
        IntegrationTestKit.waitUntilShardIsDown(this.followerConfigDatastore.getActorUtils(), ClusterUtils.getCleanShardName((YangInstanceIdentifier)TestModel.INNER_LIST_PATH));
        IntegrationTestKit.waitUntilShardIsDown(this.followerConfigDatastore.getActorUtils(), ClusterUtils.getCleanShardName((YangInstanceIdentifier)TestModel.JUNK_PATH));
        LOG.debug("All follower shards gone");
        LOG.info("testMultipleShardRegistrations ending");
    }

    @Test
    public void testMultipleRegistrationsAtOnePrefix() throws Exception {
        LOG.info("testMultipleRegistrationsAtOnePrefix starting");
        this.initEmptyDatastores();
        for (int i = 0; i < 5; ++i) {
            LOG.info("Round {}", (Object)i);
            DistributedShardRegistration reg1 = (DistributedShardRegistration)DistributedShardedDOMDataTreeRemotingTest.waitOnAsyncTask(this.leaderShardFactory.createDistributedShard(TEST_ID, (Collection)Lists.newArrayList((Object[])new MemberName[]{AbstractTest.MEMBER_NAME, AbstractTest.MEMBER_2_NAME})), DistributedShardedDOMDataTree.SHARD_FUTURE_TIMEOUT_DURATION);
            this.leaderTestKit.waitUntilLeader(this.leaderConfigDatastore.getActorUtils(), ClusterUtils.getCleanShardName((YangInstanceIdentifier)TestModel.TEST_PATH));
            Assert.assertNotNull((Object)IntegrationTestKit.findLocalShard(this.leaderConfigDatastore.getActorUtils(), ClusterUtils.getCleanShardName((YangInstanceIdentifier)TestModel.TEST_PATH)));
            Assert.assertNotNull((Object)IntegrationTestKit.findLocalShard(this.followerConfigDatastore.getActorUtils(), ClusterUtils.getCleanShardName((YangInstanceIdentifier)TestModel.TEST_PATH)));
            HashSet peers = new HashSet();
            IntegrationTestKit.verifyShardState((AbstractDataStore)this.leaderConfigDatastore, ClusterUtils.getCleanShardName((YangInstanceIdentifier)TEST_ID.getRootIdentifier()), onDemandShardState -> peers.addAll(onDemandShardState.getPeerAddresses().values()));
            Assert.assertEquals((long)peers.size(), (long)1L);
            DistributedShardedDOMDataTreeRemotingTest.waitOnAsyncTask(reg1.close(), DistributedShardedDOMDataTree.SHARD_FUTURE_TIMEOUT_DURATION);
            IntegrationTestKit.waitUntilShardIsDown(this.leaderConfigDatastore.getActorUtils(), ClusterUtils.getCleanShardName((YangInstanceIdentifier)TestModel.TEST_PATH));
            IntegrationTestKit.waitUntilShardIsDown(this.followerConfigDatastore.getActorUtils(), ClusterUtils.getCleanShardName((YangInstanceIdentifier)TestModel.TEST_PATH));
        }
        LOG.info("testMultipleRegistrationsAtOnePrefix ending");
    }

    @Test
    public void testInitialBootstrappingWithNoModuleShards() throws Exception {
        LOG.info("testInitialBootstrappingWithNoModuleShards starting");
        this.initEmptyDatastores("module-shards-default-member-1.conf");
    }
}

