/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.cluster.sharding;

import akka.actor.ActorRef;
import akka.actor.ActorSystem;
import akka.actor.Address;
import akka.actor.AddressFromURIString;
import akka.actor.Props;
import akka.cluster.Cluster;
import akka.testkit.javadsl.TestKit;
import com.google.common.collect.Lists;
import com.google.common.util.concurrent.FluentFuture;
import com.google.common.util.concurrent.ListenableFuture;
import com.typesafe.config.Config;
import com.typesafe.config.ConfigFactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.TimeUnit;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Test;
import org.mockito.ArgumentCaptor;
import org.mockito.ArgumentMatchers;
import org.mockito.Captor;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;
import org.mockito.verification.VerificationMode;
import org.opendaylight.controller.cluster.ActorSystemProvider;
import org.opendaylight.controller.cluster.access.concepts.MemberName;
import org.opendaylight.controller.cluster.databroker.actors.dds.ClientLocalHistory;
import org.opendaylight.controller.cluster.databroker.actors.dds.ClientTransaction;
import org.opendaylight.controller.cluster.databroker.actors.dds.DataStoreClient;
import org.opendaylight.controller.cluster.databroker.actors.dds.SimpleDataStoreClientActor;
import org.opendaylight.controller.cluster.datastore.AbstractTest;
import org.opendaylight.controller.cluster.datastore.DatastoreContext;
import org.opendaylight.controller.cluster.datastore.DistributedDataStore;
import org.opendaylight.controller.cluster.datastore.DistributedDataStoreInterface;
import org.opendaylight.controller.cluster.datastore.IntegrationTestKit;
import org.opendaylight.controller.cluster.datastore.utils.ActorUtils;
import org.opendaylight.controller.cluster.datastore.utils.ClusterUtils;
import org.opendaylight.controller.cluster.dom.api.CDSDataTreeProducer;
import org.opendaylight.controller.cluster.dom.api.CDSShardAccess;
import org.opendaylight.controller.cluster.raft.utils.InMemoryJournal;
import org.opendaylight.controller.cluster.raft.utils.InMemorySnapshotStore;
import org.opendaylight.controller.cluster.sharding.DistributedShardRegistration;
import org.opendaylight.controller.cluster.sharding.DistributedShardedDOMDataTree;
import org.opendaylight.controller.cluster.sharding.DistributedShardedDOMDataTreeRemotingTest;
import org.opendaylight.controller.md.cluster.datastore.model.SchemaContextHelper;
import org.opendaylight.controller.md.cluster.datastore.model.TestModel;
import org.opendaylight.mdsal.common.api.LogicalDatastoreType;
import org.opendaylight.mdsal.dom.api.DOMDataTreeCursorAwareTransaction;
import org.opendaylight.mdsal.dom.api.DOMDataTreeIdentifier;
import org.opendaylight.mdsal.dom.api.DOMDataTreeListener;
import org.opendaylight.mdsal.dom.api.DOMDataTreeProducer;
import org.opendaylight.mdsal.dom.api.DOMDataTreeWriteCursor;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;
import org.opendaylight.yangtools.yang.data.api.schema.ContainerNode;
import org.opendaylight.yangtools.yang.data.api.schema.DataContainerChild;
import org.opendaylight.yangtools.yang.data.api.schema.LeafNode;
import org.opendaylight.yangtools.yang.data.api.schema.MapEntryNode;
import org.opendaylight.yangtools.yang.data.api.schema.MapNode;
import org.opendaylight.yangtools.yang.data.api.schema.NormalizedNode;
import org.opendaylight.yangtools.yang.data.api.schema.tree.DataTreeCandidate;
import org.opendaylight.yangtools.yang.data.impl.schema.ImmutableNodes;
import org.opendaylight.yangtools.yang.data.impl.schema.builder.impl.ImmutableContainerNodeBuilder;
import org.opendaylight.yangtools.yang.data.impl.schema.builder.impl.ImmutableLeafNodeBuilder;
import org.opendaylight.yangtools.yang.data.impl.schema.builder.impl.ImmutableMapNodeBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DistributedShardedDOMDataTreeTest
extends AbstractTest {
    private static final Logger LOG = LoggerFactory.getLogger(DistributedShardedDOMDataTreeRemotingTest.class);
    private static final Address MEMBER_1_ADDRESS = AddressFromURIString.parse((String)"akka.tcp://cluster-test@127.0.0.1:2558");
    private static final DOMDataTreeIdentifier TEST_ID = new DOMDataTreeIdentifier(LogicalDatastoreType.CONFIGURATION, TestModel.TEST_PATH);
    private static final DOMDataTreeIdentifier INNER_LIST_ID = new DOMDataTreeIdentifier(LogicalDatastoreType.CONFIGURATION, YangInstanceIdentifier.create((Iterable)DistributedShardedDOMDataTreeTest.getOuterListIdFor(0).getPathArguments()).node(TestModel.INNER_LIST_QNAME));
    private static final Set<MemberName> SINGLE_MEMBER = Collections.singleton(AbstractTest.MEMBER_NAME);
    private static final String MODULE_SHARDS_CONFIG = "module-shards-default-member-1.conf";
    private ActorSystem leaderSystem;
    private final DatastoreContext.Builder leaderDatastoreContextBuilder = DatastoreContext.newBuilder().shardHeartbeatIntervalInMillis(100).shardElectionTimeoutFactor(2L).logicalStoreType(LogicalDatastoreType.CONFIGURATION);
    private DistributedDataStore leaderDistributedDataStore;
    private DistributedDataStore operDistributedDatastore;
    private IntegrationTestKit leaderTestKit;
    private DistributedShardedDOMDataTree leaderShardFactory;
    @Captor
    private ArgumentCaptor<Collection<DataTreeCandidate>> captorForChanges;
    @Captor
    private ArgumentCaptor<Map<DOMDataTreeIdentifier, NormalizedNode<?, ?>>> captorForSubtrees;
    private ActorSystemProvider leaderSystemProvider;

    @Before
    public void setUp() {
        MockitoAnnotations.initMocks((Object)this);
        InMemoryJournal.clear();
        InMemorySnapshotStore.clear();
        this.leaderSystem = ActorSystem.create((String)"cluster-test", (Config)ConfigFactory.load().getConfig("Member1"));
        Cluster.get((ActorSystem)this.leaderSystem).join(MEMBER_1_ADDRESS);
        this.leaderSystemProvider = (ActorSystemProvider)Mockito.mock(ActorSystemProvider.class);
        ((ActorSystemProvider)Mockito.doReturn((Object)this.leaderSystem).when((Object)this.leaderSystemProvider)).getActorSystem();
    }

    @After
    public void tearDown() {
        if (this.leaderDistributedDataStore != null) {
            this.leaderDistributedDataStore.close();
        }
        if (this.operDistributedDatastore != null) {
            this.operDistributedDatastore.close();
        }
        TestKit.shutdownActorSystem((ActorSystem)this.leaderSystem);
        InMemoryJournal.clear();
        InMemorySnapshotStore.clear();
    }

    private void initEmptyDatastores() throws Exception {
        this.leaderTestKit = new IntegrationTestKit(this.leaderSystem, this.leaderDatastoreContextBuilder);
        this.leaderDistributedDataStore = this.leaderTestKit.setupDistributedDataStore("config", MODULE_SHARDS_CONFIG, "empty-modules.conf", true, SchemaContextHelper.distributedShardedDOMDataTreeSchemaContext(), new String[0]);
        this.operDistributedDatastore = this.leaderTestKit.setupDistributedDataStore("operational", MODULE_SHARDS_CONFIG, "empty-modules.conf", true, SchemaContextHelper.distributedShardedDOMDataTreeSchemaContext(), new String[0]);
        this.leaderShardFactory = new DistributedShardedDOMDataTree(this.leaderSystemProvider, (DistributedDataStoreInterface)this.operDistributedDatastore, (DistributedDataStoreInterface)this.leaderDistributedDataStore);
        this.leaderShardFactory.init();
    }

    @Test
    public void testWritesIntoDefaultShard() throws Exception {
        this.initEmptyDatastores();
        DOMDataTreeIdentifier configRoot = new DOMDataTreeIdentifier(LogicalDatastoreType.CONFIGURATION, YangInstanceIdentifier.empty());
        DOMDataTreeProducer producer = this.leaderShardFactory.createProducer(Collections.singleton(configRoot));
        DOMDataTreeCursorAwareTransaction tx = producer.createTransaction(true);
        DOMDataTreeWriteCursor cursor = tx.createCursor(new DOMDataTreeIdentifier(LogicalDatastoreType.CONFIGURATION, YangInstanceIdentifier.empty()));
        Assert.assertNotNull((Object)cursor);
        ContainerNode test = (ContainerNode)ImmutableContainerNodeBuilder.create().withNodeIdentifier((YangInstanceIdentifier.PathArgument)new YangInstanceIdentifier.NodeIdentifier(TestModel.TEST_QNAME)).build();
        cursor.write(test.getIdentifier(), (NormalizedNode)test);
        cursor.close();
        tx.commit().get();
    }

    @Test
    public void testSingleNodeWritesAndRead() throws Exception {
        this.initEmptyDatastores();
        DistributedShardRegistration shardRegistration = (DistributedShardRegistration)DistributedShardedDOMDataTreeTest.waitOnAsyncTask(this.leaderShardFactory.createDistributedShard(TEST_ID, (Collection)Lists.newArrayList((Object[])new MemberName[]{AbstractTest.MEMBER_NAME})), DistributedShardedDOMDataTree.SHARD_FUTURE_TIMEOUT_DURATION);
        this.leaderTestKit.waitUntilLeader(this.leaderDistributedDataStore.getActorUtils(), ClusterUtils.getCleanShardName((YangInstanceIdentifier)TEST_ID.getRootIdentifier()));
        DOMDataTreeProducer producer = this.leaderShardFactory.createProducer(Collections.singleton(TEST_ID));
        DOMDataTreeCursorAwareTransaction tx = producer.createTransaction(true);
        DOMDataTreeWriteCursor cursor = tx.createCursor(TEST_ID);
        Assert.assertNotNull((Object)cursor);
        YangInstanceIdentifier nameId = YangInstanceIdentifier.builder((YangInstanceIdentifier)TestModel.TEST_PATH).node(TestModel.NAME_QNAME).build();
        LeafNode valueToCheck = (LeafNode)ImmutableLeafNodeBuilder.create().withNodeIdentifier((YangInstanceIdentifier.PathArgument)new YangInstanceIdentifier.NodeIdentifier(TestModel.NAME_QNAME)).withValue((Object)"Test Value").build();
        LOG.debug("Writing data {} at {}, cursor {}", new Object[]{nameId.getLastPathArgument(), valueToCheck, cursor});
        cursor.write(nameId.getLastPathArgument(), (NormalizedNode)valueToCheck);
        cursor.close();
        LOG.debug("Got to pre submit");
        tx.commit().get();
        DOMDataTreeListener mockedDataTreeListener = (DOMDataTreeListener)Mockito.mock(DOMDataTreeListener.class);
        ((DOMDataTreeListener)Mockito.doNothing().when((Object)mockedDataTreeListener)).onDataTreeChanged(ArgumentMatchers.anyCollection(), ArgumentMatchers.anyMap());
        this.leaderShardFactory.registerListener(mockedDataTreeListener, Collections.singletonList(TEST_ID), true, Collections.emptyList());
        ((DOMDataTreeListener)Mockito.verify((Object)mockedDataTreeListener, (VerificationMode)Mockito.timeout((long)1000L).times(1))).onDataTreeChanged((Collection)this.captorForChanges.capture(), (Map)this.captorForSubtrees.capture());
        List capturedValue = this.captorForChanges.getAllValues();
        Optional dataAfter = ((DataTreeCandidate)((Collection)capturedValue.get(0)).iterator().next()).getRootNode().getDataAfter();
        NormalizedNode expected = ImmutableContainerNodeBuilder.create().withNodeIdentifier((YangInstanceIdentifier.PathArgument)new YangInstanceIdentifier.NodeIdentifier(TestModel.TEST_QNAME)).withChild((DataContainerChild)valueToCheck).build();
        Assert.assertEquals((Object)expected, dataAfter.get());
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{mockedDataTreeListener});
        String shardName = ClusterUtils.getCleanShardName((YangInstanceIdentifier)TEST_ID.getRootIdentifier());
        LOG.debug("Creating distributed datastore client for shard {}", (Object)shardName);
        ActorUtils actorUtils = this.leaderDistributedDataStore.getActorUtils();
        Props distributedDataStoreClientProps = SimpleDataStoreClientActor.props((MemberName)actorUtils.getCurrentMemberName(), (String)("Shard-" + shardName), (ActorUtils)actorUtils, (String)shardName);
        ActorRef clientActor = this.leaderSystem.actorOf(distributedDataStoreClientProps);
        DataStoreClient distributedDataStoreClient = SimpleDataStoreClientActor.getDistributedDataStoreClient((ActorRef)clientActor, (long)30L, (TimeUnit)TimeUnit.SECONDS);
        ClientLocalHistory localHistory = distributedDataStoreClient.createLocalHistory();
        ClientTransaction tx2 = localHistory.createTransaction();
        FluentFuture read = tx2.read(YangInstanceIdentifier.empty());
        Optional optional = (Optional)read.get();
        tx2.abort();
        localHistory.close();
        shardRegistration.close().toCompletableFuture().get();
    }

    @Test
    public void testMultipleWritesIntoSingleMapEntry() throws Exception {
        this.initEmptyDatastores();
        DistributedShardRegistration shardRegistration = (DistributedShardRegistration)DistributedShardedDOMDataTreeTest.waitOnAsyncTask(this.leaderShardFactory.createDistributedShard(TEST_ID, (Collection)Lists.newArrayList((Object[])new MemberName[]{AbstractTest.MEMBER_NAME})), DistributedShardedDOMDataTree.SHARD_FUTURE_TIMEOUT_DURATION);
        this.leaderTestKit.waitUntilLeader(this.leaderDistributedDataStore.getActorUtils(), ClusterUtils.getCleanShardName((YangInstanceIdentifier)TEST_ID.getRootIdentifier()));
        LOG.warn("Got after waiting for nonleader");
        ActorRef leaderShardManager = this.leaderDistributedDataStore.getActorUtils().getShardManager();
        this.leaderTestKit.waitUntilLeader(this.leaderDistributedDataStore.getActorUtils(), ClusterUtils.getCleanShardName((YangInstanceIdentifier)TestModel.TEST_PATH));
        YangInstanceIdentifier oid1 = DistributedShardedDOMDataTreeTest.getOuterListIdFor(0);
        DOMDataTreeIdentifier outerListPath = new DOMDataTreeIdentifier(LogicalDatastoreType.CONFIGURATION, oid1);
        DistributedShardRegistration outerListShardReg = (DistributedShardRegistration)DistributedShardedDOMDataTreeTest.waitOnAsyncTask(this.leaderShardFactory.createDistributedShard(outerListPath, (Collection)Lists.newArrayList((Object[])new MemberName[]{AbstractTest.MEMBER_NAME})), DistributedShardedDOMDataTree.SHARD_FUTURE_TIMEOUT_DURATION);
        this.leaderTestKit.waitUntilLeader(this.leaderDistributedDataStore.getActorUtils(), ClusterUtils.getCleanShardName((YangInstanceIdentifier)outerListPath.getRootIdentifier()));
        DOMDataTreeProducer shardProducer = this.leaderShardFactory.createProducer(Collections.singletonList(outerListPath));
        DOMDataTreeCursorAwareTransaction tx = shardProducer.createTransaction(false);
        DOMDataTreeWriteCursor cursor = tx.createCursor(new DOMDataTreeIdentifier(LogicalDatastoreType.CONFIGURATION, oid1));
        Assert.assertNotNull((Object)cursor);
        MapNode innerList = (MapNode)ImmutableMapNodeBuilder.create().withNodeIdentifier(new YangInstanceIdentifier.NodeIdentifier(TestModel.INNER_LIST_QNAME)).build();
        cursor.write((YangInstanceIdentifier.PathArgument)new YangInstanceIdentifier.NodeIdentifier(TestModel.INNER_LIST_QNAME), (NormalizedNode)innerList);
        cursor.close();
        tx.commit().get();
        ArrayList<FluentFuture> futures = new ArrayList<FluentFuture>();
        for (int i = 0; i < 1000; ++i) {
            Collection<MapEntryNode> innerListMapEntries = DistributedShardedDOMDataTreeTest.createInnerListMapEntries(1000, "run-" + i);
            for (MapEntryNode innerListMapEntry : innerListMapEntries) {
                DOMDataTreeCursorAwareTransaction tx1 = shardProducer.createTransaction(false);
                DOMDataTreeWriteCursor cursor1 = tx1.createCursor(new DOMDataTreeIdentifier(LogicalDatastoreType.CONFIGURATION, oid1.node((YangInstanceIdentifier.PathArgument)new YangInstanceIdentifier.NodeIdentifier(TestModel.INNER_LIST_QNAME))));
                cursor1.write((YangInstanceIdentifier.PathArgument)innerListMapEntry.getIdentifier(), (NormalizedNode)innerListMapEntry);
                cursor1.close();
                futures.add(tx1.commit());
            }
        }
        ((ListenableFuture)futures.get(futures.size() - 1)).get();
        DOMDataTreeListener mockedDataTreeListener = (DOMDataTreeListener)Mockito.mock(DOMDataTreeListener.class);
        ((DOMDataTreeListener)Mockito.doNothing().when((Object)mockedDataTreeListener)).onDataTreeChanged(ArgumentMatchers.anyCollection(), ArgumentMatchers.anyMap());
        this.leaderShardFactory.registerListener(mockedDataTreeListener, Collections.singletonList(INNER_LIST_ID), true, Collections.emptyList());
        ((DOMDataTreeListener)Mockito.verify((Object)mockedDataTreeListener, (VerificationMode)Mockito.timeout((long)1000L).times(1))).onDataTreeChanged((Collection)this.captorForChanges.capture(), (Map)this.captorForSubtrees.capture());
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{mockedDataTreeListener});
        List capturedValue = this.captorForChanges.getAllValues();
        NormalizedNode expected = ImmutableMapNodeBuilder.create().withNodeIdentifier(new YangInstanceIdentifier.NodeIdentifier(TestModel.INNER_LIST_QNAME)).withValue(DistributedShardedDOMDataTreeTest.createInnerListMapEntries(1000, "run-999")).build();
        Assert.assertEquals((String)"List values dont match the expected values from the last run", (Object)expected, ((DataTreeCandidate)((Collection)capturedValue.get(0)).iterator().next()).getRootNode().getDataAfter().get());
    }

    @Test
    @Ignore
    public void testMultipleShardLevels() throws Exception {
        this.initEmptyDatastores();
        DistributedShardRegistration testShardReg = (DistributedShardRegistration)DistributedShardedDOMDataTreeTest.waitOnAsyncTask(this.leaderShardFactory.createDistributedShard(TEST_ID, SINGLE_MEMBER), DistributedShardedDOMDataTree.SHARD_FUTURE_TIMEOUT_DURATION);
        ArrayList<DistributedShardRegistration> registrations = new ArrayList<DistributedShardRegistration>();
        int listSize = 5;
        for (int i = 0; i < 5; ++i) {
            YangInstanceIdentifier entryYID = DistributedShardedDOMDataTreeTest.getOuterListIdFor(i);
            CompletionStage future = this.leaderShardFactory.createDistributedShard(new DOMDataTreeIdentifier(LogicalDatastoreType.CONFIGURATION, entryYID), SINGLE_MEMBER);
            registrations.add((DistributedShardRegistration)DistributedShardedDOMDataTreeTest.waitOnAsyncTask(future, DistributedShardedDOMDataTree.SHARD_FUTURE_TIMEOUT_DURATION));
        }
        DOMDataTreeIdentifier rootId = new DOMDataTreeIdentifier(LogicalDatastoreType.CONFIGURATION, YangInstanceIdentifier.empty());
        DOMDataTreeProducer producer = this.leaderShardFactory.createProducer(Collections.singletonList(rootId));
        DOMDataTreeCursorAwareTransaction transaction = producer.createTransaction(false);
        DOMDataTreeWriteCursor cursor = transaction.createCursor(rootId);
        Assert.assertNotNull((Object)cursor);
        MapNode outerList = (MapNode)ImmutableMapNodeBuilder.create().withNodeIdentifier(new YangInstanceIdentifier.NodeIdentifier(TestModel.OUTER_LIST_QNAME)).build();
        ContainerNode testNode = (ContainerNode)ImmutableContainerNodeBuilder.create().withNodeIdentifier((YangInstanceIdentifier.PathArgument)new YangInstanceIdentifier.NodeIdentifier(TestModel.TEST_QNAME)).withChild((DataContainerChild)outerList).build();
        cursor.write(testNode.getIdentifier(), (NormalizedNode)testNode);
        cursor.close();
        transaction.commit().get();
        DOMDataTreeListener mockedDataTreeListener = (DOMDataTreeListener)Mockito.mock(DOMDataTreeListener.class);
        ((DOMDataTreeListener)Mockito.doNothing().when((Object)mockedDataTreeListener)).onDataTreeChanged(ArgumentMatchers.anyCollection(), ArgumentMatchers.anyMap());
        MapNode wholeList = (MapNode)ImmutableMapNodeBuilder.create((MapNode)outerList).withValue(DistributedShardedDOMDataTreeTest.createOuterEntries(5, "testing-values")).build();
        transaction = producer.createTransaction(false);
        cursor = transaction.createCursor(TEST_ID);
        Assert.assertNotNull((Object)cursor);
        cursor.write(wholeList.getIdentifier(), (NormalizedNode)wholeList);
        cursor.close();
        transaction.commit().get();
        this.leaderShardFactory.registerListener(mockedDataTreeListener, Collections.singletonList(TEST_ID), true, Collections.emptyList());
        ((DOMDataTreeListener)Mockito.verify((Object)mockedDataTreeListener, (VerificationMode)Mockito.timeout((long)35000L).atLeast(2))).onDataTreeChanged((Collection)this.captorForChanges.capture(), (Map)this.captorForSubtrees.capture());
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{mockedDataTreeListener});
        List allSubtrees = this.captorForSubtrees.getAllValues();
        Map lastSubtree = (Map)allSubtrees.get(allSubtrees.size() - 1);
        NormalizedNode actual = (NormalizedNode)lastSubtree.get(TEST_ID);
        Assert.assertNotNull((Object)actual);
        NormalizedNode expected = ImmutableContainerNodeBuilder.create().withNodeIdentifier((YangInstanceIdentifier.PathArgument)new YangInstanceIdentifier.NodeIdentifier(TestModel.TEST_QNAME)).withChild((DataContainerChild)ImmutableMapNodeBuilder.create((MapNode)outerList).withValue(DistributedShardedDOMDataTreeTest.createOuterEntries(5, "testing-values")).build()).build();
        for (DistributedShardRegistration registration : registrations) {
            DistributedShardedDOMDataTreeTest.waitOnAsyncTask(registration.close(), DistributedShardedDOMDataTree.SHARD_FUTURE_TIMEOUT_DURATION);
        }
        DistributedShardedDOMDataTreeTest.waitOnAsyncTask(testShardReg.close(), DistributedShardedDOMDataTree.SHARD_FUTURE_TIMEOUT_DURATION);
        Assert.assertEquals((Object)expected, (Object)actual);
    }

    @Test
    public void testMultipleRegistrationsAtOnePrefix() throws Exception {
        this.initEmptyDatastores();
        for (int i = 0; i < 10; ++i) {
            LOG.debug("Round {}", (Object)i);
            DistributedShardRegistration reg1 = (DistributedShardRegistration)DistributedShardedDOMDataTreeTest.waitOnAsyncTask(this.leaderShardFactory.createDistributedShard(TEST_ID, (Collection)Lists.newArrayList((Object[])new MemberName[]{AbstractTest.MEMBER_NAME})), DistributedShardedDOMDataTree.SHARD_FUTURE_TIMEOUT_DURATION);
            this.leaderTestKit.waitUntilLeader(this.leaderDistributedDataStore.getActorUtils(), ClusterUtils.getCleanShardName((YangInstanceIdentifier)TestModel.TEST_PATH));
            Assert.assertNotNull((Object)IntegrationTestKit.findLocalShard(this.leaderDistributedDataStore.getActorUtils(), ClusterUtils.getCleanShardName((YangInstanceIdentifier)TestModel.TEST_PATH)));
            DistributedShardedDOMDataTreeTest.waitOnAsyncTask(reg1.close(), DistributedShardedDOMDataTree.SHARD_FUTURE_TIMEOUT_DURATION);
            IntegrationTestKit.waitUntilShardIsDown(this.leaderDistributedDataStore.getActorUtils(), ClusterUtils.getCleanShardName((YangInstanceIdentifier)TestModel.TEST_PATH));
        }
    }

    @Test
    public void testCDSDataTreeProducer() throws Exception {
        this.initEmptyDatastores();
        DistributedShardRegistration reg1 = (DistributedShardRegistration)DistributedShardedDOMDataTreeTest.waitOnAsyncTask(this.leaderShardFactory.createDistributedShard(TEST_ID, (Collection)Lists.newArrayList((Object[])new MemberName[]{AbstractTest.MEMBER_NAME})), DistributedShardedDOMDataTree.SHARD_FUTURE_TIMEOUT_DURATION);
        this.leaderTestKit.waitUntilLeader(this.leaderDistributedDataStore.getActorUtils(), ClusterUtils.getCleanShardName((YangInstanceIdentifier)TestModel.TEST_PATH));
        Assert.assertNotNull((Object)IntegrationTestKit.findLocalShard(this.leaderDistributedDataStore.getActorUtils(), ClusterUtils.getCleanShardName((YangInstanceIdentifier)TestModel.TEST_PATH)));
        DOMDataTreeIdentifier configRoot = new DOMDataTreeIdentifier(LogicalDatastoreType.CONFIGURATION, YangInstanceIdentifier.empty());
        DOMDataTreeProducer producer = this.leaderShardFactory.createProducer(Collections.singleton(configRoot));
        Assert.assertTrue((boolean)(producer instanceof CDSDataTreeProducer));
        CDSDataTreeProducer cdsProducer = (CDSDataTreeProducer)producer;
        CDSShardAccess shardAccess = cdsProducer.getShardAccess(TEST_ID);
        Assert.assertEquals((Object)shardAccess.getShardIdentifier(), (Object)TEST_ID);
        shardAccess = cdsProducer.getShardAccess(INNER_LIST_ID);
        Assert.assertEquals((Object)TEST_ID, (Object)shardAccess.getShardIdentifier());
        shardAccess = cdsProducer.getShardAccess(configRoot);
        Assert.assertEquals((Object)configRoot, (Object)shardAccess.getShardIdentifier());
        DistributedShardedDOMDataTreeTest.waitOnAsyncTask(reg1.close(), DistributedShardedDOMDataTree.SHARD_FUTURE_TIMEOUT_DURATION);
    }

    private static Collection<MapEntryNode> createOuterEntries(int amount, String valuePrefix) {
        ArrayList<MapEntryNode> ret = new ArrayList<MapEntryNode>();
        for (int i = 0; i < amount; ++i) {
            ret.add((MapEntryNode)ImmutableNodes.mapEntryBuilder().withNodeIdentifier((YangInstanceIdentifier.PathArgument)YangInstanceIdentifier.NodeIdentifierWithPredicates.of((QName)TestModel.OUTER_LIST_QNAME, (QName)QName.create((QName)TestModel.OUTER_LIST_QNAME, (String)"id"), (Object)i)).withChild((DataContainerChild)ImmutableNodes.leafNode((QName)QName.create((QName)TestModel.OUTER_LIST_QNAME, (String)"id"), (Object)i)).withChild((DataContainerChild)DistributedShardedDOMDataTreeTest.createWholeInnerList(amount, "outer id: " + i + " " + valuePrefix)).build());
        }
        return ret;
    }

    private static MapNode createWholeInnerList(int amount, String valuePrefix) {
        return (MapNode)ImmutableMapNodeBuilder.create().withNodeIdentifier(new YangInstanceIdentifier.NodeIdentifier(TestModel.INNER_LIST_QNAME)).withValue(DistributedShardedDOMDataTreeTest.createInnerListMapEntries(amount, valuePrefix)).build();
    }

    private static Collection<MapEntryNode> createInnerListMapEntries(int amount, String valuePrefix) {
        ArrayList<MapEntryNode> ret = new ArrayList<MapEntryNode>();
        for (int i = 0; i < amount; ++i) {
            ret.add((MapEntryNode)ImmutableNodes.mapEntryBuilder().withNodeIdentifier((YangInstanceIdentifier.PathArgument)YangInstanceIdentifier.NodeIdentifierWithPredicates.of((QName)TestModel.INNER_LIST_QNAME, (QName)QName.create((QName)TestModel.INNER_LIST_QNAME, (String)"name"), (Object)Integer.toString(i))).withChild((DataContainerChild)ImmutableNodes.leafNode((QName)QName.create((QName)TestModel.INNER_LIST_QNAME, (String)"value"), (Object)(valuePrefix + "-" + i))).build());
        }
        return ret;
    }

    private static YangInstanceIdentifier getOuterListIdFor(int id) {
        return TestModel.OUTER_LIST_PATH.node((YangInstanceIdentifier.PathArgument)YangInstanceIdentifier.NodeIdentifierWithPredicates.of((QName)TestModel.OUTER_LIST_QNAME, (QName)QName.create((QName)TestModel.OUTER_LIST_QNAME, (String)"id"), (Object)id));
    }
}

