/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.cluster.sharding;

import akka.actor.ActorRef;
import akka.actor.Props;
import akka.testkit.javadsl.TestKit;
import org.junit.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.opendaylight.controller.cluster.datastore.AbstractActorTest;
import org.opendaylight.controller.cluster.dom.api.LeaderLocation;
import org.opendaylight.controller.cluster.dom.api.LeaderLocationListener;
import org.opendaylight.controller.cluster.notifications.LeaderStateChanged;
import org.opendaylight.controller.cluster.notifications.RegisterRoleChangeListener;
import org.opendaylight.controller.cluster.sharding.RoleChangeListenerActor;

public class RoleChangeListenerActorTest
extends AbstractActorTest {
    @Test
    public void testRegisterRoleChangeListenerOnStart() {
        TestKit testKit = new TestKit(RoleChangeListenerActorTest.getSystem());
        LeaderLocationListener listener = (LeaderLocationListener)Mockito.mock(LeaderLocationListener.class);
        Props props = RoleChangeListenerActor.props((ActorRef)testKit.getRef(), (LeaderLocationListener)listener);
        RoleChangeListenerActorTest.getSystem().actorOf(props, "testRegisterRoleChangeListenerOnStart");
        testKit.expectMsgClass(RegisterRoleChangeListener.class);
    }

    @Test
    public void testOnDataTreeChanged() {
        LeaderLocationListener listener = (LeaderLocationListener)Mockito.mock(LeaderLocationListener.class);
        ((LeaderLocationListener)Mockito.doNothing().when((Object)listener)).onLeaderLocationChanged((LeaderLocation)ArgumentMatchers.any());
        Props props = RoleChangeListenerActor.props((ActorRef)RoleChangeListenerActorTest.getSystem().deadLetters(), (LeaderLocationListener)listener);
        ActorRef subject = RoleChangeListenerActorTest.getSystem().actorOf(props, "testDataTreeChangedChanged");
        subject.tell((Object)new LeaderStateChanged("member-1", null, 0), ActorRef.noSender());
        ((LeaderLocationListener)Mockito.verify((Object)listener, (VerificationMode)Mockito.timeout((long)5000L))).onLeaderLocationChanged((LeaderLocation)ArgumentMatchers.eq((Object)LeaderLocation.UNKNOWN));
        subject.tell((Object)new LeaderStateChanged("member-1", "member-1", 0), ActorRef.noSender());
        ((LeaderLocationListener)Mockito.verify((Object)listener, (VerificationMode)Mockito.timeout((long)5000L))).onLeaderLocationChanged((LeaderLocation)ArgumentMatchers.eq((Object)LeaderLocation.LOCAL));
        subject.tell((Object)new LeaderStateChanged("member-1", "member-2", 0), ActorRef.noSender());
        ((LeaderLocationListener)Mockito.verify((Object)listener, (VerificationMode)Mockito.timeout((long)5000L))).onLeaderLocationChanged((LeaderLocation)ArgumentMatchers.eq((Object)LeaderLocation.REMOTE));
    }
}

