package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.config.distributed.datastore.provider.rev140612;
import java.lang.Boolean;
import java.lang.Class;
import java.lang.Deprecated;
import java.lang.Override;
import java.lang.String;
import javax.annotation.processing.Generated;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.common.Uint32;

/**
 *
 * <p>
 * This class represents the following YANG schema fragment defined in module <b>distributed-datastore-provider</b>
 * <pre>
 * grouping data-store-properties {
 *   leaf max-shard-data-change-executor-queue-size {
 *     default 1000;
 *     type non-zero-uint32-type;
 *   }
 *   leaf max-shard-data-change-executor-pool-size {
 *     default 20;
 *     type non-zero-uint32-type;
 *   }
 *   leaf max-shard-data-change-listener-queue-size {
 *     default 1000;
 *     type non-zero-uint32-type;
 *   }
 *   leaf max-shard-data-store-executor-queue-size {
 *     default 5000;
 *     type non-zero-uint32-type;
 *   }
 *   leaf shard-transaction-idle-timeout-in-minutes {
 *     default 10;
 *     type non-zero-uint32-type;
 *   }
 *   leaf shard-snapshot-batch-count {
 *     default 20000;
 *     type non-zero-uint32-type;
 *   }
 *   leaf shard-snapshot-data-threshold-percentage {
 *     default 12;
 *     type percentage;
 *   }
 *   leaf shard-snapshot-data-threshold {
 *     default 0;
 *     type uint32 {
 *       range 0..max;
 *     }
 *   }
 *   leaf shard-heartbeat-interval-in-millis {
 *     default 500;
 *     type heartbeat-interval-type;
 *   }
 *   leaf shard-election-timeout-factor {
 *     default 20;
 *     type non-zero-uint32-type;
 *   }
 *   leaf operation-timeout-in-seconds {
 *     default 5;
 *     type operation-timeout-type;
 *   }
 *   leaf shard-journal-recovery-log-batch-size {
 *     default 1;
 *     type non-zero-uint32-type;
 *   }
 *   leaf shard-transaction-commit-timeout-in-seconds {
 *     default 30;
 *     type non-zero-uint32-type;
 *   }
 *   leaf shard-transaction-commit-queue-capacity {
 *     default 50000;
 *     type non-zero-uint32-type;
 *   }
 *   leaf shard-commit-queue-expiry-timeout-in-seconds {
 *     default 120;
 *     type non-zero-uint32-type;
 *   }
 *   leaf shard-initialization-timeout-in-seconds {
 *     default 300;
 *     type non-zero-uint32-type;
 *   }
 *   leaf shard-leader-election-timeout-in-seconds {
 *     default 30;
 *     type non-zero-uint32-type;
 *   }
 *   leaf initial-settle-timeout-multiplier {
 *     default 3;
 *     type uint32;
 *   }
 *   leaf recovery-snapshot-interval-seconds {
 *     default 0;
 *     type uint32;
 *   }
 *   leaf shard-batched-modification-count {
 *     default 1000;
 *     type non-zero-uint32-type;
 *   }
 *   leaf enable-metric-capture {
 *     default false;
 *     type boolean;
 *   }
 *   leaf bounded-mailbox-capacity {
 *     default 1000;
 *     type non-zero-uint32-type;
 *   }
 *   leaf persistent {
 *     default true;
 *     type boolean;
 *   }
 *   leaf snapshotOnRootOverwrite {
 *     default false;
 *     type boolean;
 *   }
 *   leaf shard-isolated-leader-check-interval-in-millis {
 *     default 5000;
 *     type heartbeat-interval-type;
 *   }
 *   leaf transaction-creation-initial-rate-limit {
 *     default 100;
 *     type non-zero-uint32-type;
 *   }
 *   leaf transaction-debug-context-enabled {
 *     default false;
 *     type boolean;
 *   }
 *   leaf custom-raft-policy-implementation {
 *     default "";
 *     type string;
 *   }
 *   leaf shard-snapshot-chunk-size {
 *     status deprecated;
 *     default 2048000;
 *     type non-zero-uint32-type;
 *   }
 *   leaf maximum-message-slice-size {
 *     default 2048000;
 *     type non-zero-uint32-type;
 *   }
 *   leaf use-tell-based-protocol {
 *     default false;
 *     type boolean;
 *   }
 *   leaf file-backed-streaming-threshold-in-megabytes {
 *     default 128;
 *     type non-zero-uint32-type;
 *   }
 *   leaf sync-index-threshold {
 *     default 10;
 *     type non-zero-uint32-type;
 *   }
 *   leaf backend-aliveness-timer-interval-in-seconds {
 *     default 30;
 *     type non-zero-uint32-type;
 *   }
 *   leaf frontend-request-timeout-in-seconds {
 *     default 120;
 *     type non-zero-uint32-type;
 *   }
 *   leaf frontend-no-progress-timeout-in-seconds {
 *     default 900;
 *     type non-zero-uint32-type;
 *   }
 *   leaf initial-payload-serialized-buffer-capacity {
 *     default 512;
 *     type non-zero-uint32-type;
 *   }
 *   leaf use-lz4-compression {
 *     default false;
 *     type boolean;
 *   }
 * }
 * </pre>The schema path to identify an instance is
 * <i>distributed-datastore-provider/data-store-properties</i>
 *
 */
@Generated("mdsal-binding-generator")
public interface DataStoreProperties
    extends
    DataObject
{



    public static final @NonNull QName QNAME = $YangModuleInfoImpl.qnameOf("data-store-properties");

    @Override
    Class<? extends DataStoreProperties> implementedInterface();
    
    /**
     * Return maxShardDataChangeExecutorQueueSize, or {@code null} if it is not present.
     *
     * <pre>
     *     <code>
     *         The maximum queue size for each shard's data store data change notification
     *         executor.
     *     </code>
     * </pre>
     *
     * @return {@code org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.config.distributed.datastore.provider.rev140612.NonZeroUint32Type} maxShardDataChangeExecutorQueueSize, or {@code null} if it is not present.
     *
     */
    NonZeroUint32Type getMaxShardDataChangeExecutorQueueSize();
    
    /**
     * Return maxShardDataChangeExecutorPoolSize, or {@code null} if it is not present.
     *
     * <pre>
     *     <code>
     *         The maximum thread pool size for each shard's data store data change
     *         notification executor.
     *     </code>
     * </pre>
     *
     * @return {@code org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.config.distributed.datastore.provider.rev140612.NonZeroUint32Type} maxShardDataChangeExecutorPoolSize, or {@code null} if it is not present.
     *
     */
    NonZeroUint32Type getMaxShardDataChangeExecutorPoolSize();
    
    /**
     * Return maxShardDataChangeListenerQueueSize, or {@code null} if it is not present.
     *
     * <pre>
     *     <code>
     *         The maximum queue size for each shard's data store data change listener.
     *     </code>
     * </pre>
     *
     * @return {@code org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.config.distributed.datastore.provider.rev140612.NonZeroUint32Type} maxShardDataChangeListenerQueueSize, or {@code null} if it is not present.
     *
     */
    NonZeroUint32Type getMaxShardDataChangeListenerQueueSize();
    
    /**
     * Return maxShardDataStoreExecutorQueueSize, or {@code null} if it is not present.
     *
     * <pre>
     *     <code>
     *         The maximum queue size for each shard's data store executor.
     *     </code>
     * </pre>
     *
     * @return {@code org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.config.distributed.datastore.provider.rev140612.NonZeroUint32Type} maxShardDataStoreExecutorQueueSize, or {@code null} if it is not present.
     *
     */
    NonZeroUint32Type getMaxShardDataStoreExecutorQueueSize();
    
    /**
     * Return shardTransactionIdleTimeoutInMinutes, or {@code null} if it is not present.
     *
     * <pre>
     *     <code>
     *         The maximum amount of time a shard transaction can be idle without receiving any
     *         messages before it self-destructs.
     *     </code>
     * </pre>
     *
     * @return {@code org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.config.distributed.datastore.provider.rev140612.NonZeroUint32Type} shardTransactionIdleTimeoutInMinutes, or {@code null} if it is not present.
     *
     */
    NonZeroUint32Type getShardTransactionIdleTimeoutInMinutes();
    
    /**
     * Return shardSnapshotBatchCount, or {@code null} if it is not present.
     *
     * <pre>
     *     <code>
     *         The minimum number of entries to be present in the in-memory journal log before
     *         a snapshot is to be taken.
     *     </code>
     * </pre>
     *
     * @return {@code org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.config.distributed.datastore.provider.rev140612.NonZeroUint32Type} shardSnapshotBatchCount, or {@code null} if it is not present.
     *
     */
    NonZeroUint32Type getShardSnapshotBatchCount();
    
    /**
     * Return shardSnapshotDataThresholdPercentage, or {@code null} if it is not present.
     *
     * <pre>
     *     <code>
     *         The percentage of Runtime.maxMemory() used by the in-memory journal log before a
     *         snapshot is to be taken. Disabled, if direct threshold is enabled.
     *     </code>
     * </pre>
     *
     * @return {@code org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.config.distributed.datastore.provider.rev140612.Percentage} shardSnapshotDataThresholdPercentage, or {@code null} if it is not present.
     *
     */
    Percentage getShardSnapshotDataThresholdPercentage();
    
    /**
     * Return shardSnapshotDataThreshold, or {@code null} if it is not present.
     *
     * <pre>
     *     <code>
     *         The threshold of in-memory journal size before a snapshot is to be taken. If set
     *         to 0, direct threshold is disabled and percentage is used instead.
     *     </code>
     * </pre>
     *
     * @return {@code org.opendaylight.yangtools.yang.common.Uint32} shardSnapshotDataThreshold, or {@code null} if it is not present.
     *
     */
    Uint32 getShardSnapshotDataThreshold();
    
    /**
     * Return shardHeartbeatIntervalInMillis, or {@code null} if it is not present.
     *
     * <pre>
     *     <code>
     *         The interval at which a shard will send a heart beat message to its remote
     *         shard.
     *     </code>
     * </pre>
     *
     * @return {@code org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.config.distributed.datastore.provider.rev140612.HeartbeatIntervalType} shardHeartbeatIntervalInMillis, or {@code null} if it is not present.
     *
     */
    HeartbeatIntervalType getShardHeartbeatIntervalInMillis();
    
    /**
     * Return shardElectionTimeoutFactor, or {@code null} if it is not present.
     *
     * <pre>
     *     <code>
     *         The multiplication factor to be used to determine shard election timeout. The
     *         shard election timeout is determined by multiplying
     *         shard-heartbeat-interval-in-millis with the shard-election-timeout-factor
     *     </code>
     * </pre>
     *
     * @return {@code org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.config.distributed.datastore.provider.rev140612.NonZeroUint32Type} shardElectionTimeoutFactor, or {@code null} if it is not present.
     *
     */
    NonZeroUint32Type getShardElectionTimeoutFactor();
    
    /**
     * Return operationTimeoutInSeconds, or {@code null} if it is not present.
     *
     * <pre>
     *     <code>
     *         The maximum amount of time for akka operations (remote or local) to complete
     *         before failing.
     *     </code>
     * </pre>
     *
     * @return {@code org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.config.distributed.datastore.provider.rev140612.OperationTimeoutType} operationTimeoutInSeconds, or {@code null} if it is not present.
     *
     */
    OperationTimeoutType getOperationTimeoutInSeconds();
    
    /**
     * Return shardJournalRecoveryLogBatchSize, or {@code null} if it is not present.
     *
     * <pre>
     *     <code>
     *         The maximum number of journal log entries to batch on recovery for a shard
     *         before committing to the data store.
     *     </code>
     * </pre>
     *
     * @return {@code org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.config.distributed.datastore.provider.rev140612.NonZeroUint32Type} shardJournalRecoveryLogBatchSize, or {@code null} if it is not present.
     *
     */
    NonZeroUint32Type getShardJournalRecoveryLogBatchSize();
    
    /**
     * Return shardTransactionCommitTimeoutInSeconds, or {@code null} if it is not present.
     *
     * <pre>
     *     <code>
     *         The maximum amount of time a shard transaction three-phase commit can be idle
     *         without receiving the next messages before it aborts the transaction
     *     </code>
     * </pre>
     *
     * @return {@code org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.config.distributed.datastore.provider.rev140612.NonZeroUint32Type} shardTransactionCommitTimeoutInSeconds, or {@code null} if it is not present.
     *
     */
    NonZeroUint32Type getShardTransactionCommitTimeoutInSeconds();
    
    /**
     * Return shardTransactionCommitQueueCapacity, or {@code null} if it is not present.
     *
     * <pre>
     *     <code>
     *         The maximum allowed capacity for each shard's transaction commit queue.
     *     </code>
     * </pre>
     *
     * @return {@code org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.config.distributed.datastore.provider.rev140612.NonZeroUint32Type} shardTransactionCommitQueueCapacity, or {@code null} if it is not present.
     *
     */
    NonZeroUint32Type getShardTransactionCommitQueueCapacity();
    
    /**
     * Return shardCommitQueueExpiryTimeoutInSeconds, or {@code null} if it is not present.
     *
     * <pre>
     *     <code>
     *         The maximum amount of time a transaction can remain in a shard's commit queue
     *         waiting to begin the CanCommit phase as coordinated by the broker front-end.
     *         Normally this should be quick but latencies can occur in between transaction
     *         ready and CanCommit or a remote broker could lose connection and CanCommit might
     *         never occur. Expiring transactions from the queue allows subsequent pending
     *         transaction to be processed.
     *     </code>
     * </pre>
     *
     * @return {@code org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.config.distributed.datastore.provider.rev140612.NonZeroUint32Type} shardCommitQueueExpiryTimeoutInSeconds, or {@code null} if it is not present.
     *
     */
    NonZeroUint32Type getShardCommitQueueExpiryTimeoutInSeconds();
    
    /**
     * Return shardInitializationTimeoutInSeconds, or {@code null} if it is not present.
     *
     * <pre>
     *     <code>
     *         The maximum amount of time to wait for a shard to initialize from persistence on
     *         startup before failing an operation (eg transaction create and change listener
     *         registration).
     *     </code>
     * </pre>
     *
     * @return {@code org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.config.distributed.datastore.provider.rev140612.NonZeroUint32Type} shardInitializationTimeoutInSeconds, or {@code null} if it is not present.
     *
     */
    NonZeroUint32Type getShardInitializationTimeoutInSeconds();
    
    /**
     * Return shardLeaderElectionTimeoutInSeconds, or {@code null} if it is not present.
     *
     * <pre>
     *     <code>
     *         The maximum amount of time to wait for a shard to elect a leader before failing
     *         an operation (eg transaction create).
     *     </code>
     * </pre>
     *
     * @return {@code org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.config.distributed.datastore.provider.rev140612.NonZeroUint32Type} shardLeaderElectionTimeoutInSeconds, or {@code null} if it is not present.
     *
     */
    NonZeroUint32Type getShardLeaderElectionTimeoutInSeconds();
    
    /**
     * Return initialSettleTimeoutMultiplier, or {@code null} if it is not present.
     *
     * <pre>
     *     <code>
     *         Multiplier for the maximum amount of time to wait for a shard to elect a leader.
     *         Zero value means wait indefinitely (as long as it takes).
     *     </code>
     * </pre>
     *
     * @return {@code org.opendaylight.yangtools.yang.common.Uint32} initialSettleTimeoutMultiplier, or {@code null} if it is not present.
     *
     */
    Uint32 getInitialSettleTimeoutMultiplier();
    
    /**
     * Return recoverySnapshotIntervalSeconds, or {@code null} if it is not present.
     *
     * <pre>
     *     <code>
     *         Interval after which a snapshot should be taken during the recovery process.
     *     </code>
     * </pre>
     *
     * @return {@code org.opendaylight.yangtools.yang.common.Uint32} recoverySnapshotIntervalSeconds, or {@code null} if it is not present.
     *
     */
    Uint32 getRecoverySnapshotIntervalSeconds();
    
    /**
     * Return shardBatchedModificationCount, or {@code null} if it is not present.
     *
     * <pre>
     *     <code>
     *         The number of transaction modification operations (put, merge, delete) to batch
     *         before sending to the shard transaction actor. Batching improves performance as
     *         less modifications messages are sent to the actor and thus lessens the chance
     *         that the transaction actor's mailbox queue could get full.
     *     </code>
     * </pre>
     *
     * @return {@code org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.config.distributed.datastore.provider.rev140612.NonZeroUint32Type} shardBatchedModificationCount, or {@code null} if it is not present.
     *
     */
    NonZeroUint32Type getShardBatchedModificationCount();
    
    /**
     * Return enableMetricCapture, or {@code null} if it is not present.
     *
     * <pre>
     *     <code>
     *         Enable or disable metric capture.
     *     </code>
     * </pre>
     *
     * @return {@code java.lang.Boolean} enableMetricCapture, or {@code null} if it is not present.
     *
     */
    Boolean getEnableMetricCapture();
    
    @Deprecated(forRemoval = true)
    default Boolean isEnableMetricCapture() {
        return getEnableMetricCapture();
    }
    
    /**
     * Return boundedMailboxCapacity, or {@code null} if it is not present.
     *
     * <pre>
     *     <code>
     *         Max queue size that an actor's mailbox can reach
     *     </code>
     * </pre>
     *
     * @return {@code org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.config.distributed.datastore.provider.rev140612.NonZeroUint32Type} boundedMailboxCapacity, or {@code null} if it is not present.
     *
     */
    NonZeroUint32Type getBoundedMailboxCapacity();
    
    /**
     * Return persistent, or {@code null} if it is not present.
     *
     * <pre>
     *     <code>
     *         Enable or disable data persistence
     *     </code>
     * </pre>
     *
     * @return {@code java.lang.Boolean} persistent, or {@code null} if it is not present.
     *
     */
    Boolean getPersistent();
    
    @Deprecated(forRemoval = true)
    default Boolean isPersistent() {
        return getPersistent();
    }
    
    /**
     * Return snapshotOnRootOverwrite, or {@code null} if it is not present.
     *
     * <pre>
     *     <code>
     *         Enable or disable capturing snapshots on DataTree root overwrites
     *     </code>
     * </pre>
     *
     * @return {@code java.lang.Boolean} snapshotOnRootOverwrite, or {@code null} if it is not present.
     *
     */
    Boolean getSnapshotOnRootOverwrite();
    
    @Deprecated(forRemoval = true)
    default Boolean isSnapshotOnRootOverwrite() {
        return getSnapshotOnRootOverwrite();
    }
    
    /**
     * Return shardIsolatedLeaderCheckIntervalInMillis, or {@code null} if it is not present.
     *
     * <pre>
     *     <code>
     *         The interval at which the leader of the shard will check if its majority
     *         followers are active and term itself as isolated
     *     </code>
     * </pre>
     *
     * @return {@code org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.config.distributed.datastore.provider.rev140612.HeartbeatIntervalType} shardIsolatedLeaderCheckIntervalInMillis, or {@code null} if it is not present.
     *
     */
    HeartbeatIntervalType getShardIsolatedLeaderCheckIntervalInMillis();
    
    /**
     * Return transactionCreationInitialRateLimit, or {@code null} if it is not present.
     *
     * <pre>
     *     <code>
     *         The initial number of transactions per second that are allowed before the data
     *         store should begin applying back pressure. This number is only used as an
     *         initial guidance, subsequently the datastore measures the latency for a commit
     *         and auto-adjusts the rate limit
     *     </code>
     * </pre>
     *
     * @return {@code org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.config.distributed.datastore.provider.rev140612.NonZeroUint32Type} transactionCreationInitialRateLimit, or {@code null} if it is not present.
     *
     */
    NonZeroUint32Type getTransactionCreationInitialRateLimit();
    
    /**
     * Return transactionDebugContextEnabled, or {@code null} if it is not present.
     *
     * <pre>
     *     <code>
     *         Enable or disable transaction context debug. This will log the call site trace
     *         for transactions that fail
     *     </code>
     * </pre>
     *
     * @return {@code java.lang.Boolean} transactionDebugContextEnabled, or {@code null} if it is not present.
     *
     */
    Boolean getTransactionDebugContextEnabled();
    
    @Deprecated(forRemoval = true)
    default Boolean isTransactionDebugContextEnabled() {
        return getTransactionDebugContextEnabled();
    }
    
    /**
     * Return customRaftPolicyImplementation, or {@code null} if it is not present.
     *
     * <pre>
     *     <code>
     *         A fully qualified java class name. The class should implement
     *         org.opendaylight.controller.cluster.raft.policy.RaftPolicy. This java class
     *         should be accessible to the distributed data store OSGi module so that it can be
     *         dynamically loaded via reflection. For now let's assume that these classes to
     *         customize raft behaviors should be present in the distributed data store module
     *         itself. If this property is set to a class which cannot be found then the
     *         default raft behavior will be applied
     *     </code>
     * </pre>
     *
     * @return {@code java.lang.String} customRaftPolicyImplementation, or {@code null} if it is not present.
     *
     */
    String getCustomRaftPolicyImplementation();
    
    /**
     * Return shardSnapshotChunkSize, or {@code null} if it is not present.
     *
     * <pre>
     *     <code>
     *         When sending a snapshot to a follower, this is the maximum size in bytes for a
     *         chunk of data.
     *     </code>
     * </pre>
     *
     * @return {@code org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.config.distributed.datastore.provider.rev140612.NonZeroUint32Type} shardSnapshotChunkSize, or {@code null} if it is not present.
     *
     */
    @Deprecated
    NonZeroUint32Type getShardSnapshotChunkSize();
    
    /**
     * Return maximumMessageSliceSize, or {@code null} if it is not present.
     *
     * <pre>
     *     <code>
     *         When fragmenting messages thru the akka remoting framework, this is the maximum
     *         size in bytes for a message slice.
     *     </code>
     * </pre>
     *
     * @return {@code org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.config.distributed.datastore.provider.rev140612.NonZeroUint32Type} maximumMessageSliceSize, or {@code null} if it is not present.
     *
     */
    NonZeroUint32Type getMaximumMessageSliceSize();
    
    /**
     * Return useTellBasedProtocol, or {@code null} if it is not present.
     *
     * <pre>
     *     <code>
     *         Use a newer protocol between the frontend and backend. This feature is
     *         considered exprerimental at this point.
     *     </code>
     * </pre>
     *
     * @return {@code java.lang.Boolean} useTellBasedProtocol, or {@code null} if it is not present.
     *
     */
    Boolean getUseTellBasedProtocol();
    
    @Deprecated(forRemoval = true)
    default Boolean isUseTellBasedProtocol() {
        return getUseTellBasedProtocol();
    }
    
    /**
     * Return fileBackedStreamingThresholdInMegabytes, or {@code null} if it is not present.
     *
     * <pre>
     *     <code>
     *         When streaming large amounts of data, eg when sending a snapshot to a follower,
     *         this is the threshold in terms of number of megabytes before it should switch
     *         from storing in memory to buffering to a file.
     *     </code>
     * </pre>
     *
     * @return {@code org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.config.distributed.datastore.provider.rev140612.NonZeroUint32Type} fileBackedStreamingThresholdInMegabytes, or {@code null} if it is not present.
     *
     */
    NonZeroUint32Type getFileBackedStreamingThresholdInMegabytes();
    
    /**
     * Return syncIndexThreshold, or {@code null} if it is not present.
     *
     * <pre>
     *     <code>
     *         Permitted synchronization lag, expressed in terms of RAFT entry count. It a
     *         follower's commitIndex trails the leader's journal by more than this amount of
     *         entries the follower is considered to be out-of-sync.
     *     </code>
     * </pre>
     *
     * @return {@code org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.config.distributed.datastore.provider.rev140612.NonZeroUint32Type} syncIndexThreshold, or {@code null} if it is not present.
     *
     */
    NonZeroUint32Type getSyncIndexThreshold();
    
    /**
     * Return backendAlivenessTimerIntervalInSeconds, or {@code null} if it is not present.
     *
     * <pre>
     *     <code>
     *         The timer interval whereby, on expiration after response inactivity from the
     *         back-end, the connection to the back-end is torn down and reconnection is
     *         attempted.
     *     </code>
     * </pre>
     *
     * @return {@code org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.config.distributed.datastore.provider.rev140612.NonZeroUint32Type} backendAlivenessTimerIntervalInSeconds, or {@code null} if it is not present.
     *
     */
    NonZeroUint32Type getBackendAlivenessTimerIntervalInSeconds();
    
    /**
     * Return frontendRequestTimeoutInSeconds, or {@code null} if it is not present.
     *
     * <pre>
     *     <code>
     *         The timeout interval whereby client frontend transaction requests are failed.
     *     </code>
     * </pre>
     *
     * @return {@code org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.config.distributed.datastore.provider.rev140612.NonZeroUint32Type} frontendRequestTimeoutInSeconds, or {@code null} if it is not present.
     *
     */
    NonZeroUint32Type getFrontendRequestTimeoutInSeconds();
    
    /**
     * Return frontendNoProgressTimeoutInSeconds, or {@code null} if it is not present.
     *
     * <pre>
     *     <code>
     *         The timeout interval whereby the client front-end hasn't made progress with the
     *         back-end on any request and terminates.
     *     </code>
     * </pre>
     *
     * @return {@code org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.config.distributed.datastore.provider.rev140612.NonZeroUint32Type} frontendNoProgressTimeoutInSeconds, or {@code null} if it is not present.
     *
     */
    NonZeroUint32Type getFrontendNoProgressTimeoutInSeconds();
    
    /**
     * Return initialPayloadSerializedBufferCapacity, or {@code null} if it is not present.
     *
     * <pre>
     *     <code>
     *         The initial buffer capacity, in bytes, to use when serializing message payloads.
     *     </code>
     * </pre>
     *
     * @return {@code org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.config.distributed.datastore.provider.rev140612.NonZeroUint32Type} initialPayloadSerializedBufferCapacity, or {@code null} if it is not present.
     *
     */
    NonZeroUint32Type getInitialPayloadSerializedBufferCapacity();
    
    /**
     * Return useLz4Compression, or {@code null} if it is not present.
     *
     * <pre>
     *     <code>
     *         Use lz4 compression for snapshots, sent from leader to follower, for snapshots
     *         stored by LocalSnapshotStore, use akka.conf configuration.
     *     </code>
     * </pre>
     *
     * @return {@code java.lang.Boolean} useLz4Compression, or {@code null} if it is not present.
     *
     */
    Boolean getUseLz4Compression();
    
    @Deprecated(forRemoval = true)
    default Boolean isUseLz4Compression() {
        return getUseLz4Compression();
    }

}

