package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.config.distributed.datastore.provider.rev140612;
import com.google.common.base.MoreObjects;
import java.beans.ConstructorProperties;
import java.io.Serializable;
import java.lang.Long;
import java.lang.Override;
import java.lang.String;
import java.util.Objects;
import javax.annotation.processing.Generated;
import javax.management.ConstructorParameters;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.ScalarTypeObject;
import org.opendaylight.yangtools.yang.common.Uint32;

@Generated("mdsal-binding-generator")
public class NonZeroUint32Type
 implements ScalarTypeObject<Uint32>, Serializable {
    private static final long serialVersionUID = -7519597503656647670L;
    private final Uint32 _value;

    private static void check_valueRange(final long value) {
        if (value >= 1L) {
            return;
        }
        CodeHelpers.throwInvalidRange("[[1..4294967295]]", value);
    }

    @ConstructorParameters("value")
    @ConstructorProperties("value")
    public NonZeroUint32Type(Uint32 _value) {
        if (_value != null) {
            check_valueRange(_value.longValue());
        }
        
        CodeHelpers.requireValue(_value);
    
        this._value = _value;
    }
    
    /**
     * Utility migration constructor.
     *
     * @param _value value in legacy Java type
     * @deprecated Use {@link #NonZeroUint32Type(Uint32)} instead.
     */
    @Deprecated(forRemoval = true)
    public NonZeroUint32Type(Long _value) {
        this(CodeHelpers.compatUint(_value));
    }
    
    /**
     * Creates a copy from Source Object.
     *
     * @param source Source object
     */
    public NonZeroUint32Type(NonZeroUint32Type source) {
        this._value = source._value;
    }

    public static NonZeroUint32Type getDefaultInstance(final String defaultValue) {
        return new NonZeroUint32Type(Uint32.valueOf(defaultValue));
    }

    @Override
    public Uint32 getValue() {
        return _value;
    }


    @Override
    public int hashCode() {
        return CodeHelpers.wrapperHashCode(_value);
    }

    @Override
    public final boolean equals(java.lang.Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof NonZeroUint32Type)) {
            return false;
        }
        final NonZeroUint32Type other = (NonZeroUint32Type) obj;
        if (!Objects.equals(_value, other._value)) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        final MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper(NonZeroUint32Type.class);
        CodeHelpers.appendValue(helper, "_value", _value);
        return helper.toString();
    }
}

