package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.md.sal.clustering.prefix.shard.configuration.rev170110.prefix.shards;
import com.google.common.base.MoreObjects;
import java.lang.Class;
import java.lang.NullPointerException;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Objects;
import javax.annotation.processing.Generated;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.md.sal.clustering.prefix.shard.configuration.rev170110.$YangModuleInfoImpl;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.md.sal.clustering.prefix.shard.configuration.rev170110.PrefixShards;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.md.sal.clustering.prefix.shard.configuration.rev170110.prefix.shards.shard.Replicas;
import org.opendaylight.yangtools.yang.binding.Augmentable;
import org.opendaylight.yangtools.yang.binding.ChildOf;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.Identifiable;
import org.opendaylight.yangtools.yang.binding.InstanceIdentifier;
import org.opendaylight.yangtools.yang.common.QName;

/**
 * List of prefix-based shards configured.
 *
 * <p>
 * This class represents the following YANG schema fragment defined in module <b>prefix-shard-configuration</b>
 * <pre>
 * list shard {
 *   key prefix;
 *   leaf prefix {
 *     type instance-identifier;
 *   }
 *   container replicas {
 *     leaf-list replica {
 *       type string;
 *     }
 *   }
 * }
 * </pre>The schema path to identify an instance is
 * <i>prefix-shard-configuration/prefix-shards/shard</i>
 *
 * <p>To create instances of this class use {@link ShardBuilder}.
 * @see ShardBuilder
 * @see ShardKey
 *
 */
@Generated("mdsal-binding-generator")
public interface Shard
    extends
    ChildOf<PrefixShards>,
    Augmentable<Shard>,
    Identifiable<ShardKey>
{



    public static final @NonNull QName QNAME = $YangModuleInfoImpl.qnameOf("shard");

    @Override
    default Class<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.md.sal.clustering.prefix.shard.configuration.rev170110.prefix.shards.Shard> implementedInterface() {
        return org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.md.sal.clustering.prefix.shard.configuration.rev170110.prefix.shards.Shard.class;
    }
    
    /**
     * Default implementation of {@link Object#hashCode()} contract for this interface.
     * Implementations of this interface are encouraged to defer to this method to get consistent hashing
     * results across all implementations.
     *
     * @param obj Object for which to generate hashCode() result.
     * @return Hash code value of data modeled by this interface.
     * @throws NullPointerException if {@code obj} is null
     */
    static int bindingHashCode(final org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.md.sal.clustering.prefix.shard.configuration.rev170110.prefix.shards.@NonNull Shard obj) {
        final int prime = 31;
        int result = 1;
        result = prime * result + Objects.hashCode(obj.getPrefix());
        result = prime * result + Objects.hashCode(obj.getReplicas());
        result = prime * result + obj.augmentations().hashCode();
        return result;
    }
    
    /**
     * Default implementation of {@link Object#equals(Object)} contract for this interface.
     * Implementations of this interface are encouraged to defer to this method to get consistent equality
     * results across all implementations.
     *
     * @param thisObj Object acting as the receiver of equals invocation
     * @param obj Object acting as argument to equals invocation
     * @return True if thisObj and obj are considered equal
     * @throws NullPointerException if {@code thisObj} is null
     */
    static boolean bindingEquals(final org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.md.sal.clustering.prefix.shard.configuration.rev170110.prefix.shards.@NonNull Shard thisObj, final Object obj) {
        if (thisObj == obj) {
            return true;
        }
        final org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.md.sal.clustering.prefix.shard.configuration.rev170110.prefix.shards.Shard other = CodeHelpers.checkCast(org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.md.sal.clustering.prefix.shard.configuration.rev170110.prefix.shards.Shard.class, obj);
        if (other == null) {
            return false;
        }
        if (!Objects.equals(thisObj.getPrefix(), other.getPrefix())) {
            return false;
        }
        if (!Objects.equals(thisObj.getReplicas(), other.getReplicas())) {
            return false;
        }
        return thisObj.augmentations().equals(other.augmentations());
    }
    
    /**
     * Default implementation of {@link Object#toString()} contract for this interface.
     * Implementations of this interface are encouraged to defer to this method to get consistent string
     * representations across all implementations.
     *
     * @param obj Object for which to generate toString() result.
     * @return {@link String} value of data modeled by this interface.
     * @throws NullPointerException if {@code obj} is null
     */
    static String bindingToString(final org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.md.sal.clustering.prefix.shard.configuration.rev170110.prefix.shards.@NonNull Shard obj) {
        final MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper("Shard");
        CodeHelpers.appendValue(helper, "prefix", obj.getPrefix());
        CodeHelpers.appendValue(helper, "replicas", obj.getReplicas());
        CodeHelpers.appendValue(helper, "augmentation", obj.augmentations().values());
        return helper.toString();
    }
    
    /**
     * Return prefix, or {@code null} if it is not present.
     *
     * <pre>
     *     <code>
     *         Prefix that this shard is rooted at.
     *     </code>
     * </pre>
     *
     * @return {@code org.opendaylight.yangtools.yang.binding.InstanceIdentifier} prefix, or {@code null} if it is not present.
     *
     */
    InstanceIdentifier<?> getPrefix();
    
    /**
     * Return replicas, or {@code null} if it is not present.
     *
     * <pre>
     *     <code>
     *         List of cluster member nodes that this shard is replicated on
     *     </code>
     * </pre>
     *
     * @return {@code org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.md.sal.clustering.prefix.shard.configuration.rev170110.prefix.shards.shard.Replicas} replicas, or {@code null} if it is not present.
     *
     */
    Replicas getReplicas();
    
    @Override
    ShardKey key();

}

