package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.md.sal.clustering.prefix.shard.configuration.rev170110.prefix.shards;
import java.lang.Class;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javax.annotation.processing.Generated;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.md.sal.clustering.prefix.shard.configuration.rev170110.prefix.shards.shard.Replicas;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.AbstractAugmentable;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.InstanceIdentifier;

/**
 * Class that builds {@link ShardBuilder} instances. Overall design of the class is that of a
 * <a href="https://en.wikipedia.org/wiki/Fluent_interface">fluent interface</a>, where method chaining is used.
 *
 * <p>
 * In general, this class is supposed to be used like this template:
 * <pre>
 *   <code>
 *     ShardBuilder createTarget(int fooXyzzy, int barBaz) {
 *         return new ShardBuilderBuilder()
 *             .setFoo(new FooBuilder().setXyzzy(fooXyzzy).build())
 *             .setBar(new BarBuilder().setBaz(barBaz).build())
 *             .build();
 *     }
 *   </code>
 * </pre>
 *
 * <p>
 * This pattern is supported by the immutable nature of ShardBuilder, as instances can be freely passed around without
 * worrying about synchronization issues.
 *
 * <p>
 * As a side note: method chaining results in:
 * <ul>
 *   <li>very efficient Java bytecode, as the method invocation result, in this case the Builder reference, is
 *       on the stack, so further method invocations just need to fill method arguments for the next method
 *       invocation, which is terminated by {@link #build()}, which is then returned from the method</li>
 *   <li>better understanding by humans, as the scope of mutable state (the builder) is kept to a minimum and is
 *       very localized</li>
 *   <li>better optimization oportunities, as the object scope is minimized in terms of invocation (rather than
 *       method) stack, making <a href="https://en.wikipedia.org/wiki/Escape_analysis">escape analysis</a> a lot
 *       easier. Given enough compiler (JIT/AOT) prowess, the cost of th builder object can be completely
 *       eliminated</li>
 * </ul>
 *
 * @see ShardBuilder
 * @see Builder
 *
 */
@Generated("mdsal-binding-generator")
public class ShardBuilder implements Builder<Shard> {

    private InstanceIdentifier<?> _prefix;
    private Replicas _replicas;
    private ShardKey key;


    Map<Class<? extends Augmentation<Shard>>, Augmentation<Shard>> augmentation = Collections.emptyMap();

    public ShardBuilder() {
    }
    
    
    

    public ShardBuilder(Shard base) {
        Map<Class<? extends Augmentation<Shard>>, Augmentation<Shard>> aug = base.augmentations();
        if (!aug.isEmpty()) {
            this.augmentation = new HashMap<>(aug);
        }
        this.key = base.key();
        this._prefix = base.getPrefix();
        this._replicas = base.getReplicas();
    }


    public ShardKey key() {
        return key;
    }
    
    public InstanceIdentifier<?> getPrefix() {
        return _prefix;
    }
    
    public Replicas getReplicas() {
        return _replicas;
    }

    @SuppressWarnings({ "unchecked", "checkstyle:methodTypeParameterName"})
    public <E$$ extends Augmentation<Shard>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$) augmentation.get(Objects.requireNonNull(augmentationType));
    }

    public ShardBuilder withKey(final ShardKey key) {
        this.key = key;
        return this;
    }
    
    public ShardBuilder setPrefix(final InstanceIdentifier<?> value) {
        this._prefix = value;
        return this;
    }
    
    public ShardBuilder setReplicas(final Replicas value) {
        this._replicas = value;
        return this;
    }
    
    /**
      * Add an augmentation to this builder's product.
      *
      * @param augmentation augmentation to be added
      * @return this builder
      * @throws NullPointerException if {@code augmentation} is null
      */
    public ShardBuilder addAugmentation(Augmentation<Shard> augmentation) {
        Class<? extends Augmentation<Shard>> augmentationType = augmentation.implementedInterface();
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<>();
        }
    
        this.augmentation.put(augmentationType, augmentation);
        return this;
    }
    
    /**
      * Remove an augmentation from this builder's product. If this builder does not track such an augmentation
      * type, this method does nothing.
      *
      * @param augmentationType augmentation type to be removed
      * @return this builder
      */
    public ShardBuilder removeAugmentation(Class<? extends Augmentation<Shard>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    @Override
    public Shard build() {
        return new ShardImpl(this);
    }

    private static final class ShardImpl
        extends AbstractAugmentable<Shard>
        implements Shard {
    
        private final InstanceIdentifier<?> _prefix;
        private final Replicas _replicas;
        private final ShardKey key;
    
        ShardImpl(ShardBuilder base) {
            super(base.augmentation);
            if (base.key() != null) {
                this.key = base.key();
            } else {
                this.key = new ShardKey(base.getPrefix());
            }
            this._prefix = key.getPrefix();
            this._replicas = base.getReplicas();
        }
    
        @Override
        public ShardKey key() {
            return key;
        }
        
        @Override
        public InstanceIdentifier<?> getPrefix() {
            return _prefix;
        }
        
        @Override
        public Replicas getReplicas() {
            return _replicas;
        }
    
        private int hash = 0;
        private volatile boolean hashValid = false;
        
        @Override
        public int hashCode() {
            if (hashValid) {
                return hash;
            }
        
            final int result = Shard.bindingHashCode(this);
            hash = result;
            hashValid = true;
            return result;
        }
    
        @Override
        public boolean equals(Object obj) {
            return Shard.bindingEquals(this, obj);
        }
    
        @Override
        public String toString() {
            return Shard.bindingToString(this);
        }
    }
}
