/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.cluster.databroker.actors.dds;

import akka.actor.ActorRef;
import akka.actor.ActorSystem;
import akka.testkit.TestProbe;
import akka.testkit.javadsl.TestKit;
import com.google.common.base.Ticker;
import com.google.common.primitives.UnsignedLong;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import org.hamcrest.BaseMatcher;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.core.Is;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;
import org.opendaylight.controller.cluster.access.ABIVersion;
import org.opendaylight.controller.cluster.access.client.AbstractClientConnection;
import org.opendaylight.controller.cluster.access.client.AccessClientUtil;
import org.opendaylight.controller.cluster.access.client.BackendInfo;
import org.opendaylight.controller.cluster.access.client.ClientActorContext;
import org.opendaylight.controller.cluster.access.client.ConnectedClientConnection;
import org.opendaylight.controller.cluster.access.client.ConnectionEntry;
import org.opendaylight.controller.cluster.access.commands.AbortLocalTransactionRequest;
import org.opendaylight.controller.cluster.access.commands.ExistsTransactionRequest;
import org.opendaylight.controller.cluster.access.commands.ModifyTransactionRequest;
import org.opendaylight.controller.cluster.access.commands.PersistenceProtocol;
import org.opendaylight.controller.cluster.access.commands.ReadTransactionRequest;
import org.opendaylight.controller.cluster.access.commands.TransactionAbortRequest;
import org.opendaylight.controller.cluster.access.commands.TransactionAbortSuccess;
import org.opendaylight.controller.cluster.access.commands.TransactionDelete;
import org.opendaylight.controller.cluster.access.commands.TransactionMerge;
import org.opendaylight.controller.cluster.access.commands.TransactionModification;
import org.opendaylight.controller.cluster.access.commands.TransactionPurgeRequest;
import org.opendaylight.controller.cluster.access.commands.TransactionRequest;
import org.opendaylight.controller.cluster.access.commands.TransactionSuccess;
import org.opendaylight.controller.cluster.access.commands.TransactionWrite;
import org.opendaylight.controller.cluster.access.concepts.ClientIdentifier;
import org.opendaylight.controller.cluster.access.concepts.LocalHistoryIdentifier;
import org.opendaylight.controller.cluster.access.concepts.Request;
import org.opendaylight.controller.cluster.access.concepts.RequestEnvelope;
import org.opendaylight.controller.cluster.access.concepts.RequestSuccess;
import org.opendaylight.controller.cluster.access.concepts.TransactionIdentifier;
import org.opendaylight.controller.cluster.databroker.actors.dds.AbstractClientHistory;
import org.opendaylight.controller.cluster.databroker.actors.dds.AbstractProxyTransaction;
import org.opendaylight.controller.cluster.databroker.actors.dds.LocalReadWriteProxyTransaction;
import org.opendaylight.controller.cluster.databroker.actors.dds.ProxyHistory;
import org.opendaylight.controller.cluster.databroker.actors.dds.RemoteProxyTransaction;
import org.opendaylight.controller.cluster.databroker.actors.dds.ShardBackendInfo;
import org.opendaylight.controller.cluster.databroker.actors.dds.TestUtils;
import org.opendaylight.controller.cluster.databroker.actors.dds.TransactionTester;
import org.opendaylight.controller.cluster.databroker.actors.dds.VotingFuture;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;
import org.opendaylight.yangtools.yang.data.api.schema.ContainerNode;
import org.opendaylight.yangtools.yang.data.api.schema.tree.CursorAwareDataTreeModification;
import org.opendaylight.yangtools.yang.data.api.schema.tree.DataTreeModification;
import org.opendaylight.yangtools.yang.data.api.schema.tree.DataTreeSnapshot;
import org.opendaylight.yangtools.yang.data.impl.schema.Builders;

public abstract class AbstractProxyTransactionTest<T extends AbstractProxyTransaction> {
    protected static final TransactionIdentifier TRANSACTION_ID = TestUtils.TRANSACTION_ID;
    private static final ClientIdentifier CLIENT_ID = TestUtils.CLIENT_ID;
    private static final LocalHistoryIdentifier HISTORY_ID = TestUtils.HISTORY_ID;
    protected static final YangInstanceIdentifier PATH_1 = YangInstanceIdentifier.builder().node(QName.create((String)"ns-1", (String)"node-1")).build();
    protected static final YangInstanceIdentifier PATH_2 = YangInstanceIdentifier.builder().node(QName.create((String)"ns-1", (String)"node-2")).build();
    protected static final YangInstanceIdentifier PATH_3 = YangInstanceIdentifier.builder().node(QName.create((String)"ns-1", (String)"node-3")).build();
    protected static final ContainerNode DATA_1 = (ContainerNode)Builders.containerBuilder().withNodeIdentifier((YangInstanceIdentifier.PathArgument)new YangInstanceIdentifier.NodeIdentifier(PATH_1.getLastPathArgument().getNodeType())).build();
    protected static final ContainerNode DATA_2 = (ContainerNode)Builders.containerBuilder().withNodeIdentifier((YangInstanceIdentifier.PathArgument)new YangInstanceIdentifier.NodeIdentifier(PATH_2.getLastPathArgument().getNodeType())).build();
    protected static final String PERSISTENCE_ID = "per-1";
    @Mock
    private DataTreeSnapshot snapshot;
    @Mock
    private AbstractClientHistory history;
    private ActorSystem system;
    private TestProbe backendProbe;
    private TestProbe clientContextProbe;
    private TransactionTester<T> tester;
    protected ClientActorContext context;
    protected T transaction;

    @Before
    public void setUp() {
        MockitoAnnotations.initMocks((Object)this);
        this.system = ActorSystem.apply();
        this.clientContextProbe = new TestProbe(this.system, "clientContext");
        this.backendProbe = new TestProbe(this.system, "backend");
        this.context = AccessClientUtil.createClientActorContext((ActorSystem)this.system, (ActorRef)this.clientContextProbe.ref(), (ClientIdentifier)CLIENT_ID, (String)PERSISTENCE_ID);
        ShardBackendInfo backend = new ShardBackendInfo(this.backendProbe.ref(), 0L, ABIVersion.BORON, "default", UnsignedLong.ZERO, Optional.empty(), 3);
        ConnectedClientConnection connection = AccessClientUtil.createConnectedConnection((ClientActorContext)this.context, (Long)0L, (BackendInfo)backend);
        ProxyHistory parent = ProxyHistory.createClient((AbstractClientHistory)this.history, (AbstractClientConnection)connection, (LocalHistoryIdentifier)HISTORY_ID);
        this.transaction = this.createTransaction(parent, TestUtils.TRANSACTION_ID, this.snapshot);
        this.tester = new TransactionTester<T>(this.transaction, (AbstractClientConnection<ShardBackendInfo>)connection, this.backendProbe);
    }

    protected abstract T createTransaction(ProxyHistory var1, TransactionIdentifier var2, DataTreeSnapshot var3);

    @After
    public void tearDown() {
        TestKit.shutdownActorSystem((ActorSystem)this.system);
    }

    @Test
    public abstract void testExists() throws Exception;

    @Test
    public abstract void testRead() throws Exception;

    @Test
    public abstract void testWrite();

    @Test
    public abstract void testMerge();

    @Test
    public abstract void testDelete();

    @Test
    public abstract void testDirectCommit() throws Exception;

    @Test
    public abstract void testCanCommit();

    @Test
    public abstract void testPreCommit();

    @Test
    public abstract void testDoCommit();

    @Test
    public abstract void testForwardToRemoteAbort();

    @Test
    public abstract void testForwardToRemoteCommit();

    @Test
    public void testAbortVotingFuture() {
        this.testRequestResponse(f -> this.transaction.abort(f), TransactionAbortRequest.class, TransactionAbortSuccess::new);
    }

    @Test
    public void testForwardToRemotePurge() {
        TestProbe probe = new TestProbe(this.system);
        TransactionPurgeRequest request = new TransactionPurgeRequest(TRANSACTION_ID, 0L, probe.ref());
        this.testForwardToRemote((TransactionRequest<?>)request, (Class)TransactionPurgeRequest.class);
    }

    @Test
    public void testReplayMessages() {
        TestProbe probe = new TestProbe(this.system);
        ArrayList<ConnectionEntry> entries = new ArrayList<ConnectionEntry>();
        Consumer<T> callback = AbstractProxyTransactionTest.createCallbackMock();
        ReadTransactionRequest request1 = new ReadTransactionRequest(TRANSACTION_ID, 2L, probe.ref(), PATH_2, true);
        ExistsTransactionRequest request2 = new ExistsTransactionRequest(TRANSACTION_ID, 3L, probe.ref(), PATH_3, true);
        entries.add(AccessClientUtil.createConnectionEntry((Request)request1, callback, (long)0L));
        entries.add(AccessClientUtil.createConnectionEntry((Request)request2, callback, (long)0L));
        TransactionTester<RemoteProxyTransaction> successor = this.createRemoteProxyTransactionTester();
        AbortLocalTransactionRequest successful1 = new AbortLocalTransactionRequest(TRANSACTION_ID, probe.ref());
        this.transaction.recordSuccessfulRequest((TransactionRequest)successful1);
        ReadTransactionRequest successful2 = new ReadTransactionRequest(TRANSACTION_ID, 1L, probe.ref(), PATH_1, true);
        this.transaction.recordSuccessfulRequest((TransactionRequest)successful2);
        this.transaction.startReconnect();
        ProxyHistory mockSuccessor = (ProxyHistory)Mockito.mock(ProxyHistory.class);
        Mockito.when((Object)mockSuccessor.createTransactionProxy(TRANSACTION_ID, this.transaction.isSnapshotOnly(), false)).thenReturn((Object)successor.getTransaction());
        this.transaction.replayMessages(mockSuccessor, entries);
        ModifyTransactionRequest transformed = successor.expectTransactionRequest(ModifyTransactionRequest.class);
        Assert.assertNotNull((Object)transformed);
        Assert.assertEquals((long)successful1.getSequence(), (long)transformed.getSequence());
        Assert.assertTrue((boolean)transformed.getPersistenceProtocol().isPresent());
        Assert.assertEquals((Object)PersistenceProtocol.ABORT, transformed.getPersistenceProtocol().get());
        ReadTransactionRequest tmpRead = successor.expectTransactionRequest(ReadTransactionRequest.class);
        Assert.assertNotNull((Object)tmpRead);
        Assert.assertEquals((Object)successful2.getTarget(), (Object)tmpRead.getTarget());
        Assert.assertEquals((long)successful2.getSequence(), (long)tmpRead.getSequence());
        Assert.assertEquals((Object)successful2.getPath(), (Object)tmpRead.getPath());
        Assert.assertEquals((Object)successor.localActor(), (Object)tmpRead.getReplyTo());
        tmpRead = successor.expectTransactionRequest(ReadTransactionRequest.class);
        Assert.assertNotNull((Object)tmpRead);
        Assert.assertEquals((Object)request1.getTarget(), (Object)tmpRead.getTarget());
        Assert.assertEquals((long)request1.getSequence(), (long)tmpRead.getSequence());
        Assert.assertEquals((Object)request1.getPath(), (Object)tmpRead.getPath());
        Assert.assertEquals((Object)successor.localActor(), (Object)tmpRead.getReplyTo());
        ExistsTransactionRequest tmpExist = successor.expectTransactionRequest(ExistsTransactionRequest.class);
        Assert.assertNotNull((Object)tmpExist);
        Assert.assertEquals((Object)request2.getTarget(), (Object)tmpExist.getTarget());
        Assert.assertEquals((long)request2.getSequence(), (long)tmpExist.getSequence());
        Assert.assertEquals((Object)request2.getPath(), (Object)tmpExist.getPath());
        Assert.assertEquals((Object)successor.localActor(), (Object)tmpExist.getReplyTo());
    }

    protected void checkModifications(ModifyTransactionRequest modifyRequest) {
        List modifications = modifyRequest.getModifications();
        Assert.assertEquals((long)3L, (long)modifications.size());
        MatcherAssert.assertThat((Object)modifications, (Matcher)CoreMatchers.hasItem((Matcher)CoreMatchers.allOf((Matcher[])new Matcher[]{Is.isA(TransactionWrite.class), AbstractProxyTransactionTest.hasPath(PATH_1)})));
        MatcherAssert.assertThat((Object)modifications, (Matcher)CoreMatchers.hasItem((Matcher)CoreMatchers.allOf((Matcher[])new Matcher[]{Is.isA(TransactionMerge.class), AbstractProxyTransactionTest.hasPath(PATH_2)})));
        MatcherAssert.assertThat((Object)modifications, (Matcher)CoreMatchers.hasItem((Matcher)CoreMatchers.allOf((Matcher[])new Matcher[]{Is.isA(TransactionDelete.class), AbstractProxyTransactionTest.hasPath(PATH_3)})));
    }

    protected <R extends TransactionRequest<R>> void testRequestResponse(Consumer<VotingFuture<Void>> consumer, Class<R> expectedRequest, BiFunction<TransactionIdentifier, Long, TransactionSuccess<?>> replySupplier) {
        TransactionTester<T> tester = this.getTester();
        VotingFuture future = (VotingFuture)Mockito.mock(VotingFuture.class);
        this.transaction.seal();
        consumer.accept((VotingFuture<Void>)future);
        R req = tester.expectTransactionRequest(expectedRequest);
        tester.replySuccess((RequestSuccess)replySupplier.apply(TRANSACTION_ID, req.getSequence()));
        ((VotingFuture)Mockito.verify((Object)future)).voteYes();
    }

    protected <R extends TransactionRequest<R>> R testHandleForwardedRemoteRequest(R request) {
        this.transaction.handleReplayedRemoteRequest(request, AbstractProxyTransactionTest.createCallbackMock(), Ticker.systemTicker().read());
        RequestEnvelope envelope = (RequestEnvelope)this.backendProbe.expectMsgClass(RequestEnvelope.class);
        TransactionRequest received = (TransactionRequest)envelope.getMessage();
        Assert.assertTrue((boolean)received.getClass().equals(request.getClass()));
        Assert.assertEquals((Object)TRANSACTION_ID, (Object)received.getTarget());
        Assert.assertEquals((Object)this.clientContextProbe.ref(), (Object)received.getReplyTo());
        return (R)received;
    }

    protected <R extends TransactionRequest<R>> R testForwardToRemote(TransactionRequest<?> toForward, Class<R> expectedMessageClass) {
        Consumer<T> callback = AbstractProxyTransactionTest.createCallbackMock();
        TransactionTester<RemoteProxyTransaction> transactionTester = this.createRemoteProxyTransactionTester();
        RemoteProxyTransaction successor = transactionTester.getTransaction();
        this.transaction.forwardToRemote(successor, toForward, callback);
        return transactionTester.expectTransactionRequest(expectedMessageClass);
    }

    protected TransactionTester<T> getTester() {
        return this.tester;
    }

    protected static <T> Consumer<T> createCallbackMock() {
        return (Consumer)Mockito.mock(Consumer.class);
    }

    protected static BaseMatcher<TransactionModification> hasPath(final YangInstanceIdentifier path) {
        return new BaseMatcher<TransactionModification>(){

            public boolean matches(Object item) {
                return path.equals((Object)((TransactionModification)item).getPath());
            }

            public void describeTo(Description description) {
                description.appendValue((Object)path);
            }

            public void describeMismatch(Object item, Description description) {
                TransactionModification modification = (TransactionModification)item;
                description.appendText("was ").appendValue((Object)modification.getPath());
            }
        };
    }

    protected TestProbe createProbe() {
        return new TestProbe(this.system);
    }

    protected TransactionTester<LocalReadWriteProxyTransaction> createLocalProxy() {
        TestProbe backendProbe = new TestProbe(this.system, "backend2");
        TestProbe clientContextProbe = new TestProbe(this.system, "clientContext2");
        ClientActorContext context = AccessClientUtil.createClientActorContext((ActorSystem)this.system, (ActorRef)clientContextProbe.ref(), (ClientIdentifier)CLIENT_ID, (String)PERSISTENCE_ID);
        ShardBackendInfo backend = new ShardBackendInfo(backendProbe.ref(), 0L, ABIVersion.BORON, "default", UnsignedLong.ZERO, Optional.empty(), 3);
        ConnectedClientConnection connection = AccessClientUtil.createConnectedConnection((ClientActorContext)context, (Long)0L, (BackendInfo)backend);
        AbstractClientHistory history = (AbstractClientHistory)Mockito.mock(AbstractClientHistory.class);
        ProxyHistory parent = ProxyHistory.createClient((AbstractClientHistory)history, (AbstractClientConnection)connection, (LocalHistoryIdentifier)HISTORY_ID);
        DataTreeSnapshot snapshot = (DataTreeSnapshot)Mockito.mock(DataTreeSnapshot.class);
        Mockito.when((Object)snapshot.newModification()).thenReturn((Object)((DataTreeModification)Mockito.mock(CursorAwareDataTreeModification.class)));
        LocalReadWriteProxyTransaction tx = new LocalReadWriteProxyTransaction(parent, TestUtils.TRANSACTION_ID, snapshot);
        return new TransactionTester<LocalReadWriteProxyTransaction>(tx, (AbstractClientConnection<ShardBackendInfo>)connection, backendProbe);
    }

    protected TransactionTester<RemoteProxyTransaction> createRemoteProxyTransactionTester() {
        TestProbe clientContextProbe = new TestProbe(this.system, "remoteClientContext");
        TestProbe backendProbe = new TestProbe(this.system, "remoteBackend");
        AbstractClientHistory history = (AbstractClientHistory)Mockito.mock(AbstractClientHistory.class);
        ClientActorContext context = AccessClientUtil.createClientActorContext((ActorSystem)this.system, (ActorRef)clientContextProbe.ref(), (ClientIdentifier)CLIENT_ID, (String)PERSISTENCE_ID);
        ShardBackendInfo backend = new ShardBackendInfo(backendProbe.ref(), 0L, ABIVersion.BORON, "default", UnsignedLong.ZERO, Optional.empty(), 5);
        ConnectedClientConnection connection = AccessClientUtil.createConnectedConnection((ClientActorContext)context, (Long)0L, (BackendInfo)backend);
        ProxyHistory proxyHistory = ProxyHistory.createClient((AbstractClientHistory)history, (AbstractClientConnection)connection, (LocalHistoryIdentifier)HISTORY_ID);
        RemoteProxyTransaction transaction = new RemoteProxyTransaction(proxyHistory, TRANSACTION_ID, false, false, false);
        return new TransactionTester<RemoteProxyTransaction>(transaction, (AbstractClientConnection<ShardBackendInfo>)connection, backendProbe);
    }
}

