/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.cluster.databroker.actors.dds;

import akka.actor.ActorRef;
import akka.actor.ActorSystem;
import akka.testkit.TestProbe;
import akka.testkit.javadsl.TestKit;
import com.google.common.primitives.UnsignedLong;
import com.google.common.util.concurrent.ListenableFuture;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.ExecutionException;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.junit.MockitoJUnitRunner;
import org.opendaylight.controller.cluster.access.ABIVersion;
import org.opendaylight.controller.cluster.access.client.AbstractClientConnection;
import org.opendaylight.controller.cluster.access.client.AccessClientUtil;
import org.opendaylight.controller.cluster.access.client.BackendInfo;
import org.opendaylight.controller.cluster.access.client.ClientActorContext;
import org.opendaylight.controller.cluster.access.client.ConnectedClientConnection;
import org.opendaylight.controller.cluster.access.commands.ModifyTransactionRequest;
import org.opendaylight.controller.cluster.access.commands.PersistenceProtocol;
import org.opendaylight.controller.cluster.access.commands.TransactionAbortRequest;
import org.opendaylight.controller.cluster.access.commands.TransactionAbortSuccess;
import org.opendaylight.controller.cluster.access.commands.TransactionCanCommitSuccess;
import org.opendaylight.controller.cluster.access.commands.TransactionCommitSuccess;
import org.opendaylight.controller.cluster.access.commands.TransactionDoCommitRequest;
import org.opendaylight.controller.cluster.access.commands.TransactionPreCommitRequest;
import org.opendaylight.controller.cluster.access.commands.TransactionPreCommitSuccess;
import org.opendaylight.controller.cluster.access.concepts.ClientIdentifier;
import org.opendaylight.controller.cluster.access.concepts.LocalHistoryIdentifier;
import org.opendaylight.controller.cluster.access.concepts.RequestException;
import org.opendaylight.controller.cluster.access.concepts.RequestSuccess;
import org.opendaylight.controller.cluster.access.concepts.RuntimeRequestException;
import org.opendaylight.controller.cluster.access.concepts.TransactionIdentifier;
import org.opendaylight.controller.cluster.databroker.actors.dds.AbstractClientHistory;
import org.opendaylight.controller.cluster.databroker.actors.dds.AbstractProxyTransaction;
import org.opendaylight.controller.cluster.databroker.actors.dds.ClientTransactionCommitCohort;
import org.opendaylight.controller.cluster.databroker.actors.dds.ProxyHistory;
import org.opendaylight.controller.cluster.databroker.actors.dds.RemoteProxyTransaction;
import org.opendaylight.controller.cluster.databroker.actors.dds.ShardBackendInfo;
import org.opendaylight.controller.cluster.databroker.actors.dds.TestUtils;
import org.opendaylight.controller.cluster.databroker.actors.dds.TransactionTester;

@RunWith(value=MockitoJUnitRunner.StrictStubs.class)
public class ClientTransactionCommitCohortTest {
    private static final String PERSISTENCE_ID = "per-1";
    private static final int TRANSACTIONS = 3;
    @Mock
    private AbstractClientHistory history;
    private ActorSystem system;
    private List<TransactionTester<RemoteProxyTransaction>> transactions;
    private ClientTransactionCommitCohort cohort;

    @Before
    public void setUp() {
        this.system = ActorSystem.apply();
        TestProbe clientContextProbe = new TestProbe(this.system, "clientContext");
        ClientActorContext context = AccessClientUtil.createClientActorContext((ActorSystem)this.system, (ActorRef)clientContextProbe.ref(), (ClientIdentifier)TestUtils.CLIENT_ID, (String)PERSISTENCE_ID);
        this.transactions = new ArrayList<TransactionTester<RemoteProxyTransaction>>();
        for (int i = 0; i < 3; ++i) {
            this.transactions.add(ClientTransactionCommitCohortTest.createTransactionTester(new TestProbe(this.system, "backend" + i), context, this.history));
        }
        Collection proxies = this.transactions.stream().map(TransactionTester::getTransaction).collect(Collectors.toList());
        proxies.forEach(AbstractProxyTransaction::seal);
        this.cohort = new ClientTransactionCommitCohort(this.history, TestUtils.TRANSACTION_ID, proxies);
    }

    @After
    public void tearDown() {
        TestKit.shutdownActorSystem((ActorSystem)this.system);
    }

    @Test
    public void testCanCommit() throws Exception {
        this.testOpSuccess(ClientTransactionCommitCohort::canCommit, this::expectCanCommit, this::replyCanCommitSuccess, Boolean.TRUE);
    }

    @Test
    public void testCanCommitFail() throws Exception {
        this.testOpFail(ClientTransactionCommitCohort::canCommit, this::expectCanCommit, this::replyCanCommitSuccess);
    }

    @Test
    public void testPreCommit() throws Exception {
        this.testOpSuccess(ClientTransactionCommitCohort::preCommit, this::expectPreCommit, this::replyPreCommitSuccess, null);
    }

    @Test
    public void testPreCommitFail() throws Exception {
        this.testOpFail(ClientTransactionCommitCohort::preCommit, this::expectPreCommit, this::replyPreCommitSuccess);
    }

    @Test
    public void testCommit() throws Exception {
        this.testOpSuccess(ClientTransactionCommitCohort::commit, this::expectCommit, this::replyCommitSuccess, null);
    }

    @Test
    public void testCommitFail() throws Exception {
        this.testOpFail(ClientTransactionCommitCohort::commit, this::expectCommit, this::replyCommitSuccess);
    }

    @Test
    public void testAbort() throws Exception {
        this.testOpSuccess(ClientTransactionCommitCohort::abort, this::expectAbort, this::replyAbortSuccess, null);
    }

    @Test
    public void testAbortFail() throws Exception {
        this.testOpFail(ClientTransactionCommitCohort::abort, this::expectAbort, this::replyAbortSuccess);
    }

    private void expectCanCommit(TransactionTester<RemoteProxyTransaction> tester) {
        ModifyTransactionRequest request = tester.expectTransactionRequest(ModifyTransactionRequest.class);
        Assert.assertEquals(Optional.of(PersistenceProtocol.THREE_PHASE), (Object)request.getPersistenceProtocol());
    }

    void expectPreCommit(TransactionTester<?> tester) {
        tester.expectTransactionRequest(TransactionPreCommitRequest.class);
    }

    void expectCommit(TransactionTester<?> tester) {
        tester.expectTransactionRequest(TransactionDoCommitRequest.class);
    }

    void expectAbort(TransactionTester<?> tester) {
        tester.expectTransactionRequest(TransactionAbortRequest.class);
    }

    void replyCanCommitSuccess(TransactionTester<?> tester) {
        TransactionCanCommitSuccess success = new TransactionCanCommitSuccess((TransactionIdentifier)tester.getTransaction().getIdentifier(), tester.getLastReceivedMessage().getSequence());
        tester.replySuccess((RequestSuccess<?, ?>)success);
    }

    void replyPreCommitSuccess(TransactionTester<?> tester) {
        TransactionPreCommitSuccess success = new TransactionPreCommitSuccess((TransactionIdentifier)tester.getTransaction().getIdentifier(), tester.getLastReceivedMessage().getSequence());
        tester.replySuccess((RequestSuccess<?, ?>)success);
    }

    void replyCommitSuccess(TransactionTester<?> tester) {
        TransactionCommitSuccess success = new TransactionCommitSuccess((TransactionIdentifier)tester.getTransaction().getIdentifier(), tester.getLastReceivedMessage().getSequence());
        tester.replySuccess((RequestSuccess<?, ?>)success);
    }

    void replyAbortSuccess(TransactionTester<?> tester) {
        TransactionAbortSuccess success = new TransactionAbortSuccess((TransactionIdentifier)tester.getTransaction().getIdentifier(), tester.getLastReceivedMessage().getSequence());
        tester.replySuccess((RequestSuccess<?, ?>)success);
    }

    private static TransactionTester<RemoteProxyTransaction> createTransactionTester(TestProbe backendProbe, ClientActorContext context, AbstractClientHistory history) {
        ShardBackendInfo backend = new ShardBackendInfo(backendProbe.ref(), 0L, ABIVersion.BORON, "default", UnsignedLong.ZERO, Optional.empty(), 3);
        ConnectedClientConnection connection = AccessClientUtil.createConnectedConnection((ClientActorContext)context, (Long)0L, (BackendInfo)backend);
        ProxyHistory proxyHistory = ProxyHistory.createClient((AbstractClientHistory)history, (AbstractClientConnection)connection, (LocalHistoryIdentifier)TestUtils.HISTORY_ID);
        RemoteProxyTransaction transaction = new RemoteProxyTransaction(proxyHistory, TestUtils.TRANSACTION_ID, false, false, false);
        return new TransactionTester<RemoteProxyTransaction>(transaction, (AbstractClientConnection<ShardBackendInfo>)connection, backendProbe);
    }

    private static <T extends TransactionTester<?>> void replySuccess(Collection<T> transactions, Consumer<T> expect, Consumer<T> reply) {
        for (TransactionTester transaction : transactions) {
            expect.accept(transaction);
            reply.accept(transaction);
        }
    }

    private <T> void testOpSuccess(Function<ClientTransactionCommitCohort, ListenableFuture<T>> operation, Consumer<TransactionTester<RemoteProxyTransaction>> expectFunction, Consumer<TransactionTester<RemoteProxyTransaction>> replyFunction, T expectedResult) throws Exception {
        ListenableFuture<T> result = operation.apply(this.cohort);
        ClientTransactionCommitCohortTest.replySuccess(this.transactions, expectFunction, replyFunction);
        Assert.assertEquals(expectedResult, TestUtils.getWithTimeout(result));
    }

    private <T> void testOpFail(Function<ClientTransactionCommitCohort, ListenableFuture<T>> operation, Consumer<TransactionTester<RemoteProxyTransaction>> expectFunction, Consumer<TransactionTester<RemoteProxyTransaction>> replyFunction) throws Exception {
        ListenableFuture canCommit = operation.apply(this.cohort);
        ClientTransactionCommitCohortTest.replySuccess(this.transactions.subList(0, this.transactions.size() - 1), expectFunction, replyFunction);
        TransactionTester<RemoteProxyTransaction> last = this.transactions.get(this.transactions.size() - 1);
        expectFunction.accept(last);
        RuntimeException e = new RuntimeException();
        RuntimeRequestException cause = new RuntimeRequestException("fail", (Throwable)e);
        last.replyFailure((RequestException)cause);
        ExecutionException exception = TestUtils.assertOperationThrowsException(() -> TestUtils.getWithTimeout(canCommit), ExecutionException.class);
        Assert.assertEquals((Object)e, (Object)exception.getCause());
    }
}

