/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.cluster.databroker.actors.dds;

import akka.testkit.TestProbe;
import com.google.common.util.concurrent.FluentFuture;
import com.google.common.util.concurrent.ListenableFuture;
import java.util.List;
import java.util.Optional;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Assert;
import org.junit.Test;
import org.opendaylight.controller.cluster.access.commands.ExistsTransactionRequest;
import org.opendaylight.controller.cluster.access.commands.ExistsTransactionSuccess;
import org.opendaylight.controller.cluster.access.commands.ModifyTransactionRequest;
import org.opendaylight.controller.cluster.access.commands.ModifyTransactionRequestBuilder;
import org.opendaylight.controller.cluster.access.commands.PersistenceProtocol;
import org.opendaylight.controller.cluster.access.commands.ReadTransactionRequest;
import org.opendaylight.controller.cluster.access.commands.ReadTransactionSuccess;
import org.opendaylight.controller.cluster.access.commands.TransactionAbortRequest;
import org.opendaylight.controller.cluster.access.commands.TransactionCanCommitSuccess;
import org.opendaylight.controller.cluster.access.commands.TransactionCommitSuccess;
import org.opendaylight.controller.cluster.access.commands.TransactionDelete;
import org.opendaylight.controller.cluster.access.commands.TransactionDoCommitRequest;
import org.opendaylight.controller.cluster.access.commands.TransactionMerge;
import org.opendaylight.controller.cluster.access.commands.TransactionModification;
import org.opendaylight.controller.cluster.access.commands.TransactionPreCommitRequest;
import org.opendaylight.controller.cluster.access.commands.TransactionPreCommitSuccess;
import org.opendaylight.controller.cluster.access.commands.TransactionRequest;
import org.opendaylight.controller.cluster.access.commands.TransactionWrite;
import org.opendaylight.controller.cluster.access.concepts.RequestSuccess;
import org.opendaylight.controller.cluster.access.concepts.TransactionIdentifier;
import org.opendaylight.controller.cluster.databroker.actors.dds.AbstractProxyTransactionTest;
import org.opendaylight.controller.cluster.databroker.actors.dds.ProxyHistory;
import org.opendaylight.controller.cluster.databroker.actors.dds.RemoteProxyTransaction;
import org.opendaylight.controller.cluster.databroker.actors.dds.TestUtils;
import org.opendaylight.controller.cluster.databroker.actors.dds.TransactionTester;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;
import org.opendaylight.yangtools.yang.data.api.schema.ContainerNode;
import org.opendaylight.yangtools.yang.data.api.schema.NormalizedNode;
import org.opendaylight.yangtools.yang.data.api.schema.tree.DataTreeSnapshot;

public class RemoteProxyTransactionTest
extends AbstractProxyTransactionTest<RemoteProxyTransaction> {
    @Override
    protected RemoteProxyTransaction createTransaction(ProxyHistory parent, TransactionIdentifier id, DataTreeSnapshot snapshot) {
        return new RemoteProxyTransaction(parent, TRANSACTION_ID, false, false, false);
    }

    @Override
    @Test
    public void testExists() throws Exception {
        TransactionTester tester = this.getTester();
        FluentFuture exists = ((RemoteProxyTransaction)this.transaction).exists(PATH_1);
        ExistsTransactionRequest req = tester.expectTransactionRequest(ExistsTransactionRequest.class);
        boolean existsResult = true;
        tester.replySuccess((RequestSuccess<?, ?>)new ExistsTransactionSuccess(TRANSACTION_ID, req.getSequence(), true));
        TestUtils.assertFutureEquals(true, exists);
    }

    @Override
    @Test
    public void testRead() throws Exception {
        TransactionTester tester = this.getTester();
        FluentFuture read = ((RemoteProxyTransaction)this.transaction).read(PATH_2);
        ReadTransactionRequest req = tester.expectTransactionRequest(ReadTransactionRequest.class);
        Optional<ContainerNode> result = Optional.of(DATA_1);
        tester.replySuccess((RequestSuccess<?, ?>)new ReadTransactionSuccess(TRANSACTION_ID, req.getSequence(), result));
        TestUtils.assertFutureEquals(result, read);
    }

    @Override
    @Test
    public void testWrite() {
        YangInstanceIdentifier path = PATH_1;
        this.testModification(() -> ((RemoteProxyTransaction)this.transaction).write(path, (NormalizedNode)DATA_1), TransactionWrite.class, path);
    }

    @Override
    @Test
    public void testMerge() {
        YangInstanceIdentifier path = PATH_2;
        this.testModification(() -> ((RemoteProxyTransaction)this.transaction).merge(path, (NormalizedNode)DATA_2), TransactionMerge.class, path);
    }

    @Override
    @Test
    public void testDelete() {
        YangInstanceIdentifier path = PATH_3;
        this.testModification(() -> ((RemoteProxyTransaction)this.transaction).delete(path), TransactionDelete.class, path);
    }

    @Override
    @Test
    public void testDirectCommit() throws Exception {
        ((RemoteProxyTransaction)this.transaction).seal();
        ListenableFuture result = ((RemoteProxyTransaction)this.transaction).directCommit();
        TransactionTester tester = this.getTester();
        ModifyTransactionRequest req = tester.expectTransactionRequest(ModifyTransactionRequest.class);
        Assert.assertTrue((boolean)req.getPersistenceProtocol().isPresent());
        Assert.assertEquals((Object)PersistenceProtocol.SIMPLE, req.getPersistenceProtocol().get());
        tester.replySuccess((RequestSuccess<?, ?>)new TransactionCommitSuccess(TRANSACTION_ID, req.getSequence()));
        TestUtils.assertFutureEquals(true, result);
    }

    @Override
    @Test
    public void testCanCommit() {
        this.testRequestResponse(arg_0 -> ((RemoteProxyTransaction)((RemoteProxyTransaction)this.transaction)).canCommit(arg_0), ModifyTransactionRequest.class, TransactionCanCommitSuccess::new);
    }

    @Override
    @Test
    public void testPreCommit() {
        this.testRequestResponse(arg_0 -> ((RemoteProxyTransaction)((RemoteProxyTransaction)this.transaction)).preCommit(arg_0), TransactionPreCommitRequest.class, TransactionPreCommitSuccess::new);
    }

    @Override
    @Test
    public void testDoCommit() {
        this.testRequestResponse(arg_0 -> ((RemoteProxyTransaction)((RemoteProxyTransaction)this.transaction)).doCommit(arg_0), TransactionDoCommitRequest.class, TransactionCommitSuccess::new);
    }

    @Override
    @Test
    public void testForwardToRemoteAbort() {
        TestProbe probe = this.createProbe();
        TransactionAbortRequest request = new TransactionAbortRequest(TRANSACTION_ID, 0L, probe.ref());
        this.testForwardToRemote((TransactionRequest<?>)request, TransactionAbortRequest.class);
    }

    @Override
    public void testForwardToRemoteCommit() {
        TestProbe probe = this.createProbe();
        TransactionAbortRequest request = new TransactionAbortRequest(TRANSACTION_ID, 0L, probe.ref());
        this.testForwardToRemote((TransactionRequest<?>)request, TransactionAbortRequest.class);
    }

    @Test
    public void testForwardToRemoteModifyCommitSimple() {
        TestProbe probe = this.createProbe();
        ModifyTransactionRequestBuilder builder = new ModifyTransactionRequestBuilder(TRANSACTION_ID, probe.ref());
        builder.setSequence(0L);
        builder.setCommit(false);
        ModifyTransactionRequest request = builder.build();
        ModifyTransactionRequest received = this.testForwardToRemote((TransactionRequest<?>)request, ModifyTransactionRequest.class);
        Assert.assertEquals((Object)request.getPersistenceProtocol(), (Object)received.getPersistenceProtocol());
        Assert.assertEquals((Object)request.getModifications(), (Object)received.getModifications());
        Assert.assertEquals((Object)request.getTarget(), (Object)received.getTarget());
    }

    @Test
    public void testForwardToRemoteModifyCommit3Phase() {
        TestProbe probe = this.createProbe();
        ModifyTransactionRequestBuilder builder = new ModifyTransactionRequestBuilder(TRANSACTION_ID, probe.ref());
        builder.setSequence(0L);
        builder.setCommit(true);
        ModifyTransactionRequest request = builder.build();
        ModifyTransactionRequest received = this.testForwardToRemote((TransactionRequest<?>)request, ModifyTransactionRequest.class);
        Assert.assertEquals((Object)request.getPersistenceProtocol(), (Object)received.getPersistenceProtocol());
        Assert.assertEquals((Object)request.getModifications(), (Object)received.getModifications());
        Assert.assertEquals((Object)request.getTarget(), (Object)received.getTarget());
    }

    @Test
    public void testForwardToRemoteModifyAbort() {
        TestProbe probe = this.createProbe();
        ModifyTransactionRequestBuilder builder = new ModifyTransactionRequestBuilder(TRANSACTION_ID, probe.ref());
        builder.setSequence(0L);
        builder.setAbort();
        ModifyTransactionRequest request = builder.build();
        ModifyTransactionRequest received = this.testForwardToRemote((TransactionRequest<?>)request, ModifyTransactionRequest.class);
        Assert.assertEquals((Object)request.getTarget(), (Object)received.getTarget());
        Assert.assertTrue((boolean)received.getPersistenceProtocol().isPresent());
        Assert.assertEquals((Object)PersistenceProtocol.ABORT, received.getPersistenceProtocol().get());
    }

    @Test
    public void testForwardToRemoteModifyRead() {
        TestProbe probe = this.createProbe();
        ReadTransactionRequest request = new ReadTransactionRequest(TRANSACTION_ID, 0L, probe.ref(), PATH_1, false);
        ReadTransactionRequest received = this.testForwardToRemote((TransactionRequest<?>)request, ReadTransactionRequest.class);
        Assert.assertEquals((Object)request.getTarget(), (Object)received.getTarget());
        Assert.assertEquals((Object)request.getPath(), (Object)received.getPath());
    }

    @Test
    public void testForwardToRemoteModifyExists() {
        TestProbe probe = this.createProbe();
        ExistsTransactionRequest request = new ExistsTransactionRequest(TRANSACTION_ID, 0L, probe.ref(), PATH_1, false);
        ExistsTransactionRequest received = this.testForwardToRemote((TransactionRequest<?>)request, ExistsTransactionRequest.class);
        Assert.assertEquals((Object)request.getTarget(), (Object)received.getTarget());
        Assert.assertEquals((Object)request.getPath(), (Object)received.getPath());
    }

    @Test
    public void testForwardToRemoteModifyPreCommit() {
        TestProbe probe = this.createProbe();
        TransactionPreCommitRequest request = new TransactionPreCommitRequest(TRANSACTION_ID, 0L, probe.ref());
        TransactionPreCommitRequest received = this.testForwardToRemote((TransactionRequest<?>)request, TransactionPreCommitRequest.class);
        Assert.assertEquals((Object)request.getTarget(), (Object)received.getTarget());
    }

    @Test
    public void testForwardToRemoteModifyDoCommit() {
        TestProbe probe = this.createProbe();
        TransactionDoCommitRequest request = new TransactionDoCommitRequest(TRANSACTION_ID, 0L, probe.ref());
        TransactionDoCommitRequest received = this.testForwardToRemote((TransactionRequest<?>)request, TransactionDoCommitRequest.class);
        Assert.assertEquals((Object)request.getTarget(), (Object)received.getTarget());
    }

    private <T extends TransactionModification> void testModification(Runnable modification, Class<T> cls, YangInstanceIdentifier expectedPath) {
        modification.run();
        ModifyTransactionRequest request = ((RemoteProxyTransaction)this.transaction).commitRequest(false);
        List modifications = request.getModifications();
        Assert.assertEquals((long)1L, (long)modifications.size());
        MatcherAssert.assertThat((Object)modifications, (Matcher)CoreMatchers.hasItem((Matcher)CoreMatchers.both((Matcher)CoreMatchers.isA(cls)).and(RemoteProxyTransactionTest.hasPath(expectedPath))));
    }
}

