/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.cluster.databroker.actors.dds;

import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.opendaylight.controller.cluster.databroker.actors.dds.TestUtils;
import org.opendaylight.controller.cluster.databroker.actors.dds.VotingFuture;

public class VotingFutureTest {
    private Object result;
    private ScheduledExecutorService executor;
    private VotingFuture<Object> future;

    @Before
    public void setUp() {
        this.result = new Object();
        this.future = new VotingFuture(this.result, 3);
        this.executor = Executors.newScheduledThreadPool(1);
    }

    @After
    public void tearDown() {
        this.executor.shutdownNow();
    }

    @Test
    public void testTrivialCases() throws Exception {
        VotingFuture oneYesVoteFuture = new VotingFuture(this.result, 1);
        oneYesVoteFuture.voteYes();
        TestUtils.assertFutureEquals(this.result, oneYesVoteFuture);
        VotingFuture oneNoVoteFuture = new VotingFuture(this.result, 1);
        RuntimeException cause = new RuntimeException("fail");
        oneNoVoteFuture.voteNo((Throwable)cause);
        VotingFutureTest.checkException((Future<Object>)oneNoVoteFuture, cause);
    }

    @Test
    public void testVoteYes() throws Exception {
        this.future.voteYes();
        this.future.voteYes();
        this.future.voteYes();
        TestUtils.assertFutureEquals(this.result, this.future);
    }

    @Test
    public void testVoteYesBlocking() throws Exception {
        AtomicBoolean voted = new AtomicBoolean(false);
        this.future.voteYes();
        this.future.voteYes();
        this.executor.schedule(() -> {
            voted.set(true);
            this.future.voteYes();
        }, 1L, TimeUnit.SECONDS);
        TestUtils.assertFutureEquals(this.result, this.future);
        Assert.assertTrue((String)"Future completed before vote", (boolean)voted.get());
    }

    @Test
    public void testVoteNo() throws Exception {
        this.future.voteYes();
        RuntimeException cause = new RuntimeException("fail");
        this.future.voteNo((Throwable)cause);
        this.future.voteYes();
        VotingFutureTest.checkException(this.future, cause);
    }

    @Test
    public void testVoteNoFirst() throws Exception {
        RuntimeException cause = new RuntimeException("fail");
        this.future.voteNo((Throwable)cause);
        this.future.voteYes();
        this.future.voteYes();
        VotingFutureTest.checkException(this.future, cause);
    }

    @Test
    public void testVoteNoLast() throws Exception {
        this.future.voteYes();
        this.future.voteYes();
        RuntimeException cause = new RuntimeException("fail");
        this.future.voteNo((Throwable)cause);
        VotingFutureTest.checkException(this.future, cause);
    }

    @Test
    public void testVoteNoBlocking() throws Exception {
        AtomicBoolean voted = new AtomicBoolean(false);
        this.future.voteYes();
        RuntimeException cause = new RuntimeException("fail");
        this.future.voteNo((Throwable)cause);
        this.executor.schedule(() -> {
            voted.set(true);
            this.future.voteYes();
        }, 1L, TimeUnit.SECONDS);
        VotingFutureTest.checkException(this.future, cause);
        Assert.assertTrue((String)"Future completed before vote", (boolean)voted.get());
    }

    @Test
    public void testMultipleVoteNo() throws Exception {
        this.future.voteYes();
        RuntimeException cause1 = new RuntimeException("fail");
        RuntimeException cause2 = new RuntimeException("fail");
        this.future.voteNo((Throwable)cause1);
        this.future.voteNo((Throwable)cause2);
        ExecutionException thrown = TestUtils.assertOperationThrowsException(() -> TestUtils.getWithTimeout(this.future), ExecutionException.class);
        Assert.assertEquals((Object)cause1, (Object)thrown.getCause());
        Throwable[] suppressed = thrown.getCause().getSuppressed();
        Assert.assertEquals((long)1L, (long)suppressed.length);
        Assert.assertEquals((Object)cause2, (Object)suppressed[0]);
    }

    private static void checkException(Future<Object> future, RuntimeException cause) throws Exception {
        ExecutionException thrown = TestUtils.assertOperationThrowsException(() -> TestUtils.getWithTimeout(future), ExecutionException.class);
        Assert.assertEquals((Object)cause, (Object)thrown.getCause());
    }
}

