/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.cluster.datastore;

import akka.actor.ActorRef;
import akka.actor.PoisonPill;
import akka.actor.Props;
import com.google.common.util.concurrent.SettableFuture;
import java.util.concurrent.TimeUnit;
import org.junit.After;
import org.junit.Before;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;
import org.opendaylight.controller.cluster.access.concepts.MemberName;
import org.opendaylight.controller.cluster.datastore.AbstractClusterRefActorTest;
import org.opendaylight.controller.cluster.datastore.AbstractDataStore;
import org.opendaylight.controller.cluster.datastore.DatastoreContext;
import org.opendaylight.controller.cluster.datastore.DistributedDataStore;
import org.opendaylight.controller.cluster.datastore.config.Configuration;
import org.opendaylight.controller.cluster.datastore.identifiers.ShardIdentifier;
import org.opendaylight.controller.cluster.datastore.shardmanager.ShardManagerTest;
import org.opendaylight.controller.cluster.raft.TestActorFactory;
import org.opendaylight.controller.cluster.raft.utils.InMemoryJournal;
import org.opendaylight.controller.cluster.raft.utils.InMemorySnapshotStore;
import org.opendaylight.controller.cluster.raft.utils.MessageCollectorActor;

public class AbstractShardManagerTest
extends AbstractClusterRefActorTest {
    protected static final MemberName MEMBER_1 = MemberName.forName((String)"member-1");
    protected static int ID_COUNTER = 1;
    protected static ActorRef mockShardActor;
    protected static ShardIdentifier mockShardName;
    protected final String shardMrgIDSuffix = "config" + ID_COUNTER++;
    protected final TestActorFactory actorFactory = new TestActorFactory(AbstractShardManagerTest.getSystem());
    protected final DatastoreContext.Builder datastoreContextBuilder = DatastoreContext.newBuilder().dataStoreName(this.shardMrgIDSuffix).shardInitializationTimeout(600L, TimeUnit.MILLISECONDS).shardHeartbeatIntervalInMillis(100).shardElectionTimeoutFactor(6L);
    protected static SettableFuture<Void> ready;

    protected ShardManagerTest.TestShardManager.Builder newTestShardMgrBuilder() {
        return (ShardManagerTest.TestShardManager.Builder)ShardManagerTest.TestShardManager.builder(this.datastoreContextBuilder).distributedDataStore((AbstractDataStore)Mockito.mock(DistributedDataStore.class));
    }

    protected ShardManagerTest.TestShardManager.Builder newTestShardMgrBuilder(Configuration config) {
        return (ShardManagerTest.TestShardManager.Builder)((ShardManagerTest.TestShardManager.Builder)ShardManagerTest.TestShardManager.builder(this.datastoreContextBuilder).configuration(config)).distributedDataStore((AbstractDataStore)Mockito.mock(DistributedDataStore.class));
    }

    protected Props newShardMgrProps(Configuration config) {
        return ((ShardManagerTest.TestShardManager.Builder)this.newTestShardMgrBuilder(config).readinessFuture(ready)).props();
    }

    @Before
    public void setUp() {
        MockitoAnnotations.initMocks((Object)this);
        ready = SettableFuture.create();
        InMemoryJournal.clear();
        InMemorySnapshotStore.clear();
        if (mockShardActor == null) {
            mockShardName = ShardIdentifier.create((String)"default", (MemberName)MEMBER_1, (String)"config");
            mockShardActor = AbstractShardManagerTest.getSystem().actorOf(MessageCollectorActor.props(), mockShardName.toString());
        }
        MessageCollectorActor.clearMessages((ActorRef)mockShardActor);
    }

    @After
    public void tearDown() {
        InMemoryJournal.clear();
        InMemorySnapshotStore.clear();
        mockShardActor.tell((Object)PoisonPill.getInstance(), ActorRef.noSender());
        mockShardActor = null;
        this.actorFactory.close();
    }
}

