/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.cluster.datastore;

import java.util.concurrent.TimeUnit;
import org.junit.Assert;
import org.junit.Test;
import org.opendaylight.controller.cluster.datastore.DatastoreContext;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.config.distributed.datastore.provider.rev140612.DataStoreProperties;

public class DatastoreContextTest {
    @Test
    public void testNewBuilderWithDefaultSettings() {
        DatastoreContext context = DatastoreContext.newBuilder().build();
        Assert.assertEquals((Object)DatastoreContext.DEFAULT_SHARD_TRANSACTION_IDLE_TIMEOUT, (Object)context.getShardTransactionIdleTimeout());
        Assert.assertEquals((long)5000L, (long)context.getOperationTimeoutInMillis());
        Assert.assertEquals((long)30L, (long)context.getShardTransactionCommitTimeoutInSeconds());
        Assert.assertEquals((long)1L, (long)context.getShardRaftConfig().getJournalRecoveryLogBatchSize());
        Assert.assertEquals((long)20000L, (long)context.getShardRaftConfig().getSnapshotBatchCount());
        Assert.assertEquals((long)500L, (long)context.getShardRaftConfig().getHeartBeatInterval().length());
        Assert.assertEquals((long)50000L, (long)context.getShardTransactionCommitQueueCapacity());
        Assert.assertEquals((long)DatastoreContext.DEFAULT_SHARD_INITIALIZATION_TIMEOUT.duration().toMillis(), (long)context.getShardInitializationTimeout().duration().toMillis());
        Assert.assertEquals((long)DatastoreContext.DEFAULT_SHARD_LEADER_ELECTION_TIMEOUT.duration().toMillis(), (long)context.getShardLeaderElectionTimeout().duration().toMillis());
        Assert.assertEquals((long)3L, (long)context.getInitialSettleTimeoutMultiplier());
        Assert.assertEquals((Object)true, (Object)context.isPersistent());
        Assert.assertEquals((Object)DatastoreContext.DEFAULT_CONFIGURATION_READER, (Object)context.getConfigurationReader());
        Assert.assertEquals((long)5000L, (long)context.getShardRaftConfig().getIsolatedCheckIntervalInMillis());
        Assert.assertEquals((long)12L, (long)context.getShardRaftConfig().getSnapshotDataThresholdPercentage());
        Assert.assertEquals((long)0L, (long)context.getShardRaftConfig().getSnapshotDataThreshold());
        Assert.assertEquals((long)2L, (long)context.getShardRaftConfig().getElectionTimeoutFactor());
        Assert.assertEquals((long)100L, (long)context.getTransactionCreationInitialRateLimit());
        Assert.assertEquals((long)1000L, (long)context.getShardBatchedModificationCount());
        Assert.assertEquals((long)2048000L, (long)context.getMaximumMessageSliceSize());
        Assert.assertEquals((Object)"persistence-export", (Object)context.getRecoveryExportBaseDir());
    }

    @Test
    public void testNewBuilderWithCustomSettings() {
        DatastoreContext.Builder builder = DatastoreContext.newBuilder();
        builder.shardTransactionIdleTimeout(DatastoreContext.DEFAULT_SHARD_TRANSACTION_IDLE_TIMEOUT.toMillis() + 1L, TimeUnit.MILLISECONDS);
        builder.operationTimeoutInSeconds((int)(TimeUnit.MILLISECONDS.toSeconds(5000L) + 1L));
        builder.shardTransactionCommitTimeoutInSeconds(31);
        builder.shardJournalRecoveryLogBatchSize(2);
        builder.shardSnapshotBatchCount(20001);
        builder.recoverySnapshotIntervalSeconds(1);
        builder.shardHeartbeatIntervalInMillis(501);
        builder.shardTransactionCommitQueueCapacity(50001);
        builder.shardInitializationTimeout(DatastoreContext.DEFAULT_SHARD_INITIALIZATION_TIMEOUT.duration().toMillis() + 1L, TimeUnit.MILLISECONDS);
        builder.shardInitializationTimeout(DatastoreContext.DEFAULT_SHARD_INITIALIZATION_TIMEOUT.duration().toMillis() + 1L, TimeUnit.MILLISECONDS);
        builder.shardLeaderElectionTimeout(DatastoreContext.DEFAULT_SHARD_LEADER_ELECTION_TIMEOUT.duration().toMillis() + 1L, TimeUnit.MILLISECONDS);
        builder.initialSettleTimeoutMultiplier(4);
        builder.persistent(false);
        builder.shardIsolatedLeaderCheckIntervalInMillis(5001);
        builder.shardSnapshotDataThresholdPercentage(13);
        builder.shardSnapshotDataThreshold(1);
        builder.shardElectionTimeoutFactor(3L);
        builder.transactionCreationInitialRateLimit(101L);
        builder.shardBatchedModificationCount(1001);
        builder.maximumMessageSliceSize(2048001);
        builder.initialPayloadSerializedBufferCapacity(513);
        builder.exportOnRecovery(DataStoreProperties.ExportOnRecovery.Json);
        builder.recoveryExportBaseDir("persistence-export-new");
        DatastoreContext context = builder.build();
        DatastoreContextTest.verifyCustomSettings(context);
        builder = DatastoreContext.newBuilderFrom((DatastoreContext)context);
        DatastoreContext newContext = builder.build();
        DatastoreContextTest.verifyCustomSettings(newContext);
        Assert.assertNotSame((Object)context, (Object)newContext);
    }

    private static void verifyCustomSettings(DatastoreContext context) {
        Assert.assertEquals((long)(DatastoreContext.DEFAULT_SHARD_TRANSACTION_IDLE_TIMEOUT.toMillis() + 1L), (long)context.getShardTransactionIdleTimeout().toMillis());
        Assert.assertEquals((long)(TimeUnit.MILLISECONDS.toSeconds(5000L) + 1L), (long)TimeUnit.MILLISECONDS.toSeconds(context.getOperationTimeoutInMillis()));
        Assert.assertEquals((long)31L, (long)context.getShardTransactionCommitTimeoutInSeconds());
        Assert.assertEquals((long)2L, (long)context.getShardRaftConfig().getJournalRecoveryLogBatchSize());
        Assert.assertEquals((long)20001L, (long)context.getShardRaftConfig().getSnapshotBatchCount());
        Assert.assertEquals((long)1L, (long)context.getShardRaftConfig().getRecoverySnapshotIntervalSeconds());
        Assert.assertEquals((long)501L, (long)context.getShardRaftConfig().getHeartBeatInterval().length());
        Assert.assertEquals((long)50001L, (long)context.getShardTransactionCommitQueueCapacity());
        Assert.assertEquals((long)(DatastoreContext.DEFAULT_SHARD_INITIALIZATION_TIMEOUT.duration().toMillis() + 1L), (long)context.getShardInitializationTimeout().duration().toMillis());
        Assert.assertEquals((long)(DatastoreContext.DEFAULT_SHARD_LEADER_ELECTION_TIMEOUT.duration().toMillis() + 1L), (long)context.getShardLeaderElectionTimeout().duration().toMillis());
        Assert.assertEquals((long)4L, (long)context.getInitialSettleTimeoutMultiplier());
        Assert.assertEquals((Object)false, (Object)context.isPersistent());
        Assert.assertEquals((Object)DatastoreContext.DEFAULT_CONFIGURATION_READER, (Object)context.getConfigurationReader());
        Assert.assertEquals((long)5001L, (long)context.getShardRaftConfig().getIsolatedCheckIntervalInMillis());
        Assert.assertEquals((long)13L, (long)context.getShardRaftConfig().getSnapshotDataThresholdPercentage());
        Assert.assertEquals((long)1L, (long)context.getShardRaftConfig().getSnapshotDataThreshold());
        Assert.assertEquals((long)3L, (long)context.getShardRaftConfig().getElectionTimeoutFactor());
        Assert.assertEquals((long)101L, (long)context.getTransactionCreationInitialRateLimit());
        Assert.assertEquals((long)1001L, (long)context.getShardBatchedModificationCount());
        Assert.assertEquals((long)2048001L, (long)context.getMaximumMessageSliceSize());
        Assert.assertEquals((long)513L, (long)context.getInitialPayloadSerializedBufferCapacity());
        Assert.assertEquals((Object)"persistence-export-new", (Object)context.getRecoveryExportBaseDir());
        Assert.assertEquals((Object)DataStoreProperties.ExportOnRecovery.Json, (Object)context.getExportOnRecovery());
    }
}

