/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.cluster.datastore;

import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.Optional;
import org.apache.commons.lang3.SerializationUtils;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;
import org.opendaylight.controller.cluster.datastore.AbstractShardTest;
import org.opendaylight.controller.cluster.datastore.DefaultDatastoreSnapshotRestore;
import org.opendaylight.controller.cluster.datastore.persisted.DatastoreSnapshot;
import org.opendaylight.controller.cluster.datastore.persisted.DatastoreSnapshotList;
import org.opendaylight.controller.cluster.datastore.persisted.MetadataShardDataTreeSnapshot;
import org.opendaylight.controller.cluster.datastore.persisted.ShardDataTreeSnapshot;
import org.opendaylight.controller.cluster.datastore.persisted.ShardManagerSnapshot;
import org.opendaylight.controller.cluster.datastore.persisted.ShardSnapshotState;
import org.opendaylight.controller.cluster.raft.persisted.Snapshot;
import org.opendaylight.controller.md.cluster.datastore.model.CarsModel;
import org.opendaylight.controller.md.cluster.datastore.model.PeopleModel;
import org.opendaylight.controller.md.cluster.datastore.model.SchemaContextHelper;
import org.opendaylight.controller.md.cluster.datastore.model.TestModel;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.common.Uint64;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;
import org.opendaylight.yangtools.yang.data.api.schema.NormalizedNode;
import org.opendaylight.yangtools.yang.data.api.schema.tree.DataTree;
import org.opendaylight.yangtools.yang.data.api.schema.tree.DataTreeConfiguration;
import org.opendaylight.yangtools.yang.data.impl.schema.ImmutableNodes;
import org.opendaylight.yangtools.yang.data.impl.schema.tree.InMemoryDataTreeFactory;

public class DatastoreSnapshotRestoreTest {
    String restoreDirectoryPath = "target/DatastoreSnapshotRestoreTest-" + System.nanoTime();
    File restoreDirectoryFile = new File(this.restoreDirectoryPath);
    File backupFile = new File(this.restoreDirectoryFile, "backup");

    @After
    public void tearDown() {
        this.backupFile.delete();
        this.restoreDirectoryFile.delete();
    }

    @Test
    public void test() throws Exception {
        Assert.assertTrue((String)("Failed to mkdir " + this.restoreDirectoryPath), (boolean)this.restoreDirectoryFile.mkdirs());
        DatastoreSnapshot configSnapshot = new DatastoreSnapshot("config", DatastoreSnapshotRestoreTest.newShardManagerSnapshot("config-one", "config-two"), Arrays.asList(new DatastoreSnapshot.ShardSnapshot("config-one", DatastoreSnapshotRestoreTest.newSnapshot(CarsModel.BASE_PATH, (NormalizedNode)CarsModel.newCarsNode(CarsModel.newCarsMapNode(CarsModel.newCarEntry("optima", Uint64.valueOf((int)20000)), CarsModel.newCarEntry("sportage", Uint64.valueOf((int)30000)))))), new DatastoreSnapshot.ShardSnapshot("config-two", DatastoreSnapshotRestoreTest.newSnapshot(PeopleModel.BASE_PATH, (NormalizedNode)PeopleModel.emptyContainer()))));
        DatastoreSnapshot operSnapshot = new DatastoreSnapshot("oper", null, Arrays.asList(new DatastoreSnapshot.ShardSnapshot("oper-one", DatastoreSnapshotRestoreTest.newSnapshot(TestModel.TEST_PATH, (NormalizedNode)ImmutableNodes.containerNode((QName)TestModel.TEST_QNAME)))));
        DatastoreSnapshotList snapshotList = new DatastoreSnapshotList(Arrays.asList(configSnapshot, operSnapshot));
        try (FileOutputStream fos = new FileOutputStream(this.backupFile);){
            SerializationUtils.serialize((Serializable)snapshotList, (OutputStream)fos);
        }
        DefaultDatastoreSnapshotRestore instance = new DefaultDatastoreSnapshotRestore(this.restoreDirectoryPath);
        instance.activate();
        DatastoreSnapshotRestoreTest.assertDatastoreSnapshotEquals(configSnapshot, instance.getAndRemove("config").orElse(null));
        DatastoreSnapshotRestoreTest.assertDatastoreSnapshotEquals(operSnapshot, instance.getAndRemove("oper").orElse(null));
        Assert.assertEquals((String)"DatastoreSnapshot was not removed", Optional.empty(), (Object)instance.getAndRemove("config"));
        Assert.assertFalse((String)(this.backupFile + " was not deleted"), (boolean)this.backupFile.exists());
    }

    private static void assertDatastoreSnapshotEquals(DatastoreSnapshot expected, DatastoreSnapshot actual) {
        Assert.assertNotNull((String)"DatastoreSnapshot is null", (Object)actual);
        Assert.assertEquals((String)"getType", (Object)expected.getType(), (Object)actual.getType());
        if (expected.getShardManagerSnapshot() == null) {
            Assert.assertNull((String)"Expected null ShardManagerSnapshot", (Object)actual.getShardManagerSnapshot());
        } else {
            Assert.assertEquals((String)"ShardManagerSnapshot", (Object)expected.getShardManagerSnapshot().getShardList(), (Object)actual.getShardManagerSnapshot().getShardList());
        }
        Assert.assertEquals((String)"ShardSnapshots size", (long)expected.getShardSnapshots().size(), (long)actual.getShardSnapshots().size());
        for (int i = 0; i < expected.getShardSnapshots().size(); ++i) {
            Assert.assertEquals((String)("ShardSnapshot " + (i + 1) + " name"), (Object)((DatastoreSnapshot.ShardSnapshot)expected.getShardSnapshots().get(i)).getName(), (Object)((DatastoreSnapshot.ShardSnapshot)actual.getShardSnapshots().get(i)).getName());
            DatastoreSnapshotRestoreTest.assertSnapshotEquals("ShardSnapshot " + (i + 1) + " snapshot", ((DatastoreSnapshot.ShardSnapshot)expected.getShardSnapshots().get(i)).getSnapshot(), ((DatastoreSnapshot.ShardSnapshot)actual.getShardSnapshots().get(i)).getSnapshot());
        }
    }

    private static void assertSnapshotEquals(String prefix, Snapshot expected, Snapshot actual) {
        Assert.assertEquals((String)(prefix + " lastIndex"), (long)expected.getLastIndex(), (long)actual.getLastIndex());
        Assert.assertEquals((String)(prefix + " lastTerm"), (long)expected.getLastTerm(), (long)actual.getLastTerm());
        Assert.assertEquals((String)(prefix + " lastAppliedIndex"), (long)expected.getLastAppliedIndex(), (long)actual.getLastAppliedIndex());
        Assert.assertEquals((String)(prefix + " lastAppliedTerm"), (long)expected.getLastAppliedTerm(), (long)actual.getLastAppliedTerm());
        Assert.assertEquals((String)(prefix + " unAppliedEntries"), (Object)expected.getUnAppliedEntries(), (Object)actual.getUnAppliedEntries());
        Assert.assertEquals((String)(prefix + " electionTerm"), (long)expected.getElectionTerm(), (long)actual.getElectionTerm());
        Assert.assertEquals((String)(prefix + " electionVotedFor"), (Object)expected.getElectionVotedFor(), (Object)actual.getElectionVotedFor());
        Assert.assertEquals((String)(prefix + " Root node"), (Object)((ShardSnapshotState)expected.getState()).getSnapshot().getRootNode(), (Object)((ShardSnapshotState)actual.getState()).getSnapshot().getRootNode());
    }

    private static ShardManagerSnapshot newShardManagerSnapshot(String ... shards) {
        return new ShardManagerSnapshot(Arrays.asList(shards));
    }

    private static Snapshot newSnapshot(YangInstanceIdentifier path, NormalizedNode node) throws Exception {
        DataTree dataTree = new InMemoryDataTreeFactory().create(DataTreeConfiguration.DEFAULT_OPERATIONAL, SchemaContextHelper.full());
        AbstractShardTest.writeToStore(dataTree, path, node);
        NormalizedNode root = AbstractShardTest.readStore(dataTree, YangInstanceIdentifier.empty());
        return Snapshot.create((Snapshot.State)new ShardSnapshotState((ShardDataTreeSnapshot)new MetadataShardDataTreeSnapshot(root)), Collections.emptyList(), (long)2L, (long)1L, (long)2L, (long)1L, (long)1L, (String)"member-1", null);
    }
}

