/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.cluster.datastore;

import akka.actor.ActorRef;
import akka.actor.ActorSelection;
import akka.actor.ActorSystem;
import akka.actor.Address;
import akka.actor.AddressFromURIString;
import akka.actor.Status;
import akka.cluster.Cluster;
import akka.cluster.Member;
import akka.dispatch.Futures;
import akka.pattern.Patterns;
import akka.testkit.javadsl.TestKit;
import com.google.common.base.Stopwatch;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Range;
import com.google.common.primitives.UnsignedLong;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.common.util.concurrent.Uninterruptibles;
import com.typesafe.config.Config;
import com.typesafe.config.ConfigFactory;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Supplier;
import org.awaitility.Awaitility;
import org.hamcrest.Matchers;
import org.junit.After;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.stubbing.Answer;
import org.mockito.verification.VerificationMode;
import org.opendaylight.controller.cluster.access.client.RequestTimeoutException;
import org.opendaylight.controller.cluster.access.concepts.TransactionIdentifier;
import org.opendaylight.controller.cluster.databroker.ClientBackedDataStore;
import org.opendaylight.controller.cluster.databroker.ConcurrentDOMDataBroker;
import org.opendaylight.controller.cluster.databroker.TestClientBackedDataStore;
import org.opendaylight.controller.cluster.datastore.AbstractDataStore;
import org.opendaylight.controller.cluster.datastore.AbstractShardTest;
import org.opendaylight.controller.cluster.datastore.AbstractTest;
import org.opendaylight.controller.cluster.datastore.DatastoreContext;
import org.opendaylight.controller.cluster.datastore.DatastoreContextFactory;
import org.opendaylight.controller.cluster.datastore.DistributedDataStore;
import org.opendaylight.controller.cluster.datastore.IntegrationTestKit;
import org.opendaylight.controller.cluster.datastore.LocalShardStore;
import org.opendaylight.controller.cluster.datastore.MemberNode;
import org.opendaylight.controller.cluster.datastore.ReadWriteShardDataTreeTransaction;
import org.opendaylight.controller.cluster.datastore.ShardDataTreeTransactionParent;
import org.opendaylight.controller.cluster.datastore.TestDistributedDataStore;
import org.opendaylight.controller.cluster.datastore.TestShard;
import org.opendaylight.controller.cluster.datastore.ThreePhaseCommitCohortProxy;
import org.opendaylight.controller.cluster.datastore.exceptions.NoShardLeaderException;
import org.opendaylight.controller.cluster.datastore.exceptions.ShardLeaderNotRespondingException;
import org.opendaylight.controller.cluster.datastore.messages.CommitTransactionReply;
import org.opendaylight.controller.cluster.datastore.messages.ForwardedReadyTransaction;
import org.opendaylight.controller.cluster.datastore.messages.GetShardDataTree;
import org.opendaylight.controller.cluster.datastore.messages.ReadyLocalTransaction;
import org.opendaylight.controller.cluster.datastore.messages.ReadyTransactionReply;
import org.opendaylight.controller.cluster.datastore.modification.MergeModification;
import org.opendaylight.controller.cluster.datastore.modification.WriteModification;
import org.opendaylight.controller.cluster.datastore.persisted.FrontendClientMetadata;
import org.opendaylight.controller.cluster.datastore.persisted.FrontendHistoryMetadata;
import org.opendaylight.controller.cluster.datastore.persisted.FrontendShardDataTreeSnapshotMetadata;
import org.opendaylight.controller.cluster.datastore.persisted.MetadataShardDataTreeSnapshot;
import org.opendaylight.controller.cluster.datastore.persisted.ShardDataTreeSnapshot;
import org.opendaylight.controller.cluster.datastore.persisted.ShardSnapshotState;
import org.opendaylight.controller.cluster.raft.base.messages.TimeoutNow;
import org.opendaylight.controller.cluster.raft.client.messages.GetOnDemandRaftState;
import org.opendaylight.controller.cluster.raft.client.messages.OnDemandRaftState;
import org.opendaylight.controller.cluster.raft.client.messages.Shutdown;
import org.opendaylight.controller.cluster.raft.messages.AppendEntries;
import org.opendaylight.controller.cluster.raft.messages.RequestVote;
import org.opendaylight.controller.cluster.raft.persisted.ApplyJournalEntries;
import org.opendaylight.controller.cluster.raft.persisted.Snapshot;
import org.opendaylight.controller.cluster.raft.policy.DisableElectionsRaftPolicy;
import org.opendaylight.controller.cluster.raft.utils.InMemoryJournal;
import org.opendaylight.controller.cluster.raft.utils.InMemorySnapshotStore;
import org.opendaylight.controller.md.cluster.datastore.model.CarsModel;
import org.opendaylight.controller.md.cluster.datastore.model.PeopleModel;
import org.opendaylight.controller.md.cluster.datastore.model.SchemaContextHelper;
import org.opendaylight.controller.md.cluster.datastore.model.TestModel;
import org.opendaylight.mdsal.common.api.LogicalDatastoreType;
import org.opendaylight.mdsal.dom.api.DOMDataTreeTransaction;
import org.opendaylight.mdsal.dom.api.DOMDataTreeWriteTransaction;
import org.opendaylight.mdsal.dom.api.DOMTransactionChain;
import org.opendaylight.mdsal.dom.api.DOMTransactionChainListener;
import org.opendaylight.mdsal.dom.spi.store.DOMStoreReadTransaction;
import org.opendaylight.mdsal.dom.spi.store.DOMStoreReadWriteTransaction;
import org.opendaylight.mdsal.dom.spi.store.DOMStoreThreePhaseCommitCohort;
import org.opendaylight.mdsal.dom.spi.store.DOMStoreTransactionChain;
import org.opendaylight.mdsal.dom.spi.store.DOMStoreWriteTransaction;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.common.Uint64;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;
import org.opendaylight.yangtools.yang.data.api.schema.ContainerNode;
import org.opendaylight.yangtools.yang.data.api.schema.DataContainerChild;
import org.opendaylight.yangtools.yang.data.api.schema.MapEntryNode;
import org.opendaylight.yangtools.yang.data.api.schema.NormalizedNode;
import org.opendaylight.yangtools.yang.data.api.schema.builder.CollectionNodeBuilder;
import org.opendaylight.yangtools.yang.data.api.schema.tree.DataTree;
import org.opendaylight.yangtools.yang.data.api.schema.tree.DataTreeConfiguration;
import org.opendaylight.yangtools.yang.data.api.schema.tree.DataTreeModification;
import org.opendaylight.yangtools.yang.data.impl.schema.ImmutableNodes;
import org.opendaylight.yangtools.yang.data.impl.schema.builder.impl.ImmutableContainerNodeBuilder;
import org.opendaylight.yangtools.yang.data.impl.schema.tree.InMemoryDataTreeFactory;
import org.opendaylight.yangtools.yang.model.api.SchemaContext;
import scala.concurrent.Await;
import scala.concurrent.Awaitable;
import scala.concurrent.Future;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.FiniteDuration;

@RunWith(value=Parameterized.class)
public class DistributedDataStoreRemotingIntegrationTest
extends AbstractTest {
    @Parameterized.Parameter(value=0)
    public Class<? extends AbstractDataStore> testParameter;
    @Parameterized.Parameter(value=1)
    public int commitTimeout;
    private static final String[] CARS_AND_PEOPLE = new String[]{"cars", "people"};
    private static final String[] CARS = new String[]{"cars"};
    private static final Address MEMBER_1_ADDRESS = AddressFromURIString.parse((String)"akka://cluster-test@127.0.0.1:2558");
    private static final Address MEMBER_2_ADDRESS = AddressFromURIString.parse((String)"akka://cluster-test@127.0.0.1:2559");
    private static final String MODULE_SHARDS_CARS_ONLY_1_2 = "module-shards-cars-member-1-and-2.conf";
    private static final String MODULE_SHARDS_CARS_PEOPLE_1_2 = "module-shards-member1-and-2.conf";
    private static final String MODULE_SHARDS_CARS_PEOPLE_1_2_3 = "module-shards-member1-and-2-and-3.conf";
    private static final String MODULE_SHARDS_CARS_1_2_3 = "module-shards-cars-member-1-and-2-and-3.conf";
    private ActorSystem leaderSystem;
    private ActorSystem followerSystem;
    private ActorSystem follower2System;
    private final DatastoreContext.Builder leaderDatastoreContextBuilder = DatastoreContext.newBuilder().shardHeartbeatIntervalInMillis(100).shardElectionTimeoutFactor(2L);
    private final DatastoreContext.Builder followerDatastoreContextBuilder = DatastoreContext.newBuilder().shardHeartbeatIntervalInMillis(100).shardElectionTimeoutFactor(5L).customRaftPolicyImplementation(DisableElectionsRaftPolicy.class.getName());
    private final TransactionIdentifier tx1 = DistributedDataStoreRemotingIntegrationTest.nextTransactionId();
    private final TransactionIdentifier tx2 = DistributedDataStoreRemotingIntegrationTest.nextTransactionId();
    private AbstractDataStore followerDistributedDataStore;
    private AbstractDataStore leaderDistributedDataStore;
    private IntegrationTestKit followerTestKit;
    private IntegrationTestKit leaderTestKit;

    @Parameterized.Parameters(name="{0}")
    public static Collection<Object[]> data() {
        return Arrays.asList({TestDistributedDataStore.class, 7}, {TestClientBackedDataStore.class, 12});
    }

    @Before
    public void setUp() {
        InMemoryJournal.clear();
        InMemorySnapshotStore.clear();
        this.leaderSystem = ActorSystem.create((String)"cluster-test", (Config)ConfigFactory.load().getConfig("Member1"));
        Cluster.get((ActorSystem)this.leaderSystem).join(MEMBER_1_ADDRESS);
        this.followerSystem = ActorSystem.create((String)"cluster-test", (Config)ConfigFactory.load().getConfig("Member2"));
        Cluster.get((ActorSystem)this.followerSystem).join(MEMBER_1_ADDRESS);
        this.follower2System = ActorSystem.create((String)"cluster-test", (Config)ConfigFactory.load().getConfig("Member3"));
        Cluster.get((ActorSystem)this.follower2System).join(MEMBER_1_ADDRESS);
    }

    @After
    public void tearDown() {
        if (this.followerDistributedDataStore != null) {
            this.leaderDistributedDataStore.close();
        }
        if (this.leaderDistributedDataStore != null) {
            this.leaderDistributedDataStore.close();
        }
        TestKit.shutdownActorSystem((ActorSystem)this.leaderSystem, (boolean)true);
        TestKit.shutdownActorSystem((ActorSystem)this.followerSystem, (boolean)true);
        TestKit.shutdownActorSystem((ActorSystem)this.follower2System, (boolean)true);
        InMemoryJournal.clear();
        InMemorySnapshotStore.clear();
    }

    private void initDatastoresWithCars(String type) throws Exception {
        this.initDatastores(type, MODULE_SHARDS_CARS_ONLY_1_2, CARS);
    }

    private void initDatastoresWithCarsAndPeople(String type) throws Exception {
        this.initDatastores(type, MODULE_SHARDS_CARS_PEOPLE_1_2, CARS_AND_PEOPLE);
    }

    private void initDatastores(String type, String moduleShardsConfig, String[] shards) throws Exception {
        this.initDatastores(type, moduleShardsConfig, shards, this.leaderDatastoreContextBuilder, this.followerDatastoreContextBuilder);
    }

    private void initDatastores(String type, String moduleShardsConfig, String[] shards, DatastoreContext.Builder leaderBuilder, DatastoreContext.Builder followerBuilder) throws Exception {
        this.leaderTestKit = new IntegrationTestKit(this.leaderSystem, leaderBuilder, this.commitTimeout);
        this.leaderDistributedDataStore = this.leaderTestKit.setupAbstractDataStore(this.testParameter, type, moduleShardsConfig, false, shards);
        this.followerTestKit = new IntegrationTestKit(this.followerSystem, followerBuilder, this.commitTimeout);
        this.followerDistributedDataStore = this.followerTestKit.setupAbstractDataStore(this.testParameter, type, moduleShardsConfig, false, shards);
        this.leaderTestKit.waitUntilLeader(this.leaderDistributedDataStore.getActorUtils(), shards);
        this.leaderTestKit.waitForMembersUp("member-2");
        this.followerTestKit.waitForMembersUp("member-1");
    }

    private static void verifyCars(DOMStoreReadTransaction readTx, MapEntryNode ... entries) throws Exception {
        Optional optional = (Optional)readTx.read(CarsModel.CAR_LIST_PATH).get(5L, TimeUnit.SECONDS);
        Assert.assertTrue((String)"isPresent", (boolean)optional.isPresent());
        CollectionNodeBuilder listBuilder = ImmutableNodes.mapNodeBuilder((QName)CarsModel.CAR_QNAME);
        for (MapEntryNode entry : entries) {
            listBuilder.withChild((NormalizedNode)entry);
        }
        Assert.assertEquals((String)"Car list node", (Object)listBuilder.build(), optional.get());
    }

    private static void verifyNode(DOMStoreReadTransaction readTx, YangInstanceIdentifier path, NormalizedNode expNode) throws Exception {
        Optional optional = (Optional)readTx.read(path).get(5L, TimeUnit.SECONDS);
        Assert.assertTrue((String)"isPresent", (boolean)optional.isPresent());
        Assert.assertEquals((String)"Data node", (Object)expNode, optional.get());
    }

    private static void verifyExists(DOMStoreReadTransaction readTx, YangInstanceIdentifier path) throws Exception {
        Boolean exists = (Boolean)readTx.exists(path).get(5L, TimeUnit.SECONDS);
        Assert.assertEquals((String)"exists", (Object)Boolean.TRUE, (Object)exists);
    }

    @Test
    public void testWriteTransactionWithSingleShard() throws Exception {
        String testName = "testWriteTransactionWithSingleShard";
        this.initDatastoresWithCars("testWriteTransactionWithSingleShard");
        String followerCarShardName = "member-2-shard-cars-testWriteTransactionWithSingleShard";
        DOMStoreWriteTransaction writeTx = this.followerDistributedDataStore.newWriteOnlyTransaction();
        Assert.assertNotNull((String)"newWriteOnlyTransaction returned null", (Object)writeTx);
        writeTx.write(CarsModel.BASE_PATH, (NormalizedNode)CarsModel.emptyContainer());
        writeTx.write(CarsModel.CAR_LIST_PATH, (NormalizedNode)CarsModel.newCarMapNode());
        MapEntryNode car1 = CarsModel.newCarEntry("optima", Uint64.valueOf((int)20000));
        YangInstanceIdentifier car1Path = CarsModel.newCarPath("optima");
        writeTx.merge(car1Path, (NormalizedNode)car1);
        MapEntryNode car2 = CarsModel.newCarEntry("sportage", Uint64.valueOf((int)25000));
        YangInstanceIdentifier car2Path = CarsModel.newCarPath("sportage");
        writeTx.merge(car2Path, (NormalizedNode)car2);
        this.followerTestKit.doCommit(writeTx.ready());
        DistributedDataStoreRemotingIntegrationTest.verifyCars(this.followerDistributedDataStore.newReadOnlyTransaction(), car1, car2);
        DistributedDataStoreRemotingIntegrationTest.verifyCars(this.leaderDistributedDataStore.newReadOnlyTransaction(), car1, car2);
        writeTx = this.followerDistributedDataStore.newWriteOnlyTransaction();
        writeTx.delete(car1Path);
        this.followerTestKit.doCommit(writeTx.ready());
        DistributedDataStoreRemotingIntegrationTest.verifyExists(this.followerDistributedDataStore.newReadOnlyTransaction(), car2Path);
        DistributedDataStoreRemotingIntegrationTest.verifyCars(this.followerDistributedDataStore.newReadOnlyTransaction(), car2);
        DistributedDataStoreRemotingIntegrationTest.verifyCars(this.leaderDistributedDataStore.newReadOnlyTransaction(), car2);
        AtomicLong leaderLastAppliedIndex = new AtomicLong();
        IntegrationTestKit.verifyShardState(this.leaderDistributedDataStore, CARS[0], state -> leaderLastAppliedIndex.set(state.getLastApplied()));
        Stopwatch sw = Stopwatch.createStarted();
        boolean done = false;
        while (!done) {
            List entries = InMemoryJournal.get((String)"member-2-shard-cars-testWriteTransactionWithSingleShard", ApplyJournalEntries.class);
            for (ApplyJournalEntries aje : entries) {
                if (aje.getToIndex() < leaderLastAppliedIndex.get()) continue;
                done = true;
                break;
            }
            Assert.assertTrue((String)("Follower did not persist ApplyJournalEntries containing leader's lastAppliedIndex " + leaderLastAppliedIndex + ". Entries persisted: " + entries), (sw.elapsed(TimeUnit.SECONDS) <= 5L ? 1 : 0) != 0);
            Uninterruptibles.sleepUninterruptibly((long)50L, (TimeUnit)TimeUnit.MILLISECONDS);
        }
        TestKit.shutdownActorSystem((ActorSystem)this.leaderSystem, (boolean)true);
        TestKit.shutdownActorSystem((ActorSystem)this.followerSystem, (boolean)true);
        ActorSystem newSystem = this.newActorSystem("reinstated-member2", "Member2");
        try (AbstractDataStore member2Datastore = new IntegrationTestKit(newSystem, this.leaderDatastoreContextBuilder, this.commitTimeout).setupAbstractDataStore(this.testParameter, "testWriteTransactionWithSingleShard", "module-shards-member2", true, CARS);){
            DistributedDataStoreRemotingIntegrationTest.verifyCars(member2Datastore.newReadOnlyTransaction(), car2);
        }
    }

    @Test
    public void testSingleTransactionsWritesInQuickSuccession() throws Exception {
        String testName = "testWriteTransactionWithSingleShard";
        this.initDatastoresWithCars("testWriteTransactionWithSingleShard");
        DOMStoreTransactionChain txChain = this.followerDistributedDataStore.createTransactionChain();
        DOMStoreWriteTransaction writeTx = txChain.newWriteOnlyTransaction();
        writeTx.write(CarsModel.BASE_PATH, (NormalizedNode)CarsModel.emptyContainer());
        writeTx.write(CarsModel.CAR_LIST_PATH, (NormalizedNode)CarsModel.newCarMapNode());
        this.followerTestKit.doCommit(writeTx.ready());
        int numCars = 5;
        for (int i = 0; i < numCars; ++i) {
            writeTx = txChain.newWriteOnlyTransaction();
            writeTx.write(CarsModel.newCarPath("car" + i), (NormalizedNode)CarsModel.newCarEntry("car" + i, Uint64.valueOf((int)20000)));
            this.followerTestKit.doCommit(writeTx.ready());
            DOMStoreReadTransaction domStoreReadTransaction = txChain.newReadOnlyTransaction();
            domStoreReadTransaction.read(CarsModel.BASE_PATH).get();
            domStoreReadTransaction.close();
        }
        Awaitility.await((String)"Range set leak test").atMost(5L, TimeUnit.SECONDS).pollInterval(500L, TimeUnit.MILLISECONDS).untilAsserted(() -> {
            Optional localShard = this.leaderDistributedDataStore.getActorUtils().findLocalShard("cars");
            FrontendShardDataTreeSnapshotMetadata frontendMetadata = (FrontendShardDataTreeSnapshotMetadata)this.leaderDistributedDataStore.getActorUtils().executeOperation((ActorRef)localShard.get(), (Object)new TestShard.RequestFrontendMetadata());
            if (this.leaderDistributedDataStore.getActorUtils().getDatastoreContext().isUseTellBasedProtocol()) {
                Iterator iterator = ((FrontendClientMetadata)frontendMetadata.getClients().get(0)).getCurrentHistories().iterator();
                FrontendHistoryMetadata metadata = (FrontendHistoryMetadata)iterator.next();
                while (iterator.hasNext() && metadata.getHistoryId() != 1L) {
                    metadata = (FrontendHistoryMetadata)iterator.next();
                }
                Assert.assertEquals((long)0L, (long)metadata.getClosedTransactions().size());
                Assert.assertEquals((Object)Range.closedOpen((Comparable)UnsignedLong.valueOf((long)0L), (Comparable)UnsignedLong.valueOf((long)11L)), metadata.getPurgedTransactions().asRanges().iterator().next());
            } else {
                Assert.assertTrue((boolean)((FrontendClientMetadata)frontendMetadata.getClients().get(0)).getCurrentHistories().isEmpty());
            }
        });
        Optional optional = (Optional)txChain.newReadOnlyTransaction().read(CarsModel.CAR_LIST_PATH).get(5L, TimeUnit.SECONDS);
        Assert.assertTrue((String)"isPresent", (boolean)optional.isPresent());
        Assert.assertEquals((String)"# cars", (long)numCars, (long)((Collection)((NormalizedNode)optional.get()).body()).size());
    }

    @Test
    @Ignore(value="Flushes out tell based leak needs to be handled separately")
    public void testCloseTransactionMetadataLeak() throws Exception {
        Assume.assumeTrue((boolean)this.testParameter.isAssignableFrom(TestClientBackedDataStore.class));
        String testName = "testWriteTransactionWithSingleShard";
        this.initDatastoresWithCars("testWriteTransactionWithSingleShard");
        DOMStoreTransactionChain txChain = this.followerDistributedDataStore.createTransactionChain();
        DOMStoreWriteTransaction writeTx = txChain.newWriteOnlyTransaction();
        writeTx.write(CarsModel.BASE_PATH, (NormalizedNode)CarsModel.emptyContainer());
        writeTx.write(CarsModel.CAR_LIST_PATH, (NormalizedNode)CarsModel.newCarMapNode());
        this.followerTestKit.doCommit(writeTx.ready());
        int numCars = 5;
        for (int i = 0; i < numCars; ++i) {
            writeTx = txChain.newWriteOnlyTransaction();
            writeTx.close();
            DOMStoreReadTransaction domStoreReadTransaction = txChain.newReadOnlyTransaction();
            domStoreReadTransaction.read(CarsModel.BASE_PATH).get();
            domStoreReadTransaction.close();
        }
        writeTx = txChain.newWriteOnlyTransaction();
        writeTx.write(CarsModel.BASE_PATH, (NormalizedNode)CarsModel.emptyContainer());
        writeTx.write(CarsModel.CAR_LIST_PATH, (NormalizedNode)CarsModel.newCarMapNode());
        this.followerTestKit.doCommit(writeTx.ready());
        Awaitility.await((String)"Close transaction purge leak test.").atMost(5L, TimeUnit.SECONDS).pollInterval(500L, TimeUnit.MILLISECONDS).untilAsserted(() -> {
            Optional localShard = this.leaderDistributedDataStore.getActorUtils().findLocalShard("cars");
            FrontendShardDataTreeSnapshotMetadata frontendMetadata = (FrontendShardDataTreeSnapshotMetadata)this.leaderDistributedDataStore.getActorUtils().executeOperation((ActorRef)localShard.get(), (Object)new TestShard.RequestFrontendMetadata());
            if (this.leaderDistributedDataStore.getActorUtils().getDatastoreContext().isUseTellBasedProtocol()) {
                Iterator iterator = ((FrontendClientMetadata)frontendMetadata.getClients().get(0)).getCurrentHistories().iterator();
                FrontendHistoryMetadata metadata = (FrontendHistoryMetadata)iterator.next();
                while (iterator.hasNext() && metadata.getHistoryId() != 1L) {
                    metadata = (FrontendHistoryMetadata)iterator.next();
                }
                Set ranges = metadata.getPurgedTransactions().asRanges();
                Assert.assertEquals((long)0L, (long)metadata.getClosedTransactions().size());
                Assert.assertEquals((long)1L, (long)ranges.size());
            } else {
                Assert.assertTrue((boolean)((FrontendClientMetadata)frontendMetadata.getClients().get(0)).getCurrentHistories().isEmpty());
            }
        });
        Optional optional = (Optional)txChain.newReadOnlyTransaction().read(CarsModel.CAR_LIST_PATH).get(5L, TimeUnit.SECONDS);
        Assert.assertTrue((String)"isPresent", (boolean)optional.isPresent());
        Assert.assertEquals((String)"# cars", (long)numCars, (long)((Collection)((NormalizedNode)optional.get()).body()).size());
    }

    @Test
    public void testReadWriteTransactionWithSingleShard() throws Exception {
        this.initDatastoresWithCars("testReadWriteTransactionWithSingleShard");
        DOMStoreReadWriteTransaction rwTx = this.followerDistributedDataStore.newReadWriteTransaction();
        Assert.assertNotNull((String)"newReadWriteTransaction returned null", (Object)rwTx);
        rwTx.write(CarsModel.BASE_PATH, (NormalizedNode)CarsModel.emptyContainer());
        rwTx.write(CarsModel.CAR_LIST_PATH, (NormalizedNode)CarsModel.newCarMapNode());
        MapEntryNode car1 = CarsModel.newCarEntry("optima", Uint64.valueOf((int)20000));
        rwTx.merge(CarsModel.newCarPath("optima"), (NormalizedNode)car1);
        DistributedDataStoreRemotingIntegrationTest.verifyCars((DOMStoreReadTransaction)rwTx, car1);
        MapEntryNode car2 = CarsModel.newCarEntry("sportage", Uint64.valueOf((int)25000));
        YangInstanceIdentifier car2Path = CarsModel.newCarPath("sportage");
        rwTx.merge(car2Path, (NormalizedNode)car2);
        DistributedDataStoreRemotingIntegrationTest.verifyExists((DOMStoreReadTransaction)rwTx, car2Path);
        this.followerTestKit.doCommit(rwTx.ready());
        DistributedDataStoreRemotingIntegrationTest.verifyCars(this.followerDistributedDataStore.newReadOnlyTransaction(), car1, car2);
    }

    @Test
    public void testWriteTransactionWithMultipleShards() throws Exception {
        this.initDatastoresWithCarsAndPeople("testWriteTransactionWithMultipleShards");
        DOMStoreWriteTransaction writeTx = this.followerDistributedDataStore.newWriteOnlyTransaction();
        Assert.assertNotNull((String)"newWriteOnlyTransaction returned null", (Object)writeTx);
        YangInstanceIdentifier carsPath = CarsModel.BASE_PATH;
        ContainerNode carsNode = CarsModel.emptyContainer();
        writeTx.write(carsPath, (NormalizedNode)carsNode);
        YangInstanceIdentifier peoplePath = PeopleModel.BASE_PATH;
        ContainerNode peopleNode = PeopleModel.emptyContainer();
        writeTx.write(peoplePath, (NormalizedNode)peopleNode);
        this.followerTestKit.doCommit(writeTx.ready());
        DOMStoreReadTransaction readTx = this.followerDistributedDataStore.newReadOnlyTransaction();
        DistributedDataStoreRemotingIntegrationTest.verifyNode(readTx, carsPath, (NormalizedNode)carsNode);
        DistributedDataStoreRemotingIntegrationTest.verifyNode(readTx, peoplePath, (NormalizedNode)peopleNode);
    }

    @Test
    public void testReadWriteTransactionWithMultipleShards() throws Exception {
        this.initDatastoresWithCarsAndPeople("testReadWriteTransactionWithMultipleShards");
        DOMStoreReadWriteTransaction rwTx = this.followerDistributedDataStore.newReadWriteTransaction();
        Assert.assertNotNull((String)"newReadWriteTransaction returned null", (Object)rwTx);
        YangInstanceIdentifier carsPath = CarsModel.BASE_PATH;
        ContainerNode carsNode = CarsModel.emptyContainer();
        rwTx.write(carsPath, (NormalizedNode)carsNode);
        YangInstanceIdentifier peoplePath = PeopleModel.BASE_PATH;
        ContainerNode peopleNode = PeopleModel.emptyContainer();
        rwTx.write(peoplePath, (NormalizedNode)peopleNode);
        this.followerTestKit.doCommit(rwTx.ready());
        DOMStoreReadTransaction readTx = this.followerDistributedDataStore.newReadOnlyTransaction();
        DistributedDataStoreRemotingIntegrationTest.verifyNode(readTx, carsPath, (NormalizedNode)carsNode);
        DistributedDataStoreRemotingIntegrationTest.verifyNode(readTx, peoplePath, (NormalizedNode)peopleNode);
    }

    @Test
    public void testTransactionChainWithSingleShard() throws Exception {
        this.initDatastoresWithCars("testTransactionChainWithSingleShard");
        DOMStoreTransactionChain txChain = this.followerDistributedDataStore.createTransactionChain();
        DOMStoreWriteTransaction writeTx = txChain.newWriteOnlyTransaction();
        Assert.assertNotNull((String)"newWriteOnlyTransaction returned null", (Object)writeTx);
        writeTx.write(CarsModel.BASE_PATH, (NormalizedNode)CarsModel.emptyContainer());
        DOMStoreThreePhaseCommitCohort writeTxReady = writeTx.ready();
        DistributedDataStoreRemotingIntegrationTest.verifyNode(txChain.newReadOnlyTransaction(), CarsModel.BASE_PATH, (NormalizedNode)CarsModel.emptyContainer());
        DOMStoreReadWriteTransaction rwTx = txChain.newReadWriteTransaction();
        DistributedDataStoreRemotingIntegrationTest.verifyNode((DOMStoreReadTransaction)rwTx, CarsModel.BASE_PATH, (NormalizedNode)CarsModel.emptyContainer());
        rwTx.merge(CarsModel.CAR_LIST_PATH, (NormalizedNode)CarsModel.newCarMapNode());
        MapEntryNode car1 = CarsModel.newCarEntry("optima", Uint64.valueOf((int)20000));
        YangInstanceIdentifier car1Path = CarsModel.newCarPath("optima");
        rwTx.write(car1Path, (NormalizedNode)car1);
        DistributedDataStoreRemotingIntegrationTest.verifyExists((DOMStoreReadTransaction)rwTx, car1Path);
        DistributedDataStoreRemotingIntegrationTest.verifyCars((DOMStoreReadTransaction)rwTx, car1);
        MapEntryNode car2 = CarsModel.newCarEntry("sportage", Uint64.valueOf((int)25000));
        rwTx.merge(CarsModel.newCarPath("sportage"), (NormalizedNode)car2);
        rwTx.delete(car1Path);
        this.followerTestKit.doCommit(writeTxReady);
        this.followerTestKit.doCommit(rwTx.ready());
        txChain.close();
        DistributedDataStoreRemotingIntegrationTest.verifyCars(this.followerDistributedDataStore.newReadOnlyTransaction(), car2);
    }

    @Test
    public void testTransactionChainWithMultipleShards() throws Exception {
        this.initDatastoresWithCarsAndPeople("testTransactionChainWithMultipleShards");
        DOMStoreTransactionChain txChain = this.followerDistributedDataStore.createTransactionChain();
        DOMStoreWriteTransaction writeTx = txChain.newWriteOnlyTransaction();
        Assert.assertNotNull((String)"newWriteOnlyTransaction returned null", (Object)writeTx);
        writeTx.write(CarsModel.BASE_PATH, (NormalizedNode)CarsModel.emptyContainer());
        writeTx.write(PeopleModel.BASE_PATH, (NormalizedNode)PeopleModel.emptyContainer());
        writeTx.write(CarsModel.CAR_LIST_PATH, (NormalizedNode)CarsModel.newCarMapNode());
        writeTx.write(PeopleModel.PERSON_LIST_PATH, (NormalizedNode)PeopleModel.newPersonMapNode());
        this.followerTestKit.doCommit(writeTx.ready());
        DOMStoreReadWriteTransaction readWriteTx = txChain.newReadWriteTransaction();
        MapEntryNode car = CarsModel.newCarEntry("optima", Uint64.valueOf((int)20000));
        YangInstanceIdentifier carPath = CarsModel.newCarPath("optima");
        readWriteTx.write(carPath, (NormalizedNode)car);
        MapEntryNode person = PeopleModel.newPersonEntry("jack");
        YangInstanceIdentifier personPath = PeopleModel.newPersonPath("jack");
        readWriteTx.merge(personPath, (NormalizedNode)person);
        Optional optional = (Optional)readWriteTx.read(carPath).get(5L, TimeUnit.SECONDS);
        Assert.assertTrue((String)"isPresent", (boolean)optional.isPresent());
        Assert.assertEquals((String)"Data node", (Object)car, optional.get());
        optional = (Optional)readWriteTx.read(personPath).get(5L, TimeUnit.SECONDS);
        Assert.assertTrue((String)"isPresent", (boolean)optional.isPresent());
        Assert.assertEquals((String)"Data node", (Object)person, optional.get());
        DOMStoreThreePhaseCommitCohort cohort2 = readWriteTx.ready();
        writeTx = txChain.newWriteOnlyTransaction();
        writeTx.delete(personPath);
        DOMStoreThreePhaseCommitCohort cohort3 = writeTx.ready();
        this.followerTestKit.doCommit(cohort2);
        this.followerTestKit.doCommit(cohort3);
        txChain.close();
        DOMStoreReadTransaction readTx = this.followerDistributedDataStore.newReadOnlyTransaction();
        DistributedDataStoreRemotingIntegrationTest.verifyCars(readTx, car);
        optional = (Optional)readTx.read(personPath).get(5L, TimeUnit.SECONDS);
        Assert.assertFalse((String)"isPresent", (boolean)optional.isPresent());
    }

    @Test
    public void testChainedTransactionFailureWithSingleShard() throws Exception {
        this.initDatastoresWithCars("testChainedTransactionFailureWithSingleShard");
        ConcurrentDOMDataBroker broker = new ConcurrentDOMDataBroker((Map)ImmutableMap.builder().put((Object)LogicalDatastoreType.CONFIGURATION, (Object)this.followerDistributedDataStore).build(), MoreExecutors.directExecutor());
        DOMTransactionChainListener listener = (DOMTransactionChainListener)Mockito.mock(DOMTransactionChainListener.class);
        DOMTransactionChain txChain = broker.createTransactionChain(listener);
        DOMDataTreeWriteTransaction writeTx = txChain.newWriteOnlyTransaction();
        ContainerNode invalidData = (ContainerNode)ImmutableContainerNodeBuilder.create().withNodeIdentifier((YangInstanceIdentifier.PathArgument)new YangInstanceIdentifier.NodeIdentifier(CarsModel.BASE_QNAME)).withChild((DataContainerChild)ImmutableNodes.leafNode((QName)TestModel.JUNK_QNAME, (Object)"junk")).build();
        writeTx.merge(LogicalDatastoreType.CONFIGURATION, CarsModel.BASE_PATH, (NormalizedNode)invalidData);
        try {
            writeTx.commit().get(5L, TimeUnit.SECONDS);
            Assert.fail((String)"Expected TransactionCommitFailedException");
        }
        catch (ExecutionException executionException) {
            // empty catch block
        }
        ((DOMTransactionChainListener)Mockito.verify((Object)listener, (VerificationMode)Mockito.timeout((long)5000L))).onTransactionChainFailed((DOMTransactionChain)ArgumentMatchers.eq((Object)txChain), (DOMDataTreeTransaction)ArgumentMatchers.eq((Object)writeTx), (Throwable)ArgumentMatchers.any(Throwable.class));
        txChain.close();
        broker.close();
    }

    @Test
    public void testChainedTransactionFailureWithMultipleShards() throws Exception {
        this.initDatastoresWithCarsAndPeople("testChainedTransactionFailureWithMultipleShards");
        ConcurrentDOMDataBroker broker = new ConcurrentDOMDataBroker((Map)ImmutableMap.builder().put((Object)LogicalDatastoreType.CONFIGURATION, (Object)this.followerDistributedDataStore).build(), MoreExecutors.directExecutor());
        DOMTransactionChainListener listener = (DOMTransactionChainListener)Mockito.mock(DOMTransactionChainListener.class);
        DOMTransactionChain txChain = broker.createTransactionChain(listener);
        DOMDataTreeWriteTransaction writeTx = txChain.newWriteOnlyTransaction();
        writeTx.put(LogicalDatastoreType.CONFIGURATION, PeopleModel.BASE_PATH, (NormalizedNode)PeopleModel.emptyContainer());
        ContainerNode invalidData = (ContainerNode)ImmutableContainerNodeBuilder.create().withNodeIdentifier((YangInstanceIdentifier.PathArgument)new YangInstanceIdentifier.NodeIdentifier(CarsModel.BASE_QNAME)).withChild((DataContainerChild)ImmutableNodes.leafNode((QName)TestModel.JUNK_QNAME, (Object)"junk")).build();
        writeTx.merge(LogicalDatastoreType.CONFIGURATION, CarsModel.BASE_PATH, (NormalizedNode)invalidData);
        try {
            writeTx.commit().get(5L, TimeUnit.SECONDS);
            Assert.fail((String)"Expected TransactionCommitFailedException");
        }
        catch (ExecutionException executionException) {
            // empty catch block
        }
        ((DOMTransactionChainListener)Mockito.verify((Object)listener, (VerificationMode)Mockito.timeout((long)5000L))).onTransactionChainFailed((DOMTransactionChain)ArgumentMatchers.eq((Object)txChain), (DOMDataTreeTransaction)ArgumentMatchers.eq((Object)writeTx), (Throwable)ArgumentMatchers.any(Throwable.class));
        txChain.close();
        broker.close();
    }

    @Test
    public void testSingleShardTransactionsWithLeaderChanges() throws Exception {
        this.followerDatastoreContextBuilder.backendAlivenessTimerIntervalInSeconds(2L);
        String testName = "testSingleShardTransactionsWithLeaderChanges";
        this.initDatastoresWithCars("testSingleShardTransactionsWithLeaderChanges");
        String followerCarShardName = "member-2-shard-cars-testSingleShardTransactionsWithLeaderChanges";
        InMemoryJournal.addWriteMessagesCompleteLatch((String)"member-2-shard-cars-testSingleShardTransactionsWithLeaderChanges", (int)1, ApplyJournalEntries.class);
        DOMStoreWriteTransaction writeTx = this.followerDistributedDataStore.newWriteOnlyTransaction();
        writeTx.write(CarsModel.BASE_PATH, (NormalizedNode)CarsModel.emptyContainer());
        writeTx.write(CarsModel.CAR_LIST_PATH, (NormalizedNode)CarsModel.newCarMapNode());
        this.followerTestKit.doCommit(writeTx.ready());
        InMemoryJournal.waitForWriteMessagesComplete((String)"member-2-shard-cars-testSingleShardTransactionsWithLeaderChanges");
        DistributedDataStoreRemotingIntegrationTest.sendDatastoreContextUpdate(this.followerDistributedDataStore, this.followerDatastoreContextBuilder.shardElectionTimeoutFactor(1L).customRaftPolicyImplementation(null));
        TestKit.shutdownActorSystem((ActorSystem)this.leaderSystem, (boolean)true);
        Cluster.get((ActorSystem)this.followerSystem).leave(MEMBER_1_ADDRESS);
        this.followerTestKit.waitUntilNoLeader(this.followerDistributedDataStore.getActorUtils(), CARS);
        this.leaderSystem = ActorSystem.create((String)"cluster-test", (Config)ConfigFactory.load().getConfig("Member1"));
        Cluster.get((ActorSystem)this.leaderSystem).join(MEMBER_2_ADDRESS);
        DatastoreContext.Builder newMember1Builder = DatastoreContext.newBuilder().shardHeartbeatIntervalInMillis(100).shardElectionTimeoutFactor(5L);
        IntegrationTestKit newMember1TestKit = new IntegrationTestKit(this.leaderSystem, newMember1Builder, this.commitTimeout);
        try (AbstractDataStore ds = newMember1TestKit.setupAbstractDataStore(this.testParameter, "testSingleShardTransactionsWithLeaderChanges", MODULE_SHARDS_CARS_ONLY_1_2, false, CARS);){
            this.followerTestKit.waitUntilLeader(this.followerDistributedDataStore.getActorUtils(), CARS);
            writeTx = this.followerDistributedDataStore.newWriteOnlyTransaction();
            MapEntryNode car1 = CarsModel.newCarEntry("optima", Uint64.valueOf((int)20000));
            YangInstanceIdentifier car1Path = CarsModel.newCarPath("optima");
            writeTx.merge(car1Path, (NormalizedNode)car1);
            this.followerTestKit.doCommit(writeTx.ready());
            DistributedDataStoreRemotingIntegrationTest.verifyCars(this.followerDistributedDataStore.newReadOnlyTransaction(), car1);
        }
    }

    @Test
    public void testReadyLocalTransactionForwardedToLeader() throws Exception {
        this.initDatastoresWithCars("testReadyLocalTransactionForwardedToLeader");
        this.followerTestKit.waitUntilLeader(this.followerDistributedDataStore.getActorUtils(), "cars");
        Optional carsFollowerShard = this.followerDistributedDataStore.getActorUtils().findLocalShard("cars");
        Assert.assertTrue((String)"Cars follower shard found", (boolean)carsFollowerShard.isPresent());
        DataTree dataTree = new InMemoryDataTreeFactory().create(DataTreeConfiguration.DEFAULT_OPERATIONAL, SchemaContextHelper.full());
        DataTreeModification modification = dataTree.takeSnapshot().newModification();
        new WriteModification(CarsModel.BASE_PATH, (NormalizedNode)CarsModel.emptyContainer()).apply(modification);
        new MergeModification(CarsModel.CAR_LIST_PATH, (NormalizedNode)CarsModel.newCarMapNode()).apply(modification);
        MapEntryNode car1 = CarsModel.newCarEntry("optima", Uint64.valueOf((int)20000));
        new WriteModification(CarsModel.newCarPath("optima"), (NormalizedNode)car1).apply(modification);
        modification.ready();
        ReadyLocalTransaction readyLocal = new ReadyLocalTransaction(this.tx1, modification, true, Optional.empty());
        ((ActorRef)carsFollowerShard.get()).tell((Object)readyLocal, this.followerTestKit.getRef());
        Object resp = this.followerTestKit.expectMsgClass(Object.class);
        if (resp instanceof Status.Failure) {
            throw new AssertionError("Unexpected failure response", ((Status.Failure)resp).cause());
        }
        Assert.assertEquals((String)"Response type", CommitTransactionReply.class, resp.getClass());
        DistributedDataStoreRemotingIntegrationTest.verifyCars(this.leaderDistributedDataStore.newReadOnlyTransaction(), car1);
        modification = dataTree.takeSnapshot().newModification();
        MapEntryNode car2 = CarsModel.newCarEntry("sportage", Uint64.valueOf((int)30000));
        new WriteModification(CarsModel.newCarPath("sportage"), (NormalizedNode)car2).apply(modification);
        modification.ready();
        readyLocal = new ReadyLocalTransaction(this.tx2, modification, false, Optional.empty());
        ((ActorRef)carsFollowerShard.get()).tell((Object)readyLocal, this.followerTestKit.getRef());
        resp = this.followerTestKit.expectMsgClass(Object.class);
        if (resp instanceof Status.Failure) {
            throw new AssertionError("Unexpected failure response", ((Status.Failure)resp).cause());
        }
        Assert.assertEquals((String)"Response type", ReadyTransactionReply.class, resp.getClass());
        ActorSelection txActor = this.leaderDistributedDataStore.getActorUtils().actorSelection(((ReadyTransactionReply)resp).getCohortPath());
        Supplier versionSupplier = (Supplier)Mockito.mock(Supplier.class);
        ((Supplier)Mockito.doReturn((Object)12).when((Object)versionSupplier)).get();
        ThreePhaseCommitCohortProxy cohort = new ThreePhaseCommitCohortProxy(this.leaderDistributedDataStore.getActorUtils(), Arrays.asList(new ThreePhaseCommitCohortProxy.CohortInfo(Futures.successful((Object)txActor), versionSupplier)), this.tx2);
        cohort.canCommit().get(5L, TimeUnit.SECONDS);
        cohort.preCommit().get(5L, TimeUnit.SECONDS);
        cohort.commit().get(5L, TimeUnit.SECONDS);
        DistributedDataStoreRemotingIntegrationTest.verifyCars(this.leaderDistributedDataStore.newReadOnlyTransaction(), car1, car2);
    }

    @Test
    public void testForwardedReadyTransactionForwardedToLeader() throws Exception {
        this.initDatastoresWithCars("testForwardedReadyTransactionForwardedToLeader");
        this.followerTestKit.waitUntilLeader(this.followerDistributedDataStore.getActorUtils(), "cars");
        Optional carsFollowerShard = this.followerDistributedDataStore.getActorUtils().findLocalShard("cars");
        Assert.assertTrue((String)"Cars follower shard found", (boolean)carsFollowerShard.isPresent());
        ((ActorRef)carsFollowerShard.get()).tell((Object)GetShardDataTree.INSTANCE, this.followerTestKit.getRef());
        DataTree dataTree = (DataTree)this.followerTestKit.expectMsgClass(DataTree.class);
        DataTreeModification modification = dataTree.takeSnapshot().newModification();
        new WriteModification(CarsModel.BASE_PATH, (NormalizedNode)CarsModel.emptyContainer()).apply(modification);
        new MergeModification(CarsModel.CAR_LIST_PATH, (NormalizedNode)CarsModel.newCarMapNode()).apply(modification);
        MapEntryNode car1 = CarsModel.newCarEntry("optima", Uint64.valueOf((int)20000));
        new WriteModification(CarsModel.newCarPath("optima"), (NormalizedNode)car1).apply(modification);
        ForwardedReadyTransaction forwardedReady = new ForwardedReadyTransaction(this.tx1, 12, new ReadWriteShardDataTreeTransaction((ShardDataTreeTransactionParent)Mockito.mock(ShardDataTreeTransactionParent.class), this.tx1, modification), true, Optional.empty());
        ((ActorRef)carsFollowerShard.get()).tell((Object)forwardedReady, this.followerTestKit.getRef());
        Object resp = this.followerTestKit.expectMsgClass(Object.class);
        if (resp instanceof Status.Failure) {
            throw new AssertionError("Unexpected failure response", ((Status.Failure)resp).cause());
        }
        Assert.assertEquals((String)"Response type", CommitTransactionReply.class, resp.getClass());
        DistributedDataStoreRemotingIntegrationTest.verifyCars(this.leaderDistributedDataStore.newReadOnlyTransaction(), car1);
        modification = dataTree.takeSnapshot().newModification();
        MapEntryNode car2 = CarsModel.newCarEntry("sportage", Uint64.valueOf((int)30000));
        new WriteModification(CarsModel.newCarPath("sportage"), (NormalizedNode)car2).apply(modification);
        forwardedReady = new ForwardedReadyTransaction(this.tx2, 12, new ReadWriteShardDataTreeTransaction((ShardDataTreeTransactionParent)Mockito.mock(ShardDataTreeTransactionParent.class), this.tx2, modification), false, Optional.empty());
        ((ActorRef)carsFollowerShard.get()).tell((Object)forwardedReady, this.followerTestKit.getRef());
        resp = this.followerTestKit.expectMsgClass(Object.class);
        if (resp instanceof Status.Failure) {
            throw new AssertionError("Unexpected failure response", ((Status.Failure)resp).cause());
        }
        Assert.assertEquals((String)"Response type", ReadyTransactionReply.class, resp.getClass());
        ActorSelection txActor = this.leaderDistributedDataStore.getActorUtils().actorSelection(((ReadyTransactionReply)resp).getCohortPath());
        Supplier versionSupplier = (Supplier)Mockito.mock(Supplier.class);
        ((Supplier)Mockito.doReturn((Object)12).when((Object)versionSupplier)).get();
        ThreePhaseCommitCohortProxy cohort = new ThreePhaseCommitCohortProxy(this.leaderDistributedDataStore.getActorUtils(), Arrays.asList(new ThreePhaseCommitCohortProxy.CohortInfo(Futures.successful((Object)txActor), versionSupplier)), this.tx2);
        cohort.canCommit().get(5L, TimeUnit.SECONDS);
        cohort.preCommit().get(5L, TimeUnit.SECONDS);
        cohort.commit().get(5L, TimeUnit.SECONDS);
        DistributedDataStoreRemotingIntegrationTest.verifyCars(this.leaderDistributedDataStore.newReadOnlyTransaction(), car1, car2);
    }

    @Test
    public void testTransactionForwardedToLeaderAfterRetry() throws Exception {
        Assume.assumeTrue((boolean)DistributedDataStore.class.isAssignableFrom(this.testParameter));
        this.followerDatastoreContextBuilder.shardBatchedModificationCount(2);
        this.leaderDatastoreContextBuilder.shardBatchedModificationCount(2);
        this.initDatastoresWithCarsAndPeople("testTransactionForwardedToLeaderAfterRetry");
        DOMStoreWriteTransaction initialWriteTx = this.followerDistributedDataStore.newWriteOnlyTransaction();
        initialWriteTx.write(CarsModel.BASE_PATH, (NormalizedNode)CarsModel.emptyContainer());
        initialWriteTx.write(PeopleModel.BASE_PATH, (NormalizedNode)PeopleModel.emptyContainer());
        this.followerTestKit.doCommit(initialWriteTx.ready());
        MemberNode.verifyRaftState(this.followerDistributedDataStore, "cars", raftState -> Assert.assertEquals((String)"getLastApplied", (long)1L, (long)raftState.getLastApplied()));
        MemberNode.verifyRaftState(this.followerDistributedDataStore, "people", raftState -> Assert.assertEquals((String)"getLastApplied", (long)1L, (long)raftState.getLastApplied()));
        DOMStoreWriteTransaction writeTx1 = this.followerDistributedDataStore.newWriteOnlyTransaction();
        writeTx1.write(CarsModel.CAR_LIST_PATH, (NormalizedNode)CarsModel.newCarMapNode());
        writeTx1.write(PeopleModel.BASE_PATH, (NormalizedNode)PeopleModel.emptyContainer());
        DOMStoreThreePhaseCommitCohort writeTx1Cohort = writeTx1.ready();
        ListenableFuture writeTx1CanCommit = writeTx1Cohort.canCommit();
        writeTx1CanCommit.get(5L, TimeUnit.SECONDS);
        DOMStoreWriteTransaction writeTx2 = this.followerDistributedDataStore.newWriteOnlyTransaction();
        LinkedList<MapEntryNode> cars = new LinkedList<MapEntryNode>();
        int carIndex = 1;
        cars.add(CarsModel.newCarEntry("car" + carIndex, Uint64.valueOf((int)carIndex)));
        writeTx2.write(CarsModel.newCarPath("car" + carIndex), (NormalizedNode)cars.getLast());
        ++carIndex;
        NormalizedNode people = ImmutableNodes.mapNodeBuilder((QName)PeopleModel.PERSON_QNAME).withChild((NormalizedNode)PeopleModel.newPersonEntry("Dude")).build();
        writeTx2.write(PeopleModel.PERSON_LIST_PATH, people);
        DOMStoreThreePhaseCommitCohort writeTx2Cohort = writeTx2.ready();
        DOMStoreWriteTransaction writeTx3 = this.followerDistributedDataStore.newWriteOnlyTransaction();
        int i = 1;
        while (i <= 5) {
            cars.add(CarsModel.newCarEntry("car" + carIndex, Uint64.valueOf((int)carIndex)));
            writeTx3.write(CarsModel.newCarPath("car" + carIndex), (NormalizedNode)cars.getLast());
            ++i;
            ++carIndex;
        }
        DOMStoreWriteTransaction writeTx4 = this.followerDistributedDataStore.newWriteOnlyTransaction();
        cars.add(CarsModel.newCarEntry("car" + carIndex, Uint64.valueOf((int)carIndex)));
        writeTx4.write(CarsModel.newCarPath("car" + carIndex), (NormalizedNode)cars.getLast());
        DOMStoreReadWriteTransaction readWriteTx = this.followerDistributedDataStore.newReadWriteTransaction();
        cars.add(CarsModel.newCarEntry("car" + ++carIndex, Uint64.valueOf((int)carIndex)));
        readWriteTx.write(CarsModel.newCarPath("car" + carIndex), (NormalizedNode)cars.getLast());
        IntegrationTestKit.verifyShardStats(this.leaderDistributedDataStore, "cars", stats -> Assert.assertEquals((String)"getReadWriteTransactionCount", (long)5L, (long)stats.getReadWriteTransactionCount()));
        DistributedDataStoreRemotingIntegrationTest.sendDatastoreContextUpdate(this.leaderDistributedDataStore, this.leaderDatastoreContextBuilder.customRaftPolicyImplementation(DisableElectionsRaftPolicy.class.getName()).shardElectionTimeoutFactor(10L));
        this.leaderTestKit.waitUntilNoLeader(this.leaderDistributedDataStore.getActorUtils(), "cars");
        ListenableFuture writeTx2CanCommit = writeTx2Cohort.canCommit();
        DOMStoreThreePhaseCommitCohort writeTx3Cohort = writeTx3.ready();
        DOMStoreThreePhaseCommitCohort writeTx4Cohort = writeTx4.ready();
        DOMStoreThreePhaseCommitCohort rwTxCohort = readWriteTx.ready();
        DistributedDataStoreRemotingIntegrationTest.sendDatastoreContextUpdate(this.followerDistributedDataStore, this.followerDatastoreContextBuilder.customRaftPolicyImplementation(null).shardElectionTimeoutFactor(1L));
        IntegrationTestKit.findLocalShard(this.followerDistributedDataStore.getActorUtils(), "cars").tell((Object)TimeoutNow.INSTANCE, ActorRef.noSender());
        IntegrationTestKit.findLocalShard(this.followerDistributedDataStore.getActorUtils(), "people").tell((Object)TimeoutNow.INSTANCE, ActorRef.noSender());
        this.followerTestKit.doCommit((ListenableFuture<Boolean>)writeTx1CanCommit, writeTx1Cohort);
        this.followerTestKit.doCommit((ListenableFuture<Boolean>)writeTx2CanCommit, writeTx2Cohort);
        this.followerTestKit.doCommit(writeTx3Cohort);
        this.followerTestKit.doCommit(writeTx4Cohort);
        this.followerTestKit.doCommit(rwTxCohort);
        DOMStoreReadTransaction readTx = this.leaderDistributedDataStore.newReadOnlyTransaction();
        DistributedDataStoreRemotingIntegrationTest.verifyCars(readTx, cars.toArray(new MapEntryNode[cars.size()]));
        DistributedDataStoreRemotingIntegrationTest.verifyNode(readTx, PeopleModel.PERSON_LIST_PATH, people);
    }

    @Test
    public void testLeadershipTransferOnShutdown() throws Exception {
        Assume.assumeTrue((boolean)DistributedDataStore.class.isAssignableFrom(this.testParameter));
        this.leaderDatastoreContextBuilder.shardBatchedModificationCount(1);
        this.followerDatastoreContextBuilder.shardElectionTimeoutFactor(10L).customRaftPolicyImplementation(null);
        String testName = "testLeadershipTransferOnShutdown";
        this.initDatastores("testLeadershipTransferOnShutdown", MODULE_SHARDS_CARS_PEOPLE_1_2_3, CARS_AND_PEOPLE);
        IntegrationTestKit follower2TestKit = new IntegrationTestKit(this.follower2System, DatastoreContext.newBuilderFrom((DatastoreContext)this.followerDatastoreContextBuilder.build()).operationTimeoutInMillis(500L), this.commitTimeout);
        try (AbstractDataStore follower2DistributedDataStore = follower2TestKit.setupAbstractDataStore(this.testParameter, "testLeadershipTransferOnShutdown", MODULE_SHARDS_CARS_PEOPLE_1_2_3, false, new String[0]);){
            this.followerTestKit.waitForMembersUp("member-3");
            follower2TestKit.waitForMembersUp("member-1", "member-2");
            DOMStoreWriteTransaction writeTx = this.followerDistributedDataStore.newWriteOnlyTransaction();
            writeTx.write(CarsModel.BASE_PATH, (NormalizedNode)CarsModel.emptyContainer());
            writeTx.write(CarsModel.CAR_LIST_PATH, (NormalizedNode)CarsModel.newCarMapNode());
            writeTx.write(PeopleModel.BASE_PATH, (NormalizedNode)PeopleModel.emptyContainer());
            DOMStoreThreePhaseCommitCohort cohort1 = writeTx.ready();
            IntegrationTestKit.verifyShardStats(this.leaderDistributedDataStore, "cars", stats -> Assert.assertEquals((String)"getTxCohortCacheSize", (long)1L, (long)stats.getTxCohortCacheSize()));
            writeTx = this.followerDistributedDataStore.newWriteOnlyTransaction();
            MapEntryNode car = CarsModel.newCarEntry("optima", Uint64.valueOf((int)20000));
            writeTx.write(CarsModel.newCarPath("optima"), (NormalizedNode)car);
            DOMStoreThreePhaseCommitCohort cohort2 = writeTx.ready();
            IntegrationTestKit.verifyShardStats(this.leaderDistributedDataStore, "cars", stats -> Assert.assertEquals((String)"getTxCohortCacheSize", (long)2L, (long)stats.getTxCohortCacheSize()));
            DistributedDataStoreRemotingIntegrationTest.sendDatastoreContextUpdate(this.leaderDistributedDataStore, this.leaderDatastoreContextBuilder.shardElectionTimeoutFactor(100L));
            FiniteDuration duration = FiniteDuration.create((long)5L, (TimeUnit)TimeUnit.SECONDS);
            Future future = this.leaderDistributedDataStore.getActorUtils().findLocalShardAsync("cars");
            ActorRef leaderActor = (ActorRef)Await.result((Awaitable)future, (Duration)duration);
            Future stopFuture = Patterns.gracefulStop((ActorRef)leaderActor, (FiniteDuration)duration, (Object)Shutdown.INSTANCE);
            this.followerTestKit.doCommit(cohort1);
            this.followerTestKit.doCommit(cohort2);
            Boolean stopped = (Boolean)Await.result((Awaitable)stopFuture, (Duration)duration);
            Assert.assertEquals((String)"Stopped", (Object)Boolean.TRUE, (Object)stopped);
            DistributedDataStoreRemotingIntegrationTest.verifyCars(this.followerDistributedDataStore.newReadOnlyTransaction(), car);
            DistributedDataStoreRemotingIntegrationTest.verifyCars(follower2DistributedDataStore.newReadOnlyTransaction(), car);
        }
    }

    @Test
    public void testTransactionWithIsolatedLeader() throws Exception {
        Assume.assumeTrue((boolean)DistributedDataStore.class.isAssignableFrom(this.testParameter));
        this.leaderDatastoreContextBuilder.shardIsolatedLeaderCheckIntervalInMillis(10000000);
        String testName = "testTransactionWithIsolatedLeader";
        this.initDatastoresWithCars("testTransactionWithIsolatedLeader");
        DOMStoreWriteTransaction preIsolatedLeaderWriteTx = this.leaderDistributedDataStore.newWriteOnlyTransaction();
        preIsolatedLeaderWriteTx.write(CarsModel.BASE_PATH, (NormalizedNode)CarsModel.emptyContainer());
        DOMStoreWriteTransaction noShardLeaderWriteTx = this.leaderDistributedDataStore.newWriteOnlyTransaction();
        noShardLeaderWriteTx.write(CarsModel.BASE_PATH, (NormalizedNode)CarsModel.emptyContainer());
        DOMStoreWriteTransaction successWriteTx = this.leaderDistributedDataStore.newWriteOnlyTransaction();
        successWriteTx.merge(CarsModel.BASE_PATH, (NormalizedNode)CarsModel.emptyContainer());
        this.followerTestKit.watch(this.followerDistributedDataStore.getActorUtils().getShardManager());
        this.followerDistributedDataStore.close();
        this.followerTestKit.expectTerminated(this.followerDistributedDataStore.getActorUtils().getShardManager());
        DOMStoreThreePhaseCommitCohort preIsolatedLeaderTxCohort = preIsolatedLeaderWriteTx.ready();
        DistributedDataStoreRemotingIntegrationTest.sendDatastoreContextUpdate(this.leaderDistributedDataStore, this.leaderDatastoreContextBuilder.shardIsolatedLeaderCheckIntervalInMillis(200));
        MemberNode.verifyRaftState(this.leaderDistributedDataStore, "cars", raftState -> Assert.assertEquals((String)"getRaftState", (Object)"IsolatedLeader", (Object)raftState.getRaftState()));
        try {
            this.leaderTestKit.doCommit(noShardLeaderWriteTx.ready());
            Assert.fail((String)"Expected NoShardLeaderException");
        }
        catch (ExecutionException e) {
            Assert.assertEquals((String)"getCause", NoShardLeaderException.class, Throwables.getRootCause((Throwable)e).getClass());
        }
        DistributedDataStoreRemotingIntegrationTest.sendDatastoreContextUpdate(this.leaderDistributedDataStore, this.leaderDatastoreContextBuilder.shardElectionTimeoutFactor(100L));
        DOMStoreThreePhaseCommitCohort successTxCohort = successWriteTx.ready();
        this.followerDistributedDataStore = this.followerTestKit.setupAbstractDataStore(this.testParameter, "testTransactionWithIsolatedLeader", MODULE_SHARDS_CARS_ONLY_1_2, false, CARS);
        this.leaderTestKit.doCommit(preIsolatedLeaderTxCohort);
        this.leaderTestKit.doCommit(successTxCohort);
    }

    @Test
    public void testTransactionWithShardLeaderNotResponding() throws Exception {
        this.followerDatastoreContextBuilder.frontendRequestTimeoutInSeconds(2L);
        this.followerDatastoreContextBuilder.shardElectionTimeoutFactor(50L);
        this.initDatastoresWithCars("testTransactionWithShardLeaderNotResponding");
        DOMStoreReadTransaction readTx = this.followerDistributedDataStore.newReadOnlyTransaction();
        readTx.read(CarsModel.BASE_PATH).get(5L, TimeUnit.SECONDS);
        TestKit.shutdownActorSystem((ActorSystem)this.leaderSystem, (boolean)true);
        this.followerDatastoreContextBuilder.operationTimeoutInMillis(50L).shardElectionTimeoutFactor(1L);
        DistributedDataStoreRemotingIntegrationTest.sendDatastoreContextUpdate(this.followerDistributedDataStore, this.followerDatastoreContextBuilder);
        DOMStoreReadWriteTransaction rwTx = this.followerDistributedDataStore.newReadWriteTransaction();
        rwTx.write(CarsModel.BASE_PATH, (NormalizedNode)CarsModel.emptyContainer());
        try {
            this.followerTestKit.doCommit(rwTx.ready());
            Assert.fail((String)"Exception expected");
        }
        catch (ExecutionException e) {
            String msg = "Unexpected exception: " + Throwables.getStackTraceAsString((Throwable)e.getCause());
            if (DistributedDataStore.class.isAssignableFrom(this.testParameter)) {
                Assert.assertTrue((String)msg, (Throwables.getRootCause((Throwable)e) instanceof NoShardLeaderException || e.getCause() instanceof ShardLeaderNotRespondingException ? 1 : 0) != 0);
            }
            Assert.assertTrue((String)msg, (boolean)(Throwables.getRootCause((Throwable)e) instanceof RequestTimeoutException));
        }
    }

    @Test
    public void testTransactionWithCreateTxFailureDueToNoLeader() throws Exception {
        this.followerDatastoreContextBuilder.frontendRequestTimeoutInSeconds(2L);
        this.initDatastoresWithCars("testTransactionWithCreateTxFailureDueToNoLeader");
        DOMStoreReadTransaction readTx = this.followerDistributedDataStore.newReadOnlyTransaction();
        readTx.read(CarsModel.BASE_PATH).get(5L, TimeUnit.SECONDS);
        TestKit.shutdownActorSystem((ActorSystem)this.leaderSystem, (boolean)true);
        Cluster.get((ActorSystem)this.followerSystem).leave(MEMBER_1_ADDRESS);
        Uninterruptibles.sleepUninterruptibly((long)100L, (TimeUnit)TimeUnit.MILLISECONDS);
        DistributedDataStoreRemotingIntegrationTest.sendDatastoreContextUpdate(this.followerDistributedDataStore, this.followerDatastoreContextBuilder.operationTimeoutInMillis(10L).shardElectionTimeoutFactor(1L).customRaftPolicyImplementation(null));
        DOMStoreReadWriteTransaction rwTx = this.followerDistributedDataStore.newReadWriteTransaction();
        rwTx.write(CarsModel.BASE_PATH, (NormalizedNode)CarsModel.emptyContainer());
        try {
            this.followerTestKit.doCommit(rwTx.ready());
            Assert.fail((String)"Exception expected");
        }
        catch (ExecutionException e) {
            String msg = "Unexpected exception: " + Throwables.getStackTraceAsString((Throwable)e.getCause());
            if (DistributedDataStore.class.isAssignableFrom(this.testParameter)) {
                Assert.assertTrue((String)msg, (boolean)(Throwables.getRootCause((Throwable)e) instanceof NoShardLeaderException));
            }
            Assert.assertTrue((String)msg, (boolean)(Throwables.getRootCause((Throwable)e) instanceof RequestTimeoutException));
        }
    }

    @Test
    public void testTransactionRetryWithInitialAskTimeoutExOnCreateTx() throws Exception {
        this.followerDatastoreContextBuilder.backendAlivenessTimerIntervalInSeconds(2L);
        String testName = "testTransactionRetryWithInitialAskTimeoutExOnCreateTx";
        this.initDatastores(testName, MODULE_SHARDS_CARS_1_2_3, CARS);
        DatastoreContext.Builder follower2DatastoreContextBuilder = DatastoreContext.newBuilder().shardHeartbeatIntervalInMillis(100).shardElectionTimeoutFactor(10L);
        IntegrationTestKit follower2TestKit = new IntegrationTestKit(this.follower2System, follower2DatastoreContextBuilder, this.commitTimeout);
        try (AbstractDataStore ds = follower2TestKit.setupAbstractDataStore(this.testParameter, testName, MODULE_SHARDS_CARS_1_2_3, false, CARS);){
            this.followerTestKit.waitForMembersUp("member-1", "member-3");
            follower2TestKit.waitForMembersUp("member-1", "member-2");
            DOMStoreReadTransaction readTx = this.followerDistributedDataStore.newReadOnlyTransaction();
            readTx.read(CarsModel.BASE_PATH).get(5L, TimeUnit.SECONDS);
            TestKit.shutdownActorSystem((ActorSystem)this.leaderSystem, (boolean)true);
            Cluster.get((ActorSystem)this.followerSystem).leave(MEMBER_1_ADDRESS);
            DistributedDataStoreRemotingIntegrationTest.sendDatastoreContextUpdate(this.followerDistributedDataStore, this.followerDatastoreContextBuilder.operationTimeoutInMillis(500L).shardElectionTimeoutFactor(5L).customRaftPolicyImplementation(null));
            DOMStoreReadWriteTransaction rwTx = this.followerDistributedDataStore.newReadWriteTransaction();
            rwTx.write(CarsModel.BASE_PATH, (NormalizedNode)CarsModel.emptyContainer());
            this.followerTestKit.doCommit(rwTx.ready());
        }
    }

    @Test
    public void testSemiReachableCandidateNotDroppingLeader() throws Exception {
        String testName = "testSemiReachableCandidateNotDroppingLeader";
        this.initDatastores("testSemiReachableCandidateNotDroppingLeader", MODULE_SHARDS_CARS_1_2_3, CARS);
        DatastoreContext.Builder follower2DatastoreContextBuilder = DatastoreContext.newBuilder().shardHeartbeatIntervalInMillis(100).shardElectionTimeoutFactor(10L);
        IntegrationTestKit follower2TestKit = new IntegrationTestKit(this.follower2System, follower2DatastoreContextBuilder, this.commitTimeout);
        AbstractDataStore ds2 = follower2TestKit.setupAbstractDataStore(this.testParameter, "testSemiReachableCandidateNotDroppingLeader", MODULE_SHARDS_CARS_1_2_3, false, CARS);
        this.followerTestKit.waitForMembersUp("member-1", "member-3");
        follower2TestKit.waitForMembersUp("member-1", "member-2");
        TestKit.shutdownActorSystem((ActorSystem)this.follower2System, (boolean)true);
        ActorRef cars = (ActorRef)this.leaderDistributedDataStore.getActorUtils().findLocalShard("cars").get();
        OnDemandRaftState initialState = (OnDemandRaftState)this.leaderDistributedDataStore.getActorUtils().executeOperation(cars, (Object)GetOnDemandRaftState.INSTANCE);
        Cluster leaderCluster = Cluster.get((ActorSystem)this.leaderSystem);
        Cluster followerCluster = Cluster.get((ActorSystem)this.followerSystem);
        Cluster follower2Cluster = Cluster.get((ActorSystem)this.follower2System);
        Member follower2Member = follower2Cluster.readView().self();
        Awaitility.await().atMost(10L, TimeUnit.SECONDS).until(() -> leaderCluster.readView().unreachableMembers().contains((Object)follower2Member));
        Awaitility.await().atMost(10L, TimeUnit.SECONDS).until(() -> followerCluster.readView().unreachableMembers().contains((Object)follower2Member));
        ActorRef followerCars = (ActorRef)this.followerDistributedDataStore.getActorUtils().findLocalShard("cars").get();
        cars.tell((Object)new RequestVote(initialState.getCurrentTerm() + 1L, "member-3-shard-cars", -1L, -1L), null);
        followerCars.tell((Object)new RequestVote(initialState.getCurrentTerm() + 1L, "member-3-shard-cars", -1L, -1L), null);
        cars.tell((Object)new RequestVote(initialState.getCurrentTerm() + 3L, "member-3-shard-cars", -1L, -1L), null);
        followerCars.tell((Object)new RequestVote(initialState.getCurrentTerm() + 3L, "member-3-shard-cars", -1L, -1L), null);
        OnDemandRaftState stateAfter = (OnDemandRaftState)this.leaderDistributedDataStore.getActorUtils().executeOperation(cars, (Object)GetOnDemandRaftState.INSTANCE);
        OnDemandRaftState followerState = (OnDemandRaftState)this.followerDistributedDataStore.getActorUtils().executeOperation(cars, (Object)GetOnDemandRaftState.INSTANCE);
        Assert.assertEquals((long)initialState.getCurrentTerm(), (long)stateAfter.getCurrentTerm());
        Assert.assertEquals((long)initialState.getCurrentTerm(), (long)followerState.getCurrentTerm());
        ds2.close();
    }

    @Test
    public void testInstallSnapshot() throws Exception {
        String testName = "testInstallSnapshot";
        String leaderCarShardName = "member-1-shard-cars-testInstallSnapshot";
        String followerCarShardName = "member-2-shard-cars-testInstallSnapshot";
        DataTree tree = new InMemoryDataTreeFactory().create(DataTreeConfiguration.DEFAULT_CONFIGURATION, SchemaContextHelper.full());
        ContainerNode carsNode = CarsModel.newCarsNode(CarsModel.newCarsMapNode(CarsModel.newCarEntry("optima", Uint64.valueOf((int)20000))));
        AbstractShardTest.writeToStore(tree, CarsModel.BASE_PATH, (NormalizedNode)carsNode);
        NormalizedNode snapshotRoot = AbstractShardTest.readStore(tree, YangInstanceIdentifier.empty());
        Snapshot initialSnapshot = Snapshot.create((Snapshot.State)new ShardSnapshotState((ShardDataTreeSnapshot)new MetadataShardDataTreeSnapshot(snapshotRoot)), Collections.emptyList(), (long)5L, (long)1L, (long)5L, (long)1L, (long)1L, null, null);
        InMemorySnapshotStore.addSnapshot((String)"member-1-shard-cars-testInstallSnapshot", (Object)initialSnapshot);
        InMemorySnapshotStore.addSnapshotSavedLatch((String)"member-1-shard-cars-testInstallSnapshot");
        InMemorySnapshotStore.addSnapshotSavedLatch((String)"member-2-shard-cars-testInstallSnapshot");
        this.initDatastoresWithCars("testInstallSnapshot");
        Optional readOptional = (Optional)this.leaderDistributedDataStore.newReadOnlyTransaction().read(CarsModel.BASE_PATH).get(5L, TimeUnit.SECONDS);
        Assert.assertTrue((String)"isPresent", (boolean)readOptional.isPresent());
        Assert.assertEquals((String)"Node", (Object)carsNode, readOptional.get());
        DistributedDataStoreRemotingIntegrationTest.verifySnapshot((Snapshot)InMemorySnapshotStore.waitForSavedSnapshot((String)"member-1-shard-cars-testInstallSnapshot", Snapshot.class), initialSnapshot, snapshotRoot);
        DistributedDataStoreRemotingIntegrationTest.verifySnapshot((Snapshot)InMemorySnapshotStore.waitForSavedSnapshot((String)"member-2-shard-cars-testInstallSnapshot", Snapshot.class), initialSnapshot, snapshotRoot);
    }

    @Test
    public void testReadWriteMessageSlicing() throws Exception {
        Assume.assumeTrue((boolean)ClientBackedDataStore.class.isAssignableFrom(this.testParameter));
        this.leaderDatastoreContextBuilder.maximumMessageSliceSize(100);
        this.followerDatastoreContextBuilder.maximumMessageSliceSize(100);
        this.initDatastoresWithCars("testLargeReadReplySlicing");
        DOMStoreReadWriteTransaction rwTx = this.followerDistributedDataStore.newReadWriteTransaction();
        ContainerNode carsNode = CarsModel.create();
        rwTx.write(CarsModel.BASE_PATH, (NormalizedNode)carsNode);
        DistributedDataStoreRemotingIntegrationTest.verifyNode((DOMStoreReadTransaction)rwTx, CarsModel.BASE_PATH, (NormalizedNode)carsNode);
    }

    @Test
    public void testRaftCallbackDuringLeadershipDrop() throws Exception {
        String testName = "testRaftCallbackDuringLeadershipDrop";
        this.initDatastores("testRaftCallbackDuringLeadershipDrop", MODULE_SHARDS_CARS_1_2_3, CARS);
        ExecutorService executor = Executors.newSingleThreadExecutor();
        IntegrationTestKit follower2TestKit = new IntegrationTestKit(this.follower2System, DatastoreContext.newBuilderFrom((DatastoreContext)this.followerDatastoreContextBuilder.build()).operationTimeoutInMillis(500L).shardLeaderElectionTimeoutInSeconds(3600L), this.commitTimeout);
        DOMStoreWriteTransaction initialWriteTx = this.leaderDistributedDataStore.newWriteOnlyTransaction();
        initialWriteTx.write(CarsModel.BASE_PATH, (NormalizedNode)CarsModel.emptyContainer());
        this.leaderTestKit.doCommit(initialWriteTx.ready());
        try (AbstractDataStore follower2DistributedDataStore = follower2TestKit.setupAbstractDataStore(this.testParameter, "testRaftCallbackDuringLeadershipDrop", MODULE_SHARDS_CARS_1_2_3, false, new String[0]);){
            ActorRef member3Cars = ((LocalShardStore)follower2DistributedDataStore).getLocalShards().getLocalShards().get("cars").getActor();
            ActorRef member2Cars = ((LocalShardStore)this.followerDistributedDataStore).getLocalShards().getLocalShards().get("cars").getActor();
            member2Cars.tell(new TestShard.StartDropMessages<AppendEntries>(AppendEntries.class), null);
            member3Cars.tell(new TestShard.StartDropMessages<AppendEntries>(AppendEntries.class), null);
            DOMStoreWriteTransaction newTx = this.leaderDistributedDataStore.newWriteOnlyTransaction();
            newTx.write(CarsModel.CAR_LIST_PATH, (NormalizedNode)CarsModel.newCarMapNode());
            AtomicBoolean submitDone = new AtomicBoolean(false);
            executor.submit(() -> {
                try {
                    this.leaderTestKit.doCommit(newTx.ready());
                    submitDone.set(true);
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            });
            ActorRef leaderCars = ((LocalShardStore)this.leaderDistributedDataStore).getLocalShards().getLocalShards().get("cars").getActor();
            Awaitility.await().atMost(10L, TimeUnit.SECONDS).until(() -> ((OnDemandRaftState)this.leaderDistributedDataStore.getActorUtils().executeOperation(leaderCars, (Object)GetOnDemandRaftState.INSTANCE)).getLastIndex() >= 1L);
            OnDemandRaftState raftState = (OnDemandRaftState)this.leaderDistributedDataStore.getActorUtils().executeOperation(leaderCars, (Object)GetOnDemandRaftState.INSTANCE);
            leaderCars.tell((Object)new RequestVote(raftState.getCurrentTerm() + 1L, "member-3-shard-cars-testRaftCallbackDuringLeadershipDrop", -1L, -1L), member3Cars);
            member2Cars.tell(new TestShard.StopDropMessages<AppendEntries>(AppendEntries.class), null);
            member3Cars.tell(new TestShard.StopDropMessages<AppendEntries>(AppendEntries.class), null);
            Awaitility.await((String)"Is tx stuck in COMMIT_PENDING").atMost(10L, TimeUnit.SECONDS).untilAtomic(submitDone, Matchers.equalTo((Object)true));
        }
        executor.shutdownNow();
    }

    @Test
    public void testSnapshotOnRootOverwrite() throws Exception {
        if (!DistributedDataStore.class.isAssignableFrom(this.testParameter)) {
            return;
        }
        String testName = "testSnapshotOnRootOverwrite";
        String[] shards = new String[]{"cars", "default"};
        this.initDatastores("testSnapshotOnRootOverwrite", "module-shards-default-cars-member1-and-2.conf", shards, this.leaderDatastoreContextBuilder.snapshotOnRootOverwrite(true), this.followerDatastoreContextBuilder.snapshotOnRootOverwrite(true));
        this.leaderTestKit.waitForMembersUp("member-2");
        ContainerNode rootNode = (ContainerNode)ImmutableContainerNodeBuilder.create().withNodeIdentifier((YangInstanceIdentifier.PathArgument)YangInstanceIdentifier.NodeIdentifier.create((QName)SchemaContext.NAME)).withChild((DataContainerChild)CarsModel.create()).build();
        this.leaderTestKit.testWriteTransaction(this.leaderDistributedDataStore, YangInstanceIdentifier.empty(), (NormalizedNode)rootNode);
        IntegrationTestKit.verifyShardState(this.leaderDistributedDataStore, "cars", state -> Assert.assertEquals((long)1L, (long)state.getSnapshotIndex()));
        IntegrationTestKit.verifyShardState(this.followerDistributedDataStore, "cars", state -> Assert.assertEquals((long)1L, (long)state.getSnapshotIndex()));
        this.verifySnapshot("member-1-shard-cars-testSnapshotOnRootOverwrite", 1L);
        this.verifySnapshot("member-2-shard-cars-testSnapshotOnRootOverwrite", 1L);
        for (int i = 0; i < 10; ++i) {
            this.leaderTestKit.testWriteTransaction(this.leaderDistributedDataStore, CarsModel.newCarPath("car " + i), (NormalizedNode)CarsModel.newCarEntry("car " + i, Uint64.ONE));
        }
        IntegrationTestKit.verifyShardState(this.leaderDistributedDataStore, "cars", state -> Assert.assertEquals((long)10L, (long)state.getSnapshotIndex()));
        IntegrationTestKit.verifyShardState(this.followerDistributedDataStore, "cars", state -> Assert.assertEquals((long)10L, (long)state.getSnapshotIndex()));
        this.verifySnapshot("member-1-shard-cars-testSnapshotOnRootOverwrite", 1L);
        this.verifySnapshot("member-2-shard-cars-testSnapshotOnRootOverwrite", 1L);
        this.leaderTestKit.testWriteTransaction(this.leaderDistributedDataStore, YangInstanceIdentifier.empty(), (NormalizedNode)rootNode);
        IntegrationTestKit.verifyShardState(this.leaderDistributedDataStore, "cars", state -> Assert.assertEquals((long)12L, (long)state.getSnapshotIndex()));
        IntegrationTestKit.verifyShardState(this.followerDistributedDataStore, "cars", state -> Assert.assertEquals((long)12L, (long)state.getSnapshotIndex()));
        this.verifySnapshot("member-1-shard-cars-testSnapshotOnRootOverwrite", 12L);
        this.verifySnapshot("member-2-shard-cars-testSnapshotOnRootOverwrite", 12L);
    }

    private void verifySnapshot(String persistenceId, long lastAppliedIndex) {
        Awaitility.await().atMost(5L, TimeUnit.SECONDS).untilAsserted(() -> {
            List snap = InMemorySnapshotStore.getSnapshots((String)persistenceId, Snapshot.class);
            Assert.assertEquals((long)1L, (long)snap.size());
            Assert.assertEquals((long)lastAppliedIndex, (long)((Snapshot)snap.get(0)).getLastAppliedIndex());
        });
    }

    private static void verifySnapshot(Snapshot actual, Snapshot expected, NormalizedNode expRoot) {
        Assert.assertEquals((String)"Snapshot getLastAppliedTerm", (long)expected.getLastAppliedTerm(), (long)actual.getLastAppliedTerm());
        Assert.assertEquals((String)"Snapshot getLastAppliedIndex", (long)expected.getLastAppliedIndex(), (long)actual.getLastAppliedIndex());
        Assert.assertEquals((String)"Snapshot getLastTerm", (long)expected.getLastTerm(), (long)actual.getLastTerm());
        Assert.assertEquals((String)"Snapshot getLastIndex", (long)expected.getLastIndex(), (long)actual.getLastIndex());
        Assert.assertEquals((String)"Snapshot state type", ShardSnapshotState.class, actual.getState().getClass());
        MetadataShardDataTreeSnapshot shardSnapshot = (MetadataShardDataTreeSnapshot)((ShardSnapshotState)actual.getState()).getSnapshot();
        Assert.assertEquals((String)"Snapshot root node", (Object)expRoot, shardSnapshot.getRootNode().get());
    }

    private static void sendDatastoreContextUpdate(AbstractDataStore dataStore, DatastoreContext.Builder builder) {
        DatastoreContext.Builder newBuilder = DatastoreContext.newBuilderFrom((DatastoreContext)builder.build());
        DatastoreContextFactory mockContextFactory = (DatastoreContextFactory)Mockito.mock(DatastoreContextFactory.class);
        Answer answer = invocation -> newBuilder.build();
        ((DatastoreContextFactory)Mockito.doAnswer((Answer)answer).when((Object)mockContextFactory)).getBaseDatastoreContext();
        ((DatastoreContextFactory)Mockito.doAnswer((Answer)answer).when((Object)mockContextFactory)).getShardDatastoreContext(Mockito.anyString());
        dataStore.onDatastoreContextUpdated(mockContextFactory);
    }
}

