/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.cluster.datastore;

import akka.actor.ActorRef;
import java.util.Optional;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.opendaylight.controller.cluster.access.commands.ModifyTransactionRequest;
import org.opendaylight.controller.cluster.access.commands.ModifyTransactionRequestBuilder;
import org.opendaylight.controller.cluster.access.commands.ReadTransactionRequest;
import org.opendaylight.controller.cluster.access.commands.TransactionModification;
import org.opendaylight.controller.cluster.access.commands.TransactionRequest;
import org.opendaylight.controller.cluster.access.commands.TransactionSuccess;
import org.opendaylight.controller.cluster.access.concepts.ClientIdentifier;
import org.opendaylight.controller.cluster.access.concepts.FrontendIdentifier;
import org.opendaylight.controller.cluster.access.concepts.FrontendType;
import org.opendaylight.controller.cluster.access.concepts.LocalHistoryIdentifier;
import org.opendaylight.controller.cluster.access.concepts.MemberName;
import org.opendaylight.controller.cluster.access.concepts.RequestEnvelope;
import org.opendaylight.controller.cluster.access.concepts.RequestException;
import org.opendaylight.controller.cluster.access.concepts.TransactionIdentifier;
import org.opendaylight.controller.cluster.datastore.AbstractFrontendHistory;
import org.opendaylight.controller.cluster.datastore.AbstractShardDataTreeTransaction;
import org.opendaylight.controller.cluster.datastore.FrontendReadWriteTransaction;
import org.opendaylight.controller.cluster.datastore.ReadWriteShardDataTreeTransaction;
import org.opendaylight.controller.cluster.datastore.ShardDataTreeCohort;
import org.opendaylight.controller.cluster.datastore.ShardDataTreeTransactionParent;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;
import org.opendaylight.yangtools.yang.data.api.schema.tree.DataTreeModification;

public class FrontendReadWriteTransactionTest {
    private static final ClientIdentifier CLIENT_ID = ClientIdentifier.create((FrontendIdentifier)FrontendIdentifier.create((MemberName)MemberName.forName((String)"mock"), (FrontendType)FrontendType.forName((String)"mock")), (long)0L);
    private static final LocalHistoryIdentifier HISTORY_ID = new LocalHistoryIdentifier(CLIENT_ID, 0L);
    private static final TransactionIdentifier TX_ID = new TransactionIdentifier(HISTORY_ID, 0L);
    private AbstractFrontendHistory mockHistory;
    private ReadWriteShardDataTreeTransaction shardTransaction;
    private DataTreeModification mockModification;
    private ShardDataTreeTransactionParent mockParent;
    private FrontendReadWriteTransaction openTx;
    private ShardDataTreeCohort mockCohort;

    @Before
    public void setup() {
        this.mockHistory = (AbstractFrontendHistory)Mockito.mock(AbstractFrontendHistory.class);
        this.mockParent = (ShardDataTreeTransactionParent)Mockito.mock(ShardDataTreeTransactionParent.class);
        this.mockModification = (DataTreeModification)Mockito.mock(DataTreeModification.class);
        this.mockCohort = (ShardDataTreeCohort)Mockito.mock(ShardDataTreeCohort.class);
        this.shardTransaction = new ReadWriteShardDataTreeTransaction(this.mockParent, TX_ID, this.mockModification);
        this.openTx = FrontendReadWriteTransaction.createOpen((AbstractFrontendHistory)this.mockHistory, (ReadWriteShardDataTreeTransaction)this.shardTransaction);
        Mockito.when((Object)this.mockParent.finishTransaction((ReadWriteShardDataTreeTransaction)ArgumentMatchers.same((Object)this.shardTransaction), (Optional)ArgumentMatchers.eq(Optional.empty()))).thenReturn((Object)this.mockCohort);
    }

    private TransactionSuccess<?> handleRequest(TransactionRequest<?> request) throws RequestException {
        return this.openTx.doHandleRequest(request, new RequestEnvelope(request, 0L, 0L), 0L);
    }

    @Test
    public void testDuplicateModifyAbort() throws RequestException {
        ModifyTransactionRequestBuilder b = new ModifyTransactionRequestBuilder(TX_ID, (ActorRef)Mockito.mock(ActorRef.class));
        b.setSequence(0L);
        b.setAbort();
        ModifyTransactionRequest abortReq = b.build();
        Assert.assertNull(this.handleRequest((TransactionRequest<?>)abortReq));
        ((ShardDataTreeTransactionParent)Mockito.verify((Object)this.mockParent)).abortTransaction((AbstractShardDataTreeTransaction)ArgumentMatchers.same((Object)this.shardTransaction), (Runnable)ArgumentMatchers.any(Runnable.class));
        Assert.assertNull(this.handleRequest((TransactionRequest<?>)abortReq));
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.mockParent});
    }

    @Test
    public void testDuplicateReady() throws RequestException {
        ModifyTransactionRequestBuilder b = new ModifyTransactionRequestBuilder(TX_ID, (ActorRef)Mockito.mock(ActorRef.class));
        b.setSequence(0L);
        b.setReady();
        ModifyTransactionRequest readyReq = b.build();
        Assert.assertNotNull(this.handleRequest((TransactionRequest<?>)readyReq));
        ((ShardDataTreeTransactionParent)Mockito.verify((Object)this.mockParent)).finishTransaction((ReadWriteShardDataTreeTransaction)ArgumentMatchers.same((Object)this.shardTransaction), (Optional)ArgumentMatchers.eq(Optional.empty()));
        Assert.assertNotNull(this.handleRequest((TransactionRequest<?>)readyReq));
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.mockParent});
    }

    @Test
    public void testDuplicateDirect() throws RequestException {
        ModifyTransactionRequestBuilder b = new ModifyTransactionRequestBuilder(TX_ID, (ActorRef)Mockito.mock(ActorRef.class));
        b.setSequence(0L);
        b.setCommit(false);
        ModifyTransactionRequest readyReq = b.build();
        Assert.assertNull(this.handleRequest((TransactionRequest<?>)readyReq));
        ((ShardDataTreeTransactionParent)Mockito.verify((Object)this.mockParent)).finishTransaction((ReadWriteShardDataTreeTransaction)ArgumentMatchers.same((Object)this.shardTransaction), (Optional)ArgumentMatchers.eq(Optional.empty()));
        Assert.assertNull(this.handleRequest((TransactionRequest<?>)readyReq));
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.mockParent});
    }

    @Test
    public void testDuplicateCoordinated() throws RequestException {
        ModifyTransactionRequestBuilder b = new ModifyTransactionRequestBuilder(TX_ID, (ActorRef)Mockito.mock(ActorRef.class));
        b.setSequence(0L);
        b.setCommit(true);
        ModifyTransactionRequest readyReq = b.build();
        Assert.assertNull(this.handleRequest((TransactionRequest<?>)readyReq));
        ((ShardDataTreeTransactionParent)Mockito.verify((Object)this.mockParent)).finishTransaction((ReadWriteShardDataTreeTransaction)ArgumentMatchers.same((Object)this.shardTransaction), (Optional)ArgumentMatchers.eq(Optional.empty()));
        Assert.assertNull(this.handleRequest((TransactionRequest<?>)readyReq));
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.mockParent});
    }

    @Test(expected=IllegalStateException.class)
    public void testReadAfterReady() throws RequestException {
        ModifyTransactionRequestBuilder b = new ModifyTransactionRequestBuilder(TX_ID, (ActorRef)Mockito.mock(ActorRef.class));
        b.setSequence(0L);
        b.setReady();
        ModifyTransactionRequest readyReq = b.build();
        Assert.assertNotNull(this.handleRequest((TransactionRequest<?>)readyReq));
        ((ShardDataTreeTransactionParent)Mockito.verify((Object)this.mockParent)).finishTransaction((ReadWriteShardDataTreeTransaction)ArgumentMatchers.same((Object)this.shardTransaction), (Optional)ArgumentMatchers.eq(Optional.empty()));
        this.handleRequest((TransactionRequest<?>)new ReadTransactionRequest(TX_ID, 0L, (ActorRef)Mockito.mock(ActorRef.class), YangInstanceIdentifier.empty(), true));
    }

    @Test(expected=IllegalStateException.class)
    public void testModifyAfterReady() throws RequestException {
        ModifyTransactionRequestBuilder b = new ModifyTransactionRequestBuilder(TX_ID, (ActorRef)Mockito.mock(ActorRef.class));
        b.setSequence(0L);
        b.setReady();
        ModifyTransactionRequest readyReq = b.build();
        Assert.assertNotNull(this.handleRequest((TransactionRequest<?>)readyReq));
        ((ShardDataTreeTransactionParent)Mockito.verify((Object)this.mockParent)).finishTransaction((ReadWriteShardDataTreeTransaction)ArgumentMatchers.same((Object)this.shardTransaction), (Optional)ArgumentMatchers.eq(Optional.empty()));
        b.setSequence(1L);
        b.addModification((TransactionModification)Mockito.mock(TransactionModification.class));
        this.handleRequest((TransactionRequest<?>)b.build());
    }

    @Test(expected=IllegalStateException.class)
    public void testReadAfterAbort() throws RequestException {
        ModifyTransactionRequestBuilder b = new ModifyTransactionRequestBuilder(TX_ID, (ActorRef)Mockito.mock(ActorRef.class));
        b.setSequence(0L);
        b.setAbort();
        ModifyTransactionRequest abortReq = b.build();
        Assert.assertNull(this.handleRequest((TransactionRequest<?>)abortReq));
        ((ShardDataTreeTransactionParent)Mockito.verify((Object)this.mockParent)).abortTransaction((AbstractShardDataTreeTransaction)ArgumentMatchers.same((Object)this.shardTransaction), (Runnable)ArgumentMatchers.any(Runnable.class));
        this.handleRequest((TransactionRequest<?>)new ReadTransactionRequest(TX_ID, 0L, (ActorRef)Mockito.mock(ActorRef.class), YangInstanceIdentifier.empty(), true));
    }
}

