/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.cluster.datastore;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.HashSet;
import java.util.concurrent.TimeUnit;
import org.awaitility.Awaitility;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;
import org.opendaylight.controller.cluster.datastore.AbstractShardTest;
import org.opendaylight.controller.cluster.datastore.DatastoreContext;
import org.opendaylight.controller.cluster.raft.persisted.ApplyJournalEntries;
import org.opendaylight.controller.cluster.raft.persisted.SimpleReplicatedLogEntry;
import org.opendaylight.controller.cluster.raft.protobuff.client.messages.Payload;
import org.opendaylight.controller.cluster.raft.utils.InMemoryJournal;
import org.opendaylight.controller.md.cluster.datastore.model.TestModel;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.config.distributed.datastore.provider.rev140612.DataStoreProperties;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;
import org.opendaylight.yangtools.yang.data.api.schema.NormalizedNode;
import org.opendaylight.yangtools.yang.data.api.schema.tree.DataTree;
import org.opendaylight.yangtools.yang.data.api.schema.tree.DataTreeModification;
import org.opendaylight.yangtools.yang.data.impl.schema.ImmutableNodes;

public class JsonExportTest
extends AbstractShardTest {
    private static final String DUMMY_DATA = "Dummy data as snapshot sequence number is set to 0 in InMemorySnapshotStore and journal recovery seq number will start from 1";
    private static final String EXPECTED_JOURNAL_FILE = "expectedJournalExport.json";
    private static final String EXPECTED_SNAPSHOT_FILE = "expectedSnapshotExport.json";
    private static String actualJournalFilePath;
    private static String actualSnapshotFilePath;
    private DatastoreContext datastoreContext;
    @Rule
    public TemporaryFolder temporaryFolder = new TemporaryFolder();

    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
        File exportTmpFolder = this.temporaryFolder.newFolder("persistence-export");
        actualJournalFilePath = exportTmpFolder.getAbsolutePath() + "/journals/member-1-shard-inventory-config" + this.nextShardNum + "-journal.json";
        actualSnapshotFilePath = exportTmpFolder.getAbsolutePath() + "/snapshots/member-1-shard-inventory-config" + this.nextShardNum + "-snapshot.json";
        this.datastoreContext = DatastoreContext.newBuilder().shardJournalRecoveryLogBatchSize(1).shardSnapshotBatchCount(5000).shardHeartbeatIntervalInMillis(100).persistent(true).exportOnRecovery(DataStoreProperties.ExportOnRecovery.Json).recoveryExportBaseDir(exportTmpFolder.getAbsolutePath()).build();
    }

    @Override
    protected DatastoreContext newDatastoreContext() {
        return this.datastoreContext;
    }

    @Test
    public void testJsonExport() throws Exception {
        DataTree source = this.setupInMemorySnapshotStore();
        DataTreeModification writeMod = source.takeSnapshot().newModification();
        writeMod.write(TestModel.OUTER_LIST_PATH, ImmutableNodes.mapNodeBuilder((QName)TestModel.OUTER_LIST_QNAME).build());
        writeMod.ready();
        InMemoryJournal.addEntry((String)this.shardID.toString(), (long)0L, (Object)DUMMY_DATA);
        InMemoryJournal.addEntry((String)this.shardID.toString(), (long)1L, (Object)new SimpleReplicatedLogEntry(0L, 1L, (Payload)JsonExportTest.payloadForModification(source, writeMod, JsonExportTest.nextTransactionId())));
        int nListEntries = 16;
        HashSet<Integer> listEntryKeys = new HashSet<Integer>();
        for (int i = 1; i <= 16; ++i) {
            listEntryKeys.add(i);
            YangInstanceIdentifier path = YangInstanceIdentifier.builder((YangInstanceIdentifier)TestModel.OUTER_LIST_PATH).nodeWithKey(TestModel.OUTER_LIST_QNAME, TestModel.ID_QNAME, (Object)i).build();
            DataTreeModification mod = source.takeSnapshot().newModification();
            mod.merge(path, (NormalizedNode)ImmutableNodes.mapEntry((QName)TestModel.OUTER_LIST_QNAME, (QName)TestModel.ID_QNAME, (Object)i));
            mod.ready();
            InMemoryJournal.addEntry((String)this.shardID.toString(), (long)(i + 1), (Object)new SimpleReplicatedLogEntry((long)i, 1L, (Payload)JsonExportTest.payloadForModification(source, mod, JsonExportTest.nextTransactionId())));
        }
        InMemoryJournal.addEntry((String)this.shardID.toString(), (long)18L, (Object)new ApplyJournalEntries(16L));
        this.testRecovery(listEntryKeys, false);
        JsonExportTest.verifyJournalExport();
        JsonExportTest.verifySnapshotExport();
    }

    private static void verifyJournalExport() throws IOException {
        String expectedJournalData = JsonExportTest.readExpectedFile(EXPECTED_JOURNAL_FILE);
        String actualJournalData = JsonExportTest.readActualFile(actualJournalFilePath);
        Assert.assertEquals((String)"Exported journal is not expected ", (Object)expectedJournalData, (Object)actualJournalData);
    }

    private static void verifySnapshotExport() throws IOException {
        String expectedSnapshotData = JsonExportTest.readExpectedFile(EXPECTED_SNAPSHOT_FILE);
        String actualSnapshotData = JsonExportTest.readActualFile(actualSnapshotFilePath);
        Assert.assertEquals((String)"Exported snapshot is not expected ", (Object)expectedSnapshotData, (Object)actualSnapshotData);
    }

    private static String readExpectedFile(String filePath) throws IOException {
        File exportFile = new File(JsonExportTest.class.getClassLoader().getResource(filePath).getFile());
        return new String(Files.readAllBytes(Path.of(exportFile.getPath(), new String[0])));
    }

    private static String readActualFile(String filePath) throws IOException {
        File exportFile = new File(filePath);
        Awaitility.await().atMost(10L, TimeUnit.SECONDS).until(exportFile::exists);
        return new String(Files.readAllBytes(Path.of(filePath, new String[0])));
    }
}

