/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.cluster.datastore;

import com.google.common.primitives.UnsignedLong;
import com.google.common.util.concurrent.FutureCallback;
import org.mockito.ArgumentMatchers;
import org.mockito.InOrder;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.verification.VerificationMode;
import org.opendaylight.controller.cluster.access.concepts.TransactionIdentifier;
import org.opendaylight.controller.cluster.datastore.Shard;
import org.opendaylight.controller.cluster.datastore.ShardDataTree;
import org.opendaylight.controller.cluster.datastore.ShardDataTreeCohort;
import org.opendaylight.controller.cluster.datastore.persisted.CommitTransactionPayload;
import org.opendaylight.controller.cluster.raft.protobuff.client.messages.Payload;
import org.opendaylight.yangtools.concepts.Identifier;
import org.opendaylight.yangtools.yang.data.api.schema.tree.DataTreeCandidate;

public final class ShardDataTreeMocking {
    private ShardDataTreeMocking() {
        throw new UnsupportedOperationException();
    }

    private static <T> FutureCallback<T> mockCallback() {
        return (FutureCallback)Mockito.mock(FutureCallback.class);
    }

    public static ShardDataTreeCohort immediateCanCommit(ShardDataTreeCohort cohort) {
        FutureCallback callback = ShardDataTreeMocking.mockCallback();
        ((FutureCallback)Mockito.doNothing().when(callback)).onSuccess(null);
        cohort.canCommit(callback);
        ((FutureCallback)Mockito.verify(callback)).onSuccess(null);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{callback});
        return cohort;
    }

    public static FutureCallback<Void> coordinatedCanCommit(ShardDataTreeCohort cohort) {
        FutureCallback callback = ShardDataTreeMocking.mockCallback();
        ((FutureCallback)Mockito.doNothing().when(callback)).onSuccess(null);
        ((FutureCallback)Mockito.doNothing().when(callback)).onFailure((Throwable)ArgumentMatchers.any(Throwable.class));
        cohort.canCommit(callback);
        return callback;
    }

    public static ShardDataTreeCohort immediatePreCommit(ShardDataTreeCohort cohort) {
        FutureCallback callback = ShardDataTreeMocking.mockCallback();
        ((FutureCallback)Mockito.doNothing().when(callback)).onSuccess((Object)((DataTreeCandidate)ArgumentMatchers.any(DataTreeCandidate.class)));
        cohort.preCommit(callback);
        ((FutureCallback)Mockito.verify(callback)).onSuccess((Object)((DataTreeCandidate)ArgumentMatchers.any(DataTreeCandidate.class)));
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{callback});
        return cohort;
    }

    public static FutureCallback<DataTreeCandidate> coordinatedPreCommit(ShardDataTreeCohort cohort) {
        FutureCallback callback = ShardDataTreeMocking.mockCallback();
        ((FutureCallback)Mockito.doNothing().when(callback)).onSuccess((Object)((DataTreeCandidate)ArgumentMatchers.any(DataTreeCandidate.class)));
        ((FutureCallback)Mockito.doNothing().when(callback)).onFailure((Throwable)ArgumentMatchers.any(Throwable.class));
        cohort.preCommit(callback);
        return callback;
    }

    public static ShardDataTreeCohort immediateCommit(ShardDataTreeCohort cohort) {
        FutureCallback callback = ShardDataTreeMocking.mockCallback();
        ((FutureCallback)Mockito.doNothing().when(callback)).onSuccess((Object)((UnsignedLong)ArgumentMatchers.any(UnsignedLong.class)));
        cohort.commit(callback);
        ((FutureCallback)Mockito.verify(callback, (VerificationMode)Mockito.timeout((long)5000L))).onSuccess((Object)((UnsignedLong)ArgumentMatchers.any(UnsignedLong.class)));
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{callback});
        return cohort;
    }

    public static FutureCallback<UnsignedLong> coordinatedCommit(ShardDataTreeCohort cohort) {
        FutureCallback callback = ShardDataTreeMocking.mockCallback();
        ((FutureCallback)Mockito.doNothing().when(callback)).onSuccess((Object)((UnsignedLong)ArgumentMatchers.any(UnsignedLong.class)));
        ((FutureCallback)Mockito.doNothing().when(callback)).onFailure((Throwable)ArgumentMatchers.any(Throwable.class));
        cohort.commit(callback);
        return callback;
    }

    public static FutureCallback<UnsignedLong> immediate3PhaseCommit(ShardDataTreeCohort cohort) {
        FutureCallback commitCallback = ShardDataTreeMocking.mockCallback();
        ((FutureCallback)Mockito.doNothing().when(commitCallback)).onSuccess((Object)((UnsignedLong)ArgumentMatchers.any(UnsignedLong.class)));
        ((FutureCallback)Mockito.doNothing().when(commitCallback)).onFailure((Throwable)ArgumentMatchers.any(Throwable.class));
        FutureCallback preCommitCallback = ShardDataTreeMocking.mockCallback();
        ((FutureCallback)Mockito.doAnswer(invocation -> {
            cohort.commit(commitCallback);
            return null;
        }).when(preCommitCallback)).onSuccess((Object)((DataTreeCandidate)ArgumentMatchers.any(DataTreeCandidate.class)));
        ((FutureCallback)Mockito.doNothing().when(preCommitCallback)).onFailure((Throwable)ArgumentMatchers.any(Throwable.class));
        FutureCallback canCommit = ShardDataTreeMocking.mockCallback();
        ((FutureCallback)Mockito.doAnswer(invocation -> {
            cohort.preCommit(preCommitCallback);
            return null;
        }).when(canCommit)).onSuccess(null);
        ((FutureCallback)Mockito.doNothing().when(canCommit)).onFailure((Throwable)ArgumentMatchers.any(Throwable.class));
        cohort.canCommit(canCommit);
        return commitCallback;
    }

    private static <T> Object invokeSuccess(InvocationOnMock invocation, T value) {
        ((FutureCallback)invocation.getArgument(0)).onSuccess(value);
        return null;
    }

    private static Object invokeFailure(InvocationOnMock invocation) {
        ((FutureCallback)invocation.getArgument(0)).onFailure((Throwable)Mockito.mock(Exception.class));
        return null;
    }

    public static ShardDataTreeCohort failedCanCommit(ShardDataTreeCohort mock) {
        ((ShardDataTreeCohort)Mockito.doAnswer(ShardDataTreeMocking::invokeFailure).when((Object)mock)).canCommit((FutureCallback)ArgumentMatchers.any(FutureCallback.class));
        return mock;
    }

    public static ShardDataTreeCohort failedPreCommit(ShardDataTreeCohort mock) {
        ((ShardDataTreeCohort)Mockito.doAnswer(ShardDataTreeMocking::invokeFailure).when((Object)mock)).preCommit((FutureCallback)ArgumentMatchers.any(FutureCallback.class));
        return mock;
    }

    public static ShardDataTreeCohort failedCommit(ShardDataTreeCohort mock) {
        ((ShardDataTreeCohort)Mockito.doAnswer(ShardDataTreeMocking::invokeFailure).when((Object)mock)).commit((FutureCallback)ArgumentMatchers.any(FutureCallback.class));
        return mock;
    }

    public static ShardDataTreeCohort successfulCanCommit(ShardDataTreeCohort mock) {
        ((ShardDataTreeCohort)Mockito.doAnswer(invocation -> ShardDataTreeMocking.invokeSuccess(invocation, null)).when((Object)mock)).canCommit((FutureCallback)ArgumentMatchers.any(FutureCallback.class));
        return mock;
    }

    public static ShardDataTreeCohort successfulPreCommit(ShardDataTreeCohort mock) {
        return ShardDataTreeMocking.successfulPreCommit(mock, (DataTreeCandidate)Mockito.mock(DataTreeCandidate.class));
    }

    public static ShardDataTreeCohort successfulPreCommit(ShardDataTreeCohort mock, DataTreeCandidate candidate) {
        ((ShardDataTreeCohort)Mockito.doAnswer(invocation -> ShardDataTreeMocking.invokeSuccess(invocation, candidate)).when((Object)mock)).preCommit((FutureCallback)ArgumentMatchers.any(FutureCallback.class));
        return mock;
    }

    public static ShardDataTreeCohort successfulCommit(ShardDataTreeCohort mock) {
        return ShardDataTreeMocking.successfulCommit(mock, UnsignedLong.ZERO);
    }

    public static ShardDataTreeCohort successfulCommit(ShardDataTreeCohort mock, UnsignedLong index) {
        ((ShardDataTreeCohort)Mockito.doAnswer(invocation -> ShardDataTreeMocking.invokeSuccess(invocation, index)).when((Object)mock)).commit((FutureCallback)ArgumentMatchers.any(FutureCallback.class));
        return mock;
    }

    public static void assertSequencedCommit(ShardDataTreeCohort mock) {
        InOrder inOrder = Mockito.inOrder((Object[])new Object[]{mock});
        ((ShardDataTreeCohort)inOrder.verify((Object)mock)).canCommit((FutureCallback)ArgumentMatchers.any(FutureCallback.class));
        ((ShardDataTreeCohort)inOrder.verify((Object)mock)).preCommit((FutureCallback)ArgumentMatchers.any(FutureCallback.class));
        ((ShardDataTreeCohort)inOrder.verify((Object)mock)).commit((FutureCallback)ArgumentMatchers.any(FutureCallback.class));
    }

    public static void immediatePayloadReplication(ShardDataTree shardDataTree, Shard mockShard) {
        ((Shard)Mockito.doAnswer(invocation -> {
            shardDataTree.applyReplicatedPayload((Identifier)invocation.getArgument(0), (Payload)invocation.getArgument(1));
            return null;
        }).when((Object)mockShard)).persistPayload((Identifier)ArgumentMatchers.any(TransactionIdentifier.class), (Payload)ArgumentMatchers.any(CommitTransactionPayload.class), ArgumentMatchers.anyBoolean());
    }
}

