/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.cluster.datastore;

import java.lang.management.ManagementFactory;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.opendaylight.controller.cluster.datastore.ShardStats;

public class ShardStatsTest {
    private MBeanServer mbeanServer;
    private ShardStats shardStats;
    private ObjectName testMBeanName;

    @Before
    public void setUp() throws Exception {
        this.shardStats = new ShardStats("shard-1", "DataStore", null);
        this.shardStats.registerMBean();
        this.mbeanServer = ManagementFactory.getPlatformMBeanServer();
        String objectName = "org.opendaylight.controller:type=" + this.shardStats.getMBeanType() + ",Category=" + this.shardStats.getMBeanCategory() + ",name=" + this.shardStats.getMBeanName();
        this.testMBeanName = new ObjectName(objectName);
    }

    @After
    public void tearDown() {
        this.shardStats.unregisterMBean();
    }

    @Test
    public void testGetShardName() throws Exception {
        Object attribute = this.mbeanServer.getAttribute(this.testMBeanName, "ShardName");
        Assert.assertEquals((Object)attribute, (Object)"shard-1");
    }

    @Test
    public void testGetCommittedTransactionsCount() throws Exception {
        this.shardStats.incrementCommittedTransactionCount();
        this.shardStats.incrementCommittedTransactionCount();
        this.shardStats.incrementCommittedTransactionCount();
        Object attribute = this.mbeanServer.getAttribute(this.testMBeanName, "CommittedTransactionsCount");
        Assert.assertEquals((Object)attribute, (Object)3L);
    }

    @Test
    public void testGetLastCommittedTransactionTime() throws Exception {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS");
        Assert.assertEquals((Object)this.shardStats.getLastCommittedTransactionTime(), (Object)sdf.format(new Date(0L)));
        long millis = System.currentTimeMillis();
        this.shardStats.setLastCommittedTransactionTime(millis);
        Object attribute = this.mbeanServer.getAttribute(this.testMBeanName, "LastCommittedTransactionTime");
        Assert.assertEquals((Object)attribute, (Object)sdf.format(new Date(millis)));
        Assert.assertNotEquals((Object)attribute, (Object)sdf.format(new Date(millis - 1L)));
    }

    @Test
    public void testGetFailedTransactionsCount() throws Exception {
        this.shardStats.incrementFailedTransactionsCount();
        this.shardStats.incrementFailedTransactionsCount();
        Object attribute = this.mbeanServer.getAttribute(this.testMBeanName, "FailedTransactionsCount");
        Assert.assertEquals((Object)attribute, (Object)2L);
    }

    @Test
    public void testGetAbortTransactionsCount() throws Exception {
        this.shardStats.incrementAbortTransactionsCount();
        this.shardStats.incrementAbortTransactionsCount();
        Object attribute = this.mbeanServer.getAttribute(this.testMBeanName, "AbortTransactionsCount");
        Assert.assertEquals((Object)attribute, (Object)2L);
    }

    @Test
    public void testGetFailedReadTransactionsCount() throws Exception {
        this.shardStats.incrementFailedReadTransactionsCount();
        this.shardStats.incrementFailedReadTransactionsCount();
        Object attribute = this.mbeanServer.getAttribute(this.testMBeanName, "FailedReadTransactionsCount");
        Assert.assertEquals((Object)attribute, (Object)2L);
    }

    @Test
    public void testResetTransactionCounters() throws Exception {
        this.shardStats.incrementCommittedTransactionCount();
        this.shardStats.incrementCommittedTransactionCount();
        this.shardStats.incrementCommittedTransactionCount();
        Object attribute = this.mbeanServer.getAttribute(this.testMBeanName, "CommittedTransactionsCount");
        Assert.assertEquals((Object)attribute, (Object)3L);
        this.shardStats.incrementFailedReadTransactionsCount();
        this.shardStats.incrementFailedReadTransactionsCount();
        attribute = this.mbeanServer.getAttribute(this.testMBeanName, "FailedReadTransactionsCount");
        Assert.assertEquals((Object)attribute, (Object)2L);
        this.mbeanServer.invoke(this.testMBeanName, "resetTransactionCounters", null, null);
        attribute = this.mbeanServer.getAttribute(this.testMBeanName, "CommittedTransactionsCount");
        Assert.assertEquals((Object)attribute, (Object)0L);
        attribute = this.mbeanServer.getAttribute(this.testMBeanName, "FailedReadTransactionsCount");
        Assert.assertEquals((Object)attribute, (Object)0L);
    }
}

