/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.cluster.datastore;

import akka.actor.ActorRef;
import akka.actor.ActorSystem;
import akka.pattern.Patterns;
import akka.testkit.javadsl.EventFilter;
import akka.testkit.javadsl.TestKit;
import akka.util.Timeout;
import com.google.common.util.concurrent.Uninterruptibles;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.junit.Assert;
import org.opendaylight.controller.cluster.raft.client.messages.FindLeader;
import org.opendaylight.controller.cluster.raft.client.messages.FindLeaderReply;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.concurrent.Await;
import scala.concurrent.Awaitable;
import scala.concurrent.Future;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.FiniteDuration;

public class ShardTestKit
extends TestKit {
    private static final Logger LOG = LoggerFactory.getLogger(ShardTestKit.class);

    public ShardTestKit(ActorSystem actorSystem) {
        super(actorSystem);
    }

    public void waitForLogMessage(Class<?> logLevel, ActorRef subject, String logMessage) {
        Boolean result = (Boolean)new EventFilter(logLevel, this.getSystem()).from(subject.path().toString()).message(logMessage).occurrences(1).intercept(() -> Boolean.TRUE);
        Assert.assertEquals((Object)Boolean.TRUE, (Object)result);
    }

    public static String waitUntilLeader(ActorRef shard) {
        FiniteDuration duration = FiniteDuration.create((long)100L, (TimeUnit)TimeUnit.MILLISECONDS);
        for (int i = 0; i < 100; ++i) {
            Future future = Patterns.ask((ActorRef)shard, (Object)FindLeader.INSTANCE, (Timeout)new Timeout(duration));
            try {
                Optional maybeLeader = ((FindLeaderReply)Await.result((Awaitable)future, (Duration)duration)).getLeaderActor();
                if (maybeLeader.isPresent()) {
                    return (String)maybeLeader.get();
                }
            }
            catch (TimeoutException e) {
                LOG.trace("FindLeader timed out", (Throwable)e);
            }
            catch (Exception e) {
                LOG.error("FindLeader failed", (Throwable)e);
            }
            Uninterruptibles.sleepUninterruptibly((long)50L, (TimeUnit)TimeUnit.MILLISECONDS);
        }
        Assert.fail((String)("Leader not found for shard " + shard.path()));
        return null;
    }

    public void waitUntilNoLeader(ActorRef shard) {
        FiniteDuration duration = FiniteDuration.create((long)100L, (TimeUnit)TimeUnit.MILLISECONDS);
        Exception lastResponse = null;
        for (int i = 0; i < 100; ++i) {
            Future future = Patterns.ask((ActorRef)shard, (Object)FindLeader.INSTANCE, (Timeout)new Timeout(duration));
            try {
                Optional maybeLeader = ((FindLeaderReply)Await.result((Awaitable)future, (Duration)duration)).getLeaderActor();
                if (!maybeLeader.isPresent()) {
                    return;
                }
                lastResponse = maybeLeader.get();
            }
            catch (TimeoutException e) {
                lastResponse = e;
            }
            catch (Exception e) {
                LOG.error("FindLeader failed", (Throwable)e);
                lastResponse = e;
            }
            Uninterruptibles.sleepUninterruptibly((long)50L, (TimeUnit)TimeUnit.MILLISECONDS);
        }
        if (lastResponse instanceof Throwable) {
            throw (AssertionError)((Object)((Throwable)((Object)new AssertionError((Object)String.format("Unexpected error occurred from FindLeader for shard %s", shard.path())))).initCause(lastResponse));
        }
        Assert.fail((String)String.format("Unexpected leader %s found for shard %s", lastResponse, shard.path()));
    }
}

