/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.cluster.datastore.actors;

import akka.actor.ActorRef;
import akka.testkit.javadsl.TestKit;
import com.google.common.io.ByteSource;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInput;
import java.io.ObjectInputStream;
import java.time.Duration;
import java.util.Optional;
import org.junit.Assert;
import org.junit.Test;
import org.opendaylight.controller.cluster.datastore.AbstractActorTest;
import org.opendaylight.controller.cluster.datastore.actors.ShardSnapshotActor;
import org.opendaylight.controller.cluster.datastore.persisted.MetadataShardDataTreeSnapshot;
import org.opendaylight.controller.cluster.datastore.persisted.ShardDataTreeSnapshot;
import org.opendaylight.controller.cluster.datastore.persisted.ShardSnapshotState;
import org.opendaylight.controller.cluster.io.InputOutputStreamFactory;
import org.opendaylight.controller.cluster.raft.base.messages.CaptureSnapshotReply;
import org.opendaylight.controller.md.cluster.datastore.model.TestModel;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.data.api.schema.NormalizedNode;
import org.opendaylight.yangtools.yang.data.impl.schema.ImmutableNodes;

public class ShardSnapshotActorTest
extends AbstractActorTest {
    private static final InputOutputStreamFactory STREAM_FACTORY = InputOutputStreamFactory.simple();
    private static final NormalizedNode DATA = ImmutableNodes.containerNode((QName)TestModel.TEST_QNAME);

    private static void testSerializeSnapshot(String testName, ShardDataTreeSnapshot snapshot, boolean withInstallSnapshot) throws Exception {
        TestKit kit = new TestKit(ShardSnapshotActorTest.getSystem());
        ActorRef snapshotActor = ShardSnapshotActorTest.getSystem().actorOf(ShardSnapshotActor.props((InputOutputStreamFactory)STREAM_FACTORY), testName);
        kit.watch(snapshotActor);
        NormalizedNode expectedRoot = (NormalizedNode)snapshot.getRootNode().get();
        ByteArrayOutputStream installSnapshotStream = withInstallSnapshot ? new ByteArrayOutputStream() : null;
        ShardSnapshotActor.requestSnapshot((ActorRef)snapshotActor, (ShardDataTreeSnapshot)snapshot, Optional.ofNullable(installSnapshotStream), (ActorRef)kit.getRef());
        CaptureSnapshotReply reply = (CaptureSnapshotReply)kit.expectMsgClass(Duration.ofSeconds(3L), CaptureSnapshotReply.class);
        Assert.assertNotNull((String)"getSnapshotState is null", (Object)reply.getSnapshotState());
        Assert.assertEquals((String)"SnapshotState type", ShardSnapshotState.class, reply.getSnapshotState().getClass());
        Assert.assertEquals((String)"Snapshot", (Object)snapshot, (Object)((ShardSnapshotState)reply.getSnapshotState()).getSnapshot());
        if (installSnapshotStream != null) {
            ShardDataTreeSnapshot deserialized;
            try (ObjectInputStream in = new ObjectInputStream(STREAM_FACTORY.createInputStream(ByteSource.wrap((byte[])installSnapshotStream.toByteArray())));){
                deserialized = ShardDataTreeSnapshot.deserialize((ObjectInput)in).getSnapshot();
            }
            Assert.assertEquals((String)"Deserialized snapshot type", snapshot.getClass(), deserialized.getClass());
            Optional maybeNode = deserialized.getRootNode();
            Assert.assertTrue((String)"isPresent", (boolean)maybeNode.isPresent());
            Assert.assertEquals((String)"Root node", (Object)expectedRoot, maybeNode.get());
        }
    }

    @Test
    public void testSerializeBoronSnapshot() throws Exception {
        ShardSnapshotActorTest.testSerializeSnapshot("testSerializeBoronSnapshotWithInstallSnapshot", (ShardDataTreeSnapshot)new MetadataShardDataTreeSnapshot(DATA), true);
        ShardSnapshotActorTest.testSerializeSnapshot("testSerializeBoronSnapshotWithoutInstallSnapshot", (ShardDataTreeSnapshot)new MetadataShardDataTreeSnapshot(DATA), false);
    }
}

