/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.cluster.datastore.modification;

import java.io.Serializable;
import org.apache.commons.lang.SerializationUtils;
import org.junit.Assert;
import org.junit.Test;
import org.opendaylight.controller.cluster.datastore.modification.AbstractModificationTest;
import org.opendaylight.controller.cluster.datastore.modification.DeleteModification;
import org.opendaylight.controller.cluster.datastore.modification.MergeModification;
import org.opendaylight.controller.cluster.datastore.modification.Modification;
import org.opendaylight.controller.cluster.datastore.modification.MutableCompositeModification;
import org.opendaylight.controller.cluster.datastore.modification.WriteModification;
import org.opendaylight.controller.md.cluster.datastore.model.TestModel;
import org.opendaylight.mdsal.dom.spi.store.DOMStoreReadWriteTransaction;
import org.opendaylight.mdsal.dom.spi.store.DOMStoreWriteTransaction;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;
import org.opendaylight.yangtools.yang.data.api.schema.DataContainerChild;
import org.opendaylight.yangtools.yang.data.api.schema.NormalizedNode;
import org.opendaylight.yangtools.yang.data.impl.schema.ImmutableNodes;
import org.opendaylight.yangtools.yang.data.impl.schema.builder.impl.ImmutableContainerNodeBuilder;

public class MutableCompositeModificationTest
extends AbstractModificationTest {
    @Test
    public void testApply() throws Exception {
        MutableCompositeModification compositeModification = new MutableCompositeModification();
        compositeModification.addModification((Modification)new WriteModification(TestModel.TEST_PATH, (NormalizedNode)ImmutableNodes.containerNode((QName)TestModel.TEST_QNAME)));
        DOMStoreReadWriteTransaction transaction = this.store.newReadWriteTransaction();
        compositeModification.apply((DOMStoreWriteTransaction)transaction);
        this.commitTransaction((DOMStoreWriteTransaction)transaction);
        Assert.assertEquals((Object)TestModel.TEST_QNAME, (Object)this.readData(TestModel.TEST_PATH).get().getIdentifier().getNodeType());
    }

    @Test
    public void testSerialization() {
        YangInstanceIdentifier writePath = TestModel.TEST_PATH;
        NormalizedNode writeData = ImmutableContainerNodeBuilder.create().withNodeIdentifier((YangInstanceIdentifier.PathArgument)new YangInstanceIdentifier.NodeIdentifier(TestModel.TEST_QNAME)).withChild((DataContainerChild)ImmutableNodes.leafNode((QName)TestModel.DESC_QNAME, (Object)"foo")).build();
        YangInstanceIdentifier mergePath = TestModel.OUTER_LIST_PATH;
        NormalizedNode mergeData = ImmutableContainerNodeBuilder.create().withNodeIdentifier((YangInstanceIdentifier.PathArgument)new YangInstanceIdentifier.NodeIdentifier(TestModel.OUTER_LIST_QNAME)).build();
        YangInstanceIdentifier deletePath = TestModel.TEST_PATH;
        MutableCompositeModification compositeModification = new MutableCompositeModification(11);
        compositeModification.addModification((Modification)new WriteModification(writePath, writeData));
        compositeModification.addModification((Modification)new MergeModification(mergePath, mergeData));
        compositeModification.addModification((Modification)new DeleteModification(deletePath));
        byte[] bytes = SerializationUtils.serialize((Serializable)compositeModification);
        Assert.assertEquals((long)360L, (long)bytes.length);
        MutableCompositeModification clone = (MutableCompositeModification)SerializationUtils.deserialize((byte[])bytes);
        Assert.assertEquals((String)"getVersion", (long)11L, (long)clone.getVersion());
        Assert.assertEquals((String)"getModifications size", (long)3L, (long)clone.getModifications().size());
        WriteModification write = (WriteModification)clone.getModifications().get(0);
        Assert.assertEquals((String)"getVersion", (long)11L, (long)write.getVersion());
        Assert.assertEquals((String)"getPath", (Object)writePath, (Object)write.getPath());
        Assert.assertEquals((String)"getData", (Object)writeData, (Object)write.getData());
        MergeModification merge = (MergeModification)clone.getModifications().get(1);
        Assert.assertEquals((String)"getVersion", (long)11L, (long)merge.getVersion());
        Assert.assertEquals((String)"getPath", (Object)mergePath, (Object)merge.getPath());
        Assert.assertEquals((String)"getData", (Object)mergeData, (Object)merge.getData());
        DeleteModification delete = (DeleteModification)clone.getModifications().get(2);
        Assert.assertEquals((String)"getVersion", (long)11L, (long)delete.getVersion());
        Assert.assertEquals((String)"getPath", (Object)deletePath, (Object)delete.getPath());
    }

    @Test
    public void testSerializationModern() {
        YangInstanceIdentifier writePath = TestModel.TEST_PATH;
        NormalizedNode writeData = ImmutableContainerNodeBuilder.create().withNodeIdentifier((YangInstanceIdentifier.PathArgument)new YangInstanceIdentifier.NodeIdentifier(TestModel.TEST_QNAME)).withChild((DataContainerChild)ImmutableNodes.leafNode((QName)TestModel.DESC_QNAME, (Object)"foo")).build();
        YangInstanceIdentifier mergePath = TestModel.OUTER_LIST_PATH;
        NormalizedNode mergeData = ImmutableContainerNodeBuilder.create().withNodeIdentifier((YangInstanceIdentifier.PathArgument)new YangInstanceIdentifier.NodeIdentifier(TestModel.OUTER_LIST_QNAME)).build();
        YangInstanceIdentifier deletePath = TestModel.TEST_PATH;
        MutableCompositeModification compositeModification = new MutableCompositeModification();
        compositeModification.addModification((Modification)new WriteModification(writePath, writeData));
        compositeModification.addModification((Modification)new MergeModification(mergePath, mergeData));
        compositeModification.addModification((Modification)new DeleteModification(deletePath));
        byte[] bytes = SerializationUtils.serialize((Serializable)compositeModification);
        Assert.assertEquals((long)360L, (long)bytes.length);
        MutableCompositeModification clone = (MutableCompositeModification)SerializationUtils.deserialize((byte[])bytes);
        Assert.assertEquals((String)"getVersion", (long)12L, (long)clone.getVersion());
        Assert.assertEquals((String)"getModifications size", (long)3L, (long)clone.getModifications().size());
        WriteModification write = (WriteModification)clone.getModifications().get(0);
        Assert.assertEquals((String)"getVersion", (long)12L, (long)write.getVersion());
        Assert.assertEquals((String)"getPath", (Object)writePath, (Object)write.getPath());
        Assert.assertEquals((String)"getData", (Object)writeData, (Object)write.getData());
        MergeModification merge = (MergeModification)clone.getModifications().get(1);
        Assert.assertEquals((String)"getVersion", (long)12L, (long)merge.getVersion());
        Assert.assertEquals((String)"getPath", (Object)mergePath, (Object)merge.getPath());
        Assert.assertEquals((String)"getData", (Object)mergeData, (Object)merge.getData());
        DeleteModification delete = (DeleteModification)clone.getModifications().get(2);
        Assert.assertEquals((String)"getVersion", (long)12L, (long)delete.getVersion());
        Assert.assertEquals((String)"getPath", (Object)deletePath, (Object)delete.getPath());
    }
}

