/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.cluster.datastore.persisted;

import java.io.IOException;
import java.io.Serializable;
import java.util.Collection;
import org.apache.commons.lang3.SerializationUtils;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.opendaylight.controller.cluster.access.concepts.TransactionIdentifier;
import org.opendaylight.controller.cluster.datastore.AbstractTest;
import org.opendaylight.controller.cluster.datastore.persisted.CommitTransactionPayload;
import org.opendaylight.controller.cluster.datastore.persisted.DataTreeCandidateInputOutput;
import org.opendaylight.controller.md.cluster.datastore.model.SchemaContextHelper;
import org.opendaylight.controller.md.cluster.datastore.model.TestModel;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;
import org.opendaylight.yangtools.yang.data.api.schema.DataContainerChild;
import org.opendaylight.yangtools.yang.data.api.schema.LeafNode;
import org.opendaylight.yangtools.yang.data.api.schema.LeafSetEntryNode;
import org.opendaylight.yangtools.yang.data.api.schema.NormalizedNode;
import org.opendaylight.yangtools.yang.data.api.schema.tree.DataTree;
import org.opendaylight.yangtools.yang.data.api.schema.tree.DataTreeCandidate;
import org.opendaylight.yangtools.yang.data.api.schema.tree.DataTreeCandidateNode;
import org.opendaylight.yangtools.yang.data.api.schema.tree.DataTreeCandidates;
import org.opendaylight.yangtools.yang.data.api.schema.tree.DataTreeConfiguration;
import org.opendaylight.yangtools.yang.data.api.schema.tree.DataTreeModification;
import org.opendaylight.yangtools.yang.data.impl.schema.Builders;
import org.opendaylight.yangtools.yang.data.impl.schema.ImmutableNodes;
import org.opendaylight.yangtools.yang.data.impl.schema.builder.impl.ImmutableContainerNodeBuilder;
import org.opendaylight.yangtools.yang.data.impl.schema.tree.InMemoryDataTreeFactory;

public class CommitTransactionPayloadTest
extends AbstractTest {
    static final QName LEAF_SET = QName.create((QName)TestModel.TEST_QNAME, (String)"leaf-set");
    private DataTreeCandidate candidate;

    private static DataTreeCandidateNode findNode(Collection<DataTreeCandidateNode> nodes, YangInstanceIdentifier.PathArgument arg) {
        for (DataTreeCandidateNode node : nodes) {
            if (!arg.equals(node.getIdentifier())) continue;
            return node;
        }
        return null;
    }

    private static void assertChildrenEquals(Collection<DataTreeCandidateNode> expected, Collection<DataTreeCandidateNode> actual) {
        for (DataTreeCandidateNode exp : expected) {
            DataTreeCandidateNode act = CommitTransactionPayloadTest.findNode(actual, exp.getIdentifier());
            Assert.assertNotNull((String)"missing expected child", (Object)act);
            CommitTransactionPayloadTest.assertCandidateNodeEquals(exp, act);
        }
        for (DataTreeCandidateNode act : actual) {
            DataTreeCandidateNode exp = CommitTransactionPayloadTest.findNode(expected, act.getIdentifier());
            Assert.assertNull((String)"unexpected child", (Object)exp);
        }
    }

    private static void assertCandidateEquals(DataTreeCandidate expected, DataTreeCandidateInputOutput.DataTreeCandidateWithVersion actual) {
        DataTreeCandidate candidate = actual.getCandidate();
        Assert.assertEquals((String)"root path", (Object)expected.getRootPath(), (Object)candidate.getRootPath());
        CommitTransactionPayloadTest.assertCandidateNodeEquals(expected.getRootNode(), candidate.getRootNode());
    }

    private static void assertCandidateNodeEquals(DataTreeCandidateNode expected, DataTreeCandidateNode actual) {
        Assert.assertEquals((String)"child type", (Object)expected.getModificationType(), (Object)actual.getModificationType());
        switch (actual.getModificationType()) {
            case DELETE: 
            case WRITE: {
                Assert.assertEquals((String)"child identifier", (Object)expected.getIdentifier(), (Object)actual.getIdentifier());
                Assert.assertEquals((String)"child data", (Object)expected.getDataAfter(), (Object)actual.getDataAfter());
                break;
            }
            case SUBTREE_MODIFIED: {
                Assert.assertEquals((String)"child identifier", (Object)expected.getIdentifier(), (Object)actual.getIdentifier());
                CommitTransactionPayloadTest.assertChildrenEquals(expected.getChildNodes(), actual.getChildNodes());
                break;
            }
            case UNMODIFIED: {
                break;
            }
            default: {
                Assert.fail((String)("Unexpect root type " + actual.getModificationType()));
            }
        }
    }

    @Before
    public void setUp() {
        CommitTransactionPayloadTest.setUpStatic();
        YangInstanceIdentifier writePath = TestModel.TEST_PATH;
        NormalizedNode writeData = ImmutableContainerNodeBuilder.create().withNodeIdentifier((YangInstanceIdentifier.PathArgument)new YangInstanceIdentifier.NodeIdentifier(TestModel.TEST_QNAME)).withChild((DataContainerChild)ImmutableNodes.leafNode((QName)TestModel.DESC_QNAME, (Object)"foo")).build();
        this.candidate = DataTreeCandidates.fromNormalizedNode((YangInstanceIdentifier)writePath, (NormalizedNode)writeData);
    }

    @Test
    public void testCandidateSerialization() throws IOException {
        CommitTransactionPayload payload = CommitTransactionPayload.create((TransactionIdentifier)CommitTransactionPayloadTest.nextTransactionId(), (DataTreeCandidate)this.candidate);
        Assert.assertEquals((String)"payload size", (long)156L, (long)payload.size());
    }

    @Test
    public void testCandidateSerDes() throws IOException {
        CommitTransactionPayload payload = CommitTransactionPayload.create((TransactionIdentifier)CommitTransactionPayloadTest.nextTransactionId(), (DataTreeCandidate)this.candidate);
        CommitTransactionPayloadTest.assertCandidateEquals(this.candidate, (DataTreeCandidateInputOutput.DataTreeCandidateWithVersion)payload.getCandidate().getValue());
    }

    @Test
    public void testPayloadSerDes() throws IOException {
        CommitTransactionPayload payload = CommitTransactionPayload.create((TransactionIdentifier)CommitTransactionPayloadTest.nextTransactionId(), (DataTreeCandidate)this.candidate);
        CommitTransactionPayloadTest.assertCandidateEquals(this.candidate, (DataTreeCandidateInputOutput.DataTreeCandidateWithVersion)((CommitTransactionPayload)SerializationUtils.clone((Serializable)payload)).getCandidate().getValue());
    }

    @Test
    public void testLeafSetEntryNodeCandidate() throws Exception {
        YangInstanceIdentifier.NodeWithValue entryPathArg = new YangInstanceIdentifier.NodeWithValue(LEAF_SET, (Object)"one");
        YangInstanceIdentifier leafSetEntryPath = YangInstanceIdentifier.builder((YangInstanceIdentifier)TestModel.TEST_PATH).node(LEAF_SET).node((YangInstanceIdentifier.PathArgument)entryPathArg).build();
        NormalizedNode leafSetEntryNode = Builders.leafSetEntryBuilder().withNodeIdentifier((YangInstanceIdentifier.PathArgument)entryPathArg).withValue((Object)"one").build();
        this.candidate = DataTreeCandidates.fromNormalizedNode((YangInstanceIdentifier)leafSetEntryPath, (NormalizedNode)leafSetEntryNode);
        CommitTransactionPayload payload = CommitTransactionPayload.create((TransactionIdentifier)CommitTransactionPayloadTest.nextTransactionId(), (DataTreeCandidate)this.candidate);
        CommitTransactionPayloadTest.assertCandidateEquals(this.candidate, (DataTreeCandidateInputOutput.DataTreeCandidateWithVersion)payload.getCandidate().getValue());
    }

    @Test
    public void testLeafSetNodeCandidate() throws Exception {
        YangInstanceIdentifier.NodeWithValue entryPathArg = new YangInstanceIdentifier.NodeWithValue(LEAF_SET, (Object)"one");
        YangInstanceIdentifier leafSetPath = YangInstanceIdentifier.builder((YangInstanceIdentifier)TestModel.TEST_PATH).node(LEAF_SET).build();
        LeafSetEntryNode leafSetEntryNode = (LeafSetEntryNode)Builders.leafSetEntryBuilder().withNodeIdentifier((YangInstanceIdentifier.PathArgument)entryPathArg).withValue((Object)"one").build();
        NormalizedNode leafSetNode = Builders.leafSetBuilder().withNodeIdentifier(new YangInstanceIdentifier.NodeIdentifier(LEAF_SET)).withChild(leafSetEntryNode).build();
        this.candidate = DataTreeCandidates.fromNormalizedNode((YangInstanceIdentifier)leafSetPath, (NormalizedNode)leafSetNode);
        CommitTransactionPayload payload = CommitTransactionPayload.create((TransactionIdentifier)CommitTransactionPayloadTest.nextTransactionId(), (DataTreeCandidate)this.candidate);
        CommitTransactionPayloadTest.assertCandidateEquals(this.candidate, (DataTreeCandidateInputOutput.DataTreeCandidateWithVersion)payload.getCandidate().getValue());
    }

    @Test
    public void testOrderedLeafSetNodeCandidate() throws Exception {
        YangInstanceIdentifier.NodeWithValue entryPathArg = new YangInstanceIdentifier.NodeWithValue(LEAF_SET, (Object)"one");
        YangInstanceIdentifier leafSetPath = YangInstanceIdentifier.builder((YangInstanceIdentifier)TestModel.TEST_PATH).node(LEAF_SET).build();
        LeafSetEntryNode leafSetEntryNode = (LeafSetEntryNode)Builders.leafSetEntryBuilder().withNodeIdentifier((YangInstanceIdentifier.PathArgument)entryPathArg).withValue((Object)"one").build();
        NormalizedNode leafSetNode = Builders.orderedLeafSetBuilder().withNodeIdentifier(new YangInstanceIdentifier.NodeIdentifier(LEAF_SET)).withChild(leafSetEntryNode).build();
        this.candidate = DataTreeCandidates.fromNormalizedNode((YangInstanceIdentifier)leafSetPath, (NormalizedNode)leafSetNode);
        CommitTransactionPayload payload = CommitTransactionPayload.create((TransactionIdentifier)CommitTransactionPayloadTest.nextTransactionId(), (DataTreeCandidate)this.candidate);
        CommitTransactionPayloadTest.assertCandidateEquals(this.candidate, (DataTreeCandidateInputOutput.DataTreeCandidateWithVersion)payload.getCandidate().getValue());
    }

    @Test
    public void testLeafNodeCandidate() throws Exception {
        YangInstanceIdentifier leafPath = YangInstanceIdentifier.builder((YangInstanceIdentifier)TestModel.TEST_PATH).node(TestModel.DESC_QNAME).build();
        LeafNode leafNode = (LeafNode)Builders.leafBuilder().withNodeIdentifier((YangInstanceIdentifier.PathArgument)new YangInstanceIdentifier.NodeIdentifier(TestModel.DESC_QNAME)).withValue((Object)"test").build();
        this.candidate = DataTreeCandidates.fromNormalizedNode((YangInstanceIdentifier)leafPath, (NormalizedNode)leafNode);
        CommitTransactionPayload payload = CommitTransactionPayload.create((TransactionIdentifier)CommitTransactionPayloadTest.nextTransactionId(), (DataTreeCandidate)this.candidate);
        CommitTransactionPayloadTest.assertCandidateEquals(this.candidate, (DataTreeCandidateInputOutput.DataTreeCandidateWithVersion)payload.getCandidate().getValue());
    }

    @Test
    public void testUnmodifiedRootCandidate() throws Exception {
        DataTree dataTree = new InMemoryDataTreeFactory().create(DataTreeConfiguration.DEFAULT_CONFIGURATION, SchemaContextHelper.select("/cars.yang"));
        DataTreeModification modification = dataTree.takeSnapshot().newModification();
        modification.ready();
        this.candidate = dataTree.prepare(modification);
        CommitTransactionPayload payload = CommitTransactionPayload.create((TransactionIdentifier)CommitTransactionPayloadTest.nextTransactionId(), (DataTreeCandidate)this.candidate);
        CommitTransactionPayloadTest.assertCandidateEquals(this.candidate, (DataTreeCandidateInputOutput.DataTreeCandidateWithVersion)payload.getCandidate().getValue());
    }
}

