/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.cluster.datastore.persisted;

import java.io.Serializable;
import org.apache.commons.lang.SerializationUtils;
import org.junit.Assert;
import org.junit.Test;
import org.opendaylight.controller.cluster.datastore.persisted.MetadataShardDataTreeSnapshot;
import org.opendaylight.controller.cluster.datastore.persisted.ShardDataTreeSnapshot;
import org.opendaylight.controller.cluster.datastore.persisted.ShardSnapshotState;
import org.opendaylight.controller.md.cluster.datastore.model.TestModel;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;
import org.opendaylight.yangtools.yang.data.api.schema.DataContainerChild;
import org.opendaylight.yangtools.yang.data.api.schema.NormalizedNode;
import org.opendaylight.yangtools.yang.data.impl.schema.ImmutableNodes;
import org.opendaylight.yangtools.yang.data.impl.schema.builder.impl.ImmutableContainerNodeBuilder;

public class ShardSnapshotStateTest {
    @Test
    public void testSerialization() {
        NormalizedNode expectedNode = ImmutableContainerNodeBuilder.create().withNodeIdentifier((YangInstanceIdentifier.PathArgument)new YangInstanceIdentifier.NodeIdentifier(TestModel.TEST_QNAME)).withChild((DataContainerChild)ImmutableNodes.leafNode((QName)TestModel.DESC_QNAME, (Object)"foo")).build();
        ShardSnapshotState expected = new ShardSnapshotState((ShardDataTreeSnapshot)new MetadataShardDataTreeSnapshot(expectedNode));
        ShardSnapshotState cloned = (ShardSnapshotState)SerializationUtils.clone((Serializable)expected);
        Assert.assertNotNull((String)"getSnapshot is null", (Object)cloned.getSnapshot());
        Assert.assertEquals((String)"getSnapshot type", MetadataShardDataTreeSnapshot.class, cloned.getSnapshot().getClass());
        Assert.assertEquals((String)"getRootNode", (Object)expectedNode, ((MetadataShardDataTreeSnapshot)cloned.getSnapshot()).getRootNode().get());
    }
}

