/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.cluster.datastore.utils;

import akka.actor.ActorRef;
import akka.actor.ActorSelection;
import akka.actor.ActorSystem;
import akka.actor.Address;
import akka.actor.Props;
import akka.actor.UntypedAbstractActor;
import akka.dispatch.Futures;
import akka.japi.Creator;
import akka.testkit.TestActorRef;
import akka.testkit.javadsl.TestKit;
import akka.util.Timeout;
import com.google.common.collect.Sets;
import com.typesafe.config.Config;
import com.typesafe.config.ConfigFactory;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;
import org.opendaylight.controller.cluster.datastore.AbstractActorTest;
import org.opendaylight.controller.cluster.datastore.ClusterWrapper;
import org.opendaylight.controller.cluster.datastore.DatastoreContext;
import org.opendaylight.controller.cluster.datastore.DatastoreContextFactory;
import org.opendaylight.controller.cluster.datastore.config.Configuration;
import org.opendaylight.controller.cluster.datastore.exceptions.NoShardLeaderException;
import org.opendaylight.controller.cluster.datastore.exceptions.NotInitializedException;
import org.opendaylight.controller.cluster.datastore.exceptions.PrimaryNotFoundException;
import org.opendaylight.controller.cluster.datastore.messages.FindLocalShard;
import org.opendaylight.controller.cluster.datastore.messages.FindPrimary;
import org.opendaylight.controller.cluster.datastore.messages.LocalPrimaryShardFound;
import org.opendaylight.controller.cluster.datastore.messages.LocalShardFound;
import org.opendaylight.controller.cluster.datastore.messages.LocalShardNotFound;
import org.opendaylight.controller.cluster.datastore.messages.PrimaryShardInfo;
import org.opendaylight.controller.cluster.datastore.messages.RemotePrimaryShardFound;
import org.opendaylight.controller.cluster.datastore.utils.ActorUtils;
import org.opendaylight.controller.cluster.datastore.utils.MockClusterWrapper;
import org.opendaylight.controller.cluster.datastore.utils.PrimaryShardInfoFutureCache;
import org.opendaylight.controller.cluster.raft.utils.EchoActor;
import org.opendaylight.controller.cluster.raft.utils.MessageCollectorActor;
import org.opendaylight.mdsal.common.api.LogicalDatastoreType;
import org.opendaylight.yangtools.yang.data.api.schema.tree.DataTree;
import org.opendaylight.yangtools.yang.data.api.schema.tree.ReadOnlyDataTree;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.concurrent.Await;
import scala.concurrent.Awaitable;
import scala.concurrent.Future;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.FiniteDuration;

public class ActorUtilsTest
extends AbstractActorTest {
    static final Logger LOG = LoggerFactory.getLogger(ActorUtilsTest.class);

    @Test
    public void testFindLocalShardWithShardFound() {
        TestKit testKit = new TestKit(ActorUtilsTest.getSystem());
        testKit.within(java.time.Duration.ofSeconds(1L), () -> {
            ActorRef shardActorRef = ActorUtilsTest.getSystem().actorOf(Props.create(EchoActor.class, (Object[])new Object[0]));
            ActorRef shardManagerActorRef = ActorUtilsTest.getSystem().actorOf(MockShardManager.props(true, shardActorRef));
            ActorUtils actorUtils = new ActorUtils(ActorUtilsTest.getSystem(), shardManagerActorRef, (ClusterWrapper)Mockito.mock(ClusterWrapper.class), (Configuration)Mockito.mock(Configuration.class));
            Optional out = actorUtils.findLocalShard("default");
            Assert.assertEquals((Object)shardActorRef, out.get());
            testKit.expectNoMessage();
            return null;
        });
    }

    @Test
    public void testFindLocalShardWithShardNotFound() {
        ActorRef shardManagerActorRef = ActorUtilsTest.getSystem().actorOf(MockShardManager.props(false, null));
        ActorUtils actorUtils = new ActorUtils(ActorUtilsTest.getSystem(), shardManagerActorRef, (ClusterWrapper)Mockito.mock(ClusterWrapper.class), (Configuration)Mockito.mock(Configuration.class));
        Optional out = actorUtils.findLocalShard("default");
        Assert.assertFalse((boolean)out.isPresent());
    }

    @Test
    public void testExecuteRemoteOperation() {
        ActorRef shardActorRef = ActorUtilsTest.getSystem().actorOf(Props.create(EchoActor.class, (Object[])new Object[0]));
        ActorRef shardManagerActorRef = ActorUtilsTest.getSystem().actorOf(MockShardManager.props(true, shardActorRef));
        ActorUtils actorUtils = new ActorUtils(ActorUtilsTest.getSystem(), shardManagerActorRef, (ClusterWrapper)Mockito.mock(ClusterWrapper.class), (Configuration)Mockito.mock(Configuration.class));
        ActorSelection actor = actorUtils.actorSelection(shardActorRef.path());
        Object out = actorUtils.executeOperation(actor, (Object)"hello");
        Assert.assertEquals((Object)"hello", (Object)out);
    }

    @Test
    public void testExecuteRemoteOperationAsync() throws Exception {
        ActorRef shardActorRef = ActorUtilsTest.getSystem().actorOf(Props.create(EchoActor.class, (Object[])new Object[0]));
        ActorRef shardManagerActorRef = ActorUtilsTest.getSystem().actorOf(MockShardManager.props(true, shardActorRef));
        ActorUtils actorUtils = new ActorUtils(ActorUtilsTest.getSystem(), shardManagerActorRef, (ClusterWrapper)Mockito.mock(ClusterWrapper.class), (Configuration)Mockito.mock(Configuration.class));
        ActorSelection actor = actorUtils.actorSelection(shardActorRef.path());
        Future future = actorUtils.executeOperationAsync(actor, (Object)"hello");
        Object result = Await.result((Awaitable)future, (Duration)FiniteDuration.create((long)3L, (TimeUnit)TimeUnit.SECONDS));
        Assert.assertEquals((String)"Result", (Object)"hello", (Object)result);
    }

    @Test
    public void testIsPathLocal() {
        MockClusterWrapper clusterWrapper = new MockClusterWrapper();
        ActorUtils actorUtils = null;
        actorUtils = new ActorUtils(ActorUtilsTest.getSystem(), null, (ClusterWrapper)clusterWrapper, (Configuration)Mockito.mock(Configuration.class));
        Assert.assertFalse((boolean)actorUtils.isPathLocal(null));
        Assert.assertFalse((boolean)actorUtils.isPathLocal(""));
        clusterWrapper.setSelfAddress(null);
        actorUtils = new ActorUtils(ActorUtilsTest.getSystem(), null, (ClusterWrapper)clusterWrapper, (Configuration)Mockito.mock(Configuration.class));
        Assert.assertFalse((boolean)actorUtils.isPathLocal(""));
        clusterWrapper.setSelfAddress(new Address("akka", "test"));
        actorUtils = new ActorUtils(ActorUtilsTest.getSystem(), null, (ClusterWrapper)clusterWrapper, (Configuration)Mockito.mock(Configuration.class));
        Assert.assertTrue((boolean)actorUtils.isPathLocal("akka://test/user/$a"));
        clusterWrapper.setSelfAddress(new Address("akka", "test"));
        actorUtils = new ActorUtils(ActorUtilsTest.getSystem(), null, (ClusterWrapper)clusterWrapper, (Configuration)Mockito.mock(Configuration.class));
        Assert.assertTrue((boolean)actorUtils.isPathLocal("akka://test/user/$a"));
        clusterWrapper.setSelfAddress(new Address("akka", "test"));
        actorUtils = new ActorUtils(ActorUtilsTest.getSystem(), null, (ClusterWrapper)clusterWrapper, (Configuration)Mockito.mock(Configuration.class));
        Assert.assertTrue((boolean)actorUtils.isPathLocal("akka://test/user/token2/token3/$a"));
        clusterWrapper.setSelfAddress(new Address("akka", "system", "127.0.0.1", 2550));
        actorUtils = new ActorUtils(ActorUtilsTest.getSystem(), null, (ClusterWrapper)clusterWrapper, (Configuration)Mockito.mock(Configuration.class));
        Assert.assertTrue((boolean)actorUtils.isPathLocal("akka://system/user/shardmanager/shard/transaction"));
        clusterWrapper.setSelfAddress(new Address("akka", "system"));
        actorUtils = new ActorUtils(ActorUtilsTest.getSystem(), null, (ClusterWrapper)clusterWrapper, (Configuration)Mockito.mock(Configuration.class));
        Assert.assertFalse((boolean)actorUtils.isPathLocal("akka://system@127.0.0.1:2550/user/shardmanager/shard/transaction"));
        clusterWrapper.setSelfAddress(new Address("akka", "test"));
        actorUtils = new ActorUtils(ActorUtilsTest.getSystem(), null, (ClusterWrapper)clusterWrapper, (Configuration)Mockito.mock(Configuration.class));
        Assert.assertTrue((boolean)actorUtils.isPathLocal("akka://test1/user/$a"));
        clusterWrapper.setSelfAddress(new Address("akka", "system", "127.0.0.1", 2550));
        actorUtils = new ActorUtils(ActorUtilsTest.getSystem(), null, (ClusterWrapper)clusterWrapper, (Configuration)Mockito.mock(Configuration.class));
        Assert.assertTrue((boolean)actorUtils.isPathLocal("akka://system@127.0.0.1:2550/"));
        clusterWrapper.setSelfAddress(new Address("akka", "system", "127.0.0.1", 2550));
        actorUtils = new ActorUtils(ActorUtilsTest.getSystem(), null, (ClusterWrapper)clusterWrapper, (Configuration)Mockito.mock(Configuration.class));
        Assert.assertFalse((boolean)actorUtils.isPathLocal("akka://system@127.0.0.1:2550"));
        clusterWrapper.setSelfAddress(new Address("akka", "system", "127.0.0.1", 2550));
        actorUtils = new ActorUtils(ActorUtilsTest.getSystem(), null, (ClusterWrapper)clusterWrapper, (Configuration)Mockito.mock(Configuration.class));
        Assert.assertFalse((boolean)actorUtils.isPathLocal("akka://system@127.1.0.1:2550/"));
        clusterWrapper.setSelfAddress(new Address("akka", "system", "127.0.0.1", 2550));
        actorUtils = new ActorUtils(ActorUtilsTest.getSystem(), null, (ClusterWrapper)clusterWrapper, (Configuration)Mockito.mock(Configuration.class));
        Assert.assertFalse((boolean)actorUtils.isPathLocal("akka://system@127.0.0.1:2551/"));
    }

    @Test
    public void testClientDispatcherIsGlobalDispatcher() {
        ActorUtils actorUtils = new ActorUtils(ActorUtilsTest.getSystem(), (ActorRef)Mockito.mock(ActorRef.class), (ClusterWrapper)Mockito.mock(ClusterWrapper.class), (Configuration)Mockito.mock(Configuration.class), DatastoreContext.newBuilder().build(), new PrimaryShardInfoFutureCache());
        Assert.assertEquals((Object)ActorUtilsTest.getSystem().dispatchers().defaultGlobalDispatcher(), (Object)actorUtils.getClientDispatcher());
    }

    @Test
    public void testClientDispatcherIsNotGlobalDispatcher() {
        ActorSystem actorSystem = ActorSystem.create((String)"with-custom-dispatchers", (Config)ConfigFactory.load((String)"application-with-custom-dispatchers.conf"));
        ActorUtils actorUtils = new ActorUtils(actorSystem, (ActorRef)Mockito.mock(ActorRef.class), (ClusterWrapper)Mockito.mock(ClusterWrapper.class), (Configuration)Mockito.mock(Configuration.class), DatastoreContext.newBuilder().build(), new PrimaryShardInfoFutureCache());
        Assert.assertNotEquals((Object)actorSystem.dispatchers().defaultGlobalDispatcher(), (Object)actorUtils.getClientDispatcher());
        actorSystem.terminate();
    }

    @Test
    public void testSetDatastoreContext() {
        TestKit testKit = new TestKit(ActorUtilsTest.getSystem());
        ActorUtils actorUtils = new ActorUtils(ActorUtilsTest.getSystem(), testKit.getRef(), (ClusterWrapper)Mockito.mock(ClusterWrapper.class), (Configuration)Mockito.mock(Configuration.class), DatastoreContext.newBuilder().operationTimeoutInSeconds(5).shardTransactionCommitTimeoutInSeconds(7).build(), new PrimaryShardInfoFutureCache());
        Assert.assertEquals((String)"getOperationDuration", (long)5L, (long)actorUtils.getOperationDuration().toSeconds());
        Assert.assertEquals((String)"getTransactionCommitOperationTimeout", (long)7L, (long)actorUtils.getTransactionCommitOperationTimeout().duration().toSeconds());
        DatastoreContext newContext = DatastoreContext.newBuilder().operationTimeoutInSeconds(6).shardTransactionCommitTimeoutInSeconds(8).build();
        DatastoreContextFactory mockContextFactory = (DatastoreContextFactory)Mockito.mock(DatastoreContextFactory.class);
        ((DatastoreContextFactory)Mockito.doReturn((Object)newContext).when((Object)mockContextFactory)).getBaseDatastoreContext();
        actorUtils.setDatastoreContext(mockContextFactory);
        testKit.expectMsgClass(java.time.Duration.ofSeconds(5L), DatastoreContextFactory.class);
        Assert.assertSame((String)"getDatastoreContext", (Object)newContext, (Object)actorUtils.getDatastoreContext());
        Assert.assertEquals((String)"getOperationDuration", (long)6L, (long)actorUtils.getOperationDuration().toSeconds());
        Assert.assertEquals((String)"getTransactionCommitOperationTimeout", (long)8L, (long)actorUtils.getTransactionCommitOperationTimeout().duration().toSeconds());
    }

    @Test
    public void testFindPrimaryShardAsyncRemotePrimaryFound() throws Exception {
        ActorRef shardManager = ActorUtilsTest.getSystem().actorOf(MessageCollectorActor.props());
        DatastoreContext dataStoreContext = DatastoreContext.newBuilder().logicalStoreType(LogicalDatastoreType.CONFIGURATION).shardLeaderElectionTimeout(100L, TimeUnit.MILLISECONDS).build();
        String expPrimaryPath = "akka://test-system/find-primary-shard";
        int expPrimaryVersion = 12;
        ActorUtils actorUtils = new ActorUtils(ActorUtilsTest.getSystem(), shardManager, (ClusterWrapper)Mockito.mock(ClusterWrapper.class), (Configuration)Mockito.mock(Configuration.class), dataStoreContext, new PrimaryShardInfoFutureCache()){

            protected Future<Object> doAsk(ActorRef actorRef, Object message, Timeout timeout) {
                return Futures.successful((Object)new RemotePrimaryShardFound("akka://test-system/find-primary-shard", 12));
            }
        };
        Future foobar = actorUtils.findPrimaryShardAsync("foobar");
        PrimaryShardInfo actual = (PrimaryShardInfo)Await.result((Awaitable)foobar, (Duration)FiniteDuration.apply((long)5000L, (TimeUnit)TimeUnit.MILLISECONDS));
        Assert.assertNotNull((Object)actual);
        Assert.assertFalse((String)"LocalShardDataTree present", (boolean)actual.getLocalShardDataTree().isPresent());
        Assert.assertTrue((String)("Unexpected PrimaryShardActor path " + actual.getPrimaryShardActor().path()), (boolean)"akka://test-system/find-primary-shard".endsWith(actual.getPrimaryShardActor().pathString()));
        Assert.assertEquals((String)"getPrimaryShardVersion", (long)12L, (long)actual.getPrimaryShardVersion());
        Future cached = actorUtils.getPrimaryShardInfoCache().getIfPresent("foobar");
        PrimaryShardInfo cachedInfo = (PrimaryShardInfo)Await.result((Awaitable)cached, (Duration)FiniteDuration.apply((long)1L, (TimeUnit)TimeUnit.MILLISECONDS));
        Assert.assertEquals((Object)cachedInfo, (Object)actual);
        actorUtils.getPrimaryShardInfoCache().remove("foobar");
        cached = actorUtils.getPrimaryShardInfoCache().getIfPresent("foobar");
        Assert.assertNull((Object)cached);
    }

    @Test
    public void testFindPrimaryShardAsyncLocalPrimaryFound() throws Exception {
        ActorRef shardManager = ActorUtilsTest.getSystem().actorOf(MessageCollectorActor.props());
        DatastoreContext dataStoreContext = DatastoreContext.newBuilder().logicalStoreType(LogicalDatastoreType.CONFIGURATION).shardLeaderElectionTimeout(100L, TimeUnit.MILLISECONDS).build();
        final DataTree mockDataTree = (DataTree)Mockito.mock(DataTree.class);
        String expPrimaryPath = "akka://test-system/find-primary-shard";
        ActorUtils actorUtils = new ActorUtils(ActorUtilsTest.getSystem(), shardManager, (ClusterWrapper)Mockito.mock(ClusterWrapper.class), (Configuration)Mockito.mock(Configuration.class), dataStoreContext, new PrimaryShardInfoFutureCache()){

            protected Future<Object> doAsk(ActorRef actorRef, Object message, Timeout timeout) {
                return Futures.successful((Object)new LocalPrimaryShardFound("akka://test-system/find-primary-shard", (ReadOnlyDataTree)mockDataTree));
            }
        };
        Future foobar = actorUtils.findPrimaryShardAsync("foobar");
        PrimaryShardInfo actual = (PrimaryShardInfo)Await.result((Awaitable)foobar, (Duration)FiniteDuration.apply((long)5000L, (TimeUnit)TimeUnit.MILLISECONDS));
        Assert.assertNotNull((Object)actual);
        Assert.assertTrue((String)"LocalShardDataTree present", (boolean)actual.getLocalShardDataTree().isPresent());
        Assert.assertSame((String)"LocalShardDataTree", (Object)mockDataTree, actual.getLocalShardDataTree().get());
        Assert.assertTrue((String)("Unexpected PrimaryShardActor path " + actual.getPrimaryShardActor().path()), (boolean)"akka://test-system/find-primary-shard".endsWith(actual.getPrimaryShardActor().pathString()));
        Assert.assertEquals((String)"getPrimaryShardVersion", (long)12L, (long)actual.getPrimaryShardVersion());
        Future cached = actorUtils.getPrimaryShardInfoCache().getIfPresent("foobar");
        PrimaryShardInfo cachedInfo = (PrimaryShardInfo)Await.result((Awaitable)cached, (Duration)FiniteDuration.apply((long)1L, (TimeUnit)TimeUnit.MILLISECONDS));
        Assert.assertEquals((Object)cachedInfo, (Object)actual);
        actorUtils.getPrimaryShardInfoCache().remove("foobar");
        cached = actorUtils.getPrimaryShardInfoCache().getIfPresent("foobar");
        Assert.assertNull((Object)cached);
    }

    @Test
    public void testFindPrimaryShardAsyncPrimaryNotFound() {
        ActorUtilsTest.testFindPrimaryExceptions(new PrimaryNotFoundException("not found"));
    }

    @Test
    public void testFindPrimaryShardAsyncActorNotInitialized() {
        ActorUtilsTest.testFindPrimaryExceptions(new NotInitializedException("not initialized"));
    }

    private static void testFindPrimaryExceptions(final Object expectedException) {
        ActorUtils actorUtils;
        block2: {
            ActorRef shardManager = ActorUtilsTest.getSystem().actorOf(MessageCollectorActor.props());
            DatastoreContext dataStoreContext = DatastoreContext.newBuilder().logicalStoreType(LogicalDatastoreType.CONFIGURATION).shardLeaderElectionTimeout(100L, TimeUnit.MILLISECONDS).build();
            actorUtils = new ActorUtils(ActorUtilsTest.getSystem(), shardManager, (ClusterWrapper)Mockito.mock(ClusterWrapper.class), (Configuration)Mockito.mock(Configuration.class), dataStoreContext, new PrimaryShardInfoFutureCache()){

                protected Future<Object> doAsk(ActorRef actorRef, Object message, Timeout timeout) {
                    return Futures.successful((Object)expectedException);
                }
            };
            Future foobar = actorUtils.findPrimaryShardAsync("foobar");
            try {
                Await.result((Awaitable)foobar, (Duration)FiniteDuration.apply((long)100L, (TimeUnit)TimeUnit.MILLISECONDS));
                Assert.fail((String)("Expected" + expectedException.getClass().toString()));
            }
            catch (Exception e) {
                if (expectedException.getClass().isInstance(e)) break block2;
                Assert.fail((String)("Expected Exception of type " + expectedException.getClass().toString()));
            }
        }
        Future cached = actorUtils.getPrimaryShardInfoCache().getIfPresent("foobar");
        Assert.assertNull((Object)cached);
    }

    @Test
    public void testBroadcast() {
        ActorRef shardActorRef1 = ActorUtilsTest.getSystem().actorOf(MessageCollectorActor.props());
        ActorRef shardActorRef2 = ActorUtilsTest.getSystem().actorOf(MessageCollectorActor.props());
        TestActorRef shardManagerActorRef = TestActorRef.create((ActorSystem)ActorUtilsTest.getSystem(), (Props)MockShardManager.props());
        MockShardManager shardManagerActor = (MockShardManager)shardManagerActorRef.underlyingActor();
        shardManagerActor.addFindPrimaryResp("shard1", new RemotePrimaryShardFound(shardActorRef1.path().toString(), 12));
        shardManagerActor.addFindPrimaryResp("shard2", new RemotePrimaryShardFound(shardActorRef2.path().toString(), 12));
        shardManagerActor.addFindPrimaryResp("shard3", new NoShardLeaderException("not found"));
        Configuration mockConfig = (Configuration)Mockito.mock(Configuration.class);
        ((Configuration)Mockito.doReturn((Object)Sets.newLinkedHashSet(Arrays.asList("shard1", "shard2", "shard3"))).when((Object)mockConfig)).getAllShardNames();
        ActorUtils actorUtils = new ActorUtils(ActorUtilsTest.getSystem(), (ActorRef)shardManagerActorRef, (ClusterWrapper)Mockito.mock(ClusterWrapper.class), mockConfig, DatastoreContext.newBuilder().shardInitializationTimeout(200L, TimeUnit.MILLISECONDS).build(), new PrimaryShardInfoFutureCache());
        actorUtils.broadcast(v -> new TestMessage(), TestMessage.class);
        MessageCollectorActor.expectFirstMatching((ActorRef)shardActorRef1, TestMessage.class);
        MessageCollectorActor.expectFirstMatching((ActorRef)shardActorRef2, TestMessage.class);
    }

    private static final class MockShardManager
    extends UntypedAbstractActor {
        private final Map<String, Object> findPrimaryResponses = new HashMap<String, Object>();
        private final boolean found;
        private final ActorRef actorRef;

        private MockShardManager(boolean found, ActorRef actorRef) {
            this.found = found;
            this.actorRef = actorRef;
        }

        public void onReceive(Object message) {
            if (message instanceof FindPrimary) {
                FindPrimary fp = (FindPrimary)message;
                Object resp = this.findPrimaryResponses.get(fp.getShardName());
                if (resp == null) {
                    LOG.error("No expected FindPrimary response found for shard name {}", (Object)fp.getShardName());
                } else {
                    this.getSender().tell(resp, this.getSelf());
                }
                return;
            }
            if (this.found) {
                this.getSender().tell((Object)new LocalShardFound(this.actorRef), this.getSelf());
            } else {
                this.getSender().tell((Object)new LocalShardNotFound(((FindLocalShard)message).getShardName()), this.getSelf());
            }
        }

        void addFindPrimaryResp(String shardName, Object resp) {
            this.findPrimaryResponses.put(shardName, resp);
        }

        private static Props props(boolean found, ActorRef actorRef) {
            return Props.create(MockShardManager.class, (Creator)new MockShardManagerCreator(found, actorRef));
        }

        private static Props props() {
            return Props.create(MockShardManager.class, (Creator)new MockShardManagerCreator());
        }

        private static class MockShardManagerCreator
        implements Creator<MockShardManager> {
            final boolean found;
            final ActorRef actorRef;

            MockShardManagerCreator() {
                this.found = false;
                this.actorRef = null;
            }

            MockShardManagerCreator(boolean found, ActorRef actorRef) {
                this.found = found;
                this.actorRef = actorRef;
            }

            public MockShardManager create() {
                return new MockShardManager(this.found, this.actorRef);
            }
        }
    }

    private static class TestMessage {
        private TestMessage() {
        }
    }
}

