package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.config.distributed.datastore.provider.rev140612;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableMap.Builder;
import java.lang.Boolean;
import java.lang.Class;
import java.lang.Deprecated;
import java.lang.Integer;
import java.lang.Override;
import java.lang.String;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.processing.Generated;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.binding.Enumeration;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.common.Uint32;

/**
 *
 * <p>
 * This class represents the following YANG schema fragment defined in module <b>distributed-datastore-provider</b>
 * <pre>
 * grouping data-store-properties {
 *   leaf shard-transaction-idle-timeout-in-minutes {
 *     default 10;
 *     type non-zero-uint32-type;
 *   }
 *   leaf shard-snapshot-batch-count {
 *     default 20000;
 *     type non-zero-uint32-type;
 *   }
 *   leaf shard-snapshot-data-threshold-percentage {
 *     default 12;
 *     type percentage;
 *   }
 *   leaf shard-snapshot-data-threshold {
 *     default 0;
 *     type uint32 {
 *       range 0..max;
 *     }
 *   }
 *   leaf shard-heartbeat-interval-in-millis {
 *     default 500;
 *     type heartbeat-interval-type;
 *   }
 *   leaf shard-election-timeout-factor {
 *     default 20;
 *     type non-zero-uint32-type;
 *   }
 *   leaf operation-timeout-in-seconds {
 *     default 5;
 *     type operation-timeout-type;
 *   }
 *   leaf shard-journal-recovery-log-batch-size {
 *     default 1;
 *     type non-zero-uint32-type;
 *   }
 *   leaf shard-transaction-commit-timeout-in-seconds {
 *     default 30;
 *     type non-zero-uint32-type;
 *   }
 *   leaf shard-transaction-commit-queue-capacity {
 *     default 50000;
 *     type non-zero-uint32-type;
 *   }
 *   leaf shard-commit-queue-expiry-timeout-in-seconds {
 *     default 120;
 *     type non-zero-uint32-type;
 *   }
 *   leaf shard-initialization-timeout-in-seconds {
 *     default 300;
 *     type non-zero-uint32-type;
 *   }
 *   leaf shard-leader-election-timeout-in-seconds {
 *     default 30;
 *     type non-zero-uint32-type;
 *   }
 *   leaf initial-settle-timeout-multiplier {
 *     default 3;
 *     type uint32;
 *   }
 *   leaf recovery-snapshot-interval-seconds {
 *     default 0;
 *     type uint32;
 *   }
 *   leaf shard-batched-modification-count {
 *     default 1000;
 *     type non-zero-uint32-type;
 *   }
 *   leaf enable-metric-capture {
 *     default false;
 *     type boolean;
 *   }
 *   leaf bounded-mailbox-capacity {
 *     default 1000;
 *     type non-zero-uint32-type;
 *   }
 *   leaf persistent {
 *     default true;
 *     type boolean;
 *   }
 *   leaf snapshotOnRootOverwrite {
 *     default false;
 *     type boolean;
 *   }
 *   leaf shard-isolated-leader-check-interval-in-millis {
 *     default 5000;
 *     type heartbeat-interval-type;
 *   }
 *   leaf transaction-creation-initial-rate-limit {
 *     default 100;
 *     type non-zero-uint32-type;
 *   }
 *   leaf transaction-debug-context-enabled {
 *     default false;
 *     type boolean;
 *   }
 *   leaf custom-raft-policy-implementation {
 *     default "";
 *     type string;
 *   }
 *   leaf shard-snapshot-chunk-size {
 *     status deprecated;
 *     default 2048000;
 *     type non-zero-uint32-type;
 *   }
 *   leaf maximum-message-slice-size {
 *     default 2048000;
 *     type non-zero-uint32-type;
 *   }
 *   leaf use-tell-based-protocol {
 *     default false;
 *     type boolean;
 *   }
 *   leaf file-backed-streaming-threshold-in-megabytes {
 *     default 128;
 *     type non-zero-uint32-type;
 *   }
 *   leaf sync-index-threshold {
 *     default 10;
 *     type non-zero-uint32-type;
 *   }
 *   leaf backend-aliveness-timer-interval-in-seconds {
 *     default 30;
 *     type non-zero-uint32-type;
 *   }
 *   leaf frontend-request-timeout-in-seconds {
 *     default 120;
 *     type non-zero-uint32-type;
 *   }
 *   leaf frontend-no-progress-timeout-in-seconds {
 *     default 900;
 *     type non-zero-uint32-type;
 *   }
 *   leaf initial-payload-serialized-buffer-capacity {
 *     default 512;
 *     type non-zero-uint32-type;
 *   }
 *   leaf use-lz4-compression {
 *     default false;
 *     type boolean;
 *   }
 *   leaf export-on-recovery {
 *     default off;
 *     type enumeration {
 *       enum off;
 *       enum json;
 *     }
 *   }
 *   leaf recovery-export-base-dir {
 *     default persistence-export;
 *     type string;
 *   }
 * }
 * </pre>The schema path to identify an instance is
 * <i>distributed-datastore-provider/data-store-properties</i>
 *
 */
@Generated("mdsal-binding-generator")
public interface DataStoreProperties
    extends
    DataObject
{


    @Generated("mdsal-binding-generator")
    public enum ExportOnRecovery implements Enumeration {
        Off(0, "off"),
        
        Json(1, "json")
        ;
    
        private static final Map<String, ExportOnRecovery> NAME_MAP;
        private static final Map<Integer, ExportOnRecovery> VALUE_MAP;
    
        static {
            final Builder<String, ExportOnRecovery> nb = ImmutableMap.builder();
            final Builder<Integer, ExportOnRecovery> vb = ImmutableMap.builder();
            for (ExportOnRecovery enumItem : ExportOnRecovery.values()) {
                vb.put(enumItem.value, enumItem);
                nb.put(enumItem.name, enumItem);
            }
    
            NAME_MAP = nb.build();
            VALUE_MAP = vb.build();
        }
    
        private final String name;
        private final int value;
    
        private ExportOnRecovery(int value, String name) {
            this.value = value;
            this.name = name;
        }
    
        @Override
        public String getName() {
            return name;
        }
    
        @Override
        public int getIntValue() {
            return value;
        }
    
        /**
         * Return the enumeration member whose {@link #getName()} matches specified value.
         *
         * @param name YANG assigned name
         * @return corresponding ExportOnRecovery item, if present
         * @throws NullPointerException if name is null
         */
        public static Optional<ExportOnRecovery> forName(String name) {
            return Optional.ofNullable(NAME_MAP.get(Objects.requireNonNull(name)));
        }
    
        /**
         * Return the enumeration member whose {@link #getIntValue()} matches specified value.
         *
         * @param intValue integer value
         * @return corresponding ExportOnRecovery item, or null if no such item exists
         */
        public static ExportOnRecovery forValue(int intValue) {
            return VALUE_MAP.get(intValue);
        }
    }

    public static final @NonNull QName QNAME = $YangModuleInfoImpl.qnameOf("data-store-properties");

    @Override
    Class<? extends DataStoreProperties> implementedInterface();
    
    /**
     * Return shardTransactionIdleTimeoutInMinutes, or {@code null} if it is not present.
     *
     * <pre>
     *     <code>
     *         The maximum amount of time a shard transaction can be idle without receiving any
     *         messages before it self-destructs.
     *     </code>
     * </pre>
     *
     * @return {@code NonZeroUint32Type} shardTransactionIdleTimeoutInMinutes, or {@code null} if it is not present.
     *
     */
    NonZeroUint32Type getShardTransactionIdleTimeoutInMinutes();
    
    /**
     * Return shardTransactionIdleTimeoutInMinutes, guaranteed to be non-null.
     *
     * <pre>
     *     <code>
     *         The maximum amount of time a shard transaction can be idle without receiving any
     *         messages before it self-destructs.
     *     </code>
     * </pre>
     *
     * @return {@code NonZeroUint32Type} shardTransactionIdleTimeoutInMinutes, guaranteed to be non-null.
     * @throws NoSuchElementException if shardTransactionIdleTimeoutInMinutes is not present
     *
     */
    default @NonNull NonZeroUint32Type requireShardTransactionIdleTimeoutInMinutes() {
        return CodeHelpers.require(getShardTransactionIdleTimeoutInMinutes(), "shardtransactionidletimeoutinminutes");
    }
    
    /**
     * Return shardSnapshotBatchCount, or {@code null} if it is not present.
     *
     * <pre>
     *     <code>
     *         The minimum number of entries to be present in the in-memory journal log before
     *         a snapshot is to be taken.
     *     </code>
     * </pre>
     *
     * @return {@code NonZeroUint32Type} shardSnapshotBatchCount, or {@code null} if it is not present.
     *
     */
    NonZeroUint32Type getShardSnapshotBatchCount();
    
    /**
     * Return shardSnapshotBatchCount, guaranteed to be non-null.
     *
     * <pre>
     *     <code>
     *         The minimum number of entries to be present in the in-memory journal log before
     *         a snapshot is to be taken.
     *     </code>
     * </pre>
     *
     * @return {@code NonZeroUint32Type} shardSnapshotBatchCount, guaranteed to be non-null.
     * @throws NoSuchElementException if shardSnapshotBatchCount is not present
     *
     */
    default @NonNull NonZeroUint32Type requireShardSnapshotBatchCount() {
        return CodeHelpers.require(getShardSnapshotBatchCount(), "shardsnapshotbatchcount");
    }
    
    /**
     * Return shardSnapshotDataThresholdPercentage, or {@code null} if it is not present.
     *
     * <pre>
     *     <code>
     *         The percentage of Runtime.maxMemory() used by the in-memory journal log before a
     *         snapshot is to be taken. Disabled, if direct threshold is enabled.
     *     </code>
     * </pre>
     *
     * @return {@code Percentage} shardSnapshotDataThresholdPercentage, or {@code null} if it is not present.
     *
     */
    Percentage getShardSnapshotDataThresholdPercentage();
    
    /**
     * Return shardSnapshotDataThresholdPercentage, guaranteed to be non-null.
     *
     * <pre>
     *     <code>
     *         The percentage of Runtime.maxMemory() used by the in-memory journal log before a
     *         snapshot is to be taken. Disabled, if direct threshold is enabled.
     *     </code>
     * </pre>
     *
     * @return {@code Percentage} shardSnapshotDataThresholdPercentage, guaranteed to be non-null.
     * @throws NoSuchElementException if shardSnapshotDataThresholdPercentage is not present
     *
     */
    default @NonNull Percentage requireShardSnapshotDataThresholdPercentage() {
        return CodeHelpers.require(getShardSnapshotDataThresholdPercentage(), "shardsnapshotdatathresholdpercentage");
    }
    
    /**
     * Return shardSnapshotDataThreshold, or {@code null} if it is not present.
     *
     * <pre>
     *     <code>
     *         The threshold of in-memory journal size before a snapshot is to be taken. If set
     *         to 0, direct threshold is disabled and percentage is used instead.
     *     </code>
     * </pre>
     *
     * @return {@code Uint32} shardSnapshotDataThreshold, or {@code null} if it is not present.
     *
     */
    Uint32 getShardSnapshotDataThreshold();
    
    /**
     * Return shardSnapshotDataThreshold, guaranteed to be non-null.
     *
     * <pre>
     *     <code>
     *         The threshold of in-memory journal size before a snapshot is to be taken. If set
     *         to 0, direct threshold is disabled and percentage is used instead.
     *     </code>
     * </pre>
     *
     * @return {@code Uint32} shardSnapshotDataThreshold, guaranteed to be non-null.
     * @throws NoSuchElementException if shardSnapshotDataThreshold is not present
     *
     */
    default @NonNull Uint32 requireShardSnapshotDataThreshold() {
        return CodeHelpers.require(getShardSnapshotDataThreshold(), "shardsnapshotdatathreshold");
    }
    
    /**
     * Return shardHeartbeatIntervalInMillis, or {@code null} if it is not present.
     *
     * <pre>
     *     <code>
     *         The interval at which a shard will send a heart beat message to its remote
     *         shard.
     *     </code>
     * </pre>
     *
     * @return {@code HeartbeatIntervalType} shardHeartbeatIntervalInMillis, or {@code null} if it is not present.
     *
     */
    HeartbeatIntervalType getShardHeartbeatIntervalInMillis();
    
    /**
     * Return shardHeartbeatIntervalInMillis, guaranteed to be non-null.
     *
     * <pre>
     *     <code>
     *         The interval at which a shard will send a heart beat message to its remote
     *         shard.
     *     </code>
     * </pre>
     *
     * @return {@code HeartbeatIntervalType} shardHeartbeatIntervalInMillis, guaranteed to be non-null.
     * @throws NoSuchElementException if shardHeartbeatIntervalInMillis is not present
     *
     */
    default @NonNull HeartbeatIntervalType requireShardHeartbeatIntervalInMillis() {
        return CodeHelpers.require(getShardHeartbeatIntervalInMillis(), "shardheartbeatintervalinmillis");
    }
    
    /**
     * Return shardElectionTimeoutFactor, or {@code null} if it is not present.
     *
     * <pre>
     *     <code>
     *         The multiplication factor to be used to determine shard election timeout. The
     *         shard election timeout is determined by multiplying
     *         shard-heartbeat-interval-in-millis with the shard-election-timeout-factor
     *     </code>
     * </pre>
     *
     * @return {@code NonZeroUint32Type} shardElectionTimeoutFactor, or {@code null} if it is not present.
     *
     */
    NonZeroUint32Type getShardElectionTimeoutFactor();
    
    /**
     * Return shardElectionTimeoutFactor, guaranteed to be non-null.
     *
     * <pre>
     *     <code>
     *         The multiplication factor to be used to determine shard election timeout. The
     *         shard election timeout is determined by multiplying
     *         shard-heartbeat-interval-in-millis with the shard-election-timeout-factor
     *     </code>
     * </pre>
     *
     * @return {@code NonZeroUint32Type} shardElectionTimeoutFactor, guaranteed to be non-null.
     * @throws NoSuchElementException if shardElectionTimeoutFactor is not present
     *
     */
    default @NonNull NonZeroUint32Type requireShardElectionTimeoutFactor() {
        return CodeHelpers.require(getShardElectionTimeoutFactor(), "shardelectiontimeoutfactor");
    }
    
    /**
     * Return operationTimeoutInSeconds, or {@code null} if it is not present.
     *
     * <pre>
     *     <code>
     *         The maximum amount of time for akka operations (remote or local) to complete
     *         before failing.
     *     </code>
     * </pre>
     *
     * @return {@code OperationTimeoutType} operationTimeoutInSeconds, or {@code null} if it is not present.
     *
     */
    OperationTimeoutType getOperationTimeoutInSeconds();
    
    /**
     * Return operationTimeoutInSeconds, guaranteed to be non-null.
     *
     * <pre>
     *     <code>
     *         The maximum amount of time for akka operations (remote or local) to complete
     *         before failing.
     *     </code>
     * </pre>
     *
     * @return {@code OperationTimeoutType} operationTimeoutInSeconds, guaranteed to be non-null.
     * @throws NoSuchElementException if operationTimeoutInSeconds is not present
     *
     */
    default @NonNull OperationTimeoutType requireOperationTimeoutInSeconds() {
        return CodeHelpers.require(getOperationTimeoutInSeconds(), "operationtimeoutinseconds");
    }
    
    /**
     * Return shardJournalRecoveryLogBatchSize, or {@code null} if it is not present.
     *
     * <pre>
     *     <code>
     *         The maximum number of journal log entries to batch on recovery for a shard
     *         before committing to the data store.
     *     </code>
     * </pre>
     *
     * @return {@code NonZeroUint32Type} shardJournalRecoveryLogBatchSize, or {@code null} if it is not present.
     *
     */
    NonZeroUint32Type getShardJournalRecoveryLogBatchSize();
    
    /**
     * Return shardJournalRecoveryLogBatchSize, guaranteed to be non-null.
     *
     * <pre>
     *     <code>
     *         The maximum number of journal log entries to batch on recovery for a shard
     *         before committing to the data store.
     *     </code>
     * </pre>
     *
     * @return {@code NonZeroUint32Type} shardJournalRecoveryLogBatchSize, guaranteed to be non-null.
     * @throws NoSuchElementException if shardJournalRecoveryLogBatchSize is not present
     *
     */
    default @NonNull NonZeroUint32Type requireShardJournalRecoveryLogBatchSize() {
        return CodeHelpers.require(getShardJournalRecoveryLogBatchSize(), "shardjournalrecoverylogbatchsize");
    }
    
    /**
     * Return shardTransactionCommitTimeoutInSeconds, or {@code null} if it is not present.
     *
     * <pre>
     *     <code>
     *         The maximum amount of time a shard transaction three-phase commit can be idle
     *         without receiving the next messages before it aborts the transaction
     *     </code>
     * </pre>
     *
     * @return {@code NonZeroUint32Type} shardTransactionCommitTimeoutInSeconds, or {@code null} if it is not present.
     *
     */
    NonZeroUint32Type getShardTransactionCommitTimeoutInSeconds();
    
    /**
     * Return shardTransactionCommitTimeoutInSeconds, guaranteed to be non-null.
     *
     * <pre>
     *     <code>
     *         The maximum amount of time a shard transaction three-phase commit can be idle
     *         without receiving the next messages before it aborts the transaction
     *     </code>
     * </pre>
     *
     * @return {@code NonZeroUint32Type} shardTransactionCommitTimeoutInSeconds, guaranteed to be non-null.
     * @throws NoSuchElementException if shardTransactionCommitTimeoutInSeconds is not present
     *
     */
    default @NonNull NonZeroUint32Type requireShardTransactionCommitTimeoutInSeconds() {
        return CodeHelpers.require(getShardTransactionCommitTimeoutInSeconds(), "shardtransactioncommittimeoutinseconds");
    }
    
    /**
     * Return shardTransactionCommitQueueCapacity, or {@code null} if it is not present.
     *
     * <pre>
     *     <code>
     *         The maximum allowed capacity for each shard's transaction commit queue.
     *     </code>
     * </pre>
     *
     * @return {@code NonZeroUint32Type} shardTransactionCommitQueueCapacity, or {@code null} if it is not present.
     *
     */
    NonZeroUint32Type getShardTransactionCommitQueueCapacity();
    
    /**
     * Return shardTransactionCommitQueueCapacity, guaranteed to be non-null.
     *
     * <pre>
     *     <code>
     *         The maximum allowed capacity for each shard's transaction commit queue.
     *     </code>
     * </pre>
     *
     * @return {@code NonZeroUint32Type} shardTransactionCommitQueueCapacity, guaranteed to be non-null.
     * @throws NoSuchElementException if shardTransactionCommitQueueCapacity is not present
     *
     */
    default @NonNull NonZeroUint32Type requireShardTransactionCommitQueueCapacity() {
        return CodeHelpers.require(getShardTransactionCommitQueueCapacity(), "shardtransactioncommitqueuecapacity");
    }
    
    /**
     * Return shardCommitQueueExpiryTimeoutInSeconds, or {@code null} if it is not present.
     *
     * <pre>
     *     <code>
     *         The maximum amount of time a transaction can remain in a shard's commit queue
     *         waiting to begin the CanCommit phase as coordinated by the broker front-end.
     *         Normally this should be quick but latencies can occur in between transaction
     *         ready and CanCommit or a remote broker could lose connection and CanCommit might
     *         never occur. Expiring transactions from the queue allows subsequent pending
     *         transaction to be processed.
     *     </code>
     * </pre>
     *
     * @return {@code NonZeroUint32Type} shardCommitQueueExpiryTimeoutInSeconds, or {@code null} if it is not present.
     *
     */
    NonZeroUint32Type getShardCommitQueueExpiryTimeoutInSeconds();
    
    /**
     * Return shardCommitQueueExpiryTimeoutInSeconds, guaranteed to be non-null.
     *
     * <pre>
     *     <code>
     *         The maximum amount of time a transaction can remain in a shard's commit queue
     *         waiting to begin the CanCommit phase as coordinated by the broker front-end.
     *         Normally this should be quick but latencies can occur in between transaction
     *         ready and CanCommit or a remote broker could lose connection and CanCommit might
     *         never occur. Expiring transactions from the queue allows subsequent pending
     *         transaction to be processed.
     *     </code>
     * </pre>
     *
     * @return {@code NonZeroUint32Type} shardCommitQueueExpiryTimeoutInSeconds, guaranteed to be non-null.
     * @throws NoSuchElementException if shardCommitQueueExpiryTimeoutInSeconds is not present
     *
     */
    default @NonNull NonZeroUint32Type requireShardCommitQueueExpiryTimeoutInSeconds() {
        return CodeHelpers.require(getShardCommitQueueExpiryTimeoutInSeconds(), "shardcommitqueueexpirytimeoutinseconds");
    }
    
    /**
     * Return shardInitializationTimeoutInSeconds, or {@code null} if it is not present.
     *
     * <pre>
     *     <code>
     *         The maximum amount of time to wait for a shard to initialize from persistence on
     *         startup before failing an operation (eg transaction create and change listener
     *         registration).
     *     </code>
     * </pre>
     *
     * @return {@code NonZeroUint32Type} shardInitializationTimeoutInSeconds, or {@code null} if it is not present.
     *
     */
    NonZeroUint32Type getShardInitializationTimeoutInSeconds();
    
    /**
     * Return shardInitializationTimeoutInSeconds, guaranteed to be non-null.
     *
     * <pre>
     *     <code>
     *         The maximum amount of time to wait for a shard to initialize from persistence on
     *         startup before failing an operation (eg transaction create and change listener
     *         registration).
     *     </code>
     * </pre>
     *
     * @return {@code NonZeroUint32Type} shardInitializationTimeoutInSeconds, guaranteed to be non-null.
     * @throws NoSuchElementException if shardInitializationTimeoutInSeconds is not present
     *
     */
    default @NonNull NonZeroUint32Type requireShardInitializationTimeoutInSeconds() {
        return CodeHelpers.require(getShardInitializationTimeoutInSeconds(), "shardinitializationtimeoutinseconds");
    }
    
    /**
     * Return shardLeaderElectionTimeoutInSeconds, or {@code null} if it is not present.
     *
     * <pre>
     *     <code>
     *         The maximum amount of time to wait for a shard to elect a leader before failing
     *         an operation (eg transaction create).
     *     </code>
     * </pre>
     *
     * @return {@code NonZeroUint32Type} shardLeaderElectionTimeoutInSeconds, or {@code null} if it is not present.
     *
     */
    NonZeroUint32Type getShardLeaderElectionTimeoutInSeconds();
    
    /**
     * Return shardLeaderElectionTimeoutInSeconds, guaranteed to be non-null.
     *
     * <pre>
     *     <code>
     *         The maximum amount of time to wait for a shard to elect a leader before failing
     *         an operation (eg transaction create).
     *     </code>
     * </pre>
     *
     * @return {@code NonZeroUint32Type} shardLeaderElectionTimeoutInSeconds, guaranteed to be non-null.
     * @throws NoSuchElementException if shardLeaderElectionTimeoutInSeconds is not present
     *
     */
    default @NonNull NonZeroUint32Type requireShardLeaderElectionTimeoutInSeconds() {
        return CodeHelpers.require(getShardLeaderElectionTimeoutInSeconds(), "shardleaderelectiontimeoutinseconds");
    }
    
    /**
     * Return initialSettleTimeoutMultiplier, or {@code null} if it is not present.
     *
     * <pre>
     *     <code>
     *         Multiplier for the maximum amount of time to wait for a shard to elect a leader.
     *         Zero value means wait indefinitely (as long as it takes).
     *     </code>
     * </pre>
     *
     * @return {@code Uint32} initialSettleTimeoutMultiplier, or {@code null} if it is not present.
     *
     */
    Uint32 getInitialSettleTimeoutMultiplier();
    
    /**
     * Return initialSettleTimeoutMultiplier, guaranteed to be non-null.
     *
     * <pre>
     *     <code>
     *         Multiplier for the maximum amount of time to wait for a shard to elect a leader.
     *         Zero value means wait indefinitely (as long as it takes).
     *     </code>
     * </pre>
     *
     * @return {@code Uint32} initialSettleTimeoutMultiplier, guaranteed to be non-null.
     * @throws NoSuchElementException if initialSettleTimeoutMultiplier is not present
     *
     */
    default @NonNull Uint32 requireInitialSettleTimeoutMultiplier() {
        return CodeHelpers.require(getInitialSettleTimeoutMultiplier(), "initialsettletimeoutmultiplier");
    }
    
    /**
     * Return recoverySnapshotIntervalSeconds, or {@code null} if it is not present.
     *
     * <pre>
     *     <code>
     *         Interval after which a snapshot should be taken during the recovery process.
     *     </code>
     * </pre>
     *
     * @return {@code Uint32} recoverySnapshotIntervalSeconds, or {@code null} if it is not present.
     *
     */
    Uint32 getRecoverySnapshotIntervalSeconds();
    
    /**
     * Return recoverySnapshotIntervalSeconds, guaranteed to be non-null.
     *
     * <pre>
     *     <code>
     *         Interval after which a snapshot should be taken during the recovery process.
     *     </code>
     * </pre>
     *
     * @return {@code Uint32} recoverySnapshotIntervalSeconds, guaranteed to be non-null.
     * @throws NoSuchElementException if recoverySnapshotIntervalSeconds is not present
     *
     */
    default @NonNull Uint32 requireRecoverySnapshotIntervalSeconds() {
        return CodeHelpers.require(getRecoverySnapshotIntervalSeconds(), "recoverysnapshotintervalseconds");
    }
    
    /**
     * Return shardBatchedModificationCount, or {@code null} if it is not present.
     *
     * <pre>
     *     <code>
     *         The number of transaction modification operations (put, merge, delete) to batch
     *         before sending to the shard transaction actor. Batching improves performance as
     *         less modifications messages are sent to the actor and thus lessens the chance
     *         that the transaction actor's mailbox queue could get full.
     *     </code>
     * </pre>
     *
     * @return {@code NonZeroUint32Type} shardBatchedModificationCount, or {@code null} if it is not present.
     *
     */
    NonZeroUint32Type getShardBatchedModificationCount();
    
    /**
     * Return shardBatchedModificationCount, guaranteed to be non-null.
     *
     * <pre>
     *     <code>
     *         The number of transaction modification operations (put, merge, delete) to batch
     *         before sending to the shard transaction actor. Batching improves performance as
     *         less modifications messages are sent to the actor and thus lessens the chance
     *         that the transaction actor's mailbox queue could get full.
     *     </code>
     * </pre>
     *
     * @return {@code NonZeroUint32Type} shardBatchedModificationCount, guaranteed to be non-null.
     * @throws NoSuchElementException if shardBatchedModificationCount is not present
     *
     */
    default @NonNull NonZeroUint32Type requireShardBatchedModificationCount() {
        return CodeHelpers.require(getShardBatchedModificationCount(), "shardbatchedmodificationcount");
    }
    
    /**
     * Return enableMetricCapture, or {@code null} if it is not present.
     *
     * <pre>
     *     <code>
     *         Enable or disable metric capture.
     *     </code>
     * </pre>
     *
     * @return {@code Boolean} enableMetricCapture, or {@code null} if it is not present.
     *
     */
    Boolean getEnableMetricCapture();
    
    /**
     * Return enableMetricCapture, guaranteed to be non-null.
     *
     * <pre>
     *     <code>
     *         Enable or disable metric capture.
     *     </code>
     * </pre>
     *
     * @return {@code Boolean} enableMetricCapture, guaranteed to be non-null.
     * @throws NoSuchElementException if enableMetricCapture is not present
     *
     */
    default @NonNull Boolean requireEnableMetricCapture() {
        return CodeHelpers.require(getEnableMetricCapture(), "enablemetriccapture");
    }
    
    /**
     * Return boundedMailboxCapacity, or {@code null} if it is not present.
     *
     * <pre>
     *     <code>
     *         Max queue size that an actor's mailbox can reach
     *     </code>
     * </pre>
     *
     * @return {@code NonZeroUint32Type} boundedMailboxCapacity, or {@code null} if it is not present.
     *
     */
    NonZeroUint32Type getBoundedMailboxCapacity();
    
    /**
     * Return boundedMailboxCapacity, guaranteed to be non-null.
     *
     * <pre>
     *     <code>
     *         Max queue size that an actor's mailbox can reach
     *     </code>
     * </pre>
     *
     * @return {@code NonZeroUint32Type} boundedMailboxCapacity, guaranteed to be non-null.
     * @throws NoSuchElementException if boundedMailboxCapacity is not present
     *
     */
    default @NonNull NonZeroUint32Type requireBoundedMailboxCapacity() {
        return CodeHelpers.require(getBoundedMailboxCapacity(), "boundedmailboxcapacity");
    }
    
    /**
     * Return persistent, or {@code null} if it is not present.
     *
     * <pre>
     *     <code>
     *         Enable or disable data persistence
     *     </code>
     * </pre>
     *
     * @return {@code Boolean} persistent, or {@code null} if it is not present.
     *
     */
    Boolean getPersistent();
    
    /**
     * Return persistent, guaranteed to be non-null.
     *
     * <pre>
     *     <code>
     *         Enable or disable data persistence
     *     </code>
     * </pre>
     *
     * @return {@code Boolean} persistent, guaranteed to be non-null.
     * @throws NoSuchElementException if persistent is not present
     *
     */
    default @NonNull Boolean requirePersistent() {
        return CodeHelpers.require(getPersistent(), "persistent");
    }
    
    /**
     * Return snapshotOnRootOverwrite, or {@code null} if it is not present.
     *
     * <pre>
     *     <code>
     *         Enable or disable capturing snapshots on DataTree root overwrites
     *     </code>
     * </pre>
     *
     * @return {@code Boolean} snapshotOnRootOverwrite, or {@code null} if it is not present.
     *
     */
    Boolean getSnapshotOnRootOverwrite();
    
    /**
     * Return snapshotOnRootOverwrite, guaranteed to be non-null.
     *
     * <pre>
     *     <code>
     *         Enable or disable capturing snapshots on DataTree root overwrites
     *     </code>
     * </pre>
     *
     * @return {@code Boolean} snapshotOnRootOverwrite, guaranteed to be non-null.
     * @throws NoSuchElementException if snapshotOnRootOverwrite is not present
     *
     */
    default @NonNull Boolean requireSnapshotOnRootOverwrite() {
        return CodeHelpers.require(getSnapshotOnRootOverwrite(), "snapshotonrootoverwrite");
    }
    
    /**
     * Return shardIsolatedLeaderCheckIntervalInMillis, or {@code null} if it is not present.
     *
     * <pre>
     *     <code>
     *         The interval at which the leader of the shard will check if its majority
     *         followers are active and term itself as isolated
     *     </code>
     * </pre>
     *
     * @return {@code HeartbeatIntervalType} shardIsolatedLeaderCheckIntervalInMillis, or {@code null} if it is not present.
     *
     */
    HeartbeatIntervalType getShardIsolatedLeaderCheckIntervalInMillis();
    
    /**
     * Return shardIsolatedLeaderCheckIntervalInMillis, guaranteed to be non-null.
     *
     * <pre>
     *     <code>
     *         The interval at which the leader of the shard will check if its majority
     *         followers are active and term itself as isolated
     *     </code>
     * </pre>
     *
     * @return {@code HeartbeatIntervalType} shardIsolatedLeaderCheckIntervalInMillis, guaranteed to be non-null.
     * @throws NoSuchElementException if shardIsolatedLeaderCheckIntervalInMillis is not present
     *
     */
    default @NonNull HeartbeatIntervalType requireShardIsolatedLeaderCheckIntervalInMillis() {
        return CodeHelpers.require(getShardIsolatedLeaderCheckIntervalInMillis(), "shardisolatedleadercheckintervalinmillis");
    }
    
    /**
     * Return transactionCreationInitialRateLimit, or {@code null} if it is not present.
     *
     * <pre>
     *     <code>
     *         The initial number of transactions per second that are allowed before the data
     *         store should begin applying back pressure. This number is only used as an
     *         initial guidance, subsequently the datastore measures the latency for a commit
     *         and auto-adjusts the rate limit
     *     </code>
     * </pre>
     *
     * @return {@code NonZeroUint32Type} transactionCreationInitialRateLimit, or {@code null} if it is not present.
     *
     */
    NonZeroUint32Type getTransactionCreationInitialRateLimit();
    
    /**
     * Return transactionCreationInitialRateLimit, guaranteed to be non-null.
     *
     * <pre>
     *     <code>
     *         The initial number of transactions per second that are allowed before the data
     *         store should begin applying back pressure. This number is only used as an
     *         initial guidance, subsequently the datastore measures the latency for a commit
     *         and auto-adjusts the rate limit
     *     </code>
     * </pre>
     *
     * @return {@code NonZeroUint32Type} transactionCreationInitialRateLimit, guaranteed to be non-null.
     * @throws NoSuchElementException if transactionCreationInitialRateLimit is not present
     *
     */
    default @NonNull NonZeroUint32Type requireTransactionCreationInitialRateLimit() {
        return CodeHelpers.require(getTransactionCreationInitialRateLimit(), "transactioncreationinitialratelimit");
    }
    
    /**
     * Return transactionDebugContextEnabled, or {@code null} if it is not present.
     *
     * <pre>
     *     <code>
     *         Enable or disable transaction context debug. This will log the call site trace
     *         for transactions that fail
     *     </code>
     * </pre>
     *
     * @return {@code Boolean} transactionDebugContextEnabled, or {@code null} if it is not present.
     *
     */
    Boolean getTransactionDebugContextEnabled();
    
    /**
     * Return transactionDebugContextEnabled, guaranteed to be non-null.
     *
     * <pre>
     *     <code>
     *         Enable or disable transaction context debug. This will log the call site trace
     *         for transactions that fail
     *     </code>
     * </pre>
     *
     * @return {@code Boolean} transactionDebugContextEnabled, guaranteed to be non-null.
     * @throws NoSuchElementException if transactionDebugContextEnabled is not present
     *
     */
    default @NonNull Boolean requireTransactionDebugContextEnabled() {
        return CodeHelpers.require(getTransactionDebugContextEnabled(), "transactiondebugcontextenabled");
    }
    
    /**
     * Return customRaftPolicyImplementation, or {@code null} if it is not present.
     *
     * <pre>
     *     <code>
     *         A fully qualified java class name. The class should implement
     *         org.opendaylight.controller.cluster.raft.policy.RaftPolicy. This java class
     *         should be accessible to the distributed data store OSGi module so that it can be
     *         dynamically loaded via reflection. For now let's assume that these classes to
     *         customize raft behaviors should be present in the distributed data store module
     *         itself. If this property is set to a class which cannot be found then the
     *         default raft behavior will be applied
     *     </code>
     * </pre>
     *
     * @return {@code String} customRaftPolicyImplementation, or {@code null} if it is not present.
     *
     */
    String getCustomRaftPolicyImplementation();
    
    /**
     * Return customRaftPolicyImplementation, guaranteed to be non-null.
     *
     * <pre>
     *     <code>
     *         A fully qualified java class name. The class should implement
     *         org.opendaylight.controller.cluster.raft.policy.RaftPolicy. This java class
     *         should be accessible to the distributed data store OSGi module so that it can be
     *         dynamically loaded via reflection. For now let's assume that these classes to
     *         customize raft behaviors should be present in the distributed data store module
     *         itself. If this property is set to a class which cannot be found then the
     *         default raft behavior will be applied
     *     </code>
     * </pre>
     *
     * @return {@code String} customRaftPolicyImplementation, guaranteed to be non-null.
     * @throws NoSuchElementException if customRaftPolicyImplementation is not present
     *
     */
    default @NonNull String requireCustomRaftPolicyImplementation() {
        return CodeHelpers.require(getCustomRaftPolicyImplementation(), "customraftpolicyimplementation");
    }
    
    /**
     * Return shardSnapshotChunkSize, or {@code null} if it is not present.
     *
     * <pre>
     *     <code>
     *         When sending a snapshot to a follower, this is the maximum size in bytes for a
     *         chunk of data.
     *     </code>
     * </pre>
     *
     * @return {@code NonZeroUint32Type} shardSnapshotChunkSize, or {@code null} if it is not present.
     *
     */
    @Deprecated
    NonZeroUint32Type getShardSnapshotChunkSize();
    
    /**
     * Return shardSnapshotChunkSize, guaranteed to be non-null.
     *
     * <pre>
     *     <code>
     *         When sending a snapshot to a follower, this is the maximum size in bytes for a
     *         chunk of data.
     *     </code>
     * </pre>
     *
     * @return {@code NonZeroUint32Type} shardSnapshotChunkSize, guaranteed to be non-null.
     * @throws NoSuchElementException if shardSnapshotChunkSize is not present
     *
     */
    default @NonNull NonZeroUint32Type requireShardSnapshotChunkSize() {
        return CodeHelpers.require(getShardSnapshotChunkSize(), "shardsnapshotchunksize");
    }
    
    /**
     * Return maximumMessageSliceSize, or {@code null} if it is not present.
     *
     * <pre>
     *     <code>
     *         When fragmenting messages thru the akka remoting framework, this is the maximum
     *         size in bytes for a message slice.
     *     </code>
     * </pre>
     *
     * @return {@code NonZeroUint32Type} maximumMessageSliceSize, or {@code null} if it is not present.
     *
     */
    NonZeroUint32Type getMaximumMessageSliceSize();
    
    /**
     * Return maximumMessageSliceSize, guaranteed to be non-null.
     *
     * <pre>
     *     <code>
     *         When fragmenting messages thru the akka remoting framework, this is the maximum
     *         size in bytes for a message slice.
     *     </code>
     * </pre>
     *
     * @return {@code NonZeroUint32Type} maximumMessageSliceSize, guaranteed to be non-null.
     * @throws NoSuchElementException if maximumMessageSliceSize is not present
     *
     */
    default @NonNull NonZeroUint32Type requireMaximumMessageSliceSize() {
        return CodeHelpers.require(getMaximumMessageSliceSize(), "maximummessageslicesize");
    }
    
    /**
     * Return useTellBasedProtocol, or {@code null} if it is not present.
     *
     * <pre>
     *     <code>
     *         Use a newer protocol between the frontend and backend. This feature is
     *         considered exprerimental at this point.
     *     </code>
     * </pre>
     *
     * @return {@code Boolean} useTellBasedProtocol, or {@code null} if it is not present.
     *
     */
    Boolean getUseTellBasedProtocol();
    
    /**
     * Return useTellBasedProtocol, guaranteed to be non-null.
     *
     * <pre>
     *     <code>
     *         Use a newer protocol between the frontend and backend. This feature is
     *         considered exprerimental at this point.
     *     </code>
     * </pre>
     *
     * @return {@code Boolean} useTellBasedProtocol, guaranteed to be non-null.
     * @throws NoSuchElementException if useTellBasedProtocol is not present
     *
     */
    default @NonNull Boolean requireUseTellBasedProtocol() {
        return CodeHelpers.require(getUseTellBasedProtocol(), "usetellbasedprotocol");
    }
    
    /**
     * Return fileBackedStreamingThresholdInMegabytes, or {@code null} if it is not present.
     *
     * <pre>
     *     <code>
     *         When streaming large amounts of data, eg when sending a snapshot to a follower,
     *         this is the threshold in terms of number of megabytes before it should switch
     *         from storing in memory to buffering to a file.
     *     </code>
     * </pre>
     *
     * @return {@code NonZeroUint32Type} fileBackedStreamingThresholdInMegabytes, or {@code null} if it is not present.
     *
     */
    NonZeroUint32Type getFileBackedStreamingThresholdInMegabytes();
    
    /**
     * Return fileBackedStreamingThresholdInMegabytes, guaranteed to be non-null.
     *
     * <pre>
     *     <code>
     *         When streaming large amounts of data, eg when sending a snapshot to a follower,
     *         this is the threshold in terms of number of megabytes before it should switch
     *         from storing in memory to buffering to a file.
     *     </code>
     * </pre>
     *
     * @return {@code NonZeroUint32Type} fileBackedStreamingThresholdInMegabytes, guaranteed to be non-null.
     * @throws NoSuchElementException if fileBackedStreamingThresholdInMegabytes is not present
     *
     */
    default @NonNull NonZeroUint32Type requireFileBackedStreamingThresholdInMegabytes() {
        return CodeHelpers.require(getFileBackedStreamingThresholdInMegabytes(), "filebackedstreamingthresholdinmegabytes");
    }
    
    /**
     * Return syncIndexThreshold, or {@code null} if it is not present.
     *
     * <pre>
     *     <code>
     *         Permitted synchronization lag, expressed in terms of RAFT entry count. It a
     *         follower's commitIndex trails the leader's journal by more than this amount of
     *         entries the follower is considered to be out-of-sync.
     *     </code>
     * </pre>
     *
     * @return {@code NonZeroUint32Type} syncIndexThreshold, or {@code null} if it is not present.
     *
     */
    NonZeroUint32Type getSyncIndexThreshold();
    
    /**
     * Return syncIndexThreshold, guaranteed to be non-null.
     *
     * <pre>
     *     <code>
     *         Permitted synchronization lag, expressed in terms of RAFT entry count. It a
     *         follower's commitIndex trails the leader's journal by more than this amount of
     *         entries the follower is considered to be out-of-sync.
     *     </code>
     * </pre>
     *
     * @return {@code NonZeroUint32Type} syncIndexThreshold, guaranteed to be non-null.
     * @throws NoSuchElementException if syncIndexThreshold is not present
     *
     */
    default @NonNull NonZeroUint32Type requireSyncIndexThreshold() {
        return CodeHelpers.require(getSyncIndexThreshold(), "syncindexthreshold");
    }
    
    /**
     * Return backendAlivenessTimerIntervalInSeconds, or {@code null} if it is not present.
     *
     * <pre>
     *     <code>
     *         The timer interval whereby, on expiration after response inactivity from the
     *         back-end, the connection to the back-end is torn down and reconnection is
     *         attempted.
     *     </code>
     * </pre>
     *
     * @return {@code NonZeroUint32Type} backendAlivenessTimerIntervalInSeconds, or {@code null} if it is not present.
     *
     */
    NonZeroUint32Type getBackendAlivenessTimerIntervalInSeconds();
    
    /**
     * Return backendAlivenessTimerIntervalInSeconds, guaranteed to be non-null.
     *
     * <pre>
     *     <code>
     *         The timer interval whereby, on expiration after response inactivity from the
     *         back-end, the connection to the back-end is torn down and reconnection is
     *         attempted.
     *     </code>
     * </pre>
     *
     * @return {@code NonZeroUint32Type} backendAlivenessTimerIntervalInSeconds, guaranteed to be non-null.
     * @throws NoSuchElementException if backendAlivenessTimerIntervalInSeconds is not present
     *
     */
    default @NonNull NonZeroUint32Type requireBackendAlivenessTimerIntervalInSeconds() {
        return CodeHelpers.require(getBackendAlivenessTimerIntervalInSeconds(), "backendalivenesstimerintervalinseconds");
    }
    
    /**
     * Return frontendRequestTimeoutInSeconds, or {@code null} if it is not present.
     *
     * <pre>
     *     <code>
     *         The timeout interval whereby client frontend transaction requests are failed.
     *     </code>
     * </pre>
     *
     * @return {@code NonZeroUint32Type} frontendRequestTimeoutInSeconds, or {@code null} if it is not present.
     *
     */
    NonZeroUint32Type getFrontendRequestTimeoutInSeconds();
    
    /**
     * Return frontendRequestTimeoutInSeconds, guaranteed to be non-null.
     *
     * <pre>
     *     <code>
     *         The timeout interval whereby client frontend transaction requests are failed.
     *     </code>
     * </pre>
     *
     * @return {@code NonZeroUint32Type} frontendRequestTimeoutInSeconds, guaranteed to be non-null.
     * @throws NoSuchElementException if frontendRequestTimeoutInSeconds is not present
     *
     */
    default @NonNull NonZeroUint32Type requireFrontendRequestTimeoutInSeconds() {
        return CodeHelpers.require(getFrontendRequestTimeoutInSeconds(), "frontendrequesttimeoutinseconds");
    }
    
    /**
     * Return frontendNoProgressTimeoutInSeconds, or {@code null} if it is not present.
     *
     * <pre>
     *     <code>
     *         The timeout interval whereby the client front-end hasn't made progress with the
     *         back-end on any request and terminates.
     *     </code>
     * </pre>
     *
     * @return {@code NonZeroUint32Type} frontendNoProgressTimeoutInSeconds, or {@code null} if it is not present.
     *
     */
    NonZeroUint32Type getFrontendNoProgressTimeoutInSeconds();
    
    /**
     * Return frontendNoProgressTimeoutInSeconds, guaranteed to be non-null.
     *
     * <pre>
     *     <code>
     *         The timeout interval whereby the client front-end hasn't made progress with the
     *         back-end on any request and terminates.
     *     </code>
     * </pre>
     *
     * @return {@code NonZeroUint32Type} frontendNoProgressTimeoutInSeconds, guaranteed to be non-null.
     * @throws NoSuchElementException if frontendNoProgressTimeoutInSeconds is not present
     *
     */
    default @NonNull NonZeroUint32Type requireFrontendNoProgressTimeoutInSeconds() {
        return CodeHelpers.require(getFrontendNoProgressTimeoutInSeconds(), "frontendnoprogresstimeoutinseconds");
    }
    
    /**
     * Return initialPayloadSerializedBufferCapacity, or {@code null} if it is not present.
     *
     * <pre>
     *     <code>
     *         The initial buffer capacity, in bytes, to use when serializing message payloads.
     *     </code>
     * </pre>
     *
     * @return {@code NonZeroUint32Type} initialPayloadSerializedBufferCapacity, or {@code null} if it is not present.
     *
     */
    NonZeroUint32Type getInitialPayloadSerializedBufferCapacity();
    
    /**
     * Return initialPayloadSerializedBufferCapacity, guaranteed to be non-null.
     *
     * <pre>
     *     <code>
     *         The initial buffer capacity, in bytes, to use when serializing message payloads.
     *     </code>
     * </pre>
     *
     * @return {@code NonZeroUint32Type} initialPayloadSerializedBufferCapacity, guaranteed to be non-null.
     * @throws NoSuchElementException if initialPayloadSerializedBufferCapacity is not present
     *
     */
    default @NonNull NonZeroUint32Type requireInitialPayloadSerializedBufferCapacity() {
        return CodeHelpers.require(getInitialPayloadSerializedBufferCapacity(), "initialpayloadserializedbuffercapacity");
    }
    
    /**
     * Return useLz4Compression, or {@code null} if it is not present.
     *
     * <pre>
     *     <code>
     *         Use lz4 compression for snapshots, sent from leader to follower, for snapshots
     *         stored by LocalSnapshotStore, use akka.conf configuration.
     *     </code>
     * </pre>
     *
     * @return {@code Boolean} useLz4Compression, or {@code null} if it is not present.
     *
     */
    Boolean getUseLz4Compression();
    
    /**
     * Return useLz4Compression, guaranteed to be non-null.
     *
     * <pre>
     *     <code>
     *         Use lz4 compression for snapshots, sent from leader to follower, for snapshots
     *         stored by LocalSnapshotStore, use akka.conf configuration.
     *     </code>
     * </pre>
     *
     * @return {@code Boolean} useLz4Compression, guaranteed to be non-null.
     * @throws NoSuchElementException if useLz4Compression is not present
     *
     */
    default @NonNull Boolean requireUseLz4Compression() {
        return CodeHelpers.require(getUseLz4Compression(), "uselz4compression");
    }
    
    /**
     * Return exportOnRecovery, or {@code null} if it is not present.
     *
     * <pre>
     *     <code>
     *         Export snapshot and journal during recovery. Possible modes: off(default),
     *         json(export to json files). Note that in case of large snapshot, export will
     *         take a lot of time.
     *     </code>
     * </pre>
     *
     * @return {@code ExportOnRecovery} exportOnRecovery, or {@code null} if it is not present.
     *
     */
    ExportOnRecovery getExportOnRecovery();
    
    /**
     * Return exportOnRecovery, guaranteed to be non-null.
     *
     * <pre>
     *     <code>
     *         Export snapshot and journal during recovery. Possible modes: off(default),
     *         json(export to json files). Note that in case of large snapshot, export will
     *         take a lot of time.
     *     </code>
     * </pre>
     *
     * @return {@code ExportOnRecovery} exportOnRecovery, guaranteed to be non-null.
     * @throws NoSuchElementException if exportOnRecovery is not present
     *
     */
    default @NonNull ExportOnRecovery requireExportOnRecovery() {
        return CodeHelpers.require(getExportOnRecovery(), "exportonrecovery");
    }
    
    /**
     * Return recoveryExportBaseDir, or {@code null} if it is not present.
     *
     * <pre>
     *     <code>
     *         Directory name for snapshot and journal dumps.
     *     </code>
     * </pre>
     *
     * @return {@code String} recoveryExportBaseDir, or {@code null} if it is not present.
     *
     */
    String getRecoveryExportBaseDir();
    
    /**
     * Return recoveryExportBaseDir, guaranteed to be non-null.
     *
     * <pre>
     *     <code>
     *         Directory name for snapshot and journal dumps.
     *     </code>
     * </pre>
     *
     * @return {@code String} recoveryExportBaseDir, guaranteed to be non-null.
     * @throws NoSuchElementException if recoveryExportBaseDir is not present
     *
     */
    default @NonNull String requireRecoveryExportBaseDir() {
        return CodeHelpers.require(getRecoveryExportBaseDir(), "recoveryexportbasedir");
    }

}

