package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.config.distributed.datastore.provider.rev140612;
import javax.annotation.processing.Generated;
import org.opendaylight.yangtools.yang.binding.DataRoot;

/**
 * This module contains the base YANG definitions for the distributed datastore 
 * provider implementation
 *
 * <p>
 * This class represents the following YANG schema fragment defined in module <b>distributed-datastore-provider</b>
 * <pre>
 * module distributed-datastore-provider {
 *   yang-version 1;
 *   namespace urn:opendaylight:params:xml:ns:yang:controller:config:distributed-datastore-provider;
 *   prefix distributed-datastore-provider;
 *   revision 2014-06-12 {
 *   }
 *   typedef non-zero-uint32-type {
 *     type uint32 {
 *       range 1..max;
 *     }
 *   }
 *   typedef operation-timeout-type {
 *     type uint16 {
 *       range 5..max;
 *     }
 *   }
 *   typedef heartbeat-interval-type {
 *     type uint16 {
 *       range 100..max;
 *     }
 *   }
 *   typedef percentage {
 *     type uint8 {
 *       range 0..100;
 *     }
 *   }
 *   grouping data-store-properties {
 *     leaf shard-transaction-idle-timeout-in-minutes {
 *       default 10;
 *       type non-zero-uint32-type;
 *     }
 *     leaf shard-snapshot-batch-count {
 *       default 20000;
 *       type non-zero-uint32-type;
 *     }
 *     leaf shard-snapshot-data-threshold-percentage {
 *       default 12;
 *       type percentage;
 *     }
 *     leaf shard-snapshot-data-threshold {
 *       default 0;
 *       type uint32 {
 *         range 0..max;
 *       }
 *     }
 *     leaf shard-heartbeat-interval-in-millis {
 *       default 500;
 *       type heartbeat-interval-type;
 *     }
 *     leaf shard-election-timeout-factor {
 *       default 20;
 *       type non-zero-uint32-type;
 *     }
 *     leaf operation-timeout-in-seconds {
 *       default 5;
 *       type operation-timeout-type;
 *     }
 *     leaf shard-journal-recovery-log-batch-size {
 *       default 1;
 *       type non-zero-uint32-type;
 *     }
 *     leaf shard-transaction-commit-timeout-in-seconds {
 *       default 30;
 *       type non-zero-uint32-type;
 *     }
 *     leaf shard-transaction-commit-queue-capacity {
 *       default 50000;
 *       type non-zero-uint32-type;
 *     }
 *     leaf shard-commit-queue-expiry-timeout-in-seconds {
 *       default 120;
 *       type non-zero-uint32-type;
 *     }
 *     leaf shard-initialization-timeout-in-seconds {
 *       default 300;
 *       type non-zero-uint32-type;
 *     }
 *     leaf shard-leader-election-timeout-in-seconds {
 *       default 30;
 *       type non-zero-uint32-type;
 *     }
 *     leaf initial-settle-timeout-multiplier {
 *       default 3;
 *       type uint32;
 *     }
 *     leaf recovery-snapshot-interval-seconds {
 *       default 0;
 *       type uint32;
 *     }
 *     leaf shard-batched-modification-count {
 *       default 1000;
 *       type non-zero-uint32-type;
 *     }
 *     leaf enable-metric-capture {
 *       default false;
 *       type boolean;
 *     }
 *     leaf bounded-mailbox-capacity {
 *       default 1000;
 *       type non-zero-uint32-type;
 *     }
 *     leaf persistent {
 *       default true;
 *       type boolean;
 *     }
 *     leaf snapshotOnRootOverwrite {
 *       default false;
 *       type boolean;
 *     }
 *     leaf shard-isolated-leader-check-interval-in-millis {
 *       default 5000;
 *       type heartbeat-interval-type;
 *     }
 *     leaf transaction-creation-initial-rate-limit {
 *       default 100;
 *       type non-zero-uint32-type;
 *     }
 *     leaf transaction-debug-context-enabled {
 *       default false;
 *       type boolean;
 *     }
 *     leaf custom-raft-policy-implementation {
 *       default "";
 *       type string;
 *     }
 *     leaf shard-snapshot-chunk-size {
 *       status deprecated;
 *       default 2048000;
 *       type non-zero-uint32-type;
 *     }
 *     leaf maximum-message-slice-size {
 *       default 2048000;
 *       type non-zero-uint32-type;
 *     }
 *     leaf use-tell-based-protocol {
 *       default false;
 *       type boolean;
 *     }
 *     leaf file-backed-streaming-threshold-in-megabytes {
 *       default 128;
 *       type non-zero-uint32-type;
 *     }
 *     leaf sync-index-threshold {
 *       default 10;
 *       type non-zero-uint32-type;
 *     }
 *     leaf backend-aliveness-timer-interval-in-seconds {
 *       default 30;
 *       type non-zero-uint32-type;
 *     }
 *     leaf frontend-request-timeout-in-seconds {
 *       default 120;
 *       type non-zero-uint32-type;
 *     }
 *     leaf frontend-no-progress-timeout-in-seconds {
 *       default 900;
 *       type non-zero-uint32-type;
 *     }
 *     leaf initial-payload-serialized-buffer-capacity {
 *       default 512;
 *       type non-zero-uint32-type;
 *     }
 *     leaf use-lz4-compression {
 *       default false;
 *       type boolean;
 *     }
 *     leaf export-on-recovery {
 *       default off;
 *       type enumeration {
 *         enum off;
 *         enum json;
 *       }
 *     }
 *     leaf recovery-export-base-dir {
 *       default persistence-export;
 *       type string;
 *     }
 *   }
 *   container data-store-properties-container {
 *     uses data-store-properties;
 *   }
 * }
 * </pre>
 *
 */
@Generated("mdsal-binding-generator")
public interface DistributedDatastoreProviderData
    extends
    DataRoot
{




    /**
     * Return dataStorePropertiesContainer, or {@code null} if it is not present.
     *
     * @return {@code DataStorePropertiesContainer} dataStorePropertiesContainer, or {@code null} if it is not present.
     *
     */
    DataStorePropertiesContainer getDataStorePropertiesContainer();

}

