/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.cluster.databroker.actors.dds;

import com.google.common.annotations.Beta;
import com.google.common.util.concurrent.FluentFuture;
import java.util.Optional;
import org.opendaylight.controller.cluster.access.concepts.TransactionIdentifier;
import org.opendaylight.controller.cluster.databroker.actors.dds.AbstractClientHandle;
import org.opendaylight.controller.cluster.databroker.actors.dds.AbstractClientHistory;
import org.opendaylight.controller.cluster.databroker.actors.dds.AbstractProxyTransaction;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;
import org.opendaylight.yangtools.yang.data.api.schema.NormalizedNode;

@Beta
public class ClientSnapshot
extends AbstractClientHandle<AbstractProxyTransaction> {
    ClientSnapshot(AbstractClientHistory parent, TransactionIdentifier transactionId) {
        super(parent, transactionId);
    }

    public FluentFuture<Boolean> exists(YangInstanceIdentifier path) {
        return this.ensureSnapshotProxy(path).exists(path);
    }

    public FluentFuture<Optional<NormalizedNode>> read(YangInstanceIdentifier path) {
        return this.ensureSnapshotProxy(path).read(path);
    }

    @Override
    final AbstractProxyTransaction createProxy(Long shard) {
        return this.parent().createSnapshotProxy(this.getIdentifier(), shard);
    }

    private AbstractProxyTransaction ensureSnapshotProxy(YangInstanceIdentifier path) {
        return this.ensureProxy(path);
    }
}

