/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.cluster.databroker.actors.dds;

import com.google.common.annotations.Beta;
import com.google.common.base.Preconditions;
import com.google.common.collect.Iterables;
import com.google.common.util.concurrent.FluentFuture;
import java.util.Collection;
import java.util.Optional;
import org.opendaylight.controller.cluster.access.concepts.TransactionIdentifier;
import org.opendaylight.controller.cluster.databroker.actors.dds.AbstractClientHandle;
import org.opendaylight.controller.cluster.databroker.actors.dds.AbstractClientHistory;
import org.opendaylight.controller.cluster.databroker.actors.dds.AbstractProxyTransaction;
import org.opendaylight.controller.cluster.databroker.actors.dds.AbstractTransactionCommitCohort;
import org.opendaylight.controller.cluster.databroker.actors.dds.ClientTransactionCommitCohort;
import org.opendaylight.controller.cluster.databroker.actors.dds.DirectTransactionCommitCohort;
import org.opendaylight.controller.cluster.databroker.actors.dds.EmptyTransactionCommitCohort;
import org.opendaylight.mdsal.dom.spi.store.DOMStoreThreePhaseCommitCohort;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;
import org.opendaylight.yangtools.yang.data.api.schema.NormalizedNode;

@Beta
public class ClientTransaction
extends AbstractClientHandle<AbstractProxyTransaction> {
    ClientTransaction(AbstractClientHistory parent, TransactionIdentifier transactionId) {
        super(parent, transactionId);
    }

    private AbstractProxyTransaction ensureTransactionProxy(YangInstanceIdentifier path) {
        return this.ensureProxy(path);
    }

    public FluentFuture<Boolean> exists(YangInstanceIdentifier path) {
        return this.ensureTransactionProxy(path).exists(path);
    }

    public FluentFuture<Optional<NormalizedNode>> read(YangInstanceIdentifier path) {
        return this.ensureTransactionProxy(path).read(path);
    }

    public void delete(YangInstanceIdentifier path) {
        this.ensureTransactionProxy(path).delete(path);
    }

    public void merge(YangInstanceIdentifier path, NormalizedNode data) {
        this.ensureTransactionProxy(path).merge(path, data);
    }

    public void write(YangInstanceIdentifier path, NormalizedNode data) {
        this.ensureTransactionProxy(path).write(path, data);
    }

    public DOMStoreThreePhaseCommitCohort ready() {
        AbstractTransactionCommitCohort cohort;
        Collection<AbstractProxyTransaction> toReady = this.ensureClosed();
        Preconditions.checkState((toReady != null ? 1 : 0) != 0, (String)"Attempted to submit a closed transaction %s", (Object)this);
        toReady.forEach(AbstractProxyTransaction::seal);
        switch (toReady.size()) {
            case 0: {
                cohort = new EmptyTransactionCommitCohort(this.parent(), this.getIdentifier());
                break;
            }
            case 1: {
                cohort = new DirectTransactionCommitCohort(this.parent(), this.getIdentifier(), (AbstractProxyTransaction)Iterables.getOnlyElement(toReady));
                break;
            }
            default: {
                cohort = new ClientTransactionCommitCohort(this.parent(), this.getIdentifier(), toReady);
            }
        }
        return this.parent().onTransactionReady(this, cohort);
    }

    @Override
    final AbstractProxyTransaction createProxy(Long shard) {
        return this.parent().createTransactionProxy(this.getIdentifier(), shard);
    }
}

