/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.cluster.datastore;

import akka.actor.ActorSelection;
import akka.dispatch.Futures;
import com.google.common.base.Preconditions;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.SortedSet;
import org.checkerframework.checker.lock.qual.GuardedBy;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.controller.cluster.access.concepts.TransactionIdentifier;
import org.opendaylight.controller.cluster.datastore.AbstractTransactionContextWrapper;
import org.opendaylight.controller.cluster.datastore.TransactionContext;
import org.opendaylight.controller.cluster.datastore.TransactionOperation;
import org.opendaylight.controller.cluster.datastore.utils.ActorUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.concurrent.Future;
import scala.concurrent.Promise;

final class DelayedTransactionContextWrapper
extends AbstractTransactionContextWrapper {
    private static final Logger LOG = LoggerFactory.getLogger(DelayedTransactionContextWrapper.class);
    private final @GuardedBy(value={"queuedTxOperations"}) List<Map.Entry<TransactionOperation, Boolean>> queuedTxOperations = new ArrayList<Map.Entry<TransactionOperation, Boolean>>();
    private volatile TransactionContext transactionContext;
    private @GuardedBy(value={"queuedTxOperations"}) TransactionContext deferredTransactionContext;
    private @GuardedBy(value={"queuedTxOperations"}) boolean pendingEnqueue;

    DelayedTransactionContextWrapper(@NonNull TransactionIdentifier identifier, @NonNull ActorUtils actorUtils, @NonNull String shardName) {
        super(identifier, actorUtils, shardName);
    }

    @Override
    TransactionContext getTransactionContext() {
        return this.transactionContext;
    }

    @Override
    void maybeExecuteTransactionOperation(TransactionOperation op) {
        TransactionContext localContext = this.transactionContext;
        if (localContext != null) {
            op.invoke(localContext, null);
        } else {
            this.enqueueTransactionOperation(op);
        }
    }

    @Override
    Future<ActorSelection> readyTransaction(final Optional<SortedSet<String>> participatingShardNames) {
        TransactionContext localContext = this.transactionContext;
        if (localContext != null) {
            return localContext.readyTransaction(null, participatingShardNames);
        }
        final Promise promise = Futures.promise();
        this.enqueueTransactionOperation(new TransactionOperation(){

            @Override
            public void invoke(TransactionContext newTransactionContext, Boolean havePermit) {
                promise.completeWith(newTransactionContext.readyTransaction(havePermit, participatingShardNames));
            }
        });
        return promise.future();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void enqueueTransactionOperation(TransactionOperation operation) {
        TransactionContext finishHandoff;
        block20: {
            List<Map.Entry<TransactionOperation, Boolean>> list;
            TransactionContext contextOnEntry;
            List<Map.Entry<TransactionOperation, Boolean>> list2 = this.queuedTxOperations;
            synchronized (list2) {
                contextOnEntry = this.transactionContext;
                if (contextOnEntry == null) {
                    Preconditions.checkState((!this.pendingEnqueue ? 1 : 0) != 0, (String)"Concurrent access to transaction %s detected", (Object)this.getIdentifier());
                    this.pendingEnqueue = true;
                }
            }
            if (contextOnEntry != null) {
                operation.invoke(this.transactionContext, null);
                return;
            }
            boolean cleanupEnqueue = true;
            finishHandoff = null;
            try {
                boolean havePermit = this.getLimiter().acquire();
                if (!havePermit) {
                    LOG.warn("Failed to acquire enqueue operation permit for transaction {} on shard {}", (Object)this.getIdentifier(), (Object)this.getShardName());
                }
                List<Map.Entry<TransactionOperation, Boolean>> list3 = this.queuedTxOperations;
                synchronized (list3) {
                    LOG.debug("Tx {} Queuing TransactionOperation", (Object)this.getIdentifier());
                    this.queuedTxOperations.add(new AbstractMap.SimpleImmutableEntry<TransactionOperation, Boolean>(operation, havePermit));
                    this.pendingEnqueue = false;
                    cleanupEnqueue = false;
                    finishHandoff = this.deferredTransactionContext;
                    this.deferredTransactionContext = null;
                }
                if (!cleanupEnqueue) break block20;
                list = this.queuedTxOperations;
            }
            catch (Throwable throwable) {
                if (cleanupEnqueue) {
                    List<Map.Entry<TransactionOperation, Boolean>> list4 = this.queuedTxOperations;
                    synchronized (list4) {
                        this.pendingEnqueue = false;
                        finishHandoff = this.deferredTransactionContext;
                        this.deferredTransactionContext = null;
                    }
                }
                if (finishHandoff != null) {
                    this.executePriorTransactionOperations(finishHandoff);
                }
                throw throwable;
            }
            synchronized (list) {
                this.pendingEnqueue = false;
                finishHandoff = this.deferredTransactionContext;
                this.deferredTransactionContext = null;
            }
        }
        if (finishHandoff != null) {
            this.executePriorTransactionOperations(finishHandoff);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void executePriorTransactionOperations(TransactionContext localTransactionContext) {
        block3: while (true) {
            ArrayList<Map.Entry<TransactionOperation, Boolean>> operationsBatch;
            Object object = this.queuedTxOperations;
            synchronized (object) {
                if (this.queuedTxOperations.isEmpty()) {
                    if (!this.pendingEnqueue) {
                        localTransactionContext.operationHandOffComplete();
                        this.transactionContext = localTransactionContext;
                    } else {
                        this.deferredTransactionContext = localTransactionContext;
                    }
                    return;
                }
                operationsBatch = new ArrayList<Map.Entry<TransactionOperation, Boolean>>(this.queuedTxOperations);
                this.queuedTxOperations.clear();
            }
            object = operationsBatch.iterator();
            while (true) {
                if (!object.hasNext()) continue block3;
                Map.Entry oper = (Map.Entry)object.next();
                Boolean permit = (Boolean)oper.getValue();
                if (permit.booleanValue() && !localTransactionContext.usesOperationLimiting()) {
                    this.getLimiter().release();
                }
                ((TransactionOperation)oper.getKey()).invoke(localTransactionContext, permit);
            }
            break;
        }
    }
}

