/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.cluster.datastore;

import com.google.common.base.Preconditions;
import com.google.common.collect.Range;
import com.google.common.collect.RangeSet;
import com.google.common.collect.TreeRangeSet;
import com.google.common.primitives.UnsignedLong;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.controller.cluster.access.concepts.ClientIdentifier;
import org.opendaylight.controller.cluster.access.concepts.LocalHistoryIdentifier;
import org.opendaylight.controller.cluster.access.concepts.TransactionIdentifier;
import org.opendaylight.controller.cluster.datastore.AbstractFrontendHistory;
import org.opendaylight.controller.cluster.datastore.LocalFrontendHistory;
import org.opendaylight.controller.cluster.datastore.Shard;
import org.opendaylight.controller.cluster.datastore.StandaloneFrontendHistory;
import org.opendaylight.controller.cluster.datastore.persisted.FrontendHistoryMetadata;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.concepts.Identifiable;

final class FrontendHistoryMetadataBuilder
implements Builder<FrontendHistoryMetadata>,
Identifiable<LocalHistoryIdentifier> {
    private final Map<UnsignedLong, Boolean> closedTransactions;
    private final RangeSet<UnsignedLong> purgedTransactions;
    private final LocalHistoryIdentifier identifier;
    private boolean closed;

    FrontendHistoryMetadataBuilder(LocalHistoryIdentifier identifier) {
        this.identifier = Objects.requireNonNull(identifier);
        this.purgedTransactions = TreeRangeSet.create();
        this.closedTransactions = new HashMap<UnsignedLong, Boolean>(2);
    }

    FrontendHistoryMetadataBuilder(ClientIdentifier clientId, FrontendHistoryMetadata meta) {
        this.identifier = new LocalHistoryIdentifier(clientId, meta.getHistoryId(), meta.getCookie());
        this.closedTransactions = new HashMap<UnsignedLong, Boolean>(meta.getClosedTransactions());
        this.purgedTransactions = TreeRangeSet.create(meta.getPurgedTransactions());
        this.closed = meta.isClosed();
    }

    public LocalHistoryIdentifier getIdentifier() {
        return this.identifier;
    }

    public FrontendHistoryMetadata build() {
        return new FrontendHistoryMetadata(this.identifier.getHistoryId(), this.identifier.getCookie(), this.closed, this.closedTransactions, this.purgedTransactions);
    }

    void onHistoryClosed() {
        Preconditions.checkState((this.identifier.getHistoryId() != 0L ? 1 : 0) != 0);
        this.closed = true;
    }

    void onTransactionAborted(TransactionIdentifier txId) {
        this.closedTransactions.put(UnsignedLong.fromLongBits((long)txId.getTransactionId()), Boolean.FALSE);
    }

    void onTransactionCommitted(TransactionIdentifier txId) {
        this.closedTransactions.put(UnsignedLong.fromLongBits((long)txId.getTransactionId()), Boolean.TRUE);
    }

    void onTransactionPurged(TransactionIdentifier txId) {
        UnsignedLong id = UnsignedLong.fromLongBits((long)txId.getTransactionId());
        this.closedTransactions.remove(id);
        this.purgedTransactions.add(Range.closedOpen((Comparable)id, (Comparable)UnsignedLong.ONE.plus(id)));
    }

    @NonNull AbstractFrontendHistory toLeaderState(@NonNull Shard shard) {
        if (this.identifier.getHistoryId() == 0L) {
            return StandaloneFrontendHistory.recreate(shard.persistenceId(), this.identifier.getClientId(), shard.getDataStore(), this.closedTransactions, this.purgedTransactions);
        }
        return LocalFrontendHistory.recreate(shard.persistenceId(), shard.getDataStore(), shard.getDataStore().recreateTransactionChain(this.identifier, this.closed), this.closedTransactions, this.purgedTransactions);
    }
}

