/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.cluster.datastore;

import com.google.common.base.Preconditions;
import java.io.File;
import java.util.Objects;
import org.opendaylight.controller.cluster.datastore.ShardDataTree;
import org.opendaylight.controller.cluster.datastore.persisted.ShardDataTreeSnapshot;
import org.opendaylight.controller.cluster.datastore.persisted.ShardSnapshotState;
import org.opendaylight.controller.cluster.datastore.utils.NormalizedNodeXMLOutput;
import org.opendaylight.controller.cluster.raft.RaftActorRecoveryCohort;
import org.opendaylight.controller.cluster.raft.persisted.Snapshot;
import org.opendaylight.controller.cluster.raft.protobuff.client.messages.Payload;
import org.opendaylight.yangtools.yang.data.api.schema.NormalizedNode;
import org.slf4j.Logger;

abstract class ShardRecoveryCoordinator
implements RaftActorRecoveryCohort {
    private final ShardDataTree store;
    private final String shardName;
    private final Logger log;
    private boolean open;

    ShardRecoveryCoordinator(ShardDataTree store, String shardName, Logger log) {
        this.store = Objects.requireNonNull(store);
        this.shardName = Objects.requireNonNull(shardName);
        this.log = Objects.requireNonNull(log);
    }

    static ShardRecoveryCoordinator create(ShardDataTree store, String shardName, Logger log) {
        return new Simple(store, shardName, log);
    }

    static ShardRecoveryCoordinator forSnapshot(ShardDataTree store, String shardName, Logger log, Snapshot snapshot) {
        return new WithSnapshot(store, shardName, log, snapshot);
    }

    public void startLogRecoveryBatch(int maxBatchSize) {
        this.log.debug("{}: starting log recovery batch with max size {}", (Object)this.shardName, (Object)maxBatchSize);
        this.open = true;
    }

    public void appendRecoveredLogEntry(Payload payload) {
        Preconditions.checkState((boolean)this.open, (Object)"call startLogRecovery before calling appendRecoveredLogEntry");
        try {
            this.store.applyRecoveryPayload(payload);
        }
        catch (Exception e) {
            this.log.error("{}: failed to apply payload {}", new Object[]{this.shardName, payload, e});
            throw new IllegalStateException(String.format("%s: Failed to apply recovery payload %s", this.shardName, payload), e);
        }
    }

    public void applyCurrentLogRecoveryBatch() {
        Preconditions.checkState((boolean)this.open, (Object)"call startLogRecovery before calling applyCurrentLogRecoveryBatch");
        this.open = false;
    }

    private File writeRoot(String kind, NormalizedNode node) {
        File file = new File(System.getProperty("karaf.data", "."), "failed-recovery-" + kind + "-" + this.shardName + ".xml");
        NormalizedNodeXMLOutput.toFile(file, node);
        return file;
    }

    public void applyRecoverySnapshot(Snapshot.State snapshotState) {
        if (!(snapshotState instanceof ShardSnapshotState)) {
            this.log.debug("{}: applyRecoverySnapshot ignoring snapshot: {}", (Object)this.shardName, (Object)snapshotState);
            return;
        }
        this.log.debug("{}: Applying recovered snapshot", (Object)this.shardName);
        ShardSnapshotState shardSnapshotState = (ShardSnapshotState)snapshotState;
        try {
            this.store.applyRecoverySnapshot(shardSnapshotState);
        }
        catch (Exception e) {
            ShardDataTreeSnapshot shardSnapshot = shardSnapshotState.getSnapshot();
            File f = this.writeRoot("snapshot", shardSnapshot.getRootNode().orElse(null));
            throw new IllegalStateException(String.format("%s: Failed to apply recovery snapshot %s. Node data was written to file %s", this.shardName, shardSnapshot, f), e);
        }
    }

    private static final class WithSnapshot
    extends ShardRecoveryCoordinator {
        private final Snapshot restoreFromSnapshot;

        WithSnapshot(ShardDataTree store, String shardName, Logger log, Snapshot snapshot) {
            super(store, shardName, log);
            this.restoreFromSnapshot = Objects.requireNonNull(snapshot);
        }

        public Snapshot getRestoreFromSnapshot() {
            return this.restoreFromSnapshot;
        }
    }

    private static final class Simple
    extends ShardRecoveryCoordinator {
        Simple(ShardDataTree store, String shardName, Logger log) {
            super(store, shardName, log);
        }

        public Snapshot getRestoreFromSnapshot() {
            return null;
        }
    }
}

